/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.history.Label;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.PanelWithActionsAndCloseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.RefreshIncomingChangesAction;
import com.intellij.openapi.vcs.update.AbstractTreeNode;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.FileTreeNode;
import com.intellij.openapi.vcs.update.GroupTreeNode;
import com.intellij.openapi.vcs.update.UpdateRootNode;
import com.intellij.openapi.vcs.update.UpdateTreeCellRenderer;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SelectionSaver;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateInfoTree
extends PanelWithActionsAndCloseButton {
    private final Tree myTree = new Tree();
    @NotNull
    private final Project myProject;
    private final UpdatedFiles myUpdatedFiles;
    private final VcsConfiguration myVcsConfiguration;
    private UpdateRootNode myRoot;
    private DefaultTreeModel myTreeModel;
    private FileStatusListener myFileStatusListener;
    private final FileStatusManager myFileStatusManager;
    private final String myRootName;
    private final ActionInfo myActionInfo;
    private boolean myCanGroupByChangeList = false;
    private boolean myGroupByChangeList = false;
    private JLabel myLoadingChangeListsLabel;
    private List<? extends CommittedChangeList> myCommittedChangeLists;
    private final JPanel myCenterPanel = new JPanel(new CardLayout());
    @NonNls
    private static final String CARD_STATUS = "Status";
    @NonNls
    private static final String CARD_CHANGES = "Changes";
    private CommittedChangesTreeBrowser myTreeBrowser;
    private final TreeExpander myTreeExpander;
    private final MyTreeIterable myTreeIterable;
    private Label myBefore;
    private Label myAfter;

    public UpdateInfoTree(@NotNull ContentManager contentManager, @NotNull Project project, UpdatedFiles updatedFiles, String rootName, ActionInfo actionInfo) {
        super(contentManager, "reference.versionControl.toolwindow.update");
        this.myActionInfo = actionInfo;
        this.myFileStatusListener = new FileStatusListener(){

            public void fileStatusesChanged() {
                UpdateInfoTree.this.myTree.repaint();
            }

            public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                UpdateInfoTree.this.myTree.repaint();
            }
        };
        this.myProject = project;
        this.myUpdatedFiles = updatedFiles;
        this.myRootName = rootName;
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        this.myFileStatusManager.addFileStatusListener(this.myFileStatusListener, (Disposable)this);
        this.createTree();
        this.init();
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTree);
        this.myTreeIterable = new MyTreeIterable();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myRoot);
    }

    public void setCanGroupByChangeList(boolean canGroupByChangeList) {
        this.myCanGroupByChangeList = canGroupByChangeList;
        if (this.myCanGroupByChangeList) {
            this.myLoadingChangeListsLabel = new JLabel(VcsBundle.message((String)"update.info.loading.changelists", (Object[])new Object[0]));
            this.add(this.myLoadingChangeListsLabel, "South");
            this.myGroupByChangeList = this.myVcsConfiguration.UPDATE_GROUP_BY_CHANGELIST;
            if (this.myGroupByChangeList) {
                CardLayout cardLayout = (CardLayout)this.myCenterPanel.getLayout();
                cardLayout.show(this.myCenterPanel, CARD_CHANGES);
            }
        }
    }

    protected void addActionsTo(DefaultActionGroup group) {
        group.add((AnAction)new MyGroupByPackagesAction());
        group.add((AnAction)new GroupByChangeListAction());
        group.add((AnAction)new FilterAction());
        group.add(ActionManager.getInstance().getAction("ExpandAll"));
        group.add(ActionManager.getInstance().getAction("CollapseAll"));
        group.add(ActionManager.getInstance().getAction("Diff.ShowDiff"));
    }

    protected JComponent createCenterPanel() {
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)1));
        this.myCenterPanel.add(CARD_STATUS, scrollPane);
        this.myTreeBrowser = new CommittedChangesTreeBrowser(this.myProject, Collections.emptyList());
        Disposer.register((Disposable)this, (Disposable)this.myTreeBrowser);
        this.myTreeBrowser.setHelpId(this.getHelpId());
        this.myCenterPanel.add(CARD_CHANGES, this.myTreeBrowser);
        return this.myCenterPanel;
    }

    private void createTree() {
        SmartExpander.installOn((JTree)this.myTree);
        SelectionSaver.installOn((JTree)this.myTree);
        this.createTreeModel();
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new UpdateTreeCellRenderer()));
        TreeUtil.installActions((JTree)this.myTree);
        new TreeSpeedSearch(this.myTree, path2 -> {
            Object last = path2.getLastPathComponent();
            if (last instanceof AbstractTreeNode) {
                return ((AbstractTreeNode)last).getText();
            }
            return (String)TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING.convert(path2);
        }, true);
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("UpdateActionGroup");
                if (group != null) {
                    ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("UpdatePopup", (ActionGroup)group);
                    popupMenu.getComponent().show(comp, x, y);
                }
            }
        });
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        EditSourceOnEnterKeyHandler.install((JTree)this.myTree);
        this.myTree.setSelectionRow(0);
    }

    private void createTreeModel() {
        this.myRoot = new UpdateRootNode(this.myUpdatedFiles, this.myProject, this.myRootName, this.myActionInfo);
        this.updateTreeModel();
        this.myTreeModel = new DefaultTreeModel(this.myRoot);
        this.myRoot.setTreeModel(this.myTreeModel);
        this.myTree.setModel((TreeModel)this.myTreeModel);
        this.myRoot.setTree((JTree)this.myTree);
    }

    private void updateTreeModel() {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        this.myRoot.rebuild(this.myVcsConfiguration.UPDATE_GROUP_BY_PACKAGES, this.getScopeFilter(), this.myVcsConfiguration.UPDATE_FILTER_BY_SCOPE);
        if (this.myTreeModel != null) {
            this.myTreeModel.reload();
        }
    }

    public Object getData(@NotNull String dataId) {
        if (this.myTreeBrowser != null && this.myTreeBrowser.isVisible()) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            VirtualFilePointer pointer = this.getSelectedFilePointer();
            if (pointer == null || !pointer.isValid()) {
                return null;
            }
            VirtualFile selectedFile = pointer.getFile();
            return selectedFile != null ? new OpenFileDescriptor(this.myProject, selectedFile) : null;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.getVirtualFileArray();
        }
        if (VcsDataKeys.IO_FILE_ARRAY.is(dataId)) {
            return this.getFileArray();
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            if (this.myGroupByChangeList) {
                return this.myTreeBrowser != null ? this.myTreeBrowser.getTreeExpander() : null;
            }
            return this.myTreeExpander;
        }
        if (VcsDataKeys.UPDATE_VIEW_SELECTED_PATH.is(dataId)) {
            VirtualFilePointer pointer = this.getSelectedFilePointer();
            return pointer != null ? UpdateInfoTree.getFilePath(pointer) : null;
        }
        if (VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE.is(dataId)) {
            return this.myTreeIterable;
        }
        if (VcsDataKeys.LABEL_BEFORE.is(dataId)) {
            return this.myBefore;
        }
        if (VcsDataKeys.LABEL_AFTER.is(dataId)) {
            return this.myAfter;
        }
        return super.getData(dataId);
    }

    @Nullable
    private VirtualFilePointer getSelectedFilePointer() {
        TreePath path2 = this.myTree.getSelectionPath();
        if (path2 == null) {
            return null;
        }
        AbstractTreeNode treeNode = (AbstractTreeNode)path2.getLastPathComponent();
        return treeNode instanceof FileTreeNode ? ((FileTreeNode)treeNode).getFilePointer() : null;
    }

    private VirtualFile[] getVirtualFileArray() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                AbstractTreeNode treeNode = (AbstractTreeNode)selectionPath.getLastPathComponent();
                result2.addAll(treeNode.getVirtualFiles());
            }
        }
        return VfsUtil.toVirtualFileArray(result2);
    }

    private File @Nullable [] getFileArray() {
        ArrayList<File> result2 = new ArrayList<File>();
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                AbstractTreeNode treeNode = (AbstractTreeNode)selectionPath.getLastPathComponent();
                result2.addAll(treeNode.getFiles());
            }
        }
        if (result2.isEmpty()) {
            return null;
        }
        return result2.toArray(new File[0]);
    }

    int getFilteredFilesCount() {
        Pair<PackageSetBase, NamedScopesHolder> scopeFilter = this.getScopeFilter();
        int[] result2 = new int[1];
        TreeUtil.traverse((TreeNode)this.myRoot, node -> {
            if (node instanceof FileTreeNode && ((FileTreeNode)node).acceptFilter(scopeFilter, true)) {
                result2[0] = result2[0] + 1;
            }
            return true;
        });
        return result2[0];
    }

    public void expandRootChildren() {
        TreeNode root = (TreeNode)this.myTreeModel.getRoot();
        if (root.getChildCount() == 1) {
            this.myTree.expandPath(new TreePath(new Object[]{root, root.getChildAt(0)}));
        }
    }

    public void setChangeLists(List<? extends CommittedChangeList> receivedChanges) {
        boolean hasEmptyCaches = CommittedChangesCache.getInstance(this.myProject).hasEmptyCaches();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (Disposer.isDisposed((Disposable)this)) {
                return;
            }
            if (this.myLoadingChangeListsLabel != null) {
                this.remove(this.myLoadingChangeListsLabel);
                this.myLoadingChangeListsLabel = null;
            }
            this.myCommittedChangeLists = receivedChanges;
            this.myTreeBrowser.setItems(this.myCommittedChangeLists, CommittedChangesBrowserUseCase.UPDATE);
            if (hasEmptyCaches) {
                StatusText statusText2 = this.myTreeBrowser.getEmptyText();
                statusText2.clear();
                statusText2.appendText("Click ").appendText("Refresh", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RefreshIncomingChangesAction.doRefresh(UpdateInfoTree.this.myProject);
                    }
                }).appendText(" to initialize repository changes cache");
            }
        }, this.myProject.getDisposed());
    }

    public void setBefore(Label before) {
        this.myBefore = before;
    }

    public void setAfter(Label after) {
        this.myAfter = after;
    }

    @Nullable
    private Pair<PackageSetBase, NamedScopesHolder> getScopeFilter() {
        String scopeName = this.getFilterScopeName();
        if (scopeName != null) {
            for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)this.myProject)) {
                PackageSet packageSet;
                NamedScope scope2 = holder.getScope(scopeName);
                if (scope2 == null || !((packageSet = scope2.getValue()) instanceof PackageSetBase)) continue;
                return Pair.create((Object)((PackageSetBase)packageSet), (Object)holder);
            }
        }
        return null;
    }

    @Nullable
    private String getFilterScopeName() {
        return this.myVcsConfiguration.UPDATE_FILTER_SCOPE_NAME;
    }

    @Nullable
    NamedScope getFilterScope() {
        Pair<PackageSetBase, NamedScopesHolder> filter = this.getScopeFilter();
        return filter == null ? null : ((NamedScopesHolder)filter.second).getScope(this.getFilterScopeName());
    }

    @Nullable
    private static FilePath getFilePath(@NotNull VirtualFilePointer filePointer) {
        String path2 = VirtualFileManager.extractPath((String)filePointer.getUrl());
        if (StringUtil.isEmpty((String)path2)) {
            return null;
        }
        return VcsUtil.getFilePath((String)path2, (boolean)false);
    }

    private class FilterAction
    extends ToggleAction
    implements DumbAware {
        FilterAction() {
            super(VcsBundle.messagePointer((String)"action.ToggleAction.text.scope.filter", (Object[])new Object[0]), () -> VcsBundle.getString((String)"settings.filter.update.project.info.by.scope"), AllIcons.General.Filter);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return ((UpdateInfoTree)UpdateInfoTree.this).myVcsConfiguration.UPDATE_FILTER_BY_SCOPE;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            ((UpdateInfoTree)UpdateInfoTree.this).myVcsConfiguration.UPDATE_FILTER_BY_SCOPE = state;
            UpdateInfoTree.this.updateTreeModel();
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(!UpdateInfoTree.this.myGroupByChangeList && UpdateInfoTree.this.getFilterScopeName() != null);
        }
    }

    private class GroupByChangeListAction
    extends ToggleAction
    implements DumbAware {
        GroupByChangeListAction() {
            super(VcsBundle.messagePointer((String)"update.info.group.by.changelist", (Object[])new Object[0]), AllIcons.Actions.ShowAsTree);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return UpdateInfoTree.this.myGroupByChangeList;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            UpdateInfoTree.this.myGroupByChangeList = state;
            ((UpdateInfoTree)UpdateInfoTree.this).myVcsConfiguration.UPDATE_GROUP_BY_CHANGELIST = UpdateInfoTree.this.myGroupByChangeList;
            CardLayout cardLayout = (CardLayout)UpdateInfoTree.this.myCenterPanel.getLayout();
            if (!UpdateInfoTree.this.myGroupByChangeList) {
                cardLayout.show(UpdateInfoTree.this.myCenterPanel, UpdateInfoTree.CARD_STATUS);
            } else {
                cardLayout.show(UpdateInfoTree.this.myCenterPanel, UpdateInfoTree.CARD_CHANGES);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setVisible(UpdateInfoTree.this.myCanGroupByChangeList);
        }
    }

    private class MyGroupByPackagesAction
    extends ToggleAction
    implements DumbAware {
        MyGroupByPackagesAction() {
            super(VcsBundle.messagePointer((String)"action.name.group.by.packages", (Object[])new Object[0]), PlatformIcons.GROUP_BY_PACKAGES);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return ((UpdateInfoTree)UpdateInfoTree.this).myVcsConfiguration.UPDATE_GROUP_BY_PACKAGES;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            ((UpdateInfoTree)UpdateInfoTree.this).myVcsConfiguration.UPDATE_GROUP_BY_PACKAGES = state;
            UpdateInfoTree.this.updateTreeModel();
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(!UpdateInfoTree.this.myGroupByChangeList);
        }
    }

    private class MyTreeIterable
    implements Iterable<Pair<FilePath, FileStatus>> {
        private MyTreeIterable() {
        }

        @Override
        public Iterator<Pair<FilePath, FileStatus>> iterator() {
            return new MyTreeIterator();
        }
    }

    private class MyTreeIterator
    implements Iterator<Pair<FilePath, FileStatus>> {
        private final Enumeration myEnum;
        private FilePath myNext;
        private FileStatus myStatus;

        private MyTreeIterator() {
            this.myEnum = UpdateInfoTree.this.myRoot.depthFirstEnumeration();
            this.step();
        }

        @Override
        public boolean hasNext() {
            return this.myNext != null;
        }

        @Override
        public Pair<FilePath, FileStatus> next() {
            FilePath result2 = this.myNext;
            FileStatus status = this.myStatus;
            this.step();
            return Pair.create((Object)result2, (Object)status);
        }

        private void step() {
            this.myNext = null;
            while (this.myEnum.hasMoreElements()) {
                FileTreeNode treeNode;
                VirtualFilePointer filePointer;
                FilePath filePath;
                Object o = this.myEnum.nextElement();
                if (!(o instanceof FileTreeNode) || (filePath = UpdateInfoTree.getFilePath(filePointer = (treeNode = (FileTreeNode)o).getFilePointer())) == null) continue;
                this.myNext = filePath;
                this.myStatus = FileStatus.MODIFIED;
                GroupTreeNode parent = this.findParentGroupTreeNode(treeNode.getParent());
                if (parent == null) break;
                String id = parent.getFileGroupId();
                if ("CREATED".equals(id)) {
                    this.myStatus = FileStatus.ADDED;
                    break;
                }
                if (!"REMOVED_FROM_REPOSITORY".equals(id)) break;
                this.myStatus = FileStatus.DELETED;
                break;
            }
        }

        @Nullable
        private GroupTreeNode findParentGroupTreeNode(@NotNull TreeNode treeNode) {
            TreeNode currentNode;
            for (currentNode = treeNode; currentNode != null && !(currentNode instanceof GroupTreeNode); currentNode = currentNode.getParent()) {
            }
            return (GroupTreeNode)currentNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

