/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOptionImpl;
import com.intellij.openapi.vcs.VcsShowOptionsSettingImpl;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionsAndConfirmations {
    private final Map<String, VcsShowOptionsSettingImpl> myOptions = new LinkedHashMap<String, VcsShowOptionsSettingImpl>();
    private final Map<String, VcsShowConfirmationOptionImpl> myConfirmations = new LinkedHashMap<String, VcsShowConfirmationOptionImpl>();

    public OptionsAndConfirmations() {
        this.createSettingFor(VcsConfiguration.StandardOption.ADD);
        this.createSettingFor(VcsConfiguration.StandardOption.REMOVE);
        this.createSettingFor(VcsConfiguration.StandardOption.CHECKOUT);
        this.createSettingFor(VcsConfiguration.StandardOption.UPDATE);
        this.createSettingFor(VcsConfiguration.StandardOption.STATUS);
        this.createSettingFor(VcsConfiguration.StandardOption.EDIT);
        this.createConfirmationFor(VcsConfiguration.StandardConfirmation.ADD);
        this.createConfirmationFor(VcsConfiguration.StandardConfirmation.REMOVE);
    }

    @NotNull
    public VcsShowConfirmationOptionImpl getConfirmation(VcsConfiguration.StandardConfirmation option2) {
        return this.myConfirmations.get(option2.getId());
    }

    private void createSettingFor(VcsConfiguration.StandardOption option2) {
        this.getOrCreateOption(option2.getId());
    }

    private void createConfirmationFor(VcsConfiguration.StandardConfirmation confirmation) {
        String id = confirmation.getId();
        this.myConfirmations.put(id, new VcsShowConfirmationOptionImpl(id));
    }

    @NotNull
    public VcsShowSettingOption getOptions(VcsConfiguration.StandardOption option2) {
        return this.myOptions.get(option2.getId());
    }

    public List<VcsShowOptionsSettingImpl> getAllOptions() {
        return new ArrayList<VcsShowOptionsSettingImpl>(this.myOptions.values());
    }

    public List<VcsShowConfirmationOptionImpl> getAllConfirmations() {
        return new ArrayList<VcsShowConfirmationOptionImpl>(this.myConfirmations.values());
    }

    @NotNull
    public VcsShowSettingOption getOrCreateCustomOption(@NotNull String vcsActionName, @NotNull AbstractVcs vcs) {
        VcsShowOptionsSettingImpl option2 = this.getOrCreateOption(vcsActionName);
        option2.addApplicableVcs(vcs);
        return option2;
    }

    @NotNull
    VcsShowOptionsSettingImpl getOrCreateOption(String actionName) {
        if (!this.myOptions.containsKey(actionName)) {
            this.myOptions.put(actionName, new VcsShowOptionsSettingImpl(actionName));
        }
        return this.myOptions.get(actionName);
    }

    @Nullable
    VcsShowConfirmationOptionImpl getConfirmation(String id) {
        return this.myConfirmations.get(id);
    }

    Map<String, VcsShowOptionsSettingImpl> getOptions() {
        return this.myOptions;
    }

    Map<String, VcsShowConfirmationOptionImpl> getConfirmations() {
        return this.myConfirmations;
    }
}

