/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class VcsInitialization {
    private static final Logger LOG = Logger.getInstance(VcsInitialization.class);
    private final Object myLock = new Object();
    @NotNull
    private final Project myProject;
    private Status myStatus = Status.PENDING;
    private final List<VcsStartupActivity> myInitActivities = new ArrayList<VcsStartupActivity>();
    private final List<VcsStartupActivity> myPostActivities = new ArrayList<VcsStartupActivity>();
    private volatile Future<?> myFuture;
    private final ProgressIndicator myIndicator = new StandardProgressIndicatorBase();

    VcsInitialization(@NotNull Project project) {
        this.myProject = project;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Disposable disposable = ((ProjectEx)project).getEarlyDisposable();
            Disposer.register((Disposable)disposable, () -> this.cancelBackgroundInitialization());
        }
    }

    public static VcsInitialization getInstance(Project project) {
        return (VcsInitialization)project.getService(VcsInitialization.class);
    }

    private void startInitialization() {
        this.myFuture = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(new Task.Backgroundable(this.myProject, "VCS Initialization"){

            public void run(@NotNull ProgressIndicator indicator) {
                VcsInitialization.this.execute();
            }
        }, this.myIndicator, null);
    }

    void add(@NotNull VcsInitObject vcsInitObject, @NotNull Runnable runnable) {
        if (this.myProject.isDefault()) {
            return;
        }
        boolean wasScheduled = this.scheduleActivity(vcsInitObject, runnable);
        if (!wasScheduled) {
            BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, (Runnable)runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scheduleActivity(@NotNull VcsInitObject vcsInitObject, @NotNull Runnable runnable) {
        Object object = this.myLock;
        synchronized (object) {
            ProxyVcsStartupActivity activity = new ProxyVcsStartupActivity(vcsInitObject, runnable);
            if (VcsInitialization.isInitActivity(activity)) {
                if (this.myStatus == Status.PENDING) {
                    this.myInitActivities.add(activity);
                    return true;
                }
                LOG.warn(String.format("scheduling late initialization: %s", activity));
                return false;
            }
            if (this.myStatus == Status.PENDING || this.myStatus == Status.RUNNING_INIT) {
                this.myPostActivities.add(activity);
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("scheduling late post activity: %s", activity));
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        LOG.assertTrue(!this.myProject.isDefault());
        try {
            this.runInitStep(Status.PENDING, Status.RUNNING_INIT, (Condition<VcsStartupActivity>)((Condition)it -> VcsInitialization.isInitActivity(it)), this.myInitActivities);
            this.runInitStep(Status.RUNNING_INIT, Status.RUNNING_POST, (Condition<VcsStartupActivity>)((Condition)it -> !VcsInitialization.isInitActivity(it)), this.myPostActivities);
        }
        finally {
            Object object = this.myLock;
            synchronized (object) {
                this.myStatus = Status.FINISHED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInitStep(@NotNull Status current, @NotNull Status next, @NotNull Condition<VcsStartupActivity> extensionFilter, @NotNull List<VcsStartupActivity> pendingActivities) {
        List epActivities = ContainerUtil.filter((Collection)VcsStartupActivity.EP_NAME.getExtensionList(), extensionFilter);
        ArrayList<VcsStartupActivity> activities = new ArrayList<VcsStartupActivity>();
        Object object = this.myLock;
        synchronized (object) {
            assert (this.myStatus == current);
            this.myStatus = next;
            activities.addAll(epActivities);
            activities.addAll(pendingActivities);
            pendingActivities.clear();
        }
        this.runActivities(activities);
    }

    private void runActivities(@NotNull List<VcsStartupActivity> activities) {
        Future<?> future2 = this.myFuture;
        if (future2 != null && future2.isCancelled()) {
            return;
        }
        Collections.sort(activities, Comparator.comparingInt(VcsStartupActivity::getOrder));
        for (VcsStartupActivity activity : activities) {
            ProgressManager.checkCanceled();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("running activity: %s", activity));
            }
            QueueProcessor.runSafely(() -> activity.runActivity(this.myProject));
        }
    }

    private void cancelBackgroundInitialization() {
        this.myIndicator.cancel();
        Future<?> future2 = this.myFuture;
        LOG.debug(String.format("cancelBackgroundInitialization() future=%s from %s with write access=%s", future2, Thread.currentThread(), ApplicationManager.getApplication().isWriteAccessAllowed()));
        if (future2 != null) {
            future2.cancel(false);
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                SwingUtilities.invokeLater(this::waitNotRunning);
            } else {
                this.waitNotRunning();
            }
        }
    }

    private void waitNotRunning() {
        boolean success2 = this.waitFor(status -> status == Status.PENDING || status == Status.FINISHED);
        if (!success2) {
            LOG.warn("Failed to wait for VCS initialization cancellation for project " + this.myProject, new Throwable());
        }
    }

    void waitFinished() {
        boolean success2 = this.waitFor(status -> status == Status.FINISHED);
        if (!success2) {
            LOG.error("Failed to wait for VCS initialization completion for project " + this.myProject, new Throwable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitFor(@NotNull Predicate<? super Status> predicate) {
        if (this.myProject.isDefault()) {
            throw new IllegalArgumentException();
        }
        long start2 = System.currentTimeMillis();
        while (System.currentTimeMillis() < start2 + 10000L) {
            Object object = this.myLock;
            synchronized (object) {
                if (predicate.test(this.myStatus)) {
                    return true;
                }
            }
            TimeoutUtil.sleep((long)10L);
        }
        return false;
    }

    private static boolean isInitActivity(@NotNull VcsStartupActivity activity) {
        return activity.getOrder() < VcsInitObject.AFTER_COMMON.getOrder();
    }

    private static class ProxyVcsStartupActivity
    implements VcsStartupActivity {
        @NotNull
        private final Runnable myRunnable;
        private final int myOrder;

        private ProxyVcsStartupActivity(@NotNull VcsInitObject vcsInitObject, @NotNull Runnable runnable) {
            this.myOrder = vcsInitObject.getOrder();
            this.myRunnable = runnable;
        }

        @Override
        public void runActivity(@NotNull Project project) {
            this.myRunnable.run();
        }

        @Override
        public int getOrder() {
            return this.myOrder;
        }

        public String toString() {
            return String.format("ProxyVcsStartupActivity{runnable=%s, order=%s}", this.myRunnable, this.myOrder);
        }
    }

    static final class ShutDownProjectListener
    implements ProjectManagerListener {
        ShutDownProjectListener() {
        }

        public void projectClosing(@NotNull Project project) {
            if (project.isDefault()) {
                return;
            }
            VcsInitialization vcsInitialization = (VcsInitialization)project.getServiceIfCreated(VcsInitialization.class);
            if (vcsInitialization != null) {
                vcsInitialization.cancelBackgroundInitialization();
            }
        }
    }

    static final class StartUpActivity
    implements StartupActivity.DumbAware {
        StartUpActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project.isDefault()) {
                return;
            }
            VcsInitialization vcsInitialization = (VcsInitialization)project.getService(VcsInitialization.class);
            vcsInitialization.startInitialization();
        }
    }

    private static enum Status {
        PENDING,
        RUNNING_INIT,
        RUNNING_POST,
        FINISHED;

    }
}

