/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConsoleLine;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootSettings;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowConfirmationOptionImpl;
import com.intellij.openapi.vcs.VcsShowOptionsSettingImpl;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.VirtualFileFilter;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.checkout.CompositeCheckoutListener;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.DefaultVcsRootChecker;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.impl.VcsCacheManager;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsInitialization;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.MappingsToRoots;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vcs.impl.projectlevelman.OptionsAndConfirmations;
import com.intellij.openapi.vcs.impl.projectlevelman.ProjectLevelVcsManagerSerialization;
import com.intellij.openapi.vcs.roots.VcsRootScanner;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.project.ProjectKt;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.ViewUpdateInfoNotification;
import com.intellij.vcs.console.VcsConsoleView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectLevelVcsManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ProjectLevelVcsManagerImpl
extends ProjectLevelVcsManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(ProjectLevelVcsManagerImpl.class);
    @NonNls
    private static final String SETTINGS_EDITED_MANUALLY = "settingsEditedManually";
    private final ProjectLevelVcsManagerSerialization mySerialization;
    private final OptionsAndConfirmations myOptionsAndConfirmations;
    private final NewMappings myMappings;
    private final Project myProject;
    @NonNls
    private static final String ELEMENT_MAPPING = "mapping";
    @NonNls
    private static final String ATTRIBUTE_DIRECTORY = "directory";
    @NonNls
    private static final String ATTRIBUTE_VCS = "vcs";
    @NonNls
    private static final String ATTRIBUTE_DEFAULT_PROJECT = "defaultProject";
    @NonNls
    private static final String ELEMENT_ROOT_SETTINGS = "rootSettings";
    @NonNls
    private static final String ATTRIBUTE_CLASS = "class";
    private boolean myMappingsLoaded;
    private boolean myHaveLegacyVcsConfiguration;
    @NotNull
    private final AtomicInteger myBackgroundOperationCounter = new AtomicInteger();
    private final Set<ActionKey> myBackgroundRunningTasks = new HashSet<ActionKey>();
    private final List<VcsConsoleLine> myPendingOutput = new ArrayList<VcsConsoleLine>();
    private final FileIndexFacade myExcludedIndex;
    private final Map<VcsListener, MessageBusConnection> myAdapters = new HashMap<VcsListener, MessageBusConnection>();

    public ProjectLevelVcsManagerImpl(@NotNull Project project) {
        this.myProject = project;
        this.myExcludedIndex = FileIndexFacade.getInstance((Project)project);
        this.mySerialization = new ProjectLevelVcsManagerSerialization();
        this.myOptionsAndConfirmations = new OptionsAndConfirmations();
        this.myMappings = new NewMappings(this.myProject, this);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myMappings);
    }

    public static ProjectLevelVcsManagerImpl getInstanceImpl(@NotNull Project project) {
        return (ProjectLevelVcsManagerImpl)ProjectLevelVcsManagerImpl.getInstance((Project)project);
    }

    public void registerVcs(AbstractVcs vcs) {
        AllVcses.getInstance(this.myProject).registerManually(vcs);
    }

    @Nullable
    public AbstractVcs findVcsByName(@Nullable String name) {
        AbstractVcs result2 = name == null || this.myProject.isDisposed() ? null : AllVcses.getInstance(this.myProject).getByName(name);
        ProgressManager.checkCanceled();
        return result2;
    }

    @Nullable
    public VcsDescriptor getDescriptor(String name) {
        if (name == null) {
            return null;
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        return AllVcses.getInstance(this.myProject).getDescriptor(name);
    }

    public void iterateVfUnderVcsRoot(VirtualFile file, Processor<? super VirtualFile> processor) {
        VcsRootIterator.iterateVfUnderVcsRoot(this.myProject, file, processor);
    }

    public VcsDescriptor[] getAllVcss() {
        return AllVcses.getInstance(this.myProject).getAll();
    }

    public boolean haveVcses() {
        return !AllVcses.getInstance(this.myProject).isEmpty();
    }

    @NotNull
    public VcsAnnotationLocalChangesListener getAnnotationLocalChangesListener() {
        return (VcsAnnotationLocalChangesListener)this.myProject.getService(VcsAnnotationLocalChangesListener.class);
    }

    public boolean checkAllFilesAreUnder(AbstractVcs abstractVcs, VirtualFile[] files) {
        if (files == null) {
            return false;
        }
        for (VirtualFile file : files) {
            if (this.getVcsFor(file) == abstractVcs) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public AbstractVcs getVcsFor(@NotNull VirtualFile file) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.vcs : null;
    }

    @Nullable
    public AbstractVcs getVcsFor(@NotNull FilePath file) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.vcs : null;
    }

    @Nullable
    public VirtualFile getVcsRootFor(@Nullable VirtualFile file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.root : null;
    }

    @Nullable
    public VcsRoot getVcsRootObjectFor(@Nullable VirtualFile file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? new VcsRoot(root.vcs, root.root) : null;
    }

    @Nullable
    public VirtualFile getVcsRootFor(@Nullable FilePath file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.root : null;
    }

    public VcsRoot getVcsRootObjectFor(@Nullable FilePath file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? new VcsRoot(root.vcs, root.root) : null;
    }

    public void unregisterVcs(@NotNull AbstractVcs vcs) {
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myMappings.haveActiveVcs(vcs.getName())) {
            LOG.warn("Active vcs '" + vcs.getName() + "' is being unregistered. Remove from mappings first.");
        }
        this.myMappings.beingUnregistered(vcs.getName());
        AllVcses.getInstance(this.myProject).unregisterManually(vcs);
    }

    @Override
    @Nullable
    public ContentManager getContentManager() {
        ToolWindow changes = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Version Control");
        return changes == null ? null : changes.getContentManager();
    }

    public boolean checkVcsIsActive(AbstractVcs vcs) {
        return this.checkVcsIsActive(vcs.getName());
    }

    public boolean checkVcsIsActive(String vcsName) {
        return this.myMappings.haveActiveVcs(vcsName);
    }

    public AbstractVcs @NotNull [] getAllActiveVcss() {
        return this.myMappings.getActiveVcses();
    }

    public boolean hasActiveVcss() {
        return this.myMappings.hasActiveVcss();
    }

    public boolean hasAnyMappings() {
        return !this.myMappings.isEmpty();
    }

    @Deprecated
    public void addMessageToConsoleWindow(String message, TextAttributes attributes2) {
        this.addMessageToConsoleWindow(message, new ConsoleViewContentType("", attributes2));
    }

    public void addMessageToConsoleWindow(@Nullable String message, @NotNull ConsoleViewContentType contentType) {
        this.addMessageToConsoleWindow(VcsConsoleLine.create((String)message, (ConsoleViewContentType)contentType));
    }

    public void addMessageToConsoleWindow(@Nullable VcsConsoleLine line) {
        if (!Registry.is((String)"vcs.showConsole")) {
            return;
        }
        if (line == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed() || this.myProject.isDefault()) {
                return;
            }
            ContentManager contentManager = this.getContentManager();
            if (contentManager == null) {
                this.myPendingOutput.add(line);
            } else {
                VcsConsoleContent panel2 = this.getOrCreateConsoleContent(contentManager);
                panel2.printToConsole(line);
            }
        }, ModalityState.defaultModalityState());
    }

    @Nullable
    private static VcsConsoleContent getConsoleContent(@NotNull ContentManager contentManager) {
        return (VcsConsoleContent)((Object)ContainerUtil.findInstance((Object[])contentManager.getContents(), VcsConsoleContent.class));
    }

    @NotNull
    private VcsConsoleContent getOrCreateConsoleContent(@NotNull ContentManager contentManager) {
        LOG.assertTrue(Registry.is((String)"vcs.showConsole"));
        VcsConsoleContent console = ProjectLevelVcsManagerImpl.getConsoleContent(contentManager);
        if (console != null) {
            return console;
        }
        VcsConsoleContent newConsole = new VcsConsoleContent(this.myProject);
        for (VcsConsoleLine line : this.myPendingOutput) {
            newConsole.printToConsole(line);
        }
        this.myPendingOutput.clear();
        contentManager.addContent((Content)newConsole);
        return newConsole;
    }

    @Override
    @NotNull
    public VcsShowSettingOption getOptions(VcsConfiguration.StandardOption option2) {
        return this.myOptionsAndConfirmations.getOptions(option2);
    }

    @Override
    public List<VcsShowOptionsSettingImpl> getAllOptions() {
        return this.myOptionsAndConfirmations.getAllOptions();
    }

    @NotNull
    public VcsShowSettingOption getStandardOption(@NotNull VcsConfiguration.StandardOption option2, @NotNull AbstractVcs vcs) {
        VcsShowOptionsSettingImpl options = (VcsShowOptionsSettingImpl)this.getOptions(option2);
        options.addApplicableVcs(vcs);
        return options;
    }

    @NotNull
    public VcsShowSettingOption getOrCreateCustomOption(@NotNull String vcsActionName, @NotNull AbstractVcs vcs) {
        return this.myOptionsAndConfirmations.getOrCreateCustomOption(vcsActionName, vcs);
    }

    public void showProjectOperationInfo(UpdatedFiles updatedFiles, String displayActionName) {
        UpdateInfoTree tree = this.showUpdateProjectInfo(updatedFiles, displayActionName, ActionInfo.STATUS, false);
        if (tree != null) {
            ViewUpdateInfoNotification.focusUpdateInfoTree(this.myProject, tree);
        }
    }

    @Override
    @Nullable
    public UpdateInfoTree showUpdateProjectInfo(UpdatedFiles updatedFiles, String displayActionName, ActionInfo actionInfo, boolean canceled) {
        if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
            return null;
        }
        ContentManager contentManager = this.getContentManager();
        if (contentManager == null) {
            return null;
        }
        UpdateInfoTree updateInfoTree = new UpdateInfoTree(contentManager, this.myProject, updatedFiles, displayActionName, actionInfo);
        String tabName = DateFormatUtil.formatDateTime((long)System.currentTimeMillis());
        ContentUtilEx.addTabbedContent((ContentManager)contentManager, (JComponent)((Object)updateInfoTree), (String)"Update Info", (Supplier)VcsBundle.messagePointer((String)"vcs.update.tab.name", (Object[])new Object[0]), () -> tabName, (boolean)false, (Disposable)updateInfoTree);
        updateInfoTree.expandRootChildren();
        return updateInfoTree;
    }

    public List<VcsDirectoryMapping> getDirectoryMappings() {
        return this.myMappings.getDirectoryMappings();
    }

    public List<VcsDirectoryMapping> getDirectoryMappings(AbstractVcs vcs) {
        return this.myMappings.getDirectoryMappings(vcs.getName());
    }

    @Nullable
    public VcsDirectoryMapping getDirectoryMappingFor(@Nullable FilePath file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.mapping : null;
    }

    @Nullable
    private VcsDirectoryMapping getDirectoryMappingFor(@Nullable VirtualFile file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.mapping : null;
    }

    public void setDirectoryMapping(@NotNull String path2, @Nullable String activeVcsName) {
        if (this.myMappingsLoaded) {
            return;
        }
        this.myHaveLegacyVcsConfiguration = true;
        this.myMappings.setMapping(FileUtil.toSystemIndependentName((String)path2), activeVcsName);
    }

    @Deprecated
    public void setAutoDirectoryMapping(@NotNull String path2, @Nullable String activeVcsName) {
        this.setAutoDirectoryMappings(ContainerUtil.append(this.myMappings.getDirectoryMappings(), (Object[])new VcsDirectoryMapping[]{new VcsDirectoryMapping(path2, activeVcsName)}));
    }

    public void setAutoDirectoryMappings(@NotNull List<? extends VcsDirectoryMapping> mappings) {
        this.myMappings.setDirectoryMappings(mappings);
        this.myMappings.cleanupMappings();
    }

    public void removeDirectoryMapping(@NotNull VcsDirectoryMapping mapping) {
        this.myMappings.removeDirectoryMapping(mapping);
    }

    public void setDirectoryMappings(@NotNull List<VcsDirectoryMapping> items) {
        this.myHaveLegacyVcsConfiguration = true;
        this.myMappings.setDirectoryMappings(items);
    }

    @Override
    public void scheduleMappedRootsUpdate() {
        this.myMappings.scheduleMappedRootsUpdate();
    }

    public void updateMappedVcsesImmediately() {
        this.myMappings.updateMappedVcsesImmediately();
    }

    private void activateActiveVcses() {
        this.myMappings.activateActiveVcses();
    }

    public void iterateVcsRoot(VirtualFile root, Processor<? super FilePath> iterator) {
        VcsRootIterator.iterateVcsRoot(this.myProject, root, iterator);
    }

    public void iterateVcsRoot(VirtualFile root, Processor<? super FilePath> iterator, @Nullable VirtualFileFilter directoryFilter) {
        VcsRootIterator.iterateVcsRoot(this.myProject, root, iterator, directoryFilter);
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        this.mySerialization.writeExternalUtil(element, this.myOptionsAndConfirmations);
        if (this.myHaveLegacyVcsConfiguration) {
            element.setAttribute(SETTINGS_EDITED_MANUALLY, "true");
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        this.mySerialization.readExternalUtil(state, this.myOptionsAndConfirmations);
        Attribute attribute = state.getAttribute(SETTINGS_EDITED_MANUALLY);
        if (attribute != null) {
            try {
                this.myHaveLegacyVcsConfiguration = attribute.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public VcsShowConfirmationOption getStandardConfirmation(@NotNull VcsConfiguration.StandardConfirmation option2, AbstractVcs vcs) {
        VcsShowConfirmationOptionImpl result2 = this.getConfirmation(option2);
        if (vcs != null) {
            result2.addApplicableVcs(vcs);
        }
        return result2;
    }

    @Override
    public List<VcsShowConfirmationOptionImpl> getAllConfirmations() {
        return this.myOptionsAndConfirmations.getAllConfirmations();
    }

    @Override
    @NotNull
    public VcsShowConfirmationOptionImpl getConfirmation(VcsConfiguration.StandardConfirmation option2) {
        return this.myOptionsAndConfirmations.getConfirmation(option2);
    }

    public void addVcsListener(VcsListener listener2) {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(VCS_CONFIGURATION_CHANGED, (Object)listener2);
        this.myAdapters.put(listener2, connection);
    }

    public void removeVcsListener(VcsListener listener2) {
        MessageBusConnection connection = this.myAdapters.remove(listener2);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public void startBackgroundVcsOperation() {
        this.myBackgroundOperationCounter.incrementAndGet();
    }

    public void stopBackgroundVcsOperation() {
        assert (!ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
        int counter = this.myBackgroundOperationCounter.getAndDecrement();
        LOG.assertTrue(counter > 0, (Object)("myBackgroundOperationCounter was " + counter + " while should have been > 0"));
    }

    public boolean isBackgroundVcsOperationRunning() {
        return this.myBackgroundOperationCounter.get() > 0;
    }

    public List<VirtualFile> getRootsUnderVcsWithoutFiltering(AbstractVcs vcs) {
        return this.myMappings.getMappingsAsFilesUnderVcs(vcs);
    }

    public VirtualFile @NotNull [] getRootsUnderVcs(@NotNull AbstractVcs vcs) {
        return MappingsToRoots.getRootsUnderVcs(this.myProject, this.myMappings, vcs);
    }

    public List<VirtualFile> getDetailedVcsMappings(@NotNull AbstractVcs vcs) {
        return MappingsToRoots.getDetailedVcsMappings(this.myProject, this.myMappings, vcs);
    }

    public VirtualFile[] getAllVersionedRoots() {
        AbstractVcs[] vcses;
        ArrayList vFiles = new ArrayList();
        for (AbstractVcs vcs : vcses = this.myMappings.getActiveVcses()) {
            Collections.addAll(vFiles, this.getRootsUnderVcs(vcs));
        }
        return VfsUtilCore.toVirtualFileArray(vFiles);
    }

    public VcsRoot @NotNull [] getAllVcsRoots() {
        AbstractVcs[] vcses;
        ArrayList<VcsRoot> vcsRoots = new ArrayList<VcsRoot>();
        for (AbstractVcs vcs : vcses = this.myMappings.getActiveVcses()) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = this.getRootsUnderVcs(vcs)) {
                vcsRoots.add(new VcsRoot(vcs, root));
            }
        }
        return vcsRoots.toArray(new VcsRoot[0]);
    }

    @Override
    public void notifyDirectoryMappingChanged() {
        ((VcsListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VCS_CONFIGURATION_CHANGED)).directoryMappingChanged();
    }

    void readDirectoryMappings(@NotNull Element element) {
        ArrayList<VcsDirectoryMapping> mappingsList = new ArrayList<VcsDirectoryMapping>();
        boolean haveNonEmptyMappings = false;
        for (Element child : element.getChildren(ELEMENT_MAPPING)) {
            String vcs = child.getAttributeValue(ATTRIBUTE_VCS);
            String directory = child.getAttributeValue(ATTRIBUTE_DIRECTORY);
            if (directory == null) continue;
            VcsRootSettings rootSettings = null;
            Element rootSettingsElement = child.getChild(ELEMENT_ROOT_SETTINGS);
            if (rootSettingsElement != null) {
                AbstractVcs vcsInstance;
                String className = rootSettingsElement.getAttributeValue(ATTRIBUTE_CLASS);
                AbstractVcs abstractVcs = vcsInstance = vcs == null ? null : this.findVcsByName(vcs);
                if (vcsInstance != null && className != null && (rootSettings = vcsInstance.createEmptyVcsRootSettings()) != null) {
                    try {
                        rootSettings.readExternal(rootSettingsElement);
                    }
                    catch (InvalidDataException e) {
                        LOG.error("Failed to load VCS root settings class " + className + " for VCS " + vcsInstance.getClass().getName(), (Throwable)e);
                    }
                }
            }
            VcsDirectoryMapping mapping = new VcsDirectoryMapping(directory, vcs, rootSettings);
            mappingsList.add(mapping);
            haveNonEmptyMappings |= !mapping.isDefaultMapping();
        }
        boolean defaultProject = Boolean.TRUE.toString().equals(element.getAttributeValue(ATTRIBUTE_DEFAULT_PROJECT));
        if (haveNonEmptyMappings || !defaultProject) {
            this.myMappingsLoaded = true;
        }
        this.myMappings.setDirectoryMappings(mappingsList);
    }

    void writeDirectoryMappings(@NotNull Element element) {
        if (this.myProject.isDefault()) {
            element.setAttribute(ATTRIBUTE_DEFAULT_PROJECT, Boolean.TRUE.toString());
        }
        for (VcsDirectoryMapping mapping : this.getDirectoryMappings()) {
            VcsRootSettings rootSettings = mapping.getRootSettings();
            if (rootSettings == null && mapping.isDefaultMapping() && mapping.isNoneMapping()) continue;
            Element child = new Element(ELEMENT_MAPPING);
            child.setAttribute(ATTRIBUTE_DIRECTORY, mapping.getDirectory());
            child.setAttribute(ATTRIBUTE_VCS, mapping.getVcs());
            if (rootSettings != null) {
                Element rootSettingsElement = new Element(ELEMENT_ROOT_SETTINGS);
                rootSettingsElement.setAttribute(ATTRIBUTE_CLASS, rootSettings.getClass().getName());
                try {
                    rootSettings.writeExternal(rootSettingsElement);
                    child.addContent(rootSettingsElement);
                }
                catch (WriteExternalException writeExternalException) {
                    // empty catch block
                }
            }
            element.addContent(child);
        }
    }

    public boolean needAutodetectMappings() {
        return !this.myHaveLegacyVcsConfiguration && !this.myMappingsLoaded;
    }

    @Nullable
    public AbstractVcs findVersioningVcs(VirtualFile file) {
        VcsDescriptor[] vcsDescriptors = this.getAllVcss();
        VcsDescriptor probableVcs = null;
        for (VcsDescriptor vcsDescriptor : vcsDescriptors) {
            if (!vcsDescriptor.probablyUnderVcs(file)) continue;
            if (probableVcs != null) {
                return null;
            }
            probableVcs = vcsDescriptor;
        }
        return probableVcs == null ? null : this.findVcsByName(probableVcs.getName());
    }

    @NotNull
    public VcsRootChecker getRootChecker(@NotNull AbstractVcs vcs) {
        for (VcsRootChecker checker : VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList()) {
            if (!checker.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())) continue;
            return checker;
        }
        return new DefaultVcsRootChecker(vcs);
    }

    public CheckoutProvider.Listener getCompositeCheckoutListener() {
        return new CompositeCheckoutListener(this.myProject);
    }

    @Override
    public void fireDirectoryMappingsChanged() {
        if (this.myProject.isOpen() && !this.myProject.isDisposed()) {
            this.myMappings.mappingsChanged();
        }
    }

    @Override
    @Nullable
    public String haveDefaultMapping() {
        return this.myMappings.haveDefaultMapping();
    }

    @Deprecated
    public BackgroundableActionEnabledHandler getBackgroundableActionHandler(VcsBackgroundableActions action) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return new BackgroundableActionEnabledHandler(this.myProject, action);
    }

    boolean isBackgroundTaskRunning(Object ... keys) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myBackgroundRunningTasks.contains(new ActionKey(keys));
    }

    void startBackgroundTask(Object ... keys) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.myBackgroundRunningTasks.add(new ActionKey(keys)));
    }

    void stopBackgroundTask(Object ... keys) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.myBackgroundRunningTasks.remove(new ActionKey(keys)));
    }

    public void addInitializationRequest(@NotNull VcsInitObject vcsInitObject, @NotNull Runnable runnable) {
        VcsInitialization.getInstance(this.myProject).add(vcsInitObject, runnable);
    }

    public void runAfterInitialization(@NotNull Runnable runnable) {
        this.addInitializationRequest(VcsInitObject.AFTER_COMMON, runnable);
    }

    public boolean isFileInContent(@Nullable VirtualFile vf) {
        if (vf == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            boolean isUnderProject = this.isFileInBaseDir(vf) || this.isInDirectoryBasedRoot(vf) || this.hasExplicitMapping(vf) || this.myExcludedIndex.isInContent(vf) || !Registry.is((String)"ide.hide.excluded.files") && this.myExcludedIndex.isExcludedFile(vf);
            return isUnderProject && !this.isIgnored(vf);
        });
    }

    public boolean isIgnored(@NotNull VirtualFile vf) {
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed() || this.myProject.isDefault()) {
                return false;
            }
            if (Registry.is((String)"ide.hide.excluded.files")) {
                return this.myExcludedIndex.isExcludedFile(vf);
            }
            return this.myExcludedIndex.isUnderIgnored(vf);
        });
    }

    public boolean isIgnored(@NotNull FilePath filePath) {
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed() || this.myProject.isDefault()) {
                return false;
            }
            if (Registry.is((String)"ide.hide.excluded.files")) {
                VirtualFile vf = ChangesUtil.findValidParentAccurately((FilePath)filePath);
                return vf != null && this.myExcludedIndex.isExcludedFile(vf);
            }
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            for (String name : StringUtil.tokenize((String)filePath.getPath(), (String)"/")) {
                if (!fileTypeManager.isFileIgnored(name)) continue;
                return true;
            }
            return false;
        });
    }

    private boolean isInDirectoryBasedRoot(@NotNull VirtualFile file) {
        if (ProjectKt.isDirectoryBased((Project)this.myProject)) {
            return ProjectKt.getStateStore((Project)this.myProject).isProjectFile(file);
        }
        return false;
    }

    private boolean isFileInBaseDir(@NotNull VirtualFile file) {
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir == null) {
            return false;
        }
        if (file.isDirectory()) {
            return baseDir.equals(file);
        }
        return baseDir.equals(file.getParent());
    }

    private boolean hasExplicitMapping(@NotNull VirtualFile vFile) {
        VcsDirectoryMapping mapping = this.getDirectoryMappingFor(vFile);
        return mapping != null && !mapping.isDefaultMapping();
    }

    public VcsHistoryCache getVcsHistoryCache() {
        return VcsCacheManager.getInstance(this.myProject).getVcsHistoryCache();
    }

    public ContentRevisionCache getContentRevisionCache() {
        return VcsCacheManager.getInstance(this.myProject).getContentRevisionCache();
    }

    public void waitForInitialized() {
        VcsInitialization.getInstance(this.myProject).waitFinished();
    }

    public void showConsole() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.showConsole(null);
    }

    public void showConsole(@Nullable Runnable then) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!Registry.is((String)"vcs.showConsole")) {
            return;
        }
        ToolWindow vcsToolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Version Control");
        if (vcsToolWindow == null) {
            return;
        }
        if (vcsToolWindow.isVisible()) {
            this.showConsoleInternal();
            if (then != null) {
                then.run();
            }
        } else {
            vcsToolWindow.show(() -> {
                this.showConsoleInternal();
                if (then != null) {
                    then.run();
                }
            });
        }
    }

    public void scrollConsoleToTheEnd() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!Registry.is((String)"vcs.showConsole")) {
            return;
        }
        ContentManager cm = this.getContentManager();
        if (cm == null) {
            return;
        }
        VcsConsoleContent consoleContent = ProjectLevelVcsManagerImpl.getConsoleContent(cm);
        if (consoleContent == null) {
            return;
        }
        consoleContent.scrollToEnd();
    }

    public boolean isConsoleVisible() {
        if (!Registry.is((String)"vcs.showConsole")) {
            return false;
        }
        ContentManager cm = this.getContentManager();
        if (cm == null) {
            return false;
        }
        VcsConsoleContent consoleContent = ProjectLevelVcsManagerImpl.getConsoleContent(cm);
        return consoleContent != null;
    }

    private void showConsoleInternal() {
        ContentManager cm = this.getContentManager();
        if (cm == null) {
            return;
        }
        VcsConsoleContent consoleContent = ProjectLevelVcsManagerImpl.getConsoleContent(cm);
        if (consoleContent == null) {
            return;
        }
        cm.setSelectedContent((Content)consoleContent);
    }

    static final class DetectRootsStartupActivity
    implements VcsStartupActivity {
        DetectRootsStartupActivity() {
        }

        @Override
        public void runActivity(@NotNull Project project) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            VcsRootScanner.start(project);
        }

        @Override
        public int getOrder() {
            return VcsInitObject.AFTER_COMMON.getOrder();
        }
    }

    static final class ActivateVcsesStartupActivity
    implements VcsStartupActivity {
        ActivateVcsesStartupActivity() {
        }

        @Override
        public void runActivity(@NotNull Project project) {
            ProjectLevelVcsManagerImpl.getInstanceImpl(project).activateActiveVcses();
        }

        @Override
        public int getOrder() {
            return VcsInitObject.MAPPINGS.getOrder();
        }
    }

    private static class ActionKey {
        private final Object[] myObjects;

        ActionKey(Object ... objects) {
            this.myObjects = objects;
        }

        public final boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.myObjects, ((ActionKey)o).myObjects);
        }

        public final int hashCode() {
            return Arrays.hashCode(this.myObjects);
        }

        public String toString() {
            return this.getClass() + " - " + Arrays.toString(this.myObjects);
        }
    }

    private static class VcsConsoleContent
    extends ContentImpl {
        @NotNull
        private final ConsoleView myConsole;

        private VcsConsoleContent(@NotNull Project project) {
            super(null, VcsBundle.message((String)"vcs.console.toolwindow.display.name", (Object[])new Object[0]), true);
            SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true);
            this.myConsole = new VcsConsoleView(project);
            Disposer.register((Disposable)this, (Disposable)this.myConsole);
            panel2.setContent(this.myConsole.getComponent());
            DefaultActionGroup actionGroup = new DefaultActionGroup(this.myConsole.createConsoleActions());
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("VcsManager", (ActionGroup)actionGroup, false);
            panel2.setToolbar(toolbar.getComponent());
            this.setComponent((JComponent)panel2);
            this.setPreferredFocusedComponent(() -> ((ConsoleView)this.myConsole).getPreferredFocusableComponent());
        }

        public void scrollToEnd() {
            this.myConsole.requestScrollingToEnd();
        }

        public void printToConsole(@NotNull VcsConsoleLine line) {
            line.print(this.myConsole);
        }
    }
}

