/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.diff.util.Range;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ex.ChangelistsLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Service
@State(name="LineStatusTrackerManager", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0019\u001a\u00020\u0002H\u0016J\u0017\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u0014H\u0000\u00a2\u0006\u0002\b\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0018\u0010\u001f\u001a\n\u0018\u00010\u0015j\u0004\u0018\u0001`\u00162\u0006\u0010\u001e\u001a\u00020\u0002H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0002H\u0002J\u0014\u0010#\u001a\u00020\u00022\n\u0010$\u001a\u00060%j\u0002`&H\u0002J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/vcs/impl/PartialLineStatusTrackerManagerState;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "ATT_CHANGELIST_ID", "", "ATT_CONTENT", "ATT_END_1", "ATT_END_2", "ATT_PATH", "ATT_START_1", "ATT_START_2", "NODE_CURRENT", "NODE_PARTIAL_FILE", "NODE_RANGE", "NODE_RANGES", "NODE_VCS", "storedFileStates", "", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$State;", "Lcom/intellij/openapi/vcs/impl/TrackerState;", "wasLoaded", "", "getState", "getStatesAndClear", "getStatesAndClear$intellij_platform_vcs_impl", "loadState", "", "element", "readPartialFileState", "readRangeState", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$RangeState;", "node", "writePartialFileState", "state", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$FullState;", "Lcom/intellij/openapi/vcs/impl/FullTrackerState;", "writeRangeState", "range", "intellij.platform.vcs.impl"})
public final class PartialLineStatusTrackerManagerState
implements PersistentStateComponent<Element> {
    private final String NODE_PARTIAL_FILE;
    private final String ATT_PATH;
    private final String NODE_VCS;
    private final String NODE_CURRENT;
    private final String ATT_CONTENT;
    private final String NODE_RANGES;
    private final String NODE_RANGE;
    private final String ATT_START_1;
    private final String ATT_END_1;
    private final String ATT_START_2;
    private final String ATT_END_2;
    private final String ATT_CHANGELIST_ID;
    private List<? extends ChangelistsLocalLineStatusTracker.State> storedFileStates;
    private boolean wasLoaded;
    private final Project project;

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        LineStatusTrackerManagerI lineStatusTrackerManagerI = LineStatusTrackerManager.Companion.getInstance(this.project);
        if (lineStatusTrackerManagerI == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vcs.impl.LineStatusTrackerManager");
        }
        List<ChangelistsLocalLineStatusTracker.FullState> fileStates = ((LineStatusTrackerManager)lineStatusTrackerManagerI).collectPartiallyChangedFilesStates$intellij_platform_vcs_impl();
        for (ChangelistsLocalLineStatusTracker.FullState state : fileStates) {
            element.addContent(this.writePartialFileState(state));
        }
        return element;
    }

    public void loadState(@NotNull Element element) {
        if (this.wasLoaded) {
            return;
        }
        boolean bl = false;
        List fileStates = new ArrayList();
        for (Element node : element.getChildren(this.NODE_PARTIAL_FILE)) {
            ChangelistsLocalLineStatusTracker.State state = this.readPartialFileState(node);
            if (state == null) continue;
            fileStates.add(state);
        }
        this.storedFileStates = fileStates;
    }

    @NotNull
    public final List<ChangelistsLocalLineStatusTracker.State> getStatesAndClear$intellij_platform_vcs_impl() {
        List<ChangelistsLocalLineStatusTracker.State> result2 = this.storedFileStates;
        this.storedFileStates = CollectionsKt.emptyList();
        this.wasLoaded = true;
        return result2;
    }

    private final Element writePartialFileState(ChangelistsLocalLineStatusTracker.FullState state) {
        Element element = new Element(this.NODE_PARTIAL_FILE);
        element.setAttribute(this.ATT_PATH, state.getVirtualFile().getPath());
        if (Registry.is((String)"vcs.enable.partial.changelists.persist.file.contents")) {
            element.addContent(new Element(this.NODE_VCS).setAttribute(this.ATT_CONTENT, XmlStringUtil.escapeIllegalXmlChars((String)state.getVcsContent())));
            element.addContent(new Element(this.NODE_CURRENT).setAttribute(this.ATT_CONTENT, XmlStringUtil.escapeIllegalXmlChars((String)state.getCurrentContent())));
        }
        Element rangesNode = new Element(this.NODE_RANGES);
        for (ChangelistsLocalLineStatusTracker.RangeState it : state.getRanges()) {
            rangesNode.addContent(this.writeRangeState(it));
        }
        element.addContent(rangesNode);
        return element;
    }

    private final ChangelistsLocalLineStatusTracker.State readPartialFileState(Element element) {
        String string = element.getAttributeValue(this.ATT_PATH);
        if (string == null) {
            return null;
        }
        String path2 = string;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path2);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Element element2 = element.getChild(this.NODE_VCS);
        String vcsContent = element2 != null ? element2.getAttributeValue(this.ATT_CONTENT) : null;
        Element element3 = element.getChild(this.NODE_CURRENT);
        String currentContent = element3 != null ? element3.getAttributeValue(this.ATT_CONTENT) : null;
        boolean bl = false;
        List rangeStates = new ArrayList();
        Element element4 = element.getChild(this.NODE_RANGES);
        if (element4 == null) {
            return null;
        }
        Element rangesNode = element4;
        for (Element node : rangesNode.getChildren(this.NODE_RANGE)) {
            ChangelistsLocalLineStatusTracker.RangeState rangeState;
            if (this.readRangeState(node) == null) {
                return null;
            }
            rangeStates.add(rangeState);
        }
        if (vcsContent != null && currentContent != null) {
            return new ChangelistsLocalLineStatusTracker.FullState(virtualFile2, rangeStates, XmlStringUtil.unescapeIllegalXmlChars((String)vcsContent), XmlStringUtil.unescapeIllegalXmlChars((String)currentContent));
        }
        return new ChangelistsLocalLineStatusTracker.State(virtualFile2, rangeStates);
    }

    private final Element writeRangeState(ChangelistsLocalLineStatusTracker.RangeState range) {
        return new Element(this.NODE_RANGE).setAttribute(this.ATT_START_1, String.valueOf(range.getRange().start1)).setAttribute(this.ATT_END_1, String.valueOf(range.getRange().end1)).setAttribute(this.ATT_START_2, String.valueOf(range.getRange().start2)).setAttribute(this.ATT_END_2, String.valueOf(range.getRange().end2)).setAttribute(this.ATT_CHANGELIST_ID, range.getChangelistId());
    }

    private final ChangelistsLocalLineStatusTracker.RangeState readRangeState(Element node) {
        Object object = node.getAttributeValue(this.ATT_START_1);
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            return null;
        }
        int start1 = (Integer)object;
        Object object2 = node.getAttributeValue(this.ATT_END_1);
        if (object2 == null || (object2 = StringsKt.toIntOrNull((String)object2)) == null) {
            return null;
        }
        int end1 = (Integer)object2;
        Object object3 = node.getAttributeValue(this.ATT_START_2);
        if (object3 == null || (object3 = StringsKt.toIntOrNull((String)object3)) == null) {
            return null;
        }
        int start2 = (Integer)object3;
        Object object4 = node.getAttributeValue(this.ATT_END_2);
        if (object4 == null || (object4 = StringsKt.toIntOrNull((String)object4)) == null) {
            return null;
        }
        int end2 = (Integer)object4;
        String string = node.getAttributeValue(this.ATT_CHANGELIST_ID);
        if (string == null) {
            return null;
        }
        String changelistId = string;
        return new ChangelistsLocalLineStatusTracker.RangeState(new Range(start1, end1, start2, end2), changelistId, null, 4, null);
    }

    public PartialLineStatusTrackerManagerState(@NotNull Project project) {
        this.project = project;
        this.NODE_PARTIAL_FILE = "file";
        this.ATT_PATH = "path";
        this.NODE_VCS = "vcs";
        this.NODE_CURRENT = "current";
        this.ATT_CONTENT = "content";
        this.NODE_RANGES = "ranges";
        this.NODE_RANGE = "range";
        this.ATT_START_1 = "start1";
        this.ATT_END_1 = "end1";
        this.ATT_START_2 = "start2";
        this.ATT_END_2 = "end2";
        this.ATT_CHANGELIST_ID = "changelist";
        boolean bl = false;
        this.storedFileStates = CollectionsKt.emptyList();
    }
}

