/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class ModuleDefaultVcsRootPolicy
extends DefaultVcsRootPolicy {
    public ModuleDefaultVcsRootPolicy(@NotNull Project project) {
        super(project);
        MyModulesListener listener2 = new MyModulesListener();
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectTopics.MODULES, (Object)listener2);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)listener2);
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getDefaultVcsRoots() {
        Module[] modules;
        VirtualFile ideaDir;
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null) {
            result2.add(baseDir);
        }
        if (ProjectKt.isDirectoryBased((Project)this.myProject) && baseDir != null && (ideaDir = LocalFileSystem.getInstance().findFileByNioFile(ProjectKt.getStateStore((Project)this.myProject).getDirectoryStorePath())) != null) {
            result2.add(ideaDir);
        }
        for (Module module : modules = (Module[])ReadAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).getModules())) {
            VirtualFile[] files;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (VirtualFile file : files = moduleRootManager.getContentRoots()) {
                if (!file.isDirectory()) continue;
                result2.add(file);
            }
        }
        return result2;
    }

    private class MyModulesListener
    implements ModuleRootListener,
    ModuleListener {
        private MyModulesListener() {
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            ModuleDefaultVcsRootPolicy.this.scheduleMappedRootsUpdate();
        }

        public void moduleAdded(@NotNull Project project, @NotNull Module module) {
            ModuleDefaultVcsRootPolicy.this.scheduleMappedRootsUpdate();
        }

        public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
            ModuleDefaultVcsRootPolicy.this.scheduleMappedRootsUpdate();
        }
    }
}

