/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.StandardDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class ShowDiffWithLocalFromTableHistoryAction
implements AnActionExtensionProvider {
    public boolean isActive(@NotNull AnActionEvent e) {
        return e.getData(VcsDataKeys.HISTORY_SESSION) != null;
    }

    public void update(@NotNull AnActionEvent e) {
        VcsFileRevision[] selectedRevisions = (VcsFileRevision[])e.getData(VcsDataKeys.VCS_FILE_REVISIONS);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VcsHistorySession historySession = (VcsHistorySession)e.getData(VcsDataKeys.HISTORY_SESSION);
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(selectedRevisions != null && selectedRevisions.length == 1 && virtualFile != null && historySession != null && historySession.getCurrentRevisionNumber() != null && historySession.isContentAvailable(selectedRevisions[0]) && e.getData(VcsDataKeys.FILE_PATH) != null && e.getData(VcsDataKeys.HISTORY_PROVIDER) != null && e.getData(CommonDataKeys.PROJECT) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        VcsRevisionNumber currentRevisionNumber = ((VcsHistorySession)e.getRequiredData(VcsDataKeys.HISTORY_SESSION)).getCurrentRevisionNumber();
        VcsFileRevision selectedRevision = ((VcsFileRevision[])e.getRequiredData(VcsDataKeys.VCS_FILE_REVISIONS))[0];
        FilePath filePath = (FilePath)e.getRequiredData(VcsDataKeys.FILE_PATH);
        VirtualFile virtualFile = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        if (currentRevisionNumber != null && selectedRevision != null) {
            DiffFromHistoryHandler diffHandler = (DiffFromHistoryHandler)ObjectUtils.notNull((Object)((VcsHistoryProvider)e.getRequiredData(VcsDataKeys.HISTORY_PROVIDER)).getHistoryDiffHandler(), (Object)new StandardDiffFromHistoryHandler());
            diffHandler.showDiffForTwo(project, filePath, selectedRevision, (VcsFileRevision)new CurrentRevision(virtualFile, currentRevisionNumber));
        }
    }
}

