/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CopyRevisionNumberAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        List revisions = CopyRevisionNumberAction.getRevisionNumbersFromContext(e);
        revisions = ContainerUtil.reverse(revisions);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(CopyRevisionNumberAction.getHashesAsString(revisions)));
    }

    @NotNull
    private static List<VcsRevisionNumber> getRevisionNumbersFromContext(@NotNull AnActionEvent e) {
        VcsRevisionNumber[] revisionNumbers = (VcsRevisionNumber[])e.getData(VcsDataKeys.VCS_REVISION_NUMBERS);
        return revisionNumbers != null ? Arrays.asList(revisionNumbers) : Collections.emptyList();
    }

    @NotNull
    private static String getHashesAsString(@NotNull List<VcsRevisionNumber> revisions) {
        return StringUtil.join(revisions, VcsRevisionNumber::asString, (String)" ");
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(!CopyRevisionNumberAction.getRevisionNumbersFromContext(e).isEmpty());
    }
}

