/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.application.options.colors.fileStatus.FileStatusColorsConfigurable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfigurableProvider;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictConfigurable;
import com.intellij.openapi.vcs.changes.ui.IgnoredSettingsPanel;
import com.intellij.openapi.vcs.configurable.CommitDialogConfigurable;
import com.intellij.openapi.vcs.configurable.IssueNavigationConfigurationPanel;
import com.intellij.openapi.vcs.configurable.ShelfProjectConfigurable;
import com.intellij.openapi.vcs.configurable.VcsBackgroundOperationsConfigurable;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanel;
import com.intellij.openapi.vcs.configurable.VcsGeneralConfigurationConfigurable;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsManagerConfigurable
extends SearchableConfigurable.Parent.Abstract
implements Configurable.NoScroll,
Configurable.WithEpDependencies {
    @NotNull
    private final Project myProject;
    private VcsDirectoryConfigurationPanel myMappings;
    private VcsGeneralConfigurationConfigurable myGeneralPanel;

    public VcsManagerConfigurable(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        return Arrays.asList(VcsEP.EP_NAME, VcsConfigurableProvider.EP_NAME);
    }

    public JComponent createComponent() {
        this.myMappings = new VcsDirectoryConfigurationPanel(this.myProject);
        return this.myMappings;
    }

    public boolean hasOwnContent() {
        return true;
    }

    public boolean isModified() {
        return this.myMappings != null && this.myMappings.isModified();
    }

    public void apply() throws ConfigurationException {
        super.apply();
        this.myMappings.apply();
    }

    public void reset() {
        super.reset();
        this.myMappings.reset();
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        if (this.myMappings != null) {
            this.myMappings.disposeUIResources();
        }
        if (this.myGeneralPanel != null) {
            this.myGeneralPanel.disposeUIResources();
        }
        this.myMappings = null;
    }

    public String getDisplayName() {
        return VcsBundle.message((String)"version.control.main.configurable.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "project.propVCSSupport.Mappings";
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic();
    }

    protected Configurable[] buildConfigurables() {
        this.myGeneralPanel = new VcsGeneralConfigurationConfigurable(this.myProject, this);
        ArrayList<Object> result2 = new ArrayList<Object>();
        result2.add(this.myGeneralPanel);
        result2.add(new VcsBackgroundOperationsConfigurable(this.myProject));
        boolean ignoreSettingsAvailable = Registry.is((String)"vcs.ignorefile.generation", (boolean)true);
        if (!this.myProject.isDefault() && ignoreSettingsAvailable) {
            result2.add((Object)new IgnoredSettingsPanel(this.myProject));
        }
        result2.add(new IssueNavigationConfigurationPanel(this.myProject));
        if (!this.myProject.isDefault()) {
            result2.add((Object)new ChangelistConflictConfigurable(ChangeListManagerImpl.getInstanceImpl(this.myProject)));
        }
        result2.add((Object)new CommitDialogConfigurable(this.myProject));
        result2.add(new ShelfProjectConfigurable(this.myProject));
        for (VcsConfigurableProvider provider : (VcsConfigurableProvider[])VcsConfigurableProvider.EP_NAME.getExtensions()) {
            ContainerUtil.addIfNotNull(result2, (Object)provider.getConfigurable(this.myProject));
        }
        result2.add(new FileStatusColorsConfigurable());
        Set projectConfigurableIds = ContainerUtil.map2Set((Collection)Configurable.PROJECT_CONFIGURABLE.getExtensions((AreaInstance)this.myProject), ep -> ep.id);
        for (VcsDescriptor descriptor : ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllVcss()) {
            if (projectConfigurableIds.contains(VcsManagerConfigurable.getVcsConfigurableId(descriptor.getDisplayName()))) continue;
            result2.add(ConfigurableWrapper.wrapConfigurable((ConfigurableEP)new VcsConfigurableEP(this.myProject, descriptor)));
        }
        return result2.toArray(new Configurable[0]);
    }

    @Nullable
    public VcsDirectoryConfigurationPanel getMappings() {
        return this.myMappings;
    }

    @NotNull
    public static String getVcsConfigurableId(@NotNull String displayName) {
        return "vcs." + displayName;
    }

    private static class VcsConfigurableEP
    extends ConfigurableEP<Configurable> {
        private static final int WEIGHT = -500;
        @NotNull
        private final VcsDescriptor myDescriptor;

        VcsConfigurableEP(@NotNull Project project, @NotNull VcsDescriptor descriptor) {
            super(project);
            this.myDescriptor = descriptor;
            this.displayName = descriptor.getDisplayName();
            this.id = VcsManagerConfigurable.getVcsConfigurableId(descriptor.getDisplayName());
            this.groupWeight = -500;
        }

        @NotNull
        protected ConfigurableEP.ObjectProducer createProducer() {
            return new ConfigurableEP.ObjectProducer(){

                protected Object createElement() {
                    return Objects.requireNonNull(ProjectLevelVcsManager.getInstance((Project)this.getProject()).findVcsByName(myDescriptor.getName())).getConfigurable();
                }

                protected boolean canCreateElement() {
                    return true;
                }

                protected Class<?> getType() {
                    return SearchableConfigurable.class;
                }
            };
        }
    }
}

