/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleChangesBrowser
extends ChangesBrowserBase {
    private final List<Change> myChanges = new ArrayList<Change>();
    @Nullable
    private ChangeNodeDecorator myChangeNodeDecorator;

    public SimpleChangesBrowser(@NotNull Project project, @NotNull Collection<? extends Change> changes) {
        this(project, false, false);
        this.setChangesToDisplay(changes);
    }

    public SimpleChangesBrowser(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        super(project, showCheckboxes, highlightProblems);
        this.init();
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        return TreeModelBuilder.buildFromChanges(this.myProject, this.getGrouping(), this.myChanges, this.myChangeNodeDecorator);
    }

    public void setChangesToDisplay(@NotNull Collection<? extends Change> changes) {
        this.myChanges.clear();
        this.myChanges.addAll(changes);
        this.myViewer.rebuildTree();
    }

    public void setChangeNodeDecorator(@Nullable ChangeNodeDecorator value) {
        this.myChangeNodeDecorator = value;
        this.myViewer.rebuildTree();
    }

    public void setIncludedChanges(@NotNull Collection<? extends Change> changes) {
        this.myViewer.setIncludedChanges(changes);
    }

    @NotNull
    public List<Change> getAllChanges() {
        return VcsTreeModelData.all((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    @NotNull
    public List<Change> getSelectedChanges() {
        return VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    @NotNull
    public List<Change> getIncludedChanges() {
        return VcsTreeModelData.included(this.myViewer).userObjects(Change.class);
    }
}

