/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ui.AbstractSelectFilesDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeImpl;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectFilePathsDialog
extends AbstractSelectFilesDialog {
    private final ChangesTreeImpl<FilePath> myFileList;

    public SelectFilePathsDialog(@NotNull Project project, @NotNull List<? extends FilePath> originalFiles, @Nullable String prompt, @Nullable VcsShowConfirmationOption confirmationOption, @Nullable String okActionName, @Nullable String cancelActionName, boolean showCheckboxes) {
        super(project, false, confirmationOption, prompt);
        this.myFileList = new ChangesTreeImpl.FilePaths(project, showCheckboxes, true, originalFiles);
        if (okActionName != null) {
            this.getOKAction().putValue("Name", okActionName);
        }
        if (cancelActionName != null) {
            this.getCancelAction().putValue("Name", cancelActionName);
        }
        this.init();
    }

    public Collection<FilePath> getSelectedFiles() {
        return this.myFileList.getIncludedChanges();
    }

    @Override
    @NotNull
    protected ChangesTree getFileList() {
        return this.myFileList;
    }
}

