/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.util.treeView.FileNameComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFileNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLocallyDeletedNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLockedFoldersNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLogicallyLockedFile;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Convertor;
import java.awt.Color;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ChangesBrowserNode<T>
extends DefaultMutableTreeNode
implements UserDataHolderEx {
    @NonNls
    private static final String ROOT_NODE_VALUE = "root";
    public static final Object IGNORED_FILES_TAG = new Tag("changes.nodetitle.ignored.files");
    public static final Object LOCKED_FOLDERS_TAG = new Tag("changes.nodetitle.locked.folders");
    public static final Object LOGICALLY_LOCKED_TAG = new Tag("changes.nodetitle.logicallt.locked.folders");
    public static final Object UNVERSIONED_FILES_TAG = new Tag("changes.nodetitle.unversioned.files");
    public static final Object MODIFIED_WITHOUT_EDITING_TAG = new Tag("changes.nodetitle.modified.without.editing");
    public static final Object SWITCHED_FILES_TAG = new Tag("changes.nodetitle.switched.files");
    public static final Object SWITCHED_ROOTS_TAG = new Tag("changes.nodetitle.switched.roots");
    public static final Object LOCALLY_DELETED_NODE_TAG = new Tag("changes.nodetitle.locally.deleted.files");
    protected static final int CONFLICTS_SORT_WEIGHT = 0;
    protected static final int DEFAULT_CHANGE_LIST_SORT_WEIGHT = 1;
    protected static final int CHANGE_LIST_SORT_WEIGHT = 2;
    protected static final int REPOSITORY_SORT_WEIGHT = 3;
    protected static final int MODULE_SORT_WEIGHT = 4;
    protected static final int DIRECTORY_PATH_SORT_WEIGHT = 5;
    protected static final int FILE_PATH_SORT_WEIGHT = 6;
    protected static final int CHANGE_SORT_WEIGHT = 7;
    protected static final int VIRTUAL_FILE_SORT_WEIGHT = 8;
    protected static final int UNVERSIONED_SORT_WEIGHT = 9;
    protected static final int DEFAULT_SORT_WEIGHT = 10;
    protected static final int IGNORED_SORT_WEIGHT = 11;
    public static final Convertor<TreePath, String> TO_TEXT_CONVERTER = path2 -> ((ChangesBrowserNode)path2.getLastPathComponent()).getTextPresentation();
    private SimpleTextAttributes myAttributes;
    private int myFileCount = -1;
    private int myDirectoryCount = -1;
    private boolean myHelper;
    @NotNull
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();

    protected ChangesBrowserNode(T userObject) {
        super(userObject);
        this.myAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    @NotNull
    public static ChangesBrowserNode createRoot() {
        ChangesBrowserNode root = ChangesBrowserNode.createObject(ROOT_NODE_VALUE);
        root.markAsHelperNode();
        return root;
    }

    @NotNull
    public static ChangesBrowserNode createChange(@Nullable Project project, @NotNull Change userObject) {
        return new ChangesBrowserChangeNode(project, userObject, null);
    }

    @NotNull
    public static ChangesBrowserNode createFile(@Nullable Project project, @NotNull VirtualFile userObject) {
        return new ChangesBrowserFileNode(project, userObject);
    }

    @NotNull
    public static ChangesBrowserNode createFilePath(@NotNull FilePath userObject, @Nullable FileStatus status) {
        return new ChangesBrowserFilePathNode(userObject, status);
    }

    @NotNull
    public static ChangesBrowserNode createFilePath(@NotNull FilePath userObject) {
        return ChangesBrowserNode.createFilePath(userObject, null);
    }

    @NotNull
    public static ChangesBrowserNode createLogicallyLocked(@Nullable Project project, @NotNull VirtualFile file, @NotNull LogicalLock lock) {
        return new ChangesBrowserLogicallyLockedFile(project, file, lock);
    }

    @NotNull
    public static ChangesBrowserNode createLockedFolders(@NotNull Project project) {
        return new ChangesBrowserLockedFoldersNode(project, LOCKED_FOLDERS_TAG);
    }

    @NotNull
    public static ChangesBrowserNode createLocallyDeleted(@NotNull LocallyDeletedChange change) {
        return new ChangesBrowserLocallyDeletedNode(change);
    }

    @NotNull
    public static ChangesBrowserNode createObject(@NotNull Object userObject) {
        return new ChangesBrowserNode<Object>(userObject);
    }

    @Deprecated
    @NotNull
    public static ChangesBrowserNode create(@NotNull Project project, @NotNull Object userObject) {
        if (userObject instanceof Change) {
            return new ChangesBrowserChangeNode(project, (Change)userObject, null);
        }
        if (userObject instanceof VirtualFile) {
            return new ChangesBrowserFileNode(project, (VirtualFile)userObject);
        }
        if (userObject instanceof FilePath) {
            return new ChangesBrowserFilePathNode((FilePath)userObject);
        }
        if (userObject == LOCKED_FOLDERS_TAG) {
            return new ChangesBrowserLockedFoldersNode(project, userObject);
        }
        if (userObject instanceof ChangesBrowserLogicallyLockedFile) {
            return (ChangesBrowserNode)userObject;
        }
        return new ChangesBrowserNode<Object>(userObject);
    }

    @Override
    public ChangesBrowserNode<?> getParent() {
        return (ChangesBrowserNode)super.getParent();
    }

    @Nullable
    public <V> V getUserData(@NotNull Key<V> key) {
        return (V)this.myUserDataHolder.getUserData(key);
    }

    public <V> void putUserData(@NotNull Key<V> key, @Nullable V value) {
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <V> V putUserDataIfAbsent(@NotNull Key<V> key, @NotNull V value) {
        return (V)this.myUserDataHolder.putUserDataIfAbsent(key, value);
    }

    public <V> boolean replace(@NotNull Key<V> key, @Nullable V oldValue, @Nullable V newValue) {
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        this.resetFileCounters();
    }

    @Override
    public void remove(int childIndex) {
        super.remove(childIndex);
        this.resetFileCounters();
    }

    protected boolean isFile() {
        return false;
    }

    protected boolean isDirectory() {
        return false;
    }

    public void markAsHelperNode() {
        this.myHelper = true;
    }

    public boolean isMeaningfulNode() {
        return !this.myHelper;
    }

    public int getFileCount() {
        if (this.myFileCount == -1) {
            this.myFileCount = (this.isFile() ? 1 : 0) + ChangesBrowserNode.toStream(this.children()).mapToInt(ChangesBrowserNode::getFileCount).sum();
        }
        return this.myFileCount;
    }

    public int getDirectoryCount() {
        if (this.myDirectoryCount == -1) {
            this.myDirectoryCount = (this.isDirectory() ? 1 : 0) + ChangesBrowserNode.toStream(this.children()).mapToInt(ChangesBrowserNode::getDirectoryCount).sum();
        }
        return this.myDirectoryCount;
    }

    private void resetFileCounters() {
        this.myFileCount = -1;
        this.myDirectoryCount = -1;
    }

    @NotNull
    public Stream<ChangesBrowserNode<?>> getNodesUnderStream() {
        return ChangesBrowserNode.toStream(this.preorderEnumeration());
    }

    @NotNull
    public List<Change> getAllChangesUnder() {
        return this.getAllObjectsUnder(Change.class);
    }

    @NotNull
    public <U> List<U> getAllObjectsUnder(@NotNull Class<U> clazz) {
        return this.getObjectsUnderStream(clazz).collect(Collectors.toList());
    }

    @NotNull
    public <U> Stream<U> getObjectsUnderStream(@NotNull Class<U> clazz) {
        return ChangesBrowserNode.toStream(this.preorderEnumeration()).map(ChangesBrowserNode::getUserObject).select(clazz);
    }

    @NotNull
    public List<VirtualFile> getAllFilesUnder() {
        return this.getFilesUnderStream().collect(Collectors.toList());
    }

    @NotNull
    public Stream<VirtualFile> getFilesUnderStream() {
        return ChangesBrowserNode.toStream(this.preorderEnumeration()).map(ChangesBrowserNode::getUserObject).select(VirtualFile.class).filter(VirtualFile::isValid);
    }

    @NotNull
    public List<FilePath> getAllFilePathsUnder() {
        return this.getFilePathsUnderStream().collect(Collectors.toList());
    }

    @NotNull
    public Stream<FilePath> getFilePathsUnderStream() {
        return ((StreamEx)ChangesBrowserNode.toStream(this.preorderEnumeration()).filter(DefaultMutableTreeNode::isLeaf)).map(ChangesBrowserNode::getUserObject).select(FilePath.class);
    }

    @NotNull
    private static StreamEx<ChangesBrowserNode<?>> toStream(@NotNull Enumeration enumeration) {
        return StreamEx.of((Enumeration)enumeration);
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        renderer.append(this.getTextPresentation(), this.myAttributes);
        this.appendCount(renderer);
    }

    @NotNull
    protected String getCountText() {
        int count = this.getFileCount();
        int dirCount = this.getDirectoryCount();
        String result2 = "";
        if (dirCount != 0 || count != 0) {
            result2 = FontUtil.spaceAndThinSpace() + (dirCount == 0 ? VcsBundle.message((String)"changes.nodetitle.changecount", (Object[])new Object[]{count}) : (count == 0 ? VcsBundle.message((String)"changes.nodetitle.directory.changecount", (Object[])new Object[]{dirCount}) : VcsBundle.message((String)"changes.nodetitle.directory.file.changecount", (Object[])new Object[]{dirCount, count})));
        }
        return result2;
    }

    protected void appendCount(@NotNull ColoredTreeCellRenderer renderer) {
        renderer.append(this.getCountText(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @Override
    public String toString() {
        return this.getTextPresentation();
    }

    public String getTextPresentation() {
        return this.userObject == null ? "" : this.userObject.toString();
    }

    public T getUserObject() {
        return (T)this.userObject;
    }

    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        return false;
    }

    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
    }

    public int getSortWeight() {
        return 10;
    }

    public int compareUserObjects(T o2) {
        return 0;
    }

    protected static int compareFileNames(@NotNull String name1, @NotNull String name2) {
        return FileNameComparator.INSTANCE.compare(name1, name2);
    }

    public static int compareFilePaths(@NotNull FilePath path1, @NotNull FilePath path2) {
        return ChangesComparator.getFilePathComparator(true).compare(path1, path2);
    }

    public void setAttributes(@NotNull SimpleTextAttributes attributes2) {
        this.myAttributes = attributes2;
    }

    protected void appendParentPath(@NotNull ChangesBrowserNodeRenderer renderer, @Nullable FilePath parentPath) {
        if (parentPath != null) {
            ChangesBrowserNode.appendParentPath(renderer, parentPath.getPresentableUrl());
        }
    }

    protected void appendParentPath(@NotNull ChangesBrowserNodeRenderer renderer, @Nullable VirtualFile parentPath) {
        if (parentPath != null) {
            ChangesBrowserNode.appendParentPath(renderer, parentPath.getPresentableUrl());
        }
    }

    private static void appendParentPath(@NotNull ChangesBrowserNodeRenderer renderer, @NotNull String parentPath) {
        renderer.append(FontUtil.spaceAndThinSpace() + FileUtil.getLocationRelativeToUserHome((String)parentPath), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    protected void appendUpdatingState(@NotNull ChangesBrowserNodeRenderer renderer) {
        renderer.append((this.getCountText().isEmpty() ? FontUtil.spaceAndThinSpace() : ", ") + VcsBundle.message((String)"changes.nodetitle.updating", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @Nullable
    public Color getBackgroundColor(@NotNull Project project) {
        return ChangesBrowserNode.getBackgroundColorFor(project, this.getUserObject());
    }

    @Nullable
    protected static Color getBackgroundColorFor(@NotNull Project project, @Nullable Object object) {
        VirtualFile file = object instanceof FilePath ? ChangesBrowserNode.getScopeVirtualFileFor((FilePath)object) : (object instanceof Change ? ChangesBrowserNode.getScopeVirtualFileFor(ChangesUtil.getFilePath((Change)((Change)object))) : (VirtualFile)ObjectUtils.tryCast((Object)object, VirtualFile.class));
        if (file != null) {
            return VfsPresentationUtil.getFileBackgroundColor((Project)project, (VirtualFile)file);
        }
        return null;
    }

    @Nullable
    private static VirtualFile getScopeVirtualFileFor(@NotNull FilePath filePath) {
        if (filePath.isNonLocal()) {
            return null;
        }
        return ChangesUtil.findValidParentAccurately((FilePath)filePath);
    }

    @Deprecated
    public final int getCount() {
        return this.getFileCount();
    }

    public boolean shouldExpandByDefault() {
        return true;
    }

    private static class Tag {
        @PropertyKey(resourceBundle="messages.VcsBundle")
        @NotNull
        private final String myKey;

        Tag(@PropertyKey(resourceBundle="messages.VcsBundle") @NotNull String key) {
            this.myKey = key;
        }

        public String toString() {
            return VcsBundle.message((String)this.myKey, (Object[])new Object[0]);
        }
    }
}

