/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserFileNode
extends ChangesBrowserNode<VirtualFile>
implements Comparable<ChangesBrowserFileNode> {
    @Nullable
    private final Project myProject;
    private final String myName;

    public ChangesBrowserFileNode(@Nullable Project project, @NotNull VirtualFile userObject) {
        super(userObject);
        this.myName = userObject.getName();
        this.myProject = project;
    }

    @Override
    protected boolean isFile() {
        return !((VirtualFile)this.getUserObject()).isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        if (((VirtualFile)this.getUserObject()).isDirectory()) {
            return this.isLeaf() || this.getFileStatus() != FileStatus.NOT_CHANGED;
        }
        return false;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        VirtualFile file = (VirtualFile)this.getUserObject();
        FileStatus fileStatus = this.getFileStatus();
        renderer.appendFileName(file, file.getName(), fileStatus.getColor());
        if (renderer.isShowFlatten() && file.isValid()) {
            this.appendParentPath(renderer, file.getParent());
        }
        if (!renderer.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount(renderer);
        }
        renderer.setIcon(VcsUtil.getFilePath((VirtualFile)file), file.isDirectory());
    }

    @Override
    public String getTextPresentation() {
        return ((VirtualFile)this.getUserObject()).getName();
    }

    @Override
    public String toString() {
        return ((VirtualFile)this.getUserObject()).getPresentableUrl();
    }

    @Override
    public int getSortWeight() {
        return 8;
    }

    @Override
    public int compareTo(ChangesBrowserFileNode o) {
        return ChangesBrowserFileNode.compareFileNames(this.myName, o.myName);
    }

    @NotNull
    private FileStatus getFileStatus() {
        if (this.myProject == null || this.myProject.isDisposed()) {
            return FileStatus.NOT_CHANGED;
        }
        return ChangeListManager.getInstance((Project)this.myProject).getStatus((VirtualFile)this.getUserObject());
    }
}

