/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedChangeList
implements JDOMExternalizable,
ExternalizableScheme {
    private static final Logger LOG = Logger.getInstance(ShelvedChangeList.class);
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    @NonNls
    private static final String ATTRIBUTE_DATE = "date";
    @NonNls
    private static final String ATTRIBUTE_RECYCLED_CHANGELIST = "recycled";
    @NonNls
    private static final String ATTRIBUTE_TOBE_DELETED_CHANGELIST = "toDelete";
    @NonNls
    private static final String ATTRIBUTE_DELETED_CHANGELIST = "deleted";
    @NonNls
    private static final String ELEMENT_BINARY = "binary";
    public String PATH;
    public String DESCRIPTION;
    public Date DATE;
    private volatile List<ShelvedChange> myChanges;
    private List<ShelvedBinaryFile> myBinaryFiles;
    private boolean myRecycled;
    private boolean myToDelete;
    private boolean myIsDeleted;
    private String mySchemeName;

    ShelvedChangeList() {
    }

    public ShelvedChangeList(String path2, String description, List<ShelvedBinaryFile> binaryFiles, @NotNull List<ShelvedChange> shelvedChanges) {
        this(path2, description, binaryFiles, shelvedChanges, System.currentTimeMillis());
    }

    ShelvedChangeList(String path2, String description, List<ShelvedBinaryFile> binaryFiles, @NotNull List<ShelvedChange> shelvedChanges, long time) {
        this.PATH = FileUtil.toSystemIndependentName((String)path2);
        this.DESCRIPTION = description;
        this.DATE = new Date(time);
        this.myBinaryFiles = binaryFiles;
        this.mySchemeName = this.DESCRIPTION;
        this.myChanges = shelvedChanges;
    }

    public boolean isRecycled() {
        return this.myRecycled;
    }

    public void setRecycled(boolean recycled) {
        this.myRecycled = recycled;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.PATH = FileUtil.toSystemIndependentName((String)this.PATH);
        this.mySchemeName = element.getAttributeValue(NAME_ATTRIBUTE);
        this.DATE = new Date(Long.parseLong(element.getAttributeValue(ATTRIBUTE_DATE)));
        this.myRecycled = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_RECYCLED_CHANGELIST));
        this.myToDelete = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_TOBE_DELETED_CHANGELIST));
        this.myIsDeleted = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_DELETED_CHANGELIST));
        List children = element.getChildren(ELEMENT_BINARY);
        this.myBinaryFiles = new ArrayList<ShelvedBinaryFile>(children.size());
        for (Element child : children) {
            ShelvedBinaryFile binaryFile = new ShelvedBinaryFile();
            binaryFile.readExternal(child);
            this.myBinaryFiles.add(binaryFile);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        ShelvedChangeList.writeExternal(element, this);
    }

    private static void writeExternal(@NotNull Element element, @NotNull ShelvedChangeList shelvedChangeList) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)shelvedChangeList, (Element)element);
        element.setAttribute(NAME_ATTRIBUTE, shelvedChangeList.getName());
        element.setAttribute(ATTRIBUTE_DATE, Long.toString(shelvedChangeList.DATE.getTime()));
        element.setAttribute(ATTRIBUTE_RECYCLED_CHANGELIST, Boolean.toString(shelvedChangeList.isRecycled()));
        if (shelvedChangeList.isMarkedToDelete()) {
            element.setAttribute(ATTRIBUTE_TOBE_DELETED_CHANGELIST, Boolean.toString(shelvedChangeList.isMarkedToDelete()));
        }
        if (shelvedChangeList.isDeleted()) {
            element.setAttribute(ATTRIBUTE_DELETED_CHANGELIST, Boolean.toString(shelvedChangeList.isDeleted()));
        }
        for (ShelvedBinaryFile file : shelvedChangeList.getBinaryFiles()) {
            Element child = new Element(ELEMENT_BINARY);
            file.writeExternal(child);
            element.addContent(child);
        }
    }

    public String toString() {
        return this.DESCRIPTION;
    }

    public void loadChangesIfNeeded(@NotNull Project project) {
        if (this.myChanges == null) {
            try {
                List<? extends FilePatch> list = ShelveChangesManager.loadPatchesWithoutContent(project, this.PATH, null);
                this.myChanges = ShelvedChangeList.createShelvedChangesFromFilePatches(project, this.PATH, list);
            }
            catch (Exception e) {
                LOG.error("Failed to parse the file patch: [" + this.PATH + "]", (Throwable)e);
            }
        }
    }

    @Nullable
    public List<ShelvedChange> getChanges() {
        return this.myChanges;
    }

    @Deprecated
    public List<ShelvedChange> getChanges(Project project) {
        this.loadChangesIfNeeded(project);
        return this.getChanges();
    }

    void setChanges(List<ShelvedChange> shelvedChanges) {
        this.myChanges = shelvedChanges;
    }

    @NotNull
    static List<ShelvedChange> createShelvedChangesFromFilePatches(@NotNull Project project, @NotNull String patchPath, @NotNull Collection<? extends FilePatch> filePatches) {
        ArrayList<ShelvedChange> changes = new ArrayList<ShelvedChange>();
        for (FilePatch filePatch : filePatches) {
            FileStatus status = filePatch.isNewFile() ? FileStatus.ADDED : (filePatch.isDeletedFile() ? FileStatus.DELETED : FileStatus.MODIFIED);
            changes.add(new ShelvedChange(project, patchPath, filePatch.getBeforeName(), filePatch.getAfterName(), status));
        }
        return changes;
    }

    public List<ShelvedBinaryFile> getBinaryFiles() {
        return this.myBinaryFiles;
    }

    @NotNull
    public String getName() {
        return this.mySchemeName;
    }

    public void setName(@NotNull String newName) {
        this.mySchemeName = newName;
    }

    public boolean isValid() {
        return new File(this.PATH).exists();
    }

    public void markToDelete(boolean toDeleted) {
        this.myToDelete = toDeleted;
    }

    public boolean isMarkedToDelete() {
        return this.myToDelete;
    }

    public void setDeleted(boolean isDeleted) {
        this.myIsDeleted = isDeleted;
    }

    public boolean isDeleted() {
        return this.myIsDeleted;
    }

    public void updateDate() {
        this.DATE = new Date(System.currentTimeMillis());
    }
}

