/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.google.common.collect.Lists;
import com.intellij.concurrency.JobScheduler;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vcs.changes.shelf.ShelfFileProcessorUtil;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.project.ProjectKt;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcsUtil.FilesProgress;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ShelveChangesManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ShelveChangesManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(ShelveChangesManager.class);
    @NonNls
    private static final String ELEMENT_CHANGELIST = "changelist";
    @NonNls
    private static final String ELEMENT_RECYCLED_CHANGELIST = "recycled_changelist";
    @NonNls
    private static final String DEFAULT_PATCH_NAME = "shelved";
    private static final String SHELVE_MANAGER_DIR_PATH = "shelf";
    public static final String DEFAULT_PROJECT_PRESENTATION_PATH = "<Project>/shelf";
    private static final Element EMPTY_ELEMENT = new Element("state");
    private State myState = new State();
    @NotNull
    private final PathMacroManager myPathMacroSubstitutor;
    @NotNull
    private SchemeManager<ShelvedChangeList> mySchemeManager;
    private ScheduledFuture<?> myCleaningFuture;
    private final ReentrantReadWriteLock SHELVED_FILES_LOCK = new ReentrantReadWriteLock(true);
    @Nullable
    private Set<VirtualFile> myShelvingFiles;
    private final Project myProject;
    private final MessageBus myBus;
    public static final Topic<ChangeListener> SHELF_TOPIC = new Topic("shelf updates", ChangeListener.class);

    public static ShelveChangesManager getInstance(@NotNull Project project) {
        return (ShelveChangesManager)project.getService(ShelveChangesManager.class);
    }

    @NotNull
    public Element getState() {
        return (Element)ObjectUtils.chooseNotNull((Object)XmlSerializer.serialize((Object)this.myState), (Object)EMPTY_ELEMENT);
    }

    public void loadState(@NotNull Element state) {
        this.myState = (State)XmlSerializer.deserialize((Element)state, State.class);
        this.migrateOldShelfInfo(state, false);
        this.migrateOldShelfInfo(state, true);
    }

    @NotNull
    public static String getDefaultShelfPath(@NotNull Project project) {
        IProjectStore store = ProjectKt.getStateStore((Project)project);
        return store.getDirectoryStorePath(true) + "/" + (ProjectKt.isDirectoryBased((Project)project) ? SHELVE_MANAGER_DIR_PATH : ".shelf");
    }

    @NotNull
    public static String getShelfPath(@NotNull Project project) {
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)project);
        if (vcsConfiguration.USE_CUSTOM_SHELF_PATH) {
            return Objects.requireNonNull(vcsConfiguration.CUSTOM_SHELF_PATH);
        }
        return ShelveChangesManager.getDefaultShelfPath(project);
    }

    public ShelveChangesManager(Project project, MessageBus bus) {
        this.myPathMacroSubstitutor = PathMacroManager.getInstance((ComponentManager)project);
        this.myProject = project;
        this.myBus = bus;
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)project);
        this.mySchemeManager = this.createShelveSchemeManager(project, vcsConfiguration.USE_CUSTOM_SHELF_PATH ? vcsConfiguration.CUSTOM_SHELF_PATH : null);
        this.myCleaningFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.cleanDeletedOlderOneWeek(), 1L, 1L, TimeUnit.DAYS);
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                ShelveChangesManager.this.stopCleanScheduler();
            }
        });
    }

    private void stopCleanScheduler() {
        if (this.myCleaningFuture != null) {
            this.myCleaningFuture.cancel(false);
            this.myCleaningFuture = null;
        }
    }

    @NotNull
    private SchemeManager<ShelvedChangeList> createShelveSchemeManager(@NotNull Project project, @Nullable String customPath) {
        FilePath customShelfFilePath = customPath != null ? VcsUtil.getFilePath((String)this.myPathMacroSubstitutor.expandPath(customPath)) : null;
        final boolean shouldCollapsePath = !VcsConfiguration.getInstance((Project)this.myProject).USE_CUSTOM_SHELF_PATH;
        return SchemeManagerFactory.getInstance((Project)project).create(customShelfFilePath != null ? customShelfFilePath.getName() : SHELVE_MANAGER_DIR_PATH, (SchemeProcessor)new NonLazySchemeProcessor<ShelvedChangeList, ShelvedChangeList>(){

            @NotNull
            public ShelvedChangeList readScheme(@NotNull Element element, boolean duringLoad) throws InvalidDataException {
                return ShelveChangesManager.this.readOneShelvedChangeList(element);
            }

            @NotNull
            public Parent writeScheme(@NotNull ShelvedChangeList scheme) throws WriteExternalException {
                Element child = new Element(ShelveChangesManager.ELEMENT_CHANGELIST);
                scheme.writeExternal(child);
                if (shouldCollapsePath) {
                    ShelveChangesManager.this.myPathMacroSubstitutor.collapsePaths(child);
                }
                return child;
            }
        }, null, customPath != null ? Paths.get(customPath, new String[0]) : null);
    }

    public void projectOpened() {
        try {
            this.mySchemeManager.loadSchemes();
            this.filterNonValidShelvedChangeLists();
            this.markDeletedSystemUnshelved();
            this.cleanDeletedOlderOneWeek();
        }
        catch (Exception e) {
            LOG.error("Couldn't read shelf information", (Throwable)e);
        }
    }

    private void filterNonValidShelvedChangeLists() {
        ArrayList allSchemes = new ArrayList(this.mySchemeManager.getAllSchemes());
        ContainerUtil.process(allSchemes, shelvedChangeList -> {
            if (!shelvedChangeList.isValid()) {
                this.mySchemeManager.removeScheme(shelvedChangeList);
            }
            return true;
        });
    }

    public void checkAndMigrateUnderProgress(final @NotNull File fromFile, final @NotNull File toFile, final boolean wasCustom) {
        final SchemeManager<ShelvedChangeList> newSchemeManager = this.createShelveSchemeManager(this.myProject, VcsUtil.getFilePath((File)toFile).getPath());
        newSchemeManager.loadSchemes();
        if (VcsConfiguration.getInstance((Project)this.myProject).MOVE_SHELVES && fromFile.exists()) {
            new Task.Modal(this.myProject, VcsBundle.message((String)"shelve.copying.shelves.to.progress", (Object[])new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    for (ShelvedChangeList list : ShelveChangesManager.this.mySchemeManager.getAllSchemes()) {
                        if (!list.isValid()) continue;
                        try {
                            File newTargetDirectory = ShelveChangesManager.suggestPatchName(this.myProject, list.DESCRIPTION, toFile, "");
                            ShelvedChangeList migratedList = ShelveChangesManager.this.createChangelistCopyWithChanges(list, newTargetDirectory);
                            newSchemeManager.addScheme((Object)migratedList, false);
                            indicator.checkCanceled();
                        }
                        catch (IOException e) {
                            LOG.error("Can't copy patch file: " + list.PATH);
                        }
                    }
                    ShelveChangesManager.this.clearShelvedLists(ShelveChangesManager.this.mySchemeManager.getAllSchemes(), false);
                }

                public void onSuccess() {
                    super.onSuccess();
                    ShelveChangesManager.this.updateShelveSchemaManager((SchemeManager<ShelvedChangeList>)newSchemeManager);
                }

                public void onCancel() {
                    super.onCancel();
                    this.suggestToCancelMigrationOrRevertPathToPrevious();
                }

                private void suggestToCancelMigrationOrRevertPathToPrevious() {
                    if (Messages.showOkCancelDialog((Project)this.myProject, (String)VcsBundle.message((String)"shelve.moving.failed.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"shelve.error.title", (Object[])new Object[0]), (String)VcsBundle.message((String)"shelve.use.new.directory.button", (Object[])new Object[0]), (String)VcsBundle.message((String)"shelve.revert.moving.button", (Object[])new Object[0]), (Icon)UIUtil.getWarningIcon()) == 0) {
                        ShelveChangesManager.this.updateShelveSchemaManager((SchemeManager<ShelvedChangeList>)newSchemeManager);
                    } else {
                        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
                        vcsConfiguration.USE_CUSTOM_SHELF_PATH = wasCustom;
                        if (wasCustom) {
                            vcsConfiguration.CUSTOM_SHELF_PATH = FileUtil.toSystemIndependentName((String)fromFile.getPath());
                        }
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    super.onThrowable(error);
                    this.suggestToCancelMigrationOrRevertPathToPrevious();
                }
            }.queue();
        } else {
            this.updateShelveSchemaManager(newSchemeManager);
        }
    }

    private void updateShelveSchemaManager(SchemeManager<ShelvedChangeList> newSchemeManager) {
        this.myProject.save();
        ApplicationManager.getApplication().saveSettings();
        SchemeManagerFactory.getInstance((Project)this.myProject).dispose(this.mySchemeManager);
        this.mySchemeManager = newSchemeManager;
        this.notifyStateChanged();
    }

    @NotNull
    public File getShelfResourcesDirectory() {
        return this.mySchemeManager.getRootDirectory();
    }

    @NotNull
    private ShelvedChangeList readOneShelvedChangeList(@NotNull Element element) throws InvalidDataException {
        ShelvedChangeList data = new ShelvedChangeList();
        this.myPathMacroSubstitutor.expandPaths(element);
        data.readExternal(element);
        return data;
    }

    private void migrateOldShelfInfo(@NotNull Element element, boolean recycled) throws InvalidDataException {
        Element changeSetElement;
        ShelvedChangeList list;
        Iterator iterator = element.getChildren(recycled ? ELEMENT_RECYCLED_CHANGELIST : ELEMENT_CHANGELIST).iterator();
        while (iterator.hasNext() && (list = this.readOneShelvedChangeList(changeSetElement = (Element)iterator.next())).isValid()) {
            File uniqueDir = this.generateUniqueSchemePatchDir(list.DESCRIPTION, false);
            list.setName(uniqueDir.getName());
            list.setRecycled(recycled);
            this.mySchemeManager.addScheme((Object)list, false);
        }
    }

    @NotNull
    private static List<ShelvedBinaryFile> copyBinaryFiles(@NotNull ShelvedChangeList list, @NotNull File targetDirectory) {
        ArrayList<ShelvedBinaryFile> copied = new ArrayList<ShelvedBinaryFile>();
        for (ShelvedBinaryFile file : list.getBinaryFiles()) {
            if (file.SHELVED_PATH == null) continue;
            File shelvedFile = new File(file.SHELVED_PATH);
            if (StringUtil.isEmptyOrSpaces((String)file.AFTER_PATH) || !shelvedFile.exists()) continue;
            File newShelvedFile = new File(targetDirectory, PathUtil.getFileName((String)file.AFTER_PATH));
            try {
                FileUtil.copy((File)shelvedFile, (File)newShelvedFile);
                copied.add(new ShelvedBinaryFile(file.BEFORE_PATH, file.AFTER_PATH, FileUtil.toSystemIndependentName((String)newShelvedFile.getPath())));
            }
            catch (IOException e) {
                LOG.error("Can't copy binary file: " + list.PATH);
            }
        }
        return copied;
    }

    @NotNull
    public List<ShelvedChangeList> getShelvedChangeLists() {
        return this.getRecycled(false);
    }

    @NotNull
    private List<ShelvedChangeList> getRecycled(boolean recycled) {
        return ContainerUtil.newUnmodifiableList((List)ContainerUtil.filter((Collection)this.mySchemeManager.getAllSchemes(), list -> recycled == list.isRecycled() && !list.isDeleted()));
    }

    @NotNull
    public List<ShelvedChangeList> getAllLists() {
        return ContainerUtil.newUnmodifiableList((List)this.mySchemeManager.getAllSchemes());
    }

    public ShelvedChangeList shelveChanges(Collection<? extends Change> changes, String commitMessage2, boolean rollback) throws IOException, VcsException {
        return this.shelveChanges(changes, commitMessage2, rollback, false);
    }

    public ShelvedChangeList shelveChanges(Collection<? extends Change> changes, String commitMessage2, boolean rollback, boolean markToBeDeleted) throws IOException, VcsException {
        return this.shelveChanges(changes, commitMessage2, rollback, markToBeDeleted, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelvedChangeList shelveChanges(Collection<? extends Change> changes, String commitMessage2, boolean rollback, boolean markToBeDeleted, boolean honorExcludedFromCommit) throws IOException, VcsException {
        ShelvedChangeList shelveList;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText(VcsBundle.message((String)"shelve.changes.progress.text", (Object[])new Object[0]));
        }
        try {
            this.SHELVED_FILES_LOCK.writeLock().lock();
            this.rememberShelvingFiles(changes);
            shelveList = this.createShelfFromChanges(changes, commitMessage2, markToBeDeleted, honorExcludedFromCommit);
        }
        finally {
            this.cleanShelvingFiles();
            this.SHELVED_FILES_LOCK.writeLock().unlock();
            this.notifyStateChanged();
        }
        if (rollback) {
            this.rollbackChangesAfterShelve(changes, honorExcludedFromCommit);
        }
        return shelveList;
    }

    @NotNull
    private ShelvedChangeList createShelfFromChanges(@NotNull Collection<? extends Change> changes, String commitMessage2, boolean markToBeDeleted, boolean honorExcludedFromCommit) throws IOException, VcsException {
        LOG.debug("Shelving of " + changes.size() + " changes...");
        StopWatch totalSW = StopWatch.start("Total shelving");
        File schemePatchDir = this.generateUniqueSchemePatchDir(commitMessage2, true);
        ArrayList<Change> textChanges = new ArrayList<Change>();
        ArrayList<ShelvedBinaryFile> binaryFiles = new ArrayList<ShelvedBinaryFile>();
        for (Change change : changes) {
            if (ChangesUtil.getFilePath((Change)change).isDirectory()) continue;
            if (change.getBeforeRevision() instanceof BinaryContentRevision || change.getAfterRevision() instanceof BinaryContentRevision) {
                binaryFiles.add(this.shelveBinaryFile(schemePatchDir, change));
                continue;
            }
            textChanges.add(change);
        }
        File patchFile = ShelveChangesManager.getPatchFileInConfigDir(schemePatchDir);
        ArrayList<FilePatch> arrayList = new ArrayList<FilePatch>(this.buildAndSavePatchInBatches(patchFile, textChanges, honorExcludedFromCommit));
        ShelvedChangeList changeList = new ShelvedChangeList(patchFile.toString(), commitMessage2.replace('\n', ' '), binaryFiles, ShelvedChangeList.createShelvedChangesFromFilePatches(this.myProject, patchFile.toString(), arrayList));
        changeList.markToDelete(markToBeDeleted);
        changeList.setName(schemePatchDir.getName());
        ProgressManager.checkCanceled();
        this.mySchemeManager.addScheme((Object)changeList, false);
        totalSW.report(LOG);
        return changeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FilePatch> buildAndSavePatchInBatches(@NotNull File patchFile, @NotNull List<Change> textChanges, boolean honorExcludedFromCommit) throws VcsException, IOException {
        ArrayList<FilePatch> patches = new ArrayList<FilePatch>();
        if (textChanges.isEmpty()) {
            ShelfFileProcessorUtil.savePatchFile(this.myProject, patchFile, patches, null, new CommitContext());
            return patches;
        }
        int batchIndex = 0;
        int baseContentsPreloadSize = Registry.intValue((String)"git.shelve.load.base.in.batches", (int)-1);
        int partitionSize = baseContentsPreloadSize > 0 ? baseContentsPreloadSize : textChanges.size();
        List partition = Lists.partition(textChanges, (int)partitionSize);
        for (List list : partition) {
            String inbatch = partition.size() > 1 ? " in batch #" + ++batchIndex : "";
            StopWatch totalSw = StopWatch.start("Total shelving" + inbatch);
            try {
                StopWatch iterSw;
                if (baseContentsPreloadSize > 0) {
                    iterSw = StopWatch.start("Preloading base revisions for " + list.size() + " changes");
                    this.preloadBaseRevisions(list);
                    iterSw.report(LOG);
                }
                ProgressManager.checkCanceled();
                iterSw = StopWatch.start("Building patches" + inbatch);
                patches.addAll(IdeaTextPatchBuilder.buildPatch(this.myProject, list, PathUtil.toSystemDependentName((String)this.myProject.getBasePath()), false, honorExcludedFromCommit));
                iterSw.report(LOG);
                ProgressManager.checkCanceled();
                iterSw = StopWatch.start("Storing base revisions" + inbatch);
                CommitContext commitContext = new CommitContext();
                this.baseRevisionsOfDvcsIntoContext(list, commitContext);
                iterSw.report(LOG);
                iterSw = StopWatch.start("Saving patch file" + inbatch);
                ShelfFileProcessorUtil.savePatchFile(this.myProject, patchFile, patches, null, commitContext);
                iterSw.report(LOG);
            }
            finally {
                ProjectLevelVcsManager.getInstance((Project)this.myProject).getContentRevisionCache().clearConstantCache();
                totalSw.report(LOG);
            }
        }
        return patches;
    }

    private void preloadBaseRevisions(@NotNull List<Change> textChanges) {
        MultiMap changesGroupedByRoot = MultiMap.create();
        for (Change change : textChanges) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (beforeRevision == null) continue;
            FilePath file = beforeRevision.getFile();
            VcsRoot vcsRoot = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsRootObjectFor(file);
            if (vcsRoot == null || vcsRoot.getVcs() == null) {
                LOG.error(file + " is not under VCS");
                continue;
            }
            changesGroupedByRoot.putValue((Object)vcsRoot, (Object)change);
        }
        for (VcsRoot vcsRoot : changesGroupedByRoot.keySet()) {
            AbstractVcs vcs = Objects.requireNonNull(vcsRoot.getVcs());
            if (vcs.getDiffProvider() == null) continue;
            vcs.getDiffProvider().preloadBaseRevisions(Objects.requireNonNull(vcsRoot.getPath()), changesGroupedByRoot.get((Object)vcsRoot));
        }
    }

    private void rollbackChangesAfterShelve(@NotNull Collection<? extends Change> changes, boolean honorExcludedFromCommit) {
        String operationName = UIUtil.removeMnemonic((String)RollbackChangesDialog.operationNameByChanges(this.myProject, changes));
        boolean modalContext = ApplicationManager.getApplication().isDispatchThread() && LaterInvocator.isInModalContext();
        StopWatch sw = StopWatch.start("Rollback after shelve");
        new RollbackWorker(this.myProject, operationName, modalContext).doRollback(changes, true, null, VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0]), honorExcludedFromCommit);
        sw.report(LOG);
    }

    @NotNull
    private static File getPatchFileInConfigDir(@NotNull File schemePatchDir) {
        return new File(schemePatchDir, "shelved.patch");
    }

    private void baseRevisionsOfDvcsIntoContext(List<? extends Change> textChanges, CommitContext commitContext) {
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (this.dvcsUsedInProject() && VcsConfiguration.getInstance((Project)this.myProject).INCLUDE_TEXT_INTO_SHELF) {
            HashMap<FilePath, ContentRevision> toKeep = new HashMap<FilePath, ContentRevision>();
            for (Change change : textChanges) {
                FilePath filePath;
                AbstractVcs vcs;
                if (change.getBeforeRevision() == null || change.getAfterRevision() == null || ShelveChangesManager.isBig(change) || (vcs = vcsManager2.getVcsFor(filePath = change.getBeforeRevision().getFile())) == null || !VcsType.distributed.equals((Object)vcs.getType())) continue;
                toKeep.put(filePath, change.getBeforeRevision());
            }
            commitContext.putUserData(BaseRevisionTextPatchEP.ourPutBaseRevisionTextKey, (Object)true);
            commitContext.putUserData(BaseRevisionTextPatchEP.ourBaseRevisions, toKeep);
        }
    }

    private static boolean isBig(@NotNull Change change) {
        VirtualFile vf = change.getVirtualFile();
        if (vf != null) {
            return ShelveChangesManager.isBig(vf.getLength());
        }
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (beforeRevision != null) {
            try {
                String content2 = beforeRevision.getContent();
                if (content2 != null && ShelveChangesManager.isBig(content2.length())) {
                    return true;
                }
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        }
        return false;
    }

    private static boolean isBig(long contentLength) {
        return contentLength > 500000L;
    }

    private boolean dvcsUsedInProject() {
        return Arrays.stream(ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()).anyMatch(vcs -> VcsType.distributed.equals((Object)vcs.getType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelvedChangeList importFilePatches(String fileName, List<? extends FilePatch> patches, List<PatchEP> patchTransitExtensions) throws IOException {
        try {
            File schemePatchDir = this.generateUniqueSchemePatchDir(fileName, true);
            File patchFile = ShelveChangesManager.getPatchFileInConfigDir(schemePatchDir);
            ShelfFileProcessorUtil.savePatchFile(this.myProject, patchFile, patches, patchTransitExtensions, new CommitContext());
            ShelvedChangeList changeList = new ShelvedChangeList(patchFile.toString(), fileName.replace('\n', ' '), (List<ShelvedBinaryFile>)new SmartList(), ShelvedChangeList.createShelvedChangesFromFilePatches(this.myProject, patchFile.getPath(), patches));
            changeList.setName(schemePatchDir.getName());
            this.mySchemeManager.addScheme((Object)changeList, false);
            ShelvedChangeList shelvedChangeList = changeList;
            return shelvedChangeList;
        }
        finally {
            this.notifyStateChanged();
        }
    }

    public List<VirtualFile> gatherPatchFiles(Collection<? extends VirtualFile> files) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        LinkedList<? extends VirtualFile> filesQueue = new LinkedList<VirtualFile>(files);
        while (!filesQueue.isEmpty()) {
            ProgressManager.checkCanceled();
            VirtualFile file = filesQueue.removeFirst();
            if (file.isDirectory()) {
                filesQueue.addAll(Arrays.asList(file.getChildren()));
                continue;
            }
            if (!PatchFileType.isPatchFile(file)) continue;
            result2.add(file);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShelvedChangeList> importChangeLists(Collection<? extends VirtualFile> files, Consumer<? super VcsException> exceptionConsumer) {
        ArrayList<ShelvedChangeList> result2 = new ArrayList<ShelvedChangeList>(files.size());
        try {
            FilesProgress filesProgress = new FilesProgress(files.size(), VcsBundle.message((String)"shelve.import.to.progress", (Object[])new Object[0]));
            for (VirtualFile virtualFile : files) {
                filesProgress.updateIndicator(virtualFile);
                String description = virtualFile.getNameWithoutExtension().replace('_', ' ');
                File schemeNameDir = this.generateUniqueSchemePatchDir(description, true);
                File patchFile = ShelveChangesManager.getPatchFileInConfigDir(schemeNameDir);
                String patchPath = patchFile.getPath();
                try {
                    List<? extends FilePatch> filePatches = ShelveChangesManager.loadPatchesWithoutContent(this.myProject, virtualFile.getPath(), new CommitContext());
                    if (filePatches.isEmpty()) continue;
                    FileUtil.copy((File)new File(virtualFile.getPath()), (File)patchFile);
                    ShelvedChangeList list = new ShelvedChangeList(patchPath, description, (List<ShelvedBinaryFile>)new SmartList(), ShelvedChangeList.createShelvedChangesFromFilePatches(this.myProject, patchPath, filePatches), virtualFile.getTimeStamp());
                    list.setName(schemeNameDir.getName());
                    this.mySchemeManager.addScheme((Object)list, false);
                    result2.add(list);
                }
                catch (Exception e) {
                    exceptionConsumer.consume((Object)new VcsException((Throwable)e));
                }
            }
        }
        finally {
            this.notifyStateChanged();
        }
        return result2;
    }

    private ShelvedBinaryFile shelveBinaryFile(@NotNull File schemePatchDir, Change change) throws IOException {
        ContentRevision beforeRevision = change.getBeforeRevision();
        ContentRevision afterRevision = change.getAfterRevision();
        File beforeFile = beforeRevision == null ? null : beforeRevision.getFile().getIOFile();
        File afterFile = afterRevision == null ? null : afterRevision.getFile().getIOFile();
        String shelvedPath = null;
        if (afterFile != null) {
            String shelvedFileName = afterFile.getName();
            String name = FileUtilRt.getNameWithoutExtension((String)shelvedFileName);
            String extension = FileUtilRt.getExtension((String)shelvedFileName);
            File shelvedFile = FileUtil.findSequentNonexistentFile((File)schemePatchDir, (String)name, (String)extension);
            FileUtil.copy((File)afterRevision.getFile().getIOFile(), (File)shelvedFile);
            shelvedPath = shelvedFile.getPath();
        }
        String beforePath = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)beforeFile);
        String afterPath = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)afterFile);
        return new ShelvedBinaryFile(beforePath, afterPath, shelvedPath);
    }

    private void notifyStateChanged() {
        if (!this.myProject.isDisposed()) {
            ((ChangeListener)this.myBus.syncPublisher(SHELF_TOPIC)).stateChanged(new ChangeEvent(this));
        }
    }

    @NotNull
    private File generateUniqueSchemePatchDir(@Nullable String defaultName, boolean createResourceDirectory) {
        File shelfResourcesDirectory = this.getShelfResourcesDirectory();
        File dir = ShelveChangesManager.suggestPatchName(this.myProject, defaultName, shelfResourcesDirectory, "");
        if (createResourceDirectory && !dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    @NotNull
    public static File suggestPatchName(Project project, @Nullable String commitMessage2, File file, String extension) {
        File nonexistentFile;
        String defaultPath = ShelveChangesManager.shortenAndSanitize(commitMessage2);
        while ((nonexistentFile = FileUtil.findSequentNonexistentFile((File)file, (String)defaultPath, (String)(extension == null ? VcsConfiguration.getInstance((Project)project).getPatchFileExtension() : extension))).getName().length() >= 100) {
            defaultPath = defaultPath.substring(0, defaultPath.length() - 1);
        }
        return nonexistentFile;
    }

    @NotNull
    private static String shortenAndSanitize(@Nullable String commitMessage2) {
        String defaultPath = PathUtil.suggestFileName((String)StringUtil.notNullize((String)commitMessage2));
        if (defaultPath.isEmpty()) {
            defaultPath = "unnamed";
        }
        if (defaultPath.length() > 90) {
            defaultPath = defaultPath.substring(0, 90);
        }
        return defaultPath;
    }

    public void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<? extends ShelvedChange> changes, @Nullable List<? extends ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification) {
        this.unshelveChangeList(changeList, changes, binaryFiles, targetChangeList, showSuccessNotification, this.isRemoveFilesFromShelf());
    }

    private void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<? extends ShelvedChange> changes, @Nullable List<? extends ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification, boolean removeFilesFromShelf) {
        this.unshelveChangeList(changeList, changes, binaryFiles, targetChangeList, showSuccessNotification, false, false, null, null, removeFilesFromShelf);
    }

    public void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<? extends ShelvedChange> changes, @Nullable List<? extends ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification, boolean systemOperation, boolean reverse, String leftConflictTitle, String rightConflictTitle, boolean removeFilesFromShelf) {
        List<TextFilePatch> textFilePatches;
        ArrayList<FilePatch> remainingPatches = new ArrayList<FilePatch>();
        CommitContext commitContext = new CommitContext();
        try {
            textFilePatches = ShelveChangesManager.loadTextPatches(this.myProject, changeList, changes, remainingPatches, commitContext);
        }
        catch (PatchSyntaxException | IOException e) {
            LOG.info((Throwable)e);
            PatchApplier.showError(this.myProject, VcsBundle.message((String)"unshelve.loading.patch.error", (Object[])new Object[]{e.getMessage()}));
            return;
        }
        ArrayList<TextFilePatch> patches = new ArrayList<TextFilePatch>(textFilePatches);
        ArrayList remainingBinaries = new ArrayList();
        List<ShelvedBinaryFile> binaryFilesToUnshelve = ShelveChangesManager.getBinaryFilesToUnshelve(changeList, binaryFiles, remainingBinaries);
        for (ShelvedBinaryFile shelvedBinaryFile : binaryFilesToUnshelve) {
            patches.add((TextFilePatch)new ShelvedBinaryFilePatch(shelvedBinaryFile));
        }
        PatchApplier patchApplier = new PatchApplier(this.myProject, this.myProject.getBaseDir(), patches, targetChangeList, commitContext, reverse, leftConflictTitle, rightConflictTitle);
        patchApplier.execute(showSuccessNotification, systemOperation);
        if (removeFilesFromShelf) {
            remainingPatches.addAll(patchApplier.getRemainingPatches());
            GuiUtils.invokeLaterIfNeeded(() -> this.updateListAfterUnshelve(changeList, remainingPatches, remainingBinaries, commitContext), (ModalityState)ModalityState.NON_MODAL, (Condition)this.myProject.getDisposed());
        }
    }

    @NotNull
    Map<ShelvedChangeList, Date> deleteShelves(@NotNull List<? extends ShelvedChangeList> shelvedListsToDelete, @NotNull List<? extends ShelvedChangeList> shelvedListsFromChanges, @NotNull List<? extends ShelvedChange> changesToDelete, @NotNull List<? extends ShelvedBinaryFile> binariesToDelete) {
        Date originalDate;
        ArrayList<? extends ShelvedChangeList> shelvedListsFromChangesToDelete = new ArrayList<ShelvedChangeList>(shelvedListsFromChanges);
        shelvedListsFromChangesToDelete.removeAll(shelvedListsToDelete);
        if (shelvedListsFromChangesToDelete.size() + binariesToDelete.size() == 0 && shelvedListsToDelete.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ShelvedChangeList, Date> deletedListsWithOriginalDate = new HashMap<ShelvedChangeList, Date>();
        for (ShelvedChangeList shelvedChangeList : shelvedListsToDelete) {
            originalDate = shelvedChangeList.DATE;
            if (shelvedChangeList.isDeleted()) {
                this.deleteChangeListCompletely(shelvedChangeList);
                continue;
            }
            this.markChangeListAsDeleted(shelvedChangeList);
            deletedListsWithOriginalDate.put(shelvedChangeList, originalDate);
        }
        for (ShelvedChangeList shelvedChangeList : shelvedListsFromChangesToDelete) {
            ShelvedChangeList shelvedChangeList2;
            originalDate = shelvedChangeList.DATE;
            boolean wasDeleted = shelvedChangeList.isDeleted();
            ShelvedChangeList newListWithDeletedChanges = this.removeChangesFromChangeList(shelvedChangeList, changesToDelete, binariesToDelete);
            if (newListWithDeletedChanges != null) {
                deletedListsWithOriginalDate.put(newListWithDeletedChanges, originalDate);
                continue;
            }
            if (wasDeleted || (shelvedChangeList2 = (ShelvedChangeList)this.mySchemeManager.findSchemeByName(shelvedChangeList.getName())) == null || !shelvedChangeList2.isDeleted()) continue;
            deletedListsWithOriginalDate.put(shelvedChangeList2, originalDate);
        }
        return deletedListsWithOriginalDate;
    }

    @Nullable
    private ShelvedChangeList removeChangesFromChangeList(@NotNull ShelvedChangeList list, @NotNull List<? extends ShelvedChange> changes, @NotNull List<? extends ShelvedBinaryFile> binaryFiles) {
        ArrayList<ShelvedBinaryFile> remainingBinaries = new ArrayList<ShelvedBinaryFile>(list.getBinaryFiles());
        remainingBinaries.removeAll(binaryFiles);
        CommitContext commitContext = new CommitContext();
        ArrayList remainingPatches = new ArrayList();
        try {
            ShelveChangesManager.loadTextPatches(this.myProject, list, changes, remainingPatches, commitContext);
        }
        catch (PatchSyntaxException | IOException e) {
            LOG.info((Throwable)e);
            VcsImplUtil.showErrorMessage(this.myProject, e.getMessage(), VcsBundle.message((String)"shelve.delete.files.from.changelist.error", (Object[])new Object[]{list.DESCRIPTION}));
            return null;
        }
        return this.saveRemainingPatchesIfNeeded(list, remainingPatches, remainingBinaries, commitContext, true);
    }

    static List<TextFilePatch> loadTextPatches(Project project, ShelvedChangeList changeList, List<? extends ShelvedChange> changes, List<? super FilePatch> remainingPatches, CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> textFilePatches = ShelveChangesManager.loadPatches(project, changeList.PATH, commitContext);
        if (changes != null) {
            Iterator<TextFilePatch> iterator = textFilePatches.iterator();
            while (iterator.hasNext()) {
                TextFilePatch patch = iterator.next();
                if (ShelveChangesManager.needUnshelve((FilePatch)patch, changes)) continue;
                remainingPatches.add((FilePatch)patch);
                iterator.remove();
            }
        }
        return textFilePatches;
    }

    public void setRemoveFilesFromShelf(boolean removeFilesFromShelf) {
        this.myState.myRemoveFilesFromShelf = removeFilesFromShelf;
    }

    public boolean isRemoveFilesFromShelf() {
        return this.myState.myRemoveFilesFromShelf;
    }

    private void markDeletedSystemUnshelved() {
        List systemUnshelved = ContainerUtil.filter((Collection)this.mySchemeManager.getAllSchemes(), list -> list.isRecycled() && list.isMarkedToDelete());
        for (ShelvedChangeList list2 : systemUnshelved) {
            list2.setDeleted(true);
            list2.markToDelete(false);
        }
    }

    private void cleanDeletedOlderOneWeek() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -7);
        this.clean((Condition<? super ShelvedChangeList>)((Condition)list -> list.isDeleted() && list.DATE.before(new Date(cal.getTimeInMillis()))));
    }

    public void cleanUnshelved(long timeBefore) {
        Date limitDate = new Date(timeBefore);
        this.clean((Condition<? super ShelvedChangeList>)((Condition)l -> l.isRecycled() && l.DATE.before(limitDate)));
    }

    private void clean(@NotNull Condition<? super ShelvedChangeList> condition) {
        List toDelete = ContainerUtil.filter((Collection)this.mySchemeManager.getAllSchemes(), condition);
        this.clearShelvedLists(toDelete, true);
    }

    public void shelveSilentlyUnderProgress(final @NotNull List<? extends Change> changes) {
        final ArrayList result2 = new ArrayList();
        new Task.Backgroundable(this.myProject, VcsBundle.getString((String)"shelve.changes.progress.title"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                result2.addAll(ShelveChangesManager.this.shelveChangesInSeparatedLists(changes));
            }

            public void onSuccess() {
                VcsNotifier.getInstance(this.myProject).notifySuccess(VcsBundle.message((String)"shelve.successful.message", (Object[])new Object[0]));
                if (result2.size() == 1 && ShelveChangesManager.this.isShelfContentActive()) {
                    ShelvedChangesViewManager.getInstance(this.myProject).startEditing((ShelvedChangeList)result2.get(0));
                }
            }
        }.queue();
    }

    private void rememberShelvingFiles(@NotNull Collection<? extends Change> changes) {
        HashSet<VirtualFile> fileSet = new HashSet<VirtualFile>();
        fileSet.addAll(ContainerUtil.map2SetNotNull(changes, Change::getVirtualFile));
        this.myShelvingFiles = fileSet;
    }

    private void cleanShelvingFiles() {
        this.myShelvingFiles = null;
    }

    private boolean isShelfContentActive() {
        ToolWindow window = ChangesViewContentManager.getToolWindowFor(this.myProject, "Shelf");
        return window != null && window.isVisible() && ((ChangesViewContentManager)ChangesViewContentManager.getInstance(this.myProject)).isContentSelected("Shelf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<ShelvedChangeList> shelveChangesInSeparatedLists(@NotNull Collection<? extends Change> changes) {
        ArrayList<String> failedChangeLists = new ArrayList<String>();
        ArrayList<ShelvedChangeList> result2 = new ArrayList<ShelvedChangeList>();
        ArrayList shelvedChanges = new ArrayList();
        try {
            this.SHELVED_FILES_LOCK.writeLock().lock();
            this.rememberShelvingFiles(changes);
            List changeLists = ChangeListManager.getInstance((Project)this.myProject).getChangeLists();
            for (LocalChangeList list : changeLists) {
                HashSet changeSet = new HashSet(list.getChanges());
                ArrayList<Change> changesForChangelist = new ArrayList<Change>();
                for (Change change : changes) {
                    boolean inChangelist = change instanceof ChangeListChange ? ((ChangeListChange)change).getChangeListId().equals(list.getId()) : changeSet.contains(change);
                    if (!inChangelist) continue;
                    changesForChangelist.add(change);
                }
                if (changesForChangelist.isEmpty()) continue;
                try {
                    result2.add(this.createShelfFromChanges(changesForChangelist, list.getName(), false, false));
                    shelvedChanges.addAll(changesForChangelist);
                }
                catch (Exception e) {
                    ProgressManager.checkCanceled();
                    LOG.warn((Throwable)e);
                    failedChangeLists.add(list.getName());
                }
            }
        }
        finally {
            this.cleanShelvingFiles();
            this.SHELVED_FILES_LOCK.writeLock().unlock();
            this.notifyStateChanged();
        }
        this.rollbackChangesAfterShelve(shelvedChanges, false);
        if (!failedChangeLists.isEmpty()) {
            VcsNotifier.getInstance(this.myProject).notifyError(VcsBundle.message((String)"shelve.failed.title", (Object[])new Object[0]), VcsBundle.message((String)"shelve.failed.message", (Object[])new Object[]{failedChangeLists.size(), StringUtil.join(failedChangeLists, (String)",")}));
        }
        return result2;
    }

    public static void unshelveSilentlyWithDnd(@NotNull Project project, @NotNull ShelvedChangeListDragBean shelvedChangeListDragBean, @Nullable ChangesBrowserNode dropRootNode, boolean removeFilesFromShelf) {
        FileDocumentManager.getInstance().saveAllDocuments();
        LocalChangeList predefinedChangeList = dropRootNode != null ? (LocalChangeList)ObjectUtils.tryCast(dropRootNode.getUserObject(), LocalChangeList.class) : null;
        ShelveChangesManager.getInstance(project).unshelveSilentlyAsynchronously(project, shelvedChangeListDragBean.getShelvedChangelists(), shelvedChangeListDragBean.getChanges(), shelvedChangeListDragBean.getBinaryFiles(), predefinedChangeList, removeFilesFromShelf);
    }

    public void unshelveSilentlyAsynchronously(@NotNull Project project, @NotNull List<? extends ShelvedChangeList> selectedChangeLists, @NotNull List<? extends ShelvedChange> selectedChanges, @NotNull List<? extends ShelvedBinaryFile> selectedBinaryChanges, @Nullable LocalChangeList forcePredefinedOneChangelist) {
        this.unshelveSilentlyAsynchronously(project, selectedChangeLists, selectedChanges, selectedBinaryChanges, forcePredefinedOneChangelist, this.isRemoveFilesFromShelf());
    }

    private void unshelveSilentlyAsynchronously(@NotNull Project project, final @NotNull List<? extends ShelvedChangeList> selectedChangeLists, final @NotNull List<? extends ShelvedChange> selectedChanges, final @NotNull List<? extends ShelvedBinaryFile> selectedBinaryChanges, final @Nullable LocalChangeList forcePredefinedOneChangelist, final boolean removeFilesFromShelf) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, VcsBundle.getString((String)"unshelve.changes.progress.title"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                for (ShelvedChangeList changeList : selectedChangeLists) {
                    ArrayList changesForChangelist = new ArrayList(ContainerUtil.intersection((Collection)Objects.requireNonNull(changeList.getChanges()), (Collection)selectedChanges));
                    ArrayList binariesForChangelist = new ArrayList(ContainerUtil.intersection(changeList.getBinaryFiles(), (Collection)selectedBinaryChanges));
                    boolean shouldUnshelveAllList = changesForChangelist.isEmpty() && binariesForChangelist.isEmpty();
                    ShelveChangesManager.this.unshelveChangeList(changeList, shouldUnshelveAllList ? null : changesForChangelist, shouldUnshelveAllList ? null : binariesForChangelist, forcePredefinedOneChangelist != null ? forcePredefinedOneChangelist : ShelveChangesManager.this.getChangeListUnshelveTo(changeList), true, removeFilesFromShelf);
                    ChangeListManagerImpl.getInstanceImpl(this.myProject).waitForUpdate(VcsBundle.getString((String)"unshelve.changes.progress.title"));
                }
            }
        });
    }

    @NotNull
    private LocalChangeList getChangeListUnshelveTo(@NotNull ShelvedChangeList list) {
        ChangeListManager manager = ChangeListManager.getInstance((Project)this.myProject);
        LocalChangeList localChangeList = ChangeListUtil.getPredefinedChangeList(list, manager);
        return localChangeList != null ? localChangeList : manager.addChangeList(ChangeListUtil.getChangeListNameForUnshelve(list), "");
    }

    private static List<ShelvedBinaryFile> getBinaryFilesToUnshelve(ShelvedChangeList changeList, List<? extends ShelvedBinaryFile> binaryFiles, List<? super ShelvedBinaryFile> remainingBinaries) {
        if (binaryFiles == null) {
            return new ArrayList<ShelvedBinaryFile>(changeList.getBinaryFiles());
        }
        ArrayList<ShelvedBinaryFile> result2 = new ArrayList<ShelvedBinaryFile>();
        for (ShelvedBinaryFile file : changeList.getBinaryFiles()) {
            if (binaryFiles.contains(file)) {
                result2.add(file);
                continue;
            }
            remainingBinaries.add(file);
        }
        return result2;
    }

    private static boolean needUnshelve(FilePatch patch, List<? extends ShelvedChange> changes) {
        for (ShelvedChange shelvedChange : changes) {
            if (!Objects.equals(patch.getBeforeName(), shelvedChange.getBeforePath())) continue;
            return true;
        }
        return false;
    }

    private static void writePatchesToFile(Project project, String path2, List<? extends FilePatch> remainingPatches, CommitContext commitContext) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path2), StandardCharsets.UTF_8);){
            UnifiedDiffWriter.write(project, remainingPatches, writer, "\n", commitContext);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void updateListAfterUnshelve(@NotNull ShelvedChangeList listToUpdate, @NotNull List<? extends FilePatch> patches, @NotNull List<? extends ShelvedBinaryFile> binaries, @NotNull CommitContext commitContext) {
        this.saveRemainingPatchesIfNeeded(listToUpdate, patches, binaries, commitContext, false);
    }

    @Nullable
    private ShelvedChangeList saveRemainingPatchesIfNeeded(ShelvedChangeList changeList, List<? extends FilePatch> remainingPatches, List<? extends ShelvedBinaryFile> remainingBinaries, CommitContext commitContext, boolean delete) {
        if (remainingPatches.isEmpty() && remainingBinaries.isEmpty()) {
            if (!delete) {
                this.recycleChangeList(changeList);
            } else if (changeList.isDeleted()) {
                this.deleteChangeListCompletely(changeList);
            } else {
                this.markChangeListAsDeleted(changeList);
            }
            return null;
        }
        if (!delete && changeList.isRecycled()) {
            return null;
        }
        ShelvedChangeList newlyCreatedList = null;
        if (delete && changeList.isDeleted()) {
            this.saveRemainingChangesInList(changeList, remainingPatches, remainingBinaries, commitContext);
        } else {
            newlyCreatedList = this.saveRemainingAndRecycleOthers(changeList, remainingPatches, remainingBinaries, commitContext, delete);
        }
        this.notifyStateChanged();
        return newlyCreatedList;
    }

    @Nullable
    private ShelvedChangeList saveRemainingAndRecycleOthers(@NotNull ShelvedChangeList changeList, List<? extends FilePatch> remainingPatches, List<? extends ShelvedBinaryFile> remainingBinaries, CommitContext commitContext, boolean delete) {
        try {
            ShelvedChangeList listCopy = this.createChangelistCopyWithChanges(changeList, this.generateUniqueSchemePatchDir(changeList.DESCRIPTION, true));
            listCopy.updateDate();
            this.saveRemainingChangesInList(changeList, remainingPatches, remainingBinaries, commitContext);
            this.removeFromListWithChanges(listCopy, Objects.requireNonNull(changeList.getChanges()), changeList.getBinaryFiles());
            if (delete) {
                this.markChangeListAsDeleted(listCopy);
            } else {
                this.recycleChangeList(listCopy);
            }
            this.saveListAsScheme(listCopy);
            return listCopy;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void saveRemainingChangesInList(@NotNull ShelvedChangeList changeList, List<? extends FilePatch> remainingPatches, List<? extends ShelvedBinaryFile> remainingBinaries, CommitContext commitContext) {
        ShelveChangesManager.writePatchesToFile(this.myProject, changeList.PATH, remainingPatches, commitContext);
        changeList.getBinaryFiles().retainAll(remainingBinaries);
        changeList.setChanges(ShelvedChangeList.createShelvedChangesFromFilePatches(this.myProject, changeList.PATH, remainingPatches));
    }

    void saveListAsScheme(@NotNull ShelvedChangeList list) {
        if (!list.getBinaryFiles().isEmpty() || !ContainerUtil.isEmpty(list.getChanges())) {
            this.mySchemeManager.addScheme((Object)list, false);
        }
    }

    @NotNull
    ShelvedChangeList createChangelistCopyWithChanges(@NotNull ShelvedChangeList changeList, @NotNull File targetDir) throws IOException {
        File newPath = ShelveChangesManager.getPatchFileInConfigDir(targetDir);
        FileUtil.copy((File)new File(changeList.PATH), (File)newPath);
        changeList.loadChangesIfNeeded(this.myProject);
        ShelvedChangeList listCopy = new ShelvedChangeList(newPath.getAbsolutePath(), changeList.DESCRIPTION, ShelveChangesManager.copyBinaryFiles(changeList, targetDir), new ArrayList<ShelvedChange>((Collection)Objects.requireNonNull(changeList.getChanges())), changeList.DATE.getTime());
        listCopy.markToDelete(changeList.isMarkedToDelete());
        listCopy.setRecycled(changeList.isRecycled());
        listCopy.setDeleted(changeList.isDeleted());
        listCopy.setName(targetDir.getName());
        return listCopy;
    }

    public void restoreList(@NotNull ShelvedChangeList shelvedChangeList, @NotNull Date restoreDate) {
        ShelvedChangeList list = (ShelvedChangeList)this.mySchemeManager.findSchemeByName(shelvedChangeList.getName());
        if (list == null) {
            return;
        }
        list.setDeleted(false);
        list.DATE = restoreDate;
        this.notifyStateChanged();
    }

    @NotNull
    public List<ShelvedChangeList> getRecycledShelvedChangeLists() {
        return this.getRecycled(true);
    }

    public List<ShelvedChangeList> getDeletedLists() {
        return ContainerUtil.newUnmodifiableList((List)ContainerUtil.filter((Collection)this.mySchemeManager.getAllSchemes(), ShelvedChangeList::isDeleted));
    }

    public void clearRecycled() {
        this.clearShelvedLists(this.getRecycledShelvedChangeLists(), true);
    }

    void clearShelvedLists(@NotNull List<? extends ShelvedChangeList> shelvedLists, boolean updateView) {
        if (shelvedLists.isEmpty()) {
            return;
        }
        for (ShelvedChangeList shelvedChangeList : shelvedLists) {
            this.deleteResources(shelvedChangeList);
            this.mySchemeManager.removeScheme((Object)shelvedChangeList);
        }
        if (updateView) {
            this.notifyStateChanged();
        }
    }

    @NotNull
    public Collection<VirtualFile> getShelvingFiles() {
        return new HashSet<VirtualFile>(ContainerUtil.notNullize(this.myShelvingFiles));
    }

    private void removeFromListWithChanges(@NotNull ShelvedChangeList listCopy, @NotNull List<? extends ShelvedChange> shelvedChanges, @NotNull List<? extends ShelvedBinaryFile> shelvedBinaryChanges) {
        ShelveChangesManager.removeBinaries(listCopy, shelvedBinaryChanges);
        ShelveChangesManager.removeChanges(listCopy, shelvedChanges);
        try {
            CommitContext commitContext = new CommitContext();
            ArrayList<Object> patches = new ArrayList<Object>();
            List<TextFilePatch> filePatches = ShelveChangesManager.loadPatches(this.myProject, listCopy.PATH, commitContext);
            for (ShelvedChange change : Objects.requireNonNull(listCopy.getChanges())) {
                patches.add(ContainerUtil.find(filePatches, patch -> change.getBeforePath().equals(patch.getBeforeName())));
            }
            ShelveChangesManager.writePatchesToFile(this.myProject, listCopy.PATH, patches, commitContext);
        }
        catch (PatchSyntaxException | IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static void removeChanges(@NotNull ShelvedChangeList list, @NotNull List<? extends ShelvedChange> shelvedChanges) {
        Iterator<ShelvedChange> iterator = Objects.requireNonNull(list.getChanges()).iterator();
        while (iterator.hasNext()) {
            ShelvedChange change = iterator.next();
            for (ShelvedChange shelvedChange : shelvedChanges) {
                if (!Objects.equals(change.getBeforePath(), shelvedChange.getBeforePath()) || !Objects.equals(change.getAfterPath(), shelvedChange.getAfterPath())) continue;
                iterator.remove();
            }
        }
    }

    private static void removeBinaries(@NotNull ShelvedChangeList list, @NotNull List<? extends ShelvedBinaryFile> binaryFiles) {
        Iterator<ShelvedBinaryFile> shelvedChangeListIterator = list.getBinaryFiles().iterator();
        while (shelvedChangeListIterator.hasNext()) {
            ShelvedBinaryFile binaryFile = shelvedChangeListIterator.next();
            for (ShelvedBinaryFile shelvedBinaryFile : binaryFiles) {
                if (!Objects.equals(shelvedBinaryFile.BEFORE_PATH, binaryFile.BEFORE_PATH) || !Objects.equals(shelvedBinaryFile.AFTER_PATH, binaryFile.AFTER_PATH)) continue;
                shelvedChangeListIterator.remove();
            }
        }
    }

    private void recycleChangeList(@NotNull ShelvedChangeList changeList) {
        changeList.setRecycled(true);
        changeList.updateDate();
        if (changeList.isMarkedToDelete()) {
            changeList.markToDelete(false);
            changeList.setDeleted(true);
        }
        this.notifyStateChanged();
    }

    private void deleteChangeListCompletely(@NotNull ShelvedChangeList changeList) {
        this.deleteResources(changeList);
        this.mySchemeManager.removeScheme((Object)changeList);
        this.notifyStateChanged();
    }

    void markChangeListAsDeleted(@NotNull ShelvedChangeList changeList) {
        changeList.setDeleted(true);
        changeList.updateDate();
        this.notifyStateChanged();
    }

    private void deleteResources(@NotNull ShelvedChangeList changeList) {
        FileUtil.delete((File)new File(changeList.PATH));
        for (ShelvedBinaryFile binaryFile : changeList.getBinaryFiles()) {
            String path2 = binaryFile.SHELVED_PATH;
            if (path2 == null) continue;
            FileUtil.delete((File)new File(path2));
        }
        File schemaDir = new File(this.getShelfResourcesDirectory(), changeList.getName());
        if (schemaDir.exists() && ArrayUtil.isEmpty((Object[])schemaDir.list())) {
            FileUtil.delete((File)schemaDir);
        }
    }

    public void renameChangeList(ShelvedChangeList changeList, String newName) {
        changeList.DESCRIPTION = newName;
        this.notifyStateChanged();
    }

    @NotNull
    public static List<TextFilePatch> loadPatches(Project project, String patchPath, @Nullable CommitContext commitContext) throws IOException, PatchSyntaxException {
        return ShelveChangesManager.loadPatches(project, patchPath, commitContext, true);
    }

    @NotNull
    static List<? extends FilePatch> loadPatchesWithoutContent(Project project, String patchPath, @Nullable CommitContext commitContext) throws IOException, PatchSyntaxException {
        return ShelveChangesManager.loadPatches(project, patchPath, commitContext, false);
    }

    private static List<TextFilePatch> loadPatches(Project project, String patchPath, @Nullable CommitContext commitContext, boolean loadContent) throws IOException, PatchSyntaxException {
        char[] text2 = FileUtil.loadFileText((File)new File(patchPath), (String)"UTF-8");
        PatchReader reader = new PatchReader((CharSequence)new CharArrayCharSequence(text2), loadContent);
        List<TextFilePatch> textFilePatches = reader.readTextPatches();
        ApplyPatchDefaultExecutor.applyAdditionalInfoBefore(project, reader.getAdditionalInfo(null), commitContext);
        return textFilePatches;
    }

    public boolean isShowRecycled() {
        return this.myState.myShowRecycled;
    }

    public void setShowRecycled(boolean showRecycled) {
        this.myState.myShowRecycled = showRecycled;
    }

    @NotNull
    public Set<String> getGrouping() {
        return this.myState.groupingKeys;
    }

    public void setGrouping(@NotNull Set<String> grouping2) {
        this.myState.groupingKeys = grouping2;
    }

    public static class PostStartupActivity
    implements StartupActivity.DumbAware {
        public void runActivity(@NotNull Project project) {
            ShelveChangesManager.getInstance(project).projectOpened();
        }
    }

    public static final class State {
        @OptionTag(value="remove_strategy")
        public boolean myRemoveFilesFromShelf;
        @Attribute(value="show_recycled")
        public boolean myShowRecycled;
        @XCollection
        public Set<String> groupingKeys = new HashSet<String>();
    }
}

