/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnshelvePatchDefaultExecutor
extends ApplyPatchDefaultExecutor {
    private static final Logger LOG = Logger.getInstance(UnshelvePatchDefaultExecutor.class);
    @NotNull
    private final ShelvedChangeList myCurrentShelveChangeList;

    public UnshelvePatchDefaultExecutor(@NotNull Project project, @NotNull ShelvedChangeList changeList) {
        super(project);
        this.myCurrentShelveChangeList = changeList;
    }

    @Override
    public void apply(final @NotNull List<? extends FilePatch> remaining, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> patchGroupsToApply, final @Nullable LocalChangeList localList, @Nullable String fileName, @Nullable ThrowableComputable<? extends Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        final CommitContext commitContext = new CommitContext();
        UnshelvePatchDefaultExecutor.applyAdditionalInfoBefore(this.myProject, additionalInfo, commitContext);
        final Collection<PatchApplier> appliers = this.getPatchAppliers(patchGroupsToApply, localList, commitContext);
        new Task.Backgroundable(this.myProject, VcsBundle.getString((String)"unshelve.changes.progress.title")){
            ApplyPatchStatus myApplyPatchStatus;

            public void run(@NotNull ProgressIndicator indicator) {
                this.myApplyPatchStatus = PatchApplier.executePatchGroup(appliers, localList);
            }

            public void onSuccess() {
                if (this.myApplyPatchStatus != ApplyPatchStatus.ABORT && this.myApplyPatchStatus != ApplyPatchStatus.FAILURE) {
                    UnshelvePatchDefaultExecutor.this.removeAppliedAndSaveRemainedIfNeeded(remaining, appliers, commitContext);
                }
            }
        }.queue();
    }

    private void removeAppliedAndSaveRemainedIfNeeded(@NotNull List<? extends FilePatch> remaining, @NotNull Collection<? extends PatchApplier> appliers, @NotNull CommitContext commitContext) {
        ShelveChangesManager shelveChangesManager = ShelveChangesManager.getInstance(this.myProject);
        if (!shelveChangesManager.isRemoveFilesFromShelf()) {
            return;
        }
        try {
            ArrayList<? extends FilePatch> patches = new ArrayList<FilePatch>(remaining);
            patches.addAll(ContainerUtil.concat(appliers, PatchApplier::getRemainingPatches));
            shelveChangesManager.updateListAfterUnshelve(this.myCurrentShelveChangeList, patches, ContainerUtil.mapNotNull(patches, patch -> patch instanceof ShelvedBinaryFilePatch ? ((ShelvedBinaryFilePatch)((Object)patch)).getShelvedBinaryFile() : null), commitContext);
        }
        catch (Exception e) {
            LOG.error("Couldn't update and store remaining patches", (Throwable)e);
        }
    }
}

