/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.BinaryEncoder;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.vcs.changes.patch.BlobIndexUtil;
import com.intellij.openapi.vcs.changes.patch.GitPatchWriter;
import com.intellij.util.ArrayUtilRt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BinaryPatchWriter {
    private static final Logger LOG = Logger.getInstance(BinaryFilePatch.class);
    @NonNls
    private static final String GIT_BINARY_HEADER = "GIT binary patch";
    @NonNls
    private static final String LITERAL_HEADER = "literal %s";

    public static void writeBinaries(@Nullable String basePath, @NotNull List<? extends BinaryFilePatch> patches, @NotNull Writer writer) throws IOException {
        String lineSeparator = "\n";
        for (FilePatch filePatch : patches) {
            BinaryFilePatch filePatch2 = (BinaryFilePatch)filePatch;
            GitPatchWriter.writeGitHeader(writer, basePath, (FilePatch)filePatch2);
            byte[] afterContent = filePatch2.getAfterContent();
            writer.write(GitPatchWriter.getIndexHeader(filePatch2.isNewFile() ? BlobIndexUtil.NOT_COMMITTED_HASH : BinaryPatchWriter.getSha1ForContent(filePatch2.getBeforeContent()), filePatch2.isDeletedFile() ? BlobIndexUtil.NOT_COMMITTED_HASH : BinaryPatchWriter.getSha1ForContent(afterContent)));
            writer.write(lineSeparator);
            writer.write(GIT_BINARY_HEADER);
            writer.write(lineSeparator);
            writer.write(String.format(LITERAL_HEADER, afterContent == null ? 0 : afterContent.length));
            writer.write(lineSeparator);
            try {
                BinaryEncoder.encode(new ByteArrayInputStream(afterContent != null ? afterContent : ArrayUtilRt.EMPTY_BYTE_ARRAY), writer);
            }
            catch (BinaryEncoder.BinaryPatchException e) {
                File afterFile = new File(basePath, filePatch2.getAfterName());
                LOG.error("Can't write patch for binary file: " + afterFile.getPath(), (Throwable)e);
            }
            writer.write(lineSeparator);
        }
    }

    @NotNull
    private static String getSha1ForContent(byte @Nullable [] content2) {
        return content2 != null ? BlobIndexUtil.getSha1(content2) : BlobIndexUtil.NOT_COMMITTED_HASH;
    }
}

