/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.local;

import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditComment
implements ChangeListCommand {
    private final String myName;
    private final String myNewComment;
    private String myOldComment;
    private LocalChangeList myListCopy;

    public EditComment(@NotNull String name, @NotNull String newComment) {
        this.myNewComment = newComment;
        this.myName = name;
    }

    @Override
    public void apply(ChangeListWorker worker) {
        this.myOldComment = worker.editComment(this.myName, this.myNewComment);
        this.myListCopy = this.myOldComment != null && !Objects.equals(this.myOldComment, this.myNewComment) ? worker.getChangeListByName(this.myName) : null;
    }

    @Override
    public void doNotify(ChangeListListener listener2) {
        if (this.myListCopy != null) {
            listener2.changeListCommentChanged((ChangeList)this.myListCopy, this.myOldComment);
        }
    }

    @Nullable
    public String getOldComment() {
        return this.myOldComment;
    }
}

