/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.lang;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vcs.changes.ignore.lang.Syntax;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.util.ArrayUtilRt;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoreLanguage
extends Language {
    public static final IgnoreLanguage INSTANCE = new IgnoreLanguage();
    @NonNls
    private static final String DOT = ".";
    @NotNull
    private final String myExtension;

    protected IgnoreLanguage() {
        this("IgnoreLang", "ignore");
    }

    protected IgnoreLanguage(@NotNull String name, @NotNull String extension) {
        super((Language)INSTANCE, name, ArrayUtilRt.EMPTY_STRING_ARRAY);
        this.myExtension = extension;
    }

    @NotNull
    public String getExtension() {
        return this.myExtension;
    }

    @NotNull
    public String getFilename() {
        return DOT + this.getExtension();
    }

    @NotNull
    public String getDisplayName() {
        return this.getFilename() + " (" + this.getID() + ")";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Vcs.Ignore_file;
    }

    @NotNull
    public IgnoreFileType getFileType() {
        return IgnoreFileType.INSTANCE;
    }

    @NotNull
    public final IgnoreFile createFile(@NotNull FileViewProvider viewProvider) {
        return new IgnoreFile(viewProvider, this.getFileType());
    }

    public boolean isSyntaxSupported() {
        return false;
    }

    @NotNull
    public Syntax getDefaultSyntax() {
        return Syntax.GLOB;
    }

    @Nullable
    public VirtualFile getAffectedRoot(@NotNull Project project, @NotNull VirtualFile ignoreFile) {
        return ignoreFile.getParent();
    }
}

