/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictDialog;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

final class ChangelistConflictAccessProvider
extends WritingAccessProvider {
    private final Project myProject;

    ChangelistConflictAccessProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files) {
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
        ChangelistConflictTracker.Options options = changeListManager.getConflictTracker().getOptions();
        if (!options.SHOW_DIALOG) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> denied = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files) {
            if (virtualFile == null || changeListManager.getConflictTracker().isWritingAllowed(virtualFile)) continue;
            denied.add(virtualFile);
        }
        if (!denied.isEmpty()) {
            ChangelistConflictDialog dialog;
            HashSet<LocalChangeList> changeLists = new HashSet<LocalChangeList>();
            ArrayList<Change> arrayList = new ArrayList<Change>();
            for (VirtualFile file : denied) {
                changeLists.add(changeListManager.getChangeList(file));
                arrayList.add(changeListManager.getChange(file));
            }
            int savedEventCount = IdeEventQueue.getInstance().getEventCount();
            do {
                dialog = new ChangelistConflictDialog(this.myProject, new ArrayList<ChangeList>(changeLists), denied);
                dialog.show();
            } while (dialog.isOK() && !dialog.getResolution().resolveConflict(this.myProject, arrayList, null));
            IdeEventQueue.getInstance().setEventCount(savedEventCount);
            if (dialog.isOK()) {
                options.LAST_RESOLUTION = dialog.getResolution();
                return Collections.emptyList();
            }
        }
        return denied;
    }
}

