/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.DiffVcsDataKeys;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.impl.DiffViewerWrapper;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProvider;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffViewerWrapperProvider;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeUtils;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangeDiffRequestProducer
implements DiffRequestProducer,
ChangeDiffRequestChain.Producer {
    private static final Logger LOG = Logger.getInstance(ChangeDiffRequestProducer.class);
    public static final Key<Change> CHANGE_KEY = Key.create((String)"DiffRequestPresentable.Change");
    public static final Key<Change> TAG_KEY = Key.create((String)"DiffRequestPresentable.Tag");
    @Deprecated
    public static final String YOUR_VERSION = DiffBundle.message((String)"merge.version.title.our", (Object[])new Object[0]);
    @Deprecated
    public static final String BASE_VERSION = DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]);
    @Nullable
    private final Project myProject;
    @NotNull
    private final Change myChange;
    @NotNull
    private final Map<Key<?>, Object> myChangeContext;

    private ChangeDiffRequestProducer(@Nullable Project project, @NotNull Change change, @NotNull Map<Key<?>, Object> changeContext) {
        this.myChange = change;
        this.myProject = project;
        this.myChangeContext = changeContext;
    }

    @NotNull
    public Change getChange() {
        return this.myChange;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getName() {
        return this.getFilePath().getPath();
    }

    @Override
    @NotNull
    public FilePath getFilePath() {
        return ChangesUtil.getFilePath((Change)this.myChange);
    }

    @Override
    @NotNull
    public FileStatus getFileStatus() {
        return this.myChange.getFileStatus();
    }

    @Override
    @Nullable
    public Object getPopupTag() {
        return this.myChangeContext.get(TAG_KEY);
    }

    public static boolean isEquals(@NotNull Change change1, @NotNull Change change2) {
        ThreeState equals;
        if (!Comparing.equal((Object)ChangesUtil.getBeforePath((Change)change1), (Object)ChangesUtil.getBeforePath((Change)change2)) || !Comparing.equal((Object)ChangesUtil.getAfterPath((Change)change1), (Object)ChangesUtil.getAfterPath((Change)change2))) {
            return false;
        }
        for (ChangeDiffViewerWrapperProvider changeDiffViewerWrapperProvider : (ChangeDiffViewerWrapperProvider[])ChangeDiffViewerWrapperProvider.EP_NAME.getExtensions()) {
            equals = changeDiffViewerWrapperProvider.isEquals(change1, change2);
            if (equals != ThreeState.NO) continue;
            return false;
        }
        for (ChangeDiffRequestProvider changeDiffRequestProvider : (ChangeDiffRequestProvider[])ChangeDiffRequestProvider.EP_NAME.getExtensions()) {
            equals = changeDiffRequestProvider.isEquals(change1, change2);
            if (equals == ThreeState.YES) {
                return true;
            }
            if (equals != ThreeState.NO) continue;
            return false;
        }
        if (!Comparing.equal(change1.getClass(), change2.getClass())) {
            return false;
        }
        if (!Comparing.equal((Object)change1.getFileStatus(), (Object)change2.getFileStatus())) {
            return false;
        }
        if (!ChangeDiffRequestProducer.isEquals(change1.getBeforeRevision(), change2.getBeforeRevision())) {
            return false;
        }
        if (!ChangeDiffRequestProducer.isEquals(change1.getAfterRevision(), change2.getAfterRevision())) {
            return false;
        }
        if (change1 instanceof ChangeListChange || change2 instanceof ChangeListChange) {
            String changelistId2;
            assert (change1 instanceof ChangeListChange && change2 instanceof ChangeListChange);
            String changelistId1 = ((ChangeListChange)change1).getChangeListId();
            if (!Objects.equals(changelistId1, changelistId2 = ((ChangeListChange)change2).getChangeListId())) {
                return false;
            }
        }
        return true;
    }

    private static boolean isEquals(@Nullable ContentRevision revision1, @Nullable ContentRevision revision2) {
        if (Comparing.equal((Object)revision1, (Object)revision2)) {
            return true;
        }
        if (revision1 instanceof CurrentContentRevision && revision2 instanceof CurrentContentRevision) {
            VirtualFile vFile1 = ((CurrentContentRevision)revision1).getVirtualFile();
            VirtualFile vFile2 = ((CurrentContentRevision)revision2).getVirtualFile();
            return Comparing.equal((Object)vFile1, (Object)vFile2);
        }
        return false;
    }

    public static int hashCode(@NotNull Change change) {
        return ChangeDiffRequestProducer.hashCode(change.getBeforeRevision()) + 31 * ChangeDiffRequestProducer.hashCode(change.getAfterRevision());
    }

    private static int hashCode(@Nullable ContentRevision revision) {
        return revision != null ? revision.getFile().hashCode() : 0;
    }

    @Nullable
    public static ChangeDiffRequestProducer create(@Nullable Project project, @NotNull Change change) {
        return ChangeDiffRequestProducer.create(project, change, null);
    }

    @Nullable
    public static ChangeDiffRequestProducer create(@Nullable Project project, @NotNull Change change, @Nullable Map<Key<?>, Object> changeContext) {
        if (!ChangeDiffRequestProducer.canCreate(project, change)) {
            return null;
        }
        return new ChangeDiffRequestProducer(project, change, ContainerUtil.notNullize(changeContext));
    }

    public static boolean canCreate(@Nullable Project project, @NotNull Change change) {
        for (ChangeDiffViewerWrapperProvider changeDiffViewerWrapperProvider : (ChangeDiffViewerWrapperProvider[])ChangeDiffViewerWrapperProvider.EP_NAME.getExtensions()) {
            if (!changeDiffViewerWrapperProvider.canCreate(project, change)) continue;
            return true;
        }
        for (ChangeDiffRequestProvider changeDiffRequestProvider : (ChangeDiffRequestProvider[])ChangeDiffRequestProvider.EP_NAME.getExtensions()) {
            if (!changeDiffRequestProvider.canCreate(project, change)) continue;
            return true;
        }
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision aRev = change.getAfterRevision();
        if (bRev == null && aRev == null) {
            return false;
        }
        if (bRev != null && bRev.getFile().isDirectory()) {
            return false;
        }
        return aRev == null || !aRev.getFile().isDirectory();
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        try {
            return this.loadCurrentContents(context, indicator);
        }
        catch (DiffRequestProducerException | ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            throw new DiffRequestProducerException(e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private DiffRequest loadCurrentContents(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        DiffRequestProducerException wrapperException = null;
        DiffRequestProducerException requestException = null;
        DiffViewerWrapper wrapper = null;
        try {
            void var8_12;
            ChangeDiffViewerWrapperProvider[] changeDiffViewerWrapperProviderArray = (ChangeDiffViewerWrapperProvider[])ChangeDiffViewerWrapperProvider.EP_NAME.getExtensions();
            int n = changeDiffViewerWrapperProviderArray.length;
            boolean bl = false;
            while (var8_12 < n) {
                ChangeDiffViewerWrapperProvider provider = changeDiffViewerWrapperProviderArray[var8_12];
                if (provider.canCreate(this.myProject, this.myChange)) {
                    wrapper = provider.process(this, context, indicator);
                    break;
                }
                ++var8_12;
            }
        }
        catch (DiffRequestProducerException e) {
            wrapperException = e;
        }
        ErrorDiffRequest request = null;
        try {
            for (ChangeDiffRequestProvider provider : (ChangeDiffRequestProvider[])ChangeDiffRequestProvider.EP_NAME.getExtensions()) {
                if (!provider.canCreate(this.myProject, this.myChange)) continue;
                request = provider.process(this, context, indicator);
                break;
            }
            if (request == null) {
                request = this.createRequest(this.myProject, this.myChange, context, indicator);
            }
        }
        catch (DiffRequestProducerException e) {
            requestException = e;
        }
        if (requestException != null && wrapperException != null) {
            String message = requestException.getMessage() + "\n\n" + wrapperException.getMessage();
            throw new DiffRequestProducerException(message);
        }
        if (requestException != null) {
            request = new ErrorDiffRequest(ChangeDiffRequestProducer.getRequestTitle(this.myChange), (Throwable)requestException);
            LOG.info("Request: " + requestException.getMessage());
        }
        if (wrapperException != null) {
            LOG.info("Wrapper: " + wrapperException.getMessage());
        }
        request.putUserData(CHANGE_KEY, (Object)this.myChange);
        request.putUserData(DiffViewerWrapper.KEY, wrapper);
        for (Map.Entry entry : this.myChangeContext.entrySet()) {
            request.putUserData((Key)entry.getKey(), entry.getValue());
        }
        DiffUtil.putDataKey((UserDataHolder)request, (DataKey)VcsDataKeys.CURRENT_CHANGE, (Object)this.myChange);
        return request;
    }

    @NotNull
    private DiffRequest createRequest(@Nullable Project project, @NotNull Change change, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        if (ChangesUtil.isTextConflictingChange((Change)change)) {
            return ChangeDiffRequestProducer.createMergeRequest(project, change, context);
        }
        SimpleDiffRequest request = this.createSimpleRequest(project, change, context, indicator);
        LocalChangeListDiffRequest localRequest = ChangeDiffRequestProducer.createLocalChangeListRequest(project, change, (ContentDiffRequest)request);
        if (localRequest != null) {
            return localRequest;
        }
        return request;
    }

    @NotNull
    private static DiffRequest createMergeRequest(@Nullable Project project, @NotNull Change change, @NotNull UserDataHolder context) throws DiffRequestProducerException {
        FilePath path2 = ChangesUtil.getFilePath((Change)change);
        VirtualFile file = path2.getVirtualFile();
        if (file == null) {
            file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path2.getPath());
        }
        if (file == null) {
            throw new DiffRequestProducerException("Can't show merge conflict - file not found");
        }
        if (project == null) {
            throw new DiffRequestProducerException("Can't show merge conflict - project is unknown");
        }
        AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)change, (Project)project);
        if (vcs == null || vcs.getMergeProvider() == null) {
            throw new DiffRequestProducerException("Can't show merge conflict - operation not supported");
        }
        try {
            MergeData mergeData = vcs.getMergeProvider().loadRevisions(file);
            ContentRevision bRev = change.getBeforeRevision();
            ContentRevision aRev = change.getAfterRevision();
            String beforeRevisionTitle = ChangeDiffRequestProducer.getRevisionTitle(bRev, ChangeDiffRequestProducer.getYourVersion());
            String afterRevisionTitle = ChangeDiffRequestProducer.getRevisionTitle(aRev, ChangeDiffRequestProducer.getServerVersion());
            String title2 = DiffRequestFactory.getInstance().getTitle(file);
            List<String> titles = Arrays.asList(beforeRevisionTitle, ChangeDiffRequestProducer.getBaseVersion(), afterRevisionTitle);
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            List<DiffContent> contents = Arrays.asList(contentFactory.createFromBytes(project, mergeData.CURRENT, file), contentFactory.createFromBytes(project, mergeData.ORIGINAL, file), contentFactory.createFromBytes(project, mergeData.LAST, file));
            SimpleDiffRequest request = new SimpleDiffRequest(title2, contents, titles);
            MergeUtils.putRevisionInfos((DiffRequest)request, mergeData);
            return request;
        }
        catch (VcsException | IOException e) {
            LOG.info(e);
            throw new DiffRequestProducerException(e);
        }
    }

    @NotNull
    private SimpleDiffRequest createSimpleRequest(@Nullable Project project, @NotNull Change change, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision aRev = change.getAfterRevision();
        if (bRev == null && aRev == null) {
            LOG.warn("Both revision contents are empty");
            throw new DiffRequestProducerException("Bad revisions contents");
        }
        if (bRev != null) {
            ChangeDiffRequestProducer.checkContentRevision(project, bRev, context, indicator);
        }
        if (aRev != null) {
            ChangeDiffRequestProducer.checkContentRevision(project, aRev, context, indicator);
        }
        String title2 = ChangeDiffRequestProducer.getRequestTitle(change);
        indicator.setIndeterminate(true);
        DiffContent content1 = ChangeDiffRequestProducer.createContent(project, bRev, context, indicator);
        DiffContent content2 = ChangeDiffRequestProducer.createContent(project, aRev, context, indicator);
        String userLeftRevisionTitle = (String)this.myChangeContext.get(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE);
        String beforeRevisionTitle = userLeftRevisionTitle != null ? userLeftRevisionTitle : ChangeDiffRequestProducer.getRevisionTitle(bRev, ChangeDiffRequestProducer.getBaseVersion());
        String userRightRevisionTitle = (String)this.myChangeContext.get(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE);
        String afterRevisionTitle = userRightRevisionTitle != null ? userRightRevisionTitle : ChangeDiffRequestProducer.getRevisionTitle(aRev, ChangeDiffRequestProducer.getYourVersion());
        SimpleDiffRequest request = new SimpleDiffRequest(title2, content1, content2, beforeRevisionTitle, afterRevisionTitle);
        boolean bRevCurrent = bRev instanceof CurrentContentRevision;
        boolean aRevCurrent = aRev instanceof CurrentContentRevision;
        if (bRevCurrent && !aRevCurrent) {
            request.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.LEFT);
        }
        if (!bRevCurrent && aRevCurrent) {
            request.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.RIGHT);
        }
        return request;
    }

    @Nullable
    private static LocalChangeListDiffRequest createLocalChangeListRequest(@Nullable Project project, @NotNull Change change, @NotNull ContentDiffRequest request) {
        if (project == null) {
            return null;
        }
        if (!(change instanceof ChangeListChange)) {
            return null;
        }
        ChangeListChange changeListChange = (ChangeListChange)change;
        List contents = request.getContents();
        if (contents.size() != 2) {
            return null;
        }
        DocumentContent content1 = (DocumentContent)ObjectUtils.tryCast((Object)Side.LEFT.select(contents), DocumentContent.class);
        DocumentContent content2 = (DocumentContent)ObjectUtils.tryCast((Object)Side.RIGHT.select(contents), DocumentContent.class);
        if (content1 == null || content2 == null) {
            return null;
        }
        if (!(content2 instanceof FileContent)) {
            return null;
        }
        VirtualFile virtualFile = ((FileContent)content2).getFile();
        if (!LineStatusTrackerManager.getInstance(project).arePartialChangelistsEnabled(virtualFile)) {
            return null;
        }
        return new LocalChangeListDiffRequest(project, virtualFile, changeListChange.getChangeListId(), changeListChange.getChangeListName(), request);
    }

    @NotNull
    public static String getRequestTitle(@NotNull Change change) {
        FilePath bPath = ChangesUtil.getBeforePath((Change)change);
        FilePath aPath = ChangesUtil.getAfterPath((Change)change);
        return DiffRequestFactoryImpl.getTitle((FilePath)bPath, (FilePath)aPath, (String)" -> ");
    }

    @NotNull
    public static String getRevisionTitle(@Nullable ContentRevision revision, @NotNull String defaultValue) {
        if (revision == null) {
            return defaultValue;
        }
        String title2 = revision.getRevisionNumber().asString();
        return title2.isEmpty() ? defaultValue : title2;
    }

    @NotNull
    public static DiffContent createContent(@Nullable Project project, @Nullable ContentRevision revision, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        try {
            DocumentContent content2;
            indicator.checkCanceled();
            if (revision == null) {
                return DiffContentFactory.getInstance().createEmpty();
            }
            FilePath filePath = revision.getFile();
            DiffContentFactoryEx contentFactory = DiffContentFactoryEx.getInstanceEx();
            if (revision instanceof CurrentContentRevision) {
                VirtualFile vFile = ((CurrentContentRevision)revision).getVirtualFile();
                if (vFile == null || !vFile.isValid()) {
                    throw new DiffRequestProducerException("Can't get current revision content");
                }
                return contentFactory.create(project, vFile);
            }
            if (revision instanceof ByteBackedContentRevision) {
                byte[] revisionContent = ((ByteBackedContentRevision)revision).getContentAsBytes();
                if (revisionContent == null) {
                    throw new DiffRequestProducerException("Can't get revision content");
                }
                content2 = contentFactory.createFromBytes(project, revisionContent, filePath);
            } else {
                String revisionContent = revision.getContent();
                if (revisionContent == null) {
                    throw new DiffRequestProducerException("Can't get revision content");
                }
                content2 = contentFactory.create(project, revisionContent, filePath);
            }
            content2.putUserData(DiffVcsDataKeys.REVISION_INFO, (Object)Pair.create((Object)revision.getFile(), (Object)revision.getRevisionNumber()));
            return content2;
        }
        catch (VcsException | IOException e) {
            LOG.info(e);
            throw new DiffRequestProducerException(e);
        }
    }

    public static void checkContentRevision(@Nullable Project project, @NotNull ContentRevision rev, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        if (rev.getFile().isDirectory()) {
            throw new DiffRequestProducerException("Can't show diff for directory");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeDiffRequestProducer producer = (ChangeDiffRequestProducer)o;
        return ChangeDiffRequestProducer.isEquals(producer.myChange, this.myChange);
    }

    public int hashCode() {
        return ChangeDiffRequestProducer.hashCode(this.myChange);
    }

    public static String getYourVersion() {
        return DiffBundle.message((String)"merge.version.title.our", (Object[])new Object[0]);
    }

    public static String getServerVersion() {
        return DiffBundle.message((String)"merge.version.title.their", (Object[])new Object[0]);
    }

    public static String getBaseVersion() {
        return DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]);
    }

    public static String getMergedVersion() {
        return DiffBundle.message((String)"merge.version.title.merged", (Object[])new Object[0]);
    }
}

