/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsDirtyScopeMap {
    private final Map<AbstractVcs, Set<FilePath>> myMap = new HashMap<AbstractVcs, Set<FilePath>>();

    @NotNull
    public Map<AbstractVcs, Set<FilePath>> asMap() {
        return this.myMap;
    }

    public void add(@NotNull AbstractVcs vcs, @NotNull FilePath filePath) {
        Set<FilePath> set = this.getVcsPathsSet(vcs);
        set.add(filePath);
    }

    public void addAll(@NotNull VcsDirtyScopeMap map2) {
        for (Map.Entry<AbstractVcs, Set<FilePath>> entry : map2.myMap.entrySet()) {
            Set<FilePath> set = this.getVcsPathsSet(entry.getKey());
            set.addAll((Collection<FilePath>)entry.getValue());
        }
    }

    @NotNull
    private Set<FilePath> getVcsPathsSet(@NotNull AbstractVcs vcs) {
        return this.myMap.computeIfAbsent(vcs, key -> new THashSet(VcsDirtyScopeManagerImpl.getDirtyScopeHashingStrategy(key)));
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public void clear() {
        this.myMap.clear();
    }
}

