/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListsIndexes;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.ui.ChangeListDeltaListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListWorker {
    private static final Logger LOG = Logger.getInstance(ChangeListWorker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final DelayedNotificator myDelayedNotificator;
    private final boolean myMainWorker;
    private final Set<ListData> myLists = new HashSet<ListData>();
    private ListData myDefault;
    private final Map<Change, ListData> myChangeMappings = new HashMap<Change, ListData>();
    private final Map<FilePath, PartialChangeTracker> myPartialChangeTrackers = new HashMap<FilePath, PartialChangeTracker>();
    private final ChangeListsIndexes myIdx;
    @Nullable
    private Map<ListData, Set<Change>> myReadOnlyChangesCache = null;
    private final AtomicBoolean myReadOnlyChangesCacheInvalidated = new AtomicBoolean(false);

    public ChangeListWorker(@NotNull Project project, @NotNull DelayedNotificator delayedNotificator) {
        this.myProject = project;
        this.myDelayedNotificator = delayedNotificator;
        this.myMainWorker = true;
        this.myIdx = new ChangeListsIndexes();
        this.ensureDefaultListExists();
    }

    private ChangeListWorker(@NotNull ChangeListWorker worker) {
        this.myProject = worker.myProject;
        this.myDelayedNotificator = worker.myDelayedNotificator;
        this.myMainWorker = false;
        this.myIdx = new ChangeListsIndexes(worker.myIdx);
        Map<ListData, ListData> listMapping = this.copyListsDataFrom(worker.myLists);
        worker.myChangeMappings.forEach((change, oldList) -> {
            ListData newList = this.notNullList((ListData)listMapping.get(oldList));
            this.myChangeMappings.put((Change)change, newList);
        });
        for (Map.Entry<FilePath, PartialChangeTracker> entry : worker.myPartialChangeTrackers.entrySet()) {
            this.myPartialChangeTrackers.put(entry.getKey(), new PartialChangeTrackerDump(entry.getValue(), this.myDefault));
        }
    }

    @NotNull
    private Map<ListData, ListData> copyListsDataFrom(@NotNull Collection<? extends ListData> lists) {
        ListData oldDefault = this.myDefault;
        List oldIds = ContainerUtil.map(this.myLists, list -> list.id);
        this.myLists.clear();
        this.myDefault = null;
        HashMap<ListData, ListData> listMapping = new HashMap<ListData, ListData>();
        for (ListData listData : lists) {
            ListData newList = new ListData(listData);
            if (newList.isDefault && this.myDefault != null) {
                LOG.error("multiple default lists found when copy");
                newList.isDefault = false;
            }
            newList = this.putNewListData(newList);
            if (newList.isDefault) {
                this.myDefault = newList;
            }
            listMapping.put(listData, newList);
        }
        this.ensureDefaultListExists();
        if (this.myMainWorker) {
            if (!oldDefault.id.equals(this.myDefault.id)) {
                this.fireDefaultListChanged(oldDefault.id, this.myDefault.id);
            }
            HashSet removedListIds = new HashSet(oldIds);
            for (ListData list2 : this.myLists) {
                removedListIds.remove(list2.id);
            }
            for (String listId : removedListIds) {
                this.fireChangeListRemoved(listId);
            }
        }
        this.myReadOnlyChangesCache = null;
        return listMapping;
    }

    private void ensureDefaultListExists() {
        if (this.myDefault != null) {
            return;
        }
        if (this.myLists.isEmpty()) {
            this.putNewListData(new ListData(null, LocalChangeList.getDefaultName()));
        }
        this.myDefault = this.myLists.iterator().next();
        this.myDefault.isDefault = true;
    }

    public ChangeListWorker copy() {
        return new ChangeListWorker(this);
    }

    public void registerChangeTracker(@NotNull FilePath filePath, @NotNull PartialChangeTracker tracker) {
        if (this.myPartialChangeTrackers.containsKey(filePath)) {
            LOG.error(String.format("Attempt to register duplicate trackers: %s; old: %s; new: %s", filePath, this.myPartialChangeTrackers.get(filePath), tracker));
            return;
        }
        this.myPartialChangeTrackers.put(filePath, tracker);
        ListData oldList = null;
        Change change = this.getChangeForAfterPath(filePath);
        if (change != null) {
            oldList = this.removeChangeMapping(change);
        }
        tracker.initChangeTracking(this.myDefault.id, ContainerUtil.map(this.myLists, list -> list.id), oldList != null ? oldList.id : null);
        List<String> oldIds = oldList != null ? Collections.singletonList(oldList.id) : Collections.emptyList();
        this.notifyChangelistsChanged(filePath, oldIds, tracker.getAffectedChangeListsIds());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[registerChangeTracker] path: %s, old list: %s", filePath, oldList != null ? oldList.id : "null"));
        }
    }

    public void unregisterChangeTracker(@NotNull FilePath filePath, @NotNull PartialChangeTracker tracker) {
        boolean trackerRemoved = this.myPartialChangeTrackers.remove(filePath, tracker);
        if (trackerRemoved) {
            ListData newList = null;
            Change change = this.getChangeForAfterPath(filePath);
            if (change != null) {
                newList = this.getMainList(tracker);
                this.putChangeMapping(change, newList);
            }
            List<String> newIds = newList != null ? Collections.singletonList(newList.id) : Collections.emptyList();
            this.notifyChangelistsChanged(filePath, tracker.getAffectedChangeListsIds(), newIds);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("[unregisterChangeTracker] path: %s, new list: %s, tracker lists: %s", filePath, newList != null ? newList.id : "null", tracker.getAffectedChangeListsIds()));
            }
        } else {
            Map.Entry entry = (Map.Entry)ContainerUtil.find(this.myPartialChangeTrackers.entrySet(), it -> Comparing.equal(it.getValue(), (Object)tracker));
            if (entry != null) {
                LOG.error(String.format("Unregistered tracker with wrong path: tracker: %s", tracker));
                FilePath actualFilePath = (FilePath)entry.getKey();
                this.unregisterChangeTracker(actualFilePath, tracker);
            } else {
                LOG.error(String.format("Tracker is not registered: tracker: %s", tracker));
            }
        }
    }

    @NotNull
    private ListData getMainList(@NotNull PartialChangeTracker tracker) {
        ListData list;
        List<String> changelistIds = tracker.getAffectedChangeListsIds();
        if (changelistIds.size() == 1 && (list = this.getDataByIdVerify(changelistIds.get(0))) != null) {
            return list;
        }
        return this.myDefault;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public LocalChangeList getDefaultList() {
        return this.toChangeList(this.myDefault);
    }

    @Nullable
    public LocalChangeList getChangeListByName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return this.toChangeList(this.getDataByName(name));
    }

    @Nullable
    public LocalChangeList getChangeListById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return this.toChangeList(this.getDataById(id));
    }

    @NotNull
    public List<LocalChangeList> getChangeLists() {
        List lists = ContainerUtil.map(this.myLists, this::toChangeList);
        ContainerUtil.sort((List)lists, (Comparator)ChangesUtil.CHANGELIST_COMPARATOR);
        return lists;
    }

    public int getChangeListsNumber() {
        return this.myLists.size();
    }

    @Nullable
    public Change getChangeForPath(@Nullable FilePath filePath) {
        if (filePath == null) {
            return null;
        }
        for (Change change : this.myIdx.getChanges()) {
            ContentRevision before = change.getBeforeRevision();
            ContentRevision after = change.getAfterRevision();
            if ((before == null || !before.getFile().equals(filePath)) && (after == null || !after.getFile().equals(filePath))) continue;
            return change;
        }
        return null;
    }

    @Nullable
    private Change getChangeForAfterPath(@Nullable FilePath filePath) {
        if (filePath == null) {
            return null;
        }
        for (Change change : this.myIdx.getChanges()) {
            ContentRevision after = change.getAfterRevision();
            if (after == null || !after.getFile().equals(filePath)) continue;
            return change;
        }
        return null;
    }

    @NotNull
    public Collection<Change> getAllChanges() {
        return new ArrayList<Change>(this.myIdx.getChanges());
    }

    @NotNull
    public List<LocalChangeList> getAffectedLists(@NotNull Collection<? extends Change> changes) {
        return ContainerUtil.map(this.getAffectedListsData(changes), this::toChangeList);
    }

    @NotNull
    public List<LocalChangeList> getAffectedLists(@NotNull Change change) {
        return this.getAffectedLists(Collections.singletonList(change));
    }

    @NotNull
    private List<ListData> getAffectedListsData(@NotNull Collection<? extends Change> changes) {
        HashSet<ListData> result2 = new HashSet<ListData>();
        for (Change change : changes) {
            ListData list = this.myChangeMappings.get(change);
            if (list != null) {
                result2.add(list);
                continue;
            }
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker == null) continue;
            HashSet<ListData> affectedLists = this.getAffectedLists(tracker);
            if (change instanceof ChangeListChange) {
                String changeListId = ((ChangeListChange)change).getChangeListId();
                ContainerUtil.addIfNotNull(result2, (Object)ContainerUtil.find(affectedLists, partialList -> partialList.id.equals(changeListId)));
                continue;
            }
            result2.addAll(affectedLists);
        }
        return new ArrayList<ListData>(result2);
    }

    @NotNull
    private List<Change> getChangesIn(@NotNull ListData data) {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Change change : this.myIdx.getChanges()) {
            ListData list = this.myChangeMappings.get(change);
            if (list != null) {
                if (list != data) continue;
                changes.add(change);
                continue;
            }
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker == null || !tracker.getAffectedChangeListsIds().contains(data.id)) continue;
            changes.add(change);
        }
        return changes;
    }

    @NotNull
    private Map<ListData, Set<Change>> getChangesMapping() {
        HashMap<ListData, Set<Change>> map2 = new HashMap<ListData, Set<Change>>();
        for (Change change : this.myIdx.getChanges()) {
            ListData list = this.myChangeMappings.get(change);
            if (list != null) {
                Set listChanges = map2.computeIfAbsent(list, key -> new HashSet());
                AbstractVcs vcs = this.myIdx.getVcsFor(change);
                if (vcs != null && vcs.arePartialChangelistsSupported()) {
                    listChanges.add(ChangeListWorker.toChangeListChange(change, list));
                    continue;
                }
                listChanges.add(change);
                continue;
            }
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker == null) continue;
            HashSet<ListData> lists = this.getAffectedLists(tracker);
            for (ListData partialList : lists) {
                Set listChanges = map2.computeIfAbsent(partialList, key -> new HashSet());
                listChanges.add(ChangeListWorker.toChangeListChange(change, partialList));
            }
        }
        return map2;
    }

    @NotNull
    public List<File> getAffectedPaths() {
        return ContainerUtil.map(this.myIdx.getAffectedPaths(), FilePath::getIOFile);
    }

    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        return ContainerUtil.mapNotNull(this.myIdx.getAffectedPaths(), FilePath::getVirtualFile);
    }

    public ThreeState haveChangesUnder(@NotNull VirtualFile virtualFile) {
        FilePath dir = VcsUtil.getFilePath((VirtualFile)virtualFile);
        return this.myIdx.haveChangesUnder(dir);
    }

    @Nullable
    public AbstractVcs getVcsFor(@NotNull Change change) {
        return this.myIdx.getVcsFor(change);
    }

    @Nullable
    public FileStatus getStatus(@NotNull VirtualFile file) {
        return this.myIdx.getStatus(file);
    }

    @Nullable
    public FileStatus getStatus(@NotNull FilePath file) {
        return this.myIdx.getStatus(file);
    }

    public boolean setDefaultList(@NotNull String name) {
        ListData newDefault = this.getDataByName(name);
        if (newDefault == null || newDefault.isDefault) {
            return false;
        }
        ListData oldDefault = this.myDefault;
        this.myDefault.isDefault = false;
        newDefault.isDefault = true;
        this.myDefault = newDefault;
        this.fireDefaultListChanged(oldDefault.id, newDefault.id);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[setDefaultList %s] name: %s id: %s", this.myMainWorker ? "" : "- updater", name, newDefault.id));
        }
        return true;
    }

    public boolean setReadOnly(@NotNull String name, boolean value) {
        ListData list = this.getDataByName(name);
        if (list == null) {
            return false;
        }
        list.isReadOnly = value;
        return true;
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        if (fromName.equals(toName)) {
            return false;
        }
        if (this.getDataByName(toName) != null) {
            return false;
        }
        ListData list = this.getDataByName(fromName);
        if (list == null || list.isReadOnly) {
            return false;
        }
        list.name = toName;
        return true;
    }

    @Nullable
    public String editComment(@NotNull String name, @NotNull String newComment) {
        ListData list = this.getDataByName(name);
        if (list == null) {
            return null;
        }
        String oldComment = list.comment;
        if (!Objects.equals(oldComment, newComment)) {
            list.comment = newComment;
        }
        return oldComment;
    }

    public boolean editData(@NotNull String name, @Nullable ChangeListData newData) {
        ListData list = this.getDataByName(name);
        if (list == null) {
            return false;
        }
        list.data = newData;
        return true;
    }

    @NotNull
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String description, @Nullable String id, @Nullable ChangeListData data) {
        LocalChangeList existingList = this.getChangeListByName(name);
        if (existingList != null) {
            LOG.error("Attempt to create duplicate changelist " + name);
            return existingList;
        }
        ListData list = new ListData(id, name);
        list.comment = StringUtil.notNullize((String)description);
        list.data = data;
        list = this.putNewListData(list);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[addChangeList %s] name: %s id: %s", this.myMainWorker ? "" : "- updater", name, list.id));
        }
        return this.toChangeList(list);
    }

    public boolean removeChangeList(@NotNull String name) {
        ListData removedList = this.getDataByName(name);
        if (removedList == null) {
            return false;
        }
        if (removedList.isDefault) {
            LOG.error("Cannot remove default changelist");
            return false;
        }
        ArrayList<Change> movedChanges = new ArrayList<Change>();
        this.myChangeMappings.replaceAll((change, list) -> {
            if (list == removedList) {
                movedChanges.add((Change)change);
                return this.myDefault;
            }
            return list;
        });
        this.fireChangeListRemoved(removedList.id);
        this.myReadOnlyChangesCache = null;
        if (this.myMainWorker && !movedChanges.isEmpty()) {
            this.myDelayedNotificator.changesMoved(movedChanges, (ChangeList)this.toChangeList(removedList), (ChangeList)this.toChangeList(this.myDefault));
        }
        this.myLists.remove(removedList);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[removeChangeList %s] name: %s id: %s", this.myMainWorker ? "" : "- updater", name, removedList.id));
        }
        return true;
    }

    @Nullable
    public MultiMap<LocalChangeList, Change> moveChangesTo(@NotNull String name, @NotNull List<? extends Change> changes) {
        ListData targetList = this.getDataByName(name);
        if (targetList == null) {
            return null;
        }
        MultiMap result2 = new MultiMap();
        for (Change change : changes) {
            ListData list = this.myChangeMappings.get(change);
            if (list != null) {
                if (list == targetList) continue;
                this.myChangeMappings.replace(change, targetList);
                result2.putValue((Object)list, (Object)change);
                continue;
            }
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker == null) continue;
            if (change instanceof ChangeListChange) {
                String fromListId = ((ChangeListChange)change).getChangeListId();
                ListData fromList = this.getDataById(fromListId);
                if (fromList == null || fromList == targetList) continue;
                tracker.moveChanges(fromList.id, targetList.id);
                result2.putValue((Object)fromList, (Object)change);
                continue;
            }
            HashSet<ListData> fromLists = this.getAffectedLists(tracker);
            fromLists.remove(targetList);
            if (fromLists.isEmpty()) continue;
            tracker.moveChangesTo(targetList.id);
            for (ListData fromList : fromLists) {
                result2.putValue((Object)fromList, (Object)change);
            }
        }
        this.myReadOnlyChangesCache = null;
        MultiMap notifications = new MultiMap();
        for (Map.Entry entry : result2.entrySet()) {
            notifications.put((Object)this.toChangeList((ListData)entry.getKey()), (Collection)entry.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[moveChangesTo %s] name: %s id: %s, changes: %s", this.myMainWorker ? "" : "- updater", targetList.name, targetList.id, changes));
        }
        return notifications;
    }

    public void notifyChangelistsChanged(@NotNull FilePath path2, @NotNull List<String> beforeChangeListsIds, @NotNull List<String> afterChangeListsIds) {
        this.myReadOnlyChangesCacheInvalidated.set(true);
        HashSet<String> removed = new HashSet<String>(beforeChangeListsIds);
        removed.removeAll(afterChangeListsIds);
        HashSet<String> added = new HashSet<String>(afterChangeListsIds);
        added.removeAll(beforeChangeListsIds);
        if (!removed.isEmpty() || !added.isEmpty()) {
            this.myDelayedNotificator.changeListsForFileChanged(path2, removed, added);
        }
    }

    public void applyChangesFromUpdate(@NotNull ChangeListWorker updatedWorker, @NotNull ChangeListDeltaListener deltaListener) {
        HashMap<Change, ListData> oldChangeMappings = new HashMap<Change, ListData>(this.myChangeMappings);
        ChangeListWorker.notifyPathsChanged(this.myIdx, updatedWorker.myIdx, deltaListener);
        this.myIdx.copyFrom(updatedWorker.myIdx);
        this.myChangeMappings.clear();
        Map<ListData, ListData> listMapping = this.copyListsDataFrom(updatedWorker.myLists);
        for (Change change : this.myIdx.getChanges()) {
            ListData oldMappedList;
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker != null) continue;
            ListData oldList = updatedWorker.myChangeMappings.get(change);
            ListData newList = null;
            if (oldList == null) {
                if (updatedWorker.getChangeTrackerFor(change) == null) {
                    LOG.error("Change mapping not found");
                }
            } else {
                newList = listMapping.get(oldList);
                if (newList == null) {
                    LOG.error("List mapping not found");
                }
            }
            if (newList == null && (oldMappedList = oldChangeMappings.get(change)) != null) {
                newList = this.getDataById(oldMappedList.id);
            }
            if (newList == null) {
                newList = this.myDefault;
            }
            this.myChangeMappings.put(change, newList);
        }
        if (this.myMainWorker) {
            this.myDelayedNotificator.allChangeListsMappingsChanged();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[applyChangesFromUpdate] %s", this));
        }
    }

    private static void notifyPathsChanged(@NotNull ChangeListsIndexes was, @NotNull ChangeListsIndexes became, @NotNull ChangeListDeltaListener deltaListener) {
        HashSet toRemove = new HashSet();
        HashSet toAdd = new HashSet();
        HashSet toModify = new HashSet();
        was.getDelta(became, toRemove, toAdd, toModify);
        for (BaseRevision pair : toRemove) {
            deltaListener.removed(pair);
        }
        for (BaseRevision pair : toAdd) {
            deltaListener.added(pair);
        }
        for (BeforeAfter beforeAfter : toModify) {
            deltaListener.modified((BaseRevision)beforeAfter.getBefore(), (BaseRevision)beforeAfter.getAfter());
        }
    }

    void setChangeLists(@NotNull Collection<? extends LocalChangeListImpl> lists) {
        this.myIdx.clear();
        this.myChangeMappings.clear();
        this.copyListsDataFrom(ContainerUtil.map(lists, ListData::new));
        for (LocalChangeListImpl localChangeListImpl : lists) {
            ListData listData = this.notNullList(this.getDataByIdVerify(localChangeListImpl.getId()));
            for (Change change : localChangeListImpl.getChanges()) {
                if (this.myIdx.getChanges().contains(change)) continue;
                this.myIdx.changeAdded(change, null);
                PartialChangeTracker tracker = this.getChangeTrackerFor(change);
                if (tracker != null) continue;
                this.myChangeMappings.put(change, listData);
            }
        }
        if (this.myMainWorker) {
            this.myDelayedNotificator.allChangeListsMappingsChanged();
        }
    }

    private void fireDefaultListChanged(@NotNull String oldDefaultId, @NotNull String newDefaultId) {
        for (PartialChangeTracker tracker : this.myPartialChangeTrackers.values()) {
            tracker.defaultListChanged(oldDefaultId, newDefaultId);
        }
    }

    private void fireChangeListRemoved(@NotNull String listId) {
        for (PartialChangeTracker tracker : this.myPartialChangeTrackers.values()) {
            tracker.changeListRemoved(listId);
        }
    }

    @Nullable
    private ListData removeChangeMapping(@NotNull Change change) {
        ListData oldList = this.myChangeMappings.remove(change);
        this.myReadOnlyChangesCache = null;
        return oldList;
    }

    private void putChangeMapping(@NotNull Change change, @NotNull ListData list) {
        this.myChangeMappings.put(change, list);
        this.myReadOnlyChangesCache = null;
    }

    @NotNull
    private ListData putNewListData(@NotNull ListData list) {
        ListData listWithSameName = this.getDataByName(list.name);
        if (listWithSameName != null) {
            LOG.error(String.format("Attempt to create changelist with same name: %s - %s", list.name, list.id));
            return listWithSameName;
        }
        ListData listWithSameId = this.getDataById(list.id);
        if (listWithSameId != null) {
            LOG.error(String.format("Attempt to create changelist with same id: %s - %s", list.name, list.id));
            return listWithSameId;
        }
        this.myLists.add(list);
        return list;
    }

    @NotNull
    private ListData notNullList(@Nullable ListData listData) {
        if (listData == null) {
            LOG.error("ListData not found");
        }
        return (ListData)ObjectUtils.notNull((Object)listData, (Object)this.myDefault);
    }

    @Nullable
    private ListData getDataById(@NotNull String id) {
        return (ListData)ContainerUtil.find(this.myLists, list -> list.id.equals(id));
    }

    @Nullable
    private ListData getDataByName(@NotNull String name) {
        return (ListData)ContainerUtil.find(this.myLists, list -> list.name.equals(name));
    }

    @Nullable
    private ListData getDataByIdVerify(@NotNull String id) {
        ListData list = this.getDataById(id);
        if (this.myMainWorker && list == null) {
            LOG.error(String.format("Unknown changelist %s", id));
        }
        return list;
    }

    @Nullable
    private PartialChangeTracker getChangeTrackerFor(@NotNull Change change) {
        if (this.myPartialChangeTrackers.isEmpty()) {
            return null;
        }
        if (!this.myIdx.getChanges().contains(change)) {
            return null;
        }
        ContentRevision revision = change.getAfterRevision();
        if (revision == null) {
            return null;
        }
        return this.myPartialChangeTrackers.get(revision.getFile());
    }

    @NotNull
    private HashSet<ListData> getAffectedLists(@NotNull PartialChangeTracker tracker) {
        HashSet<ListData> data = new HashSet<ListData>();
        for (String listId : tracker.getAffectedChangeListsIds()) {
            ListData partialList = this.getDataById(listId);
            if (this.myMainWorker && partialList == null) {
                LOG.error(String.format("Unknown changelist %s", listId));
                tracker.initChangeTracking(this.myDefault.id, ContainerUtil.map(this.myLists, list -> list.id), null);
            }
            data.add(partialList != null ? partialList : this.myDefault);
        }
        return data;
    }

    @Contract(value="!null -> !null; null -> null")
    private LocalChangeListImpl toChangeList(@Nullable ListData data) {
        Set<Change> cachedChanges;
        if (data == null) {
            return null;
        }
        if (this.myReadOnlyChangesCache == null || this.myReadOnlyChangesCacheInvalidated.get()) {
            this.myReadOnlyChangesCacheInvalidated.set(false);
            this.myReadOnlyChangesCache = this.getChangesMapping();
        }
        Set<Change> changes = (cachedChanges = this.myReadOnlyChangesCache.get(data)) != null ? Collections.unmodifiableSet(cachedChanges) : Collections.emptySet();
        return new LocalChangeListImpl.Builder(this.myProject, data.name).setId(data.id).setComment(data.comment).setChangesCollection(changes).setData(data.data).setDefault(data.isDefault).setReadOnly(data.isReadOnly).build();
    }

    @NotNull
    private static Change toChangeListChange(@NotNull Change change, @NotNull ListData list) {
        if (change.getClass() == Change.class) {
            return new ChangeListChange(change, list.name, list.id);
        }
        return change;
    }

    public String toString() {
        String lists = StringUtil.join(this.myLists, list -> String.format("list: %s (%s) changes: %s", list.name, list.id, StringUtil.join(this.getChangesIn((ListData)list), (String)", ")), (String)"\n");
        String trackers2 = StringUtil.join(this.myPartialChangeTrackers.entrySet(), entry -> entry.getKey() + " " + ((PartialChangeTracker)entry.getValue()).getAffectedChangeListsIds(), (String)",");
        return String.format("ChangeListWorker{ default = %s, lists = {\n%s }\ntrackers = %s\n}", this.myDefault.id, lists, trackers2);
    }

    public static interface PartialChangeTracker {
        @NotNull
        public List<String> getAffectedChangeListsIds();

        public void initChangeTracking(@NotNull String var1, @NotNull List<String> var2, @Nullable String var3);

        public void defaultListChanged(@NotNull String var1, @NotNull String var2);

        public void changeListRemoved(@NotNull String var1);

        public void moveChanges(@NotNull String var1, @NotNull String var2);

        public void moveChangesTo(@NotNull String var1);
    }

    private static class PartialChangeTrackerDump
    implements PartialChangeTracker {
        @NotNull
        private final Set<String> myChangeListsIds;
        @NotNull
        private String myDefaultId;

        PartialChangeTrackerDump(@NotNull PartialChangeTracker tracker, @NotNull ListData defaultList) {
            this.myChangeListsIds = new HashSet<String>(tracker.getAffectedChangeListsIds());
            this.myDefaultId = defaultList.id;
        }

        @Override
        @NotNull
        public List<String> getAffectedChangeListsIds() {
            return new ArrayList<String>(this.myChangeListsIds);
        }

        @Override
        public void initChangeTracking(@NotNull String defaultId, @NotNull List<String> changelistsId, @Nullable String fileChangelistIds) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void defaultListChanged(@NotNull String oldListId, @NotNull String newListId) {
            this.myDefaultId = newListId;
        }

        @Override
        public void changeListRemoved(@NotNull String listId) {
            this.myChangeListsIds.remove(listId);
            if (this.myChangeListsIds.isEmpty()) {
                this.myChangeListsIds.add(this.myDefaultId);
            }
        }

        @Override
        public void moveChanges(@NotNull String fromListId, @NotNull String toListId) {
            if (this.myChangeListsIds.remove(fromListId)) {
                this.myChangeListsIds.add(toListId);
            }
        }

        @Override
        public void moveChangesTo(@NotNull String toListId) {
            this.myChangeListsIds.clear();
            this.myChangeListsIds.add(toListId);
        }
    }

    public static class ChangeListUpdater
    implements ChangeListManagerGate {
        private final ChangeListWorker myWorker;
        private final Map<String, OpenTHashSet<Change>> myChangesBeforeUpdateMap = FactoryMap.create(it -> new OpenTHashSet());
        private static final String CONFLICT_CHANGELIST_ID = "";
        private final Map<FilePath, String> myListsForPathsBeforeUpdate = new HashMap<FilePath, String>();
        private final Set<String> myListsToDisappear = new HashSet<String>();
        private final Comparator<Change> CHANGES_AFTER_REVISION_COMPARATOR = (o1, o2) -> {
            String s1 = o1.getAfterRevision().getFile().getPresentableUrl();
            String s2 = o2.getAfterRevision().getFile().getPresentableUrl();
            return SystemInfo.isFileSystemCaseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
        };

        public ChangeListUpdater(@NotNull ChangeListWorker worker) {
            this.myWorker = worker.copy();
        }

        @NotNull
        public Project getProject() {
            return this.myWorker.getProject();
        }

        public void notifyStartProcessingChanges(@Nullable VcsModifiableDirtyScope scope2) {
            this.myWorker.myChangeMappings.forEach((change, list) -> {
                this.putPathBeforeUpdate(ChangesUtil.getBeforePath((Change)change), list.id);
                this.putPathBeforeUpdate(ChangesUtil.getAfterPath((Change)change), list.id);
                OpenTHashSet<Change> changes = this.myChangesBeforeUpdateMap.get(list.id);
                changes.add(change);
            });
            List<Change> removedChanges = this.removeChangesUnderScope(scope2);
            if (scope2 != null) {
                for (Change change2 : removedChanges) {
                    if (!change2.isMoved() && !change2.isRenamed()) continue;
                    scope2.addDirtyFile(change2.getBeforeRevision().getFile());
                    scope2.addDirtyFile(change2.getAfterRevision().getFile());
                }
            }
        }

        private void putPathBeforeUpdate(@Nullable FilePath path2, @NotNull String listId) {
            if (path2 == null) {
                return;
            }
            String oldListId = this.myListsForPathsBeforeUpdate.get(path2);
            if (CONFLICT_CHANGELIST_ID.equals(oldListId) || listId.equals(oldListId)) {
                return;
            }
            if (oldListId == null) {
                this.myListsForPathsBeforeUpdate.put(path2, listId);
            } else {
                this.myListsForPathsBeforeUpdate.put(path2, CONFLICT_CHANGELIST_ID);
            }
        }

        @Nullable
        private String guessChangeListByPaths(@NotNull Change change) {
            FilePath bPath = ChangesUtil.getBeforePath((Change)change);
            FilePath aPath = ChangesUtil.getAfterPath((Change)change);
            String bListId = this.myListsForPathsBeforeUpdate.get(bPath);
            String aListId = this.myListsForPathsBeforeUpdate.get(aPath);
            if (CONFLICT_CHANGELIST_ID.equals(bListId) || CONFLICT_CHANGELIST_ID.equals(aListId)) {
                return null;
            }
            if (bListId == null && aListId == null) {
                return null;
            }
            if (bListId == null) {
                return aListId;
            }
            if (aListId == null) {
                return bListId;
            }
            return bListId.equals(aListId) ? bListId : null;
        }

        @NotNull
        private List<Change> removeChangesUnderScope(@Nullable VcsModifiableDirtyScope scope2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Process scope: %s", scope2));
            }
            ArrayList<Change> removed = new ArrayList<Change>();
            for (Change change : this.myWorker.myIdx.getChanges()) {
                boolean isUnderScope;
                ContentRevision before = change.getBeforeRevision();
                ContentRevision after = change.getAfterRevision();
                boolean bl = isUnderScope = scope2 == null || before != null && scope2.belongsTo(before.getFile()) || after != null && scope2.belongsTo(after.getFile()) || ChangeListUpdater.isIgnoredChange(before, after, this.getProject());
                if (isUnderScope) {
                    removed.add(change);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(String.format("under scope - %s, change - %s", isUnderScope, change));
            }
            for (Change change : removed) {
                this.myWorker.myIdx.changeRemoved(change);
                this.myWorker.removeChangeMapping(change);
            }
            return removed;
        }

        private static boolean isIgnoredChange(@Nullable ContentRevision before, @Nullable ContentRevision after, @NotNull Project project) {
            return ChangeListUpdater.isIgnoredRevision(before, project) && ChangeListUpdater.isIgnoredRevision(after, project);
        }

        private static boolean isIgnoredRevision(@Nullable ContentRevision revision, @NotNull Project project) {
            if (revision == null) {
                return true;
            }
            return (Boolean)ReadAction.compute(() -> {
                if (project.isDisposed()) {
                    return false;
                }
                return ProjectLevelVcsManager.getInstance((Project)project).isIgnored(revision.getFile());
            });
        }

        public void notifyDoneProcessingChanges(@NotNull DelayedNotificator dispatcher) {
            ArrayList<LocalChangeListImpl> changedLists = new ArrayList<LocalChangeListImpl>();
            HashMap<LocalChangeListImpl, List> removedChanges = new HashMap<LocalChangeListImpl, List>();
            HashMap<LocalChangeListImpl, List> addedChanges = new HashMap<LocalChangeListImpl, List>();
            for (ListData listData : this.myWorker.myLists) {
                ArrayList removed = new ArrayList();
                ArrayList added = new ArrayList();
                this.doneProcessingChanges(listData, removed, added);
                LocalChangeListImpl changeList2 = this.myWorker.toChangeList(listData);
                if (!removed.isEmpty() || !added.isEmpty()) {
                    changedLists.add(changeList2);
                }
                if (!removed.isEmpty()) {
                    removedChanges.put(changeList2, removed);
                }
                if (added.isEmpty()) continue;
                addedChanges.put(changeList2, added);
            }
            removedChanges.forEach((changeList, changes) -> dispatcher.changesRemoved((Collection<Change>)changes, (ChangeList)changeList));
            addedChanges.forEach((changeList, changes) -> dispatcher.changesAdded((Collection<Change>)changes, (ChangeList)changeList));
            for (ChangeList changeList2 : changedLists) {
                dispatcher.changeListChanged(changeList2);
            }
            for (String string : this.myListsToDisappear) {
                ListData list = this.myWorker.getDataByName(string);
                if (list == null || !this.myWorker.getChangesIn(list).isEmpty() || list.isReadOnly || list.isDefault) continue;
                this.myWorker.removeChangeList(string);
            }
            this.myListsToDisappear.clear();
            this.myChangesBeforeUpdateMap.clear();
            this.myListsForPathsBeforeUpdate.clear();
        }

        private void doneProcessingChanges(@NotNull ListData list, @NotNull List<? super Change> removedChanges, @NotNull List<? super Change> addedChanges) {
            OpenTHashSet<Change> changesBeforeUpdate = this.myChangesBeforeUpdateMap.get(list.id);
            HashSet listChanges = new HashSet(this.myWorker.getChangesIn(list));
            for (Change newChange : listChanges) {
                Change oldChange = ChangeListUpdater.findOldChange(changesBeforeUpdate, newChange);
                if (oldChange != null) continue;
                addedChanges.add((Change)newChange);
            }
            removedChanges.addAll((Collection<? super Change>)changesBeforeUpdate);
            removedChanges.removeAll(listChanges);
        }

        @Nullable
        private static Change findOldChange(@NotNull OpenTHashSet<Change> changesBeforeUpdate, @NotNull Change newChange) {
            Change oldChange = (Change)changesBeforeUpdate.get((Object)newChange);
            if (oldChange != null && ChangeListUpdater.sameBeforeRevision(oldChange, newChange) && newChange.getFileStatus().equals(oldChange.getFileStatus())) {
                return oldChange;
            }
            return null;
        }

        private static boolean sameBeforeRevision(@NotNull Change change1, @NotNull Change change2) {
            ContentRevision b1 = change1.getBeforeRevision();
            ContentRevision b2 = change2.getBeforeRevision();
            if (b1 != null && b2 != null) {
                VcsRevisionNumber rn1 = b1.getRevisionNumber();
                VcsRevisionNumber rn2 = b2.getRevisionNumber();
                return rn1 != VcsRevisionNumber.NULL && rn2 != VcsRevisionNumber.NULL && b1.getClass() == b2.getClass() && rn1.compareTo((Object)rn2) == 0;
            }
            return b1 == null && b2 == null;
        }

        @NotNull
        public ChangeListWorker finish() {
            this.checkForMultipleCopiesNotMove();
            return this.myWorker;
        }

        private void checkForMultipleCopiesNotMove() {
            MultiMap moves = new MultiMap();
            for (Change change : this.myWorker.myIdx.getChanges()) {
                if (!change.isMoved() && !change.isRenamed()) continue;
                moves.putValue((Object)change.getBeforeRevision().getFile(), (Object)change);
            }
            for (FilePath filePath : moves.keySet()) {
                List copies = (List)moves.get((Object)filePath);
                if (copies.size() == 1) continue;
                copies.sort(this.CHANGES_AFTER_REVISION_COMPARATOR);
                for (int i = 0; i < copies.size() - 1; ++i) {
                    Change oldChange = (Change)copies.get(i);
                    Change newChange = new Change(null, oldChange.getAfterRevision());
                    AbstractVcs vcs = this.myWorker.myIdx.getVcsFor(oldChange);
                    this.myWorker.myIdx.changeRemoved(oldChange);
                    this.myWorker.myIdx.changeAdded(newChange, vcs);
                    ListData list = this.myWorker.removeChangeMapping(oldChange);
                    if (list == null) continue;
                    this.myWorker.putChangeMapping(newChange, list);
                }
            }
        }

        public void addChangeToList(@NotNull String name, @NotNull Change change, AbstractVcs vcs) {
            ListData list;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("[addChangeToList] name: %s change: %s vcs: %s", name, ChangesUtil.getFilePath((Change)change).getPath(), vcs == null ? null : vcs.getName()));
            }
            if ((list = this.myWorker.getDataByName(name)) != null) {
                this.addChangeToList(list, change, vcs);
            } else {
                LOG.error(String.format("Changelist not found: vcs - %s", vcs == null ? null : vcs.getName()));
                this.addChangeToCorrespondingList(change, vcs);
            }
        }

        public void addChangeToCorrespondingList(@NotNull Change change, AbstractVcs vcs) {
            ListData listData = this.guessListForChange(change);
            this.addChangeToList(listData, change, vcs);
        }

        @Nullable
        private ListData guessListForChange(@NotNull Change change) {
            ListData list2;
            if (LOG.isDebugEnabled()) {
                String path2 = ChangesUtil.getFilePath((Change)change).getPath();
                LOG.debug("[addChangeToCorrespondingList] for change " + (String)path2 + " type: " + change.getType() + " have before revision: " + (change.getBeforeRevision() != null));
            }
            for (ListData list2 : this.myWorker.myLists) {
                Set changesBeforeUpdate = (Set)this.myChangesBeforeUpdateMap.get(list2.id);
                if (!changesBeforeUpdate.contains(change)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[addChangeToCorrespondingList] matched by change: " + list2.name);
                }
                return list2;
            }
            String listId = this.guessChangeListByPaths(change);
            if (listId != null && (list2 = this.myWorker.getDataById(listId)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[addChangeToCorrespondingList] matched by paths: " + list2.name);
                }
                return list2;
            }
            ContentRevision revision = change.getAfterRevision();
            if (revision != null && this.myWorker.myPartialChangeTrackers.get(revision.getFile()) != null) {
                LOG.debug("[addChangeToCorrespondingList] partial tracker found");
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("[addChangeToCorrespondingList] added to default list");
            }
            return this.myWorker.myDefault;
        }

        private void addChangeToList(@Nullable ListData list, @NotNull Change change, AbstractVcs vcs) {
            if (this.myWorker.myIdx.getChanges().contains(change)) {
                LOG.warn(String.format("Multiple equal changes added: %s", change));
                return;
            }
            this.myWorker.myIdx.changeAdded(change, vcs);
            if (list != null) {
                this.myWorker.putChangeMapping(change, list);
            }
            this.myWorker.myReadOnlyChangesCache = null;
        }

        public void removeRegisteredChangeFor(@Nullable FilePath filePath) {
            Change change = this.myWorker.getChangeForPath(filePath);
            if (change == null) {
                return;
            }
            this.myWorker.myIdx.changeRemoved(change);
            this.myWorker.removeChangeMapping(change);
        }

        @NotNull
        public List<LocalChangeList> getListsCopy() {
            return this.myWorker.getChangeLists();
        }

        @Nullable
        public LocalChangeList findChangeList(String name) {
            return this.myWorker.getChangeListByName(name);
        }

        @NotNull
        public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment) {
            return this.myWorker.addChangeList(name, comment, null, null);
        }

        @NotNull
        public LocalChangeList findOrCreateList(@NotNull String name, String comment) {
            LocalChangeList list = this.myWorker.getChangeListByName(name);
            if (list != null) {
                return list;
            }
            return this.addChangeList(name, comment);
        }

        public void editComment(@NotNull String name, String comment) {
            this.myWorker.editComment(name, StringUtil.notNullize((String)comment));
        }

        public void editName(@NotNull String oldName, @NotNull String newName) {
            this.myWorker.editName(oldName, newName);
        }

        public void setListsToDisappear(@NotNull Collection<String> names) {
            this.myListsToDisappear.addAll(names);
        }

        public FileStatus getStatus(@NotNull VirtualFile file) {
            return this.myWorker.getStatus(file);
        }

        @Deprecated
        public FileStatus getStatus(@NotNull File file) {
            return this.myWorker.getStatus(VcsUtil.getFilePath((File)file));
        }

        public FileStatus getStatus(@NotNull FilePath filePath) {
            return this.myWorker.getStatus(filePath);
        }

        public void setDefaultChangeList(@NotNull String list) {
            this.myWorker.setDefaultList(list);
        }
    }

    private static class ListData {
        @NotNull
        public final String id;
        @NotNull
        public String name;
        @NotNull
        public String comment = "";
        @Nullable
        public ChangeListData data;
        public boolean isDefault = false;
        public boolean isReadOnly = false;

        ListData(@Nullable String id, @NotNull String name) {
            this.id = id != null ? id : LocalChangeListImpl.generateChangelistId();
            this.name = name;
        }

        ListData(@NotNull LocalChangeListImpl list) {
            this.id = list.getId();
            this.name = list.getName();
            this.comment = list.getComment();
            this.data = list.getData();
            this.isDefault = list.isDefault();
            this.isReadOnly = list.isReadOnly();
        }

        ListData(@NotNull ListData list) {
            this.id = list.id;
            this.name = list.name;
            this.comment = list.comment;
            this.data = list.data;
            this.isDefault = list.isDefault;
            this.isReadOnly = list.isReadOnly;
        }
    }
}

