/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectSetProcessor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class OpenProjectSetProcessor
extends ProjectSetProcessor {
    OpenProjectSetProcessor() {
    }

    public String getId() {
        return "project";
    }

    public void processEntries(@NotNull List<? extends Pair<String, String>> entries, @NotNull ProjectSetProcessor.Context context, @NotNull Runnable runNext) {
        Project project;
        String root = context.directory == null || context.directoryName == null ? null : context.directory.getPath() + "/" + context.directoryName;
        for (Pair<String, String> pair : entries) {
            if (!"project".equals(pair.getFirst())) continue;
            String path2 = root == null ? (String)pair.getSecond() : root + "/" + (String)pair.getSecond();
            context.project = ProjectUtil.openProject((Path)Paths.get(path2, new String[0]), (OpenProjectTask)OpenProjectTask.withProjectToClose(null));
            if (context.project != null) {
                runNext.run();
            }
            return;
        }
        VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
        if (dir != null && (project = PlatformProjectOpenProcessor.getInstance().doOpenProject(dir, null, false)) != null) {
            runNext.run();
        }
    }
}

