/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diff.impl.patch.AirContentRevision;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.BeforeAfter;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextPatchBuilder {
    private static final int CONTEXT_LINES = 3;
    @NonNls
    private static final String REVISION_NAME_TEMPLATE = "(revision {0})";
    @NonNls
    private static final String DATE_NAME_TEMPLATE = "(date {0})";
    @NotNull
    private final String myBasePath;
    private final boolean myIsReversePath;
    @Nullable
    private final Runnable myCancelChecker;

    private TextPatchBuilder(@NotNull String basePath, boolean isReversePath, @Nullable Runnable cancelChecker) {
        this.myBasePath = basePath;
        this.myIsReversePath = isReversePath;
        this.myCancelChecker = cancelChecker;
    }

    @NotNull
    public static List<FilePatch> buildPatch(@NotNull Collection<? extends BeforeAfter<AirContentRevision>> changes, @NotNull String basePath, boolean reversePatch, @Nullable Runnable cancelChecker) throws VcsException {
        TextPatchBuilder builder = new TextPatchBuilder(basePath, reversePatch, cancelChecker);
        return builder.build(changes);
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static List<FilePatch> buildPatch(@NotNull Collection<? extends BeforeAfter<AirContentRevision>> changes, @NotNull String basePath, boolean reversePatch, boolean isCaseSensitive, @Nullable Runnable cancelChecker) throws VcsException {
        return TextPatchBuilder.buildPatch(changes, basePath, reversePatch, cancelChecker);
    }

    @NotNull
    private List<FilePatch> build(@NotNull Collection<? extends BeforeAfter<AirContentRevision>> changes) throws VcsException {
        ArrayList<FilePatch> result2 = new ArrayList<FilePatch>();
        for (BeforeAfter<AirContentRevision> beforeAfter : changes) {
            AirContentRevision afterRevision;
            AirContentRevision beforeRevision;
            FilePatch patch;
            if (this.myCancelChecker != null) {
                this.myCancelChecker.run();
            }
            if ((patch = this.createPatch(beforeRevision = this.myIsReversePath ? (AirContentRevision)beforeAfter.getAfter() : (AirContentRevision)beforeAfter.getBefore(), afterRevision = this.myIsReversePath ? (AirContentRevision)beforeAfter.getBefore() : (AirContentRevision)beforeAfter.getAfter())) == null) continue;
            result2.add(patch);
        }
        return result2;
    }

    @Nullable
    private FilePatch createPatch(@Nullable AirContentRevision beforeRevision, @Nullable AirContentRevision afterRevision) throws VcsException {
        if (beforeRevision == null && afterRevision == null) {
            return null;
        }
        if (beforeRevision != null && beforeRevision.getPath().isDirectory()) {
            return null;
        }
        if (afterRevision != null && afterRevision.getPath().isDirectory()) {
            return null;
        }
        if (beforeRevision != null && beforeRevision.isBinary() || afterRevision != null && afterRevision.isBinary()) {
            return this.buildBinaryPatch(beforeRevision, afterRevision);
        }
        if (beforeRevision == null) {
            return this.buildAddedFile(afterRevision);
        }
        if (afterRevision == null) {
            return this.buildDeletedFile(beforeRevision);
        }
        return this.buildModifiedFile(beforeRevision, afterRevision);
    }

    @Nullable
    private TextFilePatch buildModifiedFile(@NotNull AirContentRevision beforeRevision, @NotNull AirContentRevision afterRevision) throws VcsException {
        String beforeContent = TextPatchBuilder.getContent(beforeRevision);
        String afterContent = TextPatchBuilder.getContent(afterRevision);
        TextFilePatch patch = this.buildPatchHeading(beforeRevision, afterRevision);
        if (beforeContent.equals(afterContent)) {
            if (beforeRevision.getPath().getPath().equals(afterRevision.getPath().getPath())) {
                return null;
            }
            return patch;
        }
        List<PatchHunk> hunks = TextPatchBuilder.buildPatchHunks(beforeContent, afterContent);
        for (PatchHunk hunk : hunks) {
            patch.addHunk(hunk);
        }
        return patch;
    }

    @NotNull
    public static List<PatchHunk> buildPatchHunks(@NotNull String beforeContent, @NotNull String afterContent) {
        List<Range> hunkFragments;
        if (beforeContent.isEmpty()) {
            return Collections.singletonList(TextPatchBuilder.createWholeFileHunk(afterContent, true, true));
        }
        if (afterContent.isEmpty()) {
            return Collections.singletonList(TextPatchBuilder.createWholeFileHunk(beforeContent, false, true));
        }
        ArrayList<PatchHunk> hunks = new ArrayList<PatchHunk>();
        List<String> beforeLines = TextPatchBuilder.tokenize(beforeContent);
        List<String> afterLines = TextPatchBuilder.tokenize(afterContent);
        boolean beforeNoNewlineAtEOF = !beforeContent.endsWith("\n");
        boolean afterNoNewlineAtEOF = !afterContent.endsWith("\n");
        List<Range> fragments = TextPatchBuilder.compareLines(beforeLines, afterLines, beforeNoNewlineAtEOF, afterNoNewlineAtEOF);
        for (int hunkStart = 0; hunkStart < fragments.size(); hunkStart += hunkFragments.size()) {
            hunkFragments = TextPatchBuilder.getAdjacentFragments(fragments, hunkStart);
            hunks.add(TextPatchBuilder.createHunk(hunkFragments, beforeLines, afterLines, beforeNoNewlineAtEOF, afterNoNewlineAtEOF));
        }
        return hunks;
    }

    @NotNull
    private static List<Range> getAdjacentFragments(@NotNull List<Range> fragments, int hunkStart) {
        int hunkEnd;
        for (hunkEnd = hunkStart + 1; hunkEnd < fragments.size(); ++hunkEnd) {
            Range lastFragment = fragments.get(hunkEnd - 1);
            Range nextFragment = fragments.get(hunkEnd);
            if (lastFragment.end1 + 3 < nextFragment.start1 - 3 && lastFragment.end2 + 3 < nextFragment.start2 - 3) break;
        }
        return fragments.subList(hunkStart, hunkEnd);
    }

    @NotNull
    private static PatchHunk createHunk(@NotNull List<? extends Range> hunkFragments, @NotNull List<String> beforeLines, @NotNull List<String> afterLines, boolean beforeNoNewlineAtEOF, boolean afterNoNewlineAtEOF) {
        Range first = hunkFragments.get(0);
        Range last = hunkFragments.get(hunkFragments.size() - 1);
        int contextStart1 = Math.max(first.start1 - 3, 0);
        int contextStart2 = Math.max(first.start2 - 3, 0);
        int contextEnd1 = Math.min(last.end1 + 3, beforeLines.size());
        int contextEnd2 = Math.min(last.end2 + 3, afterLines.size());
        PatchHunk hunk = new PatchHunk(contextStart1, contextEnd1, contextStart2, contextEnd2);
        int lastLine1 = contextStart1;
        int lastLine2 = contextStart2;
        for (Range range : hunkFragments) {
            int i;
            int start1 = range.start1;
            int start2 = range.start2;
            int end1 = range.end1;
            int end2 = range.end2;
            assert (start1 - lastLine1 == start2 - lastLine2);
            for (i = lastLine1; i < start1; ++i) {
                TextPatchBuilder.addLineToHunk(hunk, beforeLines, PatchLine.Type.CONTEXT, i, beforeNoNewlineAtEOF);
            }
            for (i = start1; i < end1; ++i) {
                TextPatchBuilder.addLineToHunk(hunk, beforeLines, PatchLine.Type.REMOVE, i, beforeNoNewlineAtEOF);
            }
            for (i = start2; i < end2; ++i) {
                TextPatchBuilder.addLineToHunk(hunk, afterLines, PatchLine.Type.ADD, i, afterNoNewlineAtEOF);
            }
            lastLine1 = end1;
            lastLine2 = end2;
        }
        assert (contextEnd1 - lastLine1 == contextEnd2 - lastLine2);
        for (int i = lastLine1; i < contextEnd1; ++i) {
            TextPatchBuilder.addLineToHunk(hunk, beforeLines, PatchLine.Type.CONTEXT, i, beforeNoNewlineAtEOF);
        }
        return hunk;
    }

    @NotNull
    private static List<Range> compareLines(@NotNull List<String> beforeLines, @NotNull List<String> afterLines, boolean beforeNoNewlineAtEOF, boolean afterNoNewlineAtEOF) {
        if (!beforeNoNewlineAtEOF && !afterNoNewlineAtEOF) {
            return TextPatchBuilder.doCompareLines(beforeLines, afterLines);
        }
        int beforeLastLine = beforeLines.size() - 1;
        int afterLastLine = afterLines.size() - 1;
        List<String> beforeComparedLines = beforeNoNewlineAtEOF ? beforeLines.subList(0, beforeLastLine) : beforeLines;
        List<String> afterComparedLines = afterNoNewlineAtEOF ? afterLines.subList(0, afterLastLine) : afterLines;
        List<Range> ranges = TextPatchBuilder.doCompareLines(beforeComparedLines, afterComparedLines);
        if (beforeNoNewlineAtEOF && afterNoNewlineAtEOF) {
            if (beforeLines.get(beforeLastLine).equals(afterLines.get(afterLastLine))) {
                return ranges;
            }
            Range range = new Range(beforeLastLine, beforeLastLine + 1, afterLastLine, afterLastLine + 1);
            return TextPatchBuilder.appendRange(ranges, range);
        }
        if (beforeNoNewlineAtEOF) {
            Range range = new Range(beforeLastLine, beforeLastLine + 1, afterLastLine + 1, afterLastLine + 1);
            return TextPatchBuilder.appendRange(ranges, range);
        }
        Range range = new Range(beforeLastLine + 1, beforeLastLine + 1, afterLastLine, afterLastLine + 1);
        return TextPatchBuilder.appendRange(ranges, range);
    }

    @NotNull
    private static List<Range> appendRange(@NotNull List<? extends Range> ranges, @NotNull Range change) {
        if (ranges.isEmpty()) {
            return Collections.singletonList(change);
        }
        Range lastRange = ranges.get(ranges.size() - 1);
        if (lastRange.end1 == change.start1 && lastRange.end2 == change.start2) {
            Range mergedChange = new Range(lastRange.start1, change.end1, lastRange.start2, change.end2);
            return ContainerUtil.append(ranges.subList(0, ranges.size() - 1), (Object[])new Range[]{mergedChange});
        }
        return ContainerUtil.append(ranges, (Object[])new Range[]{change});
    }

    @NotNull
    private static List<Range> doCompareLines(@NotNull List<String> beforeLines, @NotNull List<String> afterLines) {
        try {
            FairDiffIterable iterable = ByLine.compare(beforeLines, afterLines, (ComparisonPolicy)ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            return ContainerUtil.newArrayList((Iterable)iterable.iterateChanges());
        }
        catch (DiffTooBigException e) {
            return Collections.singletonList(new Range(0, beforeLines.size(), 0, afterLines.size()));
        }
    }

    @NotNull
    private FilePatch buildBinaryPatch(@Nullable AirContentRevision beforeRevision, @Nullable AirContentRevision afterRevision) throws VcsException {
        assert (beforeRevision != null || afterRevision != null);
        AirContentRevision headingBeforeRevision = beforeRevision != null ? beforeRevision : afterRevision;
        AirContentRevision headingAfterRevision = afterRevision != null ? afterRevision : beforeRevision;
        byte[] beforeContent = beforeRevision != null ? beforeRevision.getContentAsBytes() : null;
        byte[] afterContent = afterRevision != null ? afterRevision.getContentAsBytes() : null;
        BinaryFilePatch patch = new BinaryFilePatch(beforeContent, afterContent);
        this.setPatchHeading((FilePatch)patch, headingBeforeRevision, headingAfterRevision);
        return patch;
    }

    @NotNull
    private TextFilePatch buildAddedFile(@NotNull AirContentRevision afterRevision) throws VcsException {
        TextFilePatch result2 = this.buildPatchHeading(afterRevision, afterRevision);
        result2.setFileStatus(FileStatus.ADDED);
        String content2 = TextPatchBuilder.getContent(afterRevision);
        if (!content2.isEmpty()) {
            result2.addHunk(TextPatchBuilder.createWholeFileHunk(content2, true, false));
        }
        return result2;
    }

    @NotNull
    private TextFilePatch buildDeletedFile(@NotNull AirContentRevision beforeRevision) throws VcsException {
        TextFilePatch result2 = this.buildPatchHeading(beforeRevision, beforeRevision);
        result2.setFileStatus(FileStatus.DELETED);
        String content2 = TextPatchBuilder.getContent(beforeRevision);
        if (!content2.isEmpty()) {
            result2.addHunk(TextPatchBuilder.createWholeFileHunk(content2, false, false));
        }
        return result2;
    }

    private static void addLineToHunk(@NotNull PatchHunk hunk, @NotNull List<String> lines, @NotNull PatchLine.Type type, int index, boolean noNewlineAtEOF) {
        String line = lines.get(index);
        boolean isLastLine = index == lines.size() - 1;
        PatchLine patchLine = new PatchLine(type, line);
        patchLine.setSuppressNewLine(noNewlineAtEOF && isLastLine);
        hunk.addLine(patchLine);
    }

    @NotNull
    private static PatchHunk createWholeFileHunk(@NotNull String content2, boolean isInsertion, boolean isWithEmptyFile) {
        PatchLine.Type type = isInsertion ? PatchLine.Type.ADD : PatchLine.Type.REMOVE;
        List<String> lines = TextPatchBuilder.tokenize(content2);
        boolean noNewlineAtEOF = !content2.endsWith("\n");
        int contentStart = 0;
        int contentEnd = lines.size();
        int emptyStart = isWithEmptyFile ? 0 : -1;
        int emptyEnd = isWithEmptyFile ? 0 : -1;
        PatchHunk hunk = new PatchHunk(isInsertion ? emptyStart : contentStart, isInsertion ? emptyEnd : contentEnd, isInsertion ? contentStart : emptyStart, isInsertion ? contentEnd : emptyEnd);
        for (int i = 0; i < lines.size(); ++i) {
            TextPatchBuilder.addLineToHunk(hunk, lines, type, i, noNewlineAtEOF);
        }
        return hunk;
    }

    @NotNull
    public static String getRelativePath(@NotNull String basePath, @NotNull String secondPath) {
        String secondModified;
        String baseModified = FileUtil.toSystemIndependentName((String)basePath);
        String relPath = FileUtil.getRelativePath((String)baseModified, (String)(secondModified = FileUtil.toSystemIndependentName((String)secondPath)), (char)'/', (boolean)SystemInfo.isFileSystemCaseSensitive);
        if (relPath == null) {
            return secondModified;
        }
        return relPath;
    }

    @NotNull
    private TextFilePatch buildPatchHeading(@NotNull AirContentRevision beforeRevision, @NotNull AirContentRevision afterRevision) {
        TextFilePatch result2 = new TextFilePatch(afterRevision.getCharset(), afterRevision.getLineSeparator());
        this.setPatchHeading((FilePatch)result2, beforeRevision, afterRevision);
        return result2;
    }

    private void setPatchHeading(@NotNull FilePatch result2, @NotNull AirContentRevision beforeRevision, @NotNull AirContentRevision afterRevision) {
        result2.setBeforeName(TextPatchBuilder.getRelativePath(this.myBasePath, beforeRevision.getPath().getPath()));
        result2.setBeforeVersionId(TextPatchBuilder.getRevisionName(beforeRevision));
        result2.setAfterName(TextPatchBuilder.getRelativePath(this.myBasePath, afterRevision.getPath().getPath()));
        result2.setAfterVersionId(TextPatchBuilder.getRevisionName(afterRevision));
    }

    @NotNull
    private static String getRevisionName(@NotNull AirContentRevision revision) {
        String revisionName = revision.getRevisionNumber();
        if (!StringUtil.isEmptyOrSpaces((String)revisionName)) {
            return MessageFormat.format(REVISION_NAME_TEMPLATE, revisionName);
        }
        return MessageFormat.format(DATE_NAME_TEMPLATE, Long.toString(revision.getPath().lastModified()));
    }

    @NotNull
    private static String getContent(@NotNull AirContentRevision revision) throws VcsException {
        String beforeContent = revision.getContentAsString();
        if (beforeContent == null) {
            throw new VcsException(String.format("Failed to fetch old content for file %s in revision %s", revision.getPath().getPath(), revision.getRevisionNumber()));
        }
        return beforeContent;
    }

    @NotNull
    private static List<String> tokenize(@NotNull String text2) {
        return LineTokenizer.tokenizeIntoList((CharSequence)text2, (boolean)false, (boolean)true);
    }
}

