/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.CompareBranchesDiffPanel;
import com.intellij.dvcs.ui.CompareBranchesHelper;
import com.intellij.dvcs.ui.CompareBranchesLogPanel;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.ui.TabbedPaneImpl;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CompareBranchesDialog {
    @NotNull
    private final Project myProject;
    @NotNull
    private final JPanel myLogPanel;
    @NotNull
    private final TabbedPaneImpl myTabbedPane;
    @NotNull
    private final String myTitle;
    @NotNull
    private final WindowWrapper.Mode myMode;
    private WindowWrapper myWrapper;

    public CompareBranchesDialog(@NotNull CompareBranchesHelper helper, @NotNull String branchName, @NotNull String currentBranchName, @NotNull CommitCompareInfo compareInfo, @NotNull Repository initialRepo, boolean dialog) {
        this.myProject = helper.getProject();
        String rootString = compareInfo.getRepositories().size() == 1 && helper.getRepositoryManager().moreThanOneRoot() ? " in root " + DvcsUtil.getShortRepositoryName(initialRepo) : "";
        this.myTitle = String.format("Comparing %s with %s%s", currentBranchName, branchName, rootString);
        this.myMode = dialog ? WindowWrapper.Mode.MODAL : WindowWrapper.Mode.FRAME;
        CompareBranchesDiffPanel diffPanel = new CompareBranchesDiffPanel(helper.getProject(), helper.getDvcsCompareSettings(), branchName, currentBranchName);
        diffPanel.setCompareInfo(compareInfo);
        this.myLogPanel = new CompareBranchesLogPanel(helper, branchName, currentBranchName, compareInfo, initialRepo);
        this.myTabbedPane = new TabbedPaneImpl(1);
        this.myTabbedPane.addTab("Log", AllIcons.Vcs.Branch, (Component)this.myLogPanel);
        this.myTabbedPane.addTab("Files", AllIcons.Actions.ListChanges, (Component)diffPanel);
        this.myTabbedPane.setKeyboardNavigation(TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS);
    }

    public void show() {
        if (this.myWrapper == null) {
            this.myWrapper = new WindowWrapperBuilder(this.myMode, (JComponent)this.myTabbedPane).setProject(this.myProject).setTitle(this.myTitle).setPreferredFocusedComponent((JComponent)this.myLogPanel).setDimensionServiceKey(CompareBranchesDialog.class.getName()).build();
        }
        this.myWrapper.show();
    }
}

