/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.ui.ValidationInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CloneDvcsValidationUtils {
    private static final Pattern SSH_URL_PATTERN;

    @Nullable
    public static ValidationInfo createDestination(@NotNull String path2) {
        try {
            Path directoryPath = Paths.get(path2, new String[0]);
            if (!directoryPath.toFile().exists()) {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            } else if (!directoryPath.toFile().isDirectory()) {
                return new ValidationInfo(DvcsBundle.getString("clone.destination.directory.error.access")).withOKEnabled();
            }
            return null;
        }
        catch (InvalidPathException e) {
            return new ValidationInfo(DvcsBundle.getString("clone.destination.directory.error.invalid"));
        }
        catch (Exception e) {
            return new ValidationInfo(DvcsBundle.getString("clone.destination.directory.error.access")).withOKEnabled();
        }
    }

    @Nullable
    public static ValidationInfo checkDirectory(String directoryPath, JTextField component) {
        if (directoryPath.length() == 0) {
            return new ValidationInfo("");
        }
        try {
            Path path2 = Paths.get(directoryPath, new String[0]);
            if (!path2.toFile().exists()) {
                return null;
            }
            if (!path2.toFile().isDirectory()) {
                return new ValidationInfo(DvcsBundle.getString("clone.destination.directory.error.not.directory"), (JComponent)component);
            }
            if (!CloneDvcsValidationUtils.isDirectoryEmpty(path2)) {
                return new ValidationInfo(DvcsBundle.message("clone.destination.directory.error.exists", new Object[0]), (JComponent)component);
            }
        }
        catch (IOException | InvalidPathException e) {
            return new ValidationInfo(DvcsBundle.getString("clone.destination.directory.error.invalid"), (JComponent)component);
        }
        return null;
    }

    private static boolean isDirectoryEmpty(@NotNull Path directory) throws IOException {
        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);
        return !directoryStream.iterator().hasNext();
    }

    @Nullable
    public static ValidationInfo checkRepositoryURL(JComponent component, String repository) {
        if (repository.length() == 0) {
            return new ValidationInfo(DvcsBundle.getString("clone.repository.url.error.empty"), component);
        }
        repository = CloneDvcsValidationUtils.sanitizeCloneUrl(repository);
        try {
            if (new URI(repository).isAbsolute()) {
                return null;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (SSH_URL_PATTERN.matcher(repository).matches()) {
            return null;
        }
        try {
            Path path2 = Paths.get(repository, new String[0]);
            if (path2.toFile().exists()) {
                if (!path2.toFile().isDirectory()) {
                    return new ValidationInfo(DvcsBundle.getString("clone.repository.url.error.not.directory"), component);
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ValidationInfo(DvcsBundle.getString("clone.repository.url.error.invalid"), component);
    }

    @NotNull
    static String sanitizeCloneUrl(@NotNull String urlText) {
        return StringsKt.removePrefix((String)StringsKt.removePrefix((String)urlText.trim(), (CharSequence)"git clone"), (CharSequence)"hg clone").trim();
    }

    static {
        String ch = "[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]";
        String host = "[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*";
        String path2 = "/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?";
        String all = "(?:[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+@)?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*:/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?";
        SSH_URL_PATTERN = Pattern.compile("(?:[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+@)?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*:/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?");
    }
}

