/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.hosting.RepositoryHostingService;
import com.intellij.dvcs.hosting.RepositoryListLoader;
import com.intellij.dvcs.hosting.RepositoryListLoadingException;
import com.intellij.dvcs.repo.ClonePathProvider;
import com.intellij.dvcs.ui.CloneDvcsValidationUtils;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboBoxCompositeEditor;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.progress.ComponentVisibilityProgressManager;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class CloneDvcsDialog
extends DialogWrapper {
    private ComboBox<String> myRepositoryUrlCombobox;
    private CollectionComboBoxModel<String> myRepositoryUrlComboboxModel;
    private TextFieldWithAutoCompletion<String> myRepositoryUrlField;
    private ComponentVisibilityProgressManager mySpinnerProgressManager;
    private JButton myTestButton;
    private MyTextFieldWithBrowseButton myDirectoryField;
    private LoginButtonComponent myLoginButtonComponent;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final String myVcsDirectoryName;
    @Nullable
    private ValidationInfo myCreateDirectoryValidationInfo;
    @Nullable
    private ValidationInfo myRepositoryTestValidationInfo;
    @Nullable
    private ProgressIndicator myRepositoryTestProgressIndicator;
    @NotNull
    private final List<String> myLoadedRepositoryHostingServicesNames;
    @Nullable
    private Alarm myRepositoryUrlAutoCompletionTooltipAlarm;
    @NotNull
    private final Set<String> myUniqueAvailableRepositories;
    @NotNull
    private final List<ValidationInfo> myRepositoryListLoadingErrors = new ArrayList<ValidationInfo>();

    public CloneDvcsDialog(@NotNull Project project, @NotNull String displayName, @NotNull String vcsDirectoryName) {
        this(project, displayName, vcsDirectoryName, null);
    }

    public CloneDvcsDialog(@NotNull Project project, @NotNull String displayName, @NotNull String vcsDirectoryName, @Nullable String defaultUrl) {
        super(project, true);
        this.myProject = project;
        this.myVcsDirectoryName = vcsDirectoryName;
        this.myLoadedRepositoryHostingServicesNames = new ArrayList<String>();
        this.myUniqueAvailableRepositories = new HashSet<String>();
        this.initComponents(defaultUrl);
        Map<String, RepositoryListLoader> loadersToSchedule = this.initUrlAutocomplete();
        this.setTitle(DvcsBundle.getString("clone.title"));
        this.setOKButtonText(DvcsBundle.getString("clone.button"));
        this.init();
        this.scheduleLater(loadersToSchedule);
    }

    protected void doOKAction() {
        final String path2 = this.myDirectoryField.getText();
        new Task.Modal(this.myProject, DvcsBundle.message("progress.title.creating.destination.directory", new Object[0]), true){
            private ValidationInfo error;
            {
                super(x0, x1, x2);
                this.error = null;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                this.error = CloneDvcsValidationUtils.createDestination(path2);
            }

            public void onSuccess() {
                if (this.error == null) {
                    CloneDvcsDialog.super.doOKAction();
                } else {
                    CloneDvcsDialog.this.myCreateDirectoryValidationInfo = this.error;
                    CloneDvcsDialog.this.startTrackingValidation();
                }
            }
        }.queue();
    }

    @NotNull
    public String getSourceRepositoryURL() {
        return this.getCurrentUrlText();
    }

    @NotNull
    public String getParentDirectory() {
        Path parent = Paths.get(this.myDirectoryField.getText(), new String[0]).toAbsolutePath().getParent();
        return Objects.requireNonNull(parent).toAbsolutePath().toString();
    }

    @NotNull
    public String getDirectoryName() {
        return Paths.get(this.myDirectoryField.getText(), new String[0]).getFileName().toString();
    }

    private void initComponents(@Nullable String defaultUrl) {
        this.myRepositoryUrlComboboxModel = new CollectionComboBoxModel();
        this.myRepositoryUrlField = TextFieldWithAutoCompletion.create((Project)this.myProject, (Collection)this.myRepositoryUrlComboboxModel.getItems(), (boolean)false, (String)"");
        JLabel repositoryUrlFieldSpinner = new JLabel((Icon)new AnimatedIcon.Default());
        repositoryUrlFieldSpinner.setVisible(false);
        this.mySpinnerProgressManager = new ComponentVisibilityProgressManager(repositoryUrlFieldSpinner);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.mySpinnerProgressManager);
        this.myRepositoryUrlCombobox = new ComboBox();
        this.myRepositoryUrlCombobox.setEditable(true);
        this.myRepositoryUrlCombobox.setEditor((ComboBoxEditor)ComboBoxCompositeEditor.withComponents(this.myRepositoryUrlField, (JComponent[])new JComponent[]{repositoryUrlFieldSpinner}));
        this.myRepositoryUrlCombobox.setModel(this.myRepositoryUrlComboboxModel);
        this.myRepositoryUrlField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                CloneDvcsDialog.this.myDirectoryField.trySetChildPath(CloneDvcsDialog.this.defaultDirectoryPath(CloneDvcsDialog.this.myRepositoryUrlField.getText().trim()));
            }
        });
        this.myRepositoryUrlField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                CloneDvcsDialog.this.myRepositoryTestValidationInfo = null;
            }
        });
        this.myTestButton = new JButton(DvcsBundle.getString("clone.repository.url.test.label"));
        this.myTestButton.addActionListener(e -> this.test());
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setHideIgnored(false);
        this.myDirectoryField = new MyTextFieldWithBrowseButton(ClonePathProvider.defaultParentDirectoryPath(this.myProject, this.getRememberedInputs()));
        this.myDirectoryField.addBrowseFolderListener(DvcsBundle.getString("clone.destination.directory.browser.title"), DvcsBundle.getString("clone.destination.directory.browser.description"), this.myProject, fcd);
        if (defaultUrl != null) {
            this.myRepositoryUrlField.setText(defaultUrl);
            this.myRepositoryUrlField.selectAll();
            this.myTestButton.setEnabled(true);
        }
    }

    private Map<String, RepositoryListLoader> initUrlAutocomplete() {
        Collection<RepositoryHostingService> repositoryHostingServices = this.getRepositoryHostingServices();
        if (repositoryHostingServices.size() > 1) {
            this.myRepositoryUrlAutoCompletionTooltipAlarm = new Alarm(this.getDisposable());
            this.myRepositoryUrlAutoCompletionTooltipAlarm.setActivationComponent(this.myRepositoryUrlCombobox);
        }
        ArrayList<Action> loginActions = new ArrayList<Action>();
        HashMap<String, RepositoryListLoader> enabledLoaders = new HashMap<String, RepositoryListLoader>();
        for (RepositoryHostingService service : repositoryHostingServices) {
            final String serviceDisplayName = service.getServiceDisplayName();
            final RepositoryListLoader loader = service.getRepositoryListLoader(this.myProject);
            if (loader == null) continue;
            if (loader.isEnabled()) {
                enabledLoaders.put(serviceDisplayName, loader);
                continue;
            }
            loginActions.add(new AbstractAction(DvcsBundle.message("clone.repository.url.autocomplete.login.text", serviceDisplayName)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (loader.enable((Component)CloneDvcsDialog.this.myLoginButtonComponent.getPanel())) {
                        CloneDvcsDialog.this.myLoginButtonComponent.removeAction(this);
                        CloneDvcsDialog.this.schedule(serviceDisplayName, loader);
                    }
                }
            });
        }
        this.myRepositoryUrlField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CloneDvcsDialog.this.showRepositoryUrlAutoCompletionTooltip();
            }
        });
        this.myLoginButtonComponent = new LoginButtonComponent(loginActions);
        return enabledLoaders;
    }

    @NotNull
    protected Collection<RepositoryHostingService> getRepositoryHostingServices() {
        return Collections.emptyList();
    }

    private void scheduleLater(@NotNull Map<String, RepositoryListLoader> loaders) {
        ApplicationManager.getApplication().invokeLater(() -> loaders.forEach(this::schedule), ModalityState.stateForComponent((Component)this.getRootPane()));
    }

    private void schedule(final @NotNull String serviceDisplayName, final @NotNull RepositoryListLoader loader) {
        this.mySpinnerProgressManager.run(new Task.Backgroundable(this.myProject, DvcsBundle.message("progress.title.visible", new Object[0])){
            private final List<String> myNewRepositories;
            private final List<RepositoryListLoadingException> myErrors;
            {
                super(x0, x1);
                this.myNewRepositories = new ArrayList<String>();
                this.myErrors = new ArrayList<RepositoryListLoadingException>();
            }

            public void run(@NotNull ProgressIndicator indicator) {
                RepositoryListLoader.Result loadingResult = loader.getAvailableRepositoriesFromMultipleSources(indicator);
                for (String repository : loadingResult.getUrls()) {
                    if (!CloneDvcsDialog.this.myUniqueAvailableRepositories.add(repository)) continue;
                    this.myNewRepositories.add(repository);
                }
                this.myErrors.addAll(loadingResult.getErrors());
            }

            public void onSuccess() {
                if (CloneDvcsDialog.this.mySpinnerProgressManager.getDisposed()) {
                    return;
                }
                if (!this.myNewRepositories.isEmpty()) {
                    CloneDvcsDialog.this.myRepositoryUrlCombobox.setSelectedItem((Object)CloneDvcsDialog.this.myRepositoryUrlField.getText());
                    CloneDvcsDialog.this.myRepositoryUrlComboboxModel.addAll(CloneDvcsDialog.this.myRepositoryUrlComboboxModel.getSize(), this.myNewRepositories);
                    CloneDvcsDialog.this.myRepositoryUrlField.setVariants((Collection)CloneDvcsDialog.this.myRepositoryUrlComboboxModel.getItems());
                }
                CloneDvcsDialog.this.myLoadedRepositoryHostingServicesNames.add(serviceDisplayName);
                CloneDvcsDialog.this.showRepositoryUrlAutoCompletionTooltip();
                if (!this.myErrors.isEmpty()) {
                    for (RepositoryListLoadingException error : this.myErrors) {
                        StringBuilder errorMessageBuilder = new StringBuilder();
                        errorMessageBuilder.append(error.getMessage());
                        Throwable cause = error.getCause();
                        if (cause != null) {
                            errorMessageBuilder.append(": ").append(cause.getMessage());
                        }
                        CloneDvcsDialog.this.myRepositoryListLoadingErrors.add(new ValidationInfo(errorMessageBuilder.toString()).asWarning().withOKEnabled());
                    }
                    CloneDvcsDialog.this.startTrackingValidation();
                }
            }
        });
    }

    private void showRepositoryUrlAutoCompletionTooltip() {
        if (this.myRepositoryUrlAutoCompletionTooltipAlarm == null) {
            this.showRepositoryUrlAutoCompletionTooltipNow();
        } else {
            this.myRepositoryUrlAutoCompletionTooltipAlarm.cancelAllRequests();
            this.myRepositoryUrlAutoCompletionTooltipAlarm.addComponentRequest(this::showRepositoryUrlAutoCompletionTooltipNow, 1);
        }
    }

    private void showRepositoryUrlAutoCompletionTooltipNow() {
        if (!this.hasErrors((JComponent)this.myRepositoryUrlCombobox) && !this.myLoadedRepositoryHostingServicesNames.isEmpty()) {
            Editor editor = this.myRepositoryUrlField.getEditor();
            if (editor == null) {
                return;
            }
            String completionShortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
            HintManager.getInstance().showInformationHint(editor, DvcsBundle.message("clone.repository.url.autocomplete.hint", DvcsUtil.joinWithAnd(this.myLoadedRepositoryHostingServicesNames, 0), completionShortcutText));
        }
    }

    private void test() {
        final String testUrl = this.getCurrentUrlText();
        if (this.myRepositoryTestProgressIndicator != null) {
            this.myRepositoryTestProgressIndicator.cancel();
            this.myRepositoryTestProgressIndicator = null;
        }
        this.myRepositoryTestProgressIndicator = this.mySpinnerProgressManager.run(new Task.Backgroundable(this.myProject, DvcsBundle.message("clone.repository.url.test.title", testUrl), true){
            private TestResult myTestResult;

            public void run(@NotNull ProgressIndicator indicator) {
                this.myTestResult = CloneDvcsDialog.this.test(testUrl);
            }

            public void onSuccess() {
                if (this.myTestResult.isSuccess()) {
                    CloneDvcsDialog.this.myRepositoryTestValidationInfo = null;
                    Disposable dialogDisposable = CloneDvcsDialog.this.getDisposable();
                    if (Disposer.isDisposed((Disposable)dialogDisposable)) {
                        return;
                    }
                    JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(DvcsBundle.getString("clone.repository.url.test.success.message"))).setDisposable(dialogDisposable).createBalloon().show(new RelativePoint((Component)CloneDvcsDialog.this.myTestButton, new Point(CloneDvcsDialog.this.myTestButton.getWidth() / 2, CloneDvcsDialog.this.myTestButton.getHeight())), Balloon.Position.below);
                } else {
                    CloneDvcsDialog.this.myRepositoryTestValidationInfo = new ValidationInfo(DvcsBundle.message("clone.repository.url.test.failed.message", this.myTestResult.myErrorMessage), (JComponent)CloneDvcsDialog.this.myRepositoryUrlCombobox);
                    CloneDvcsDialog.this.startTrackingValidation();
                }
                CloneDvcsDialog.this.myRepositoryTestProgressIndicator = null;
            }
        });
    }

    @NotNull
    protected abstract TestResult test(@NotNull String var1);

    @NotNull
    protected abstract DvcsRememberedInputs getRememberedInputs();

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        ValidationInfo urlValidation = CloneDvcsValidationUtils.checkRepositoryURL(this.myRepositoryUrlCombobox, this.getCurrentUrlText());
        ValidationInfo directoryValidation = CloneDvcsValidationUtils.checkDirectory(this.myDirectoryField.getText(), this.myDirectoryField.getTextField());
        this.myTestButton.setEnabled(urlValidation == null);
        ArrayList<ValidationInfo> infoList = new ArrayList<ValidationInfo>();
        ContainerUtil.addIfNotNull(infoList, (Object)this.myRepositoryTestValidationInfo);
        ContainerUtil.addIfNotNull(infoList, (Object)this.myCreateDirectoryValidationInfo);
        ContainerUtil.addIfNotNull(infoList, (Object)urlValidation);
        ContainerUtil.addIfNotNull(infoList, (Object)directoryValidation);
        infoList.addAll(this.myRepositoryListLoadingErrors);
        return infoList;
    }

    @NotNull
    private String getCurrentUrlText() {
        return FileUtil.expandUserHome((String)this.myRepositoryUrlField.getText().trim());
    }

    @Deprecated
    public void prependToHistory(@NotNull String item) {
        this.myRepositoryUrlComboboxModel.add((Object)item);
    }

    public void rememberSettings() {
        DvcsRememberedInputs rememberedInputs = this.getRememberedInputs();
        rememberedInputs.addUrl(this.getSourceRepositoryURL());
        rememberedInputs.setCloneParentDir(this.getParentDirectory());
    }

    @NotNull
    private String defaultDirectoryPath(@NotNull String url) {
        return StringUtil.trimEnd((String)ClonePathProvider.relativeDirectoryPathForVcsUrl(this.myProject, url), (String)this.myVcsDirectoryName);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myRepositoryUrlField;
    }

    @NotNull
    protected JPanel createSouthAdditionalPanel() {
        return this.myLoginButtonComponent.getPanel();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)JBUI.Panels.simplePanel((int)10, (int)4).addToCenter(this.myRepositoryUrlCombobox).addToRight((Component)this.myTestButton)).withLabel(DvcsBundle.getString("clone.repository.url.label"))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)((Object)this.myDirectoryField)).withLabel(DvcsBundle.getString("clone.destination.directory.label"))).createPanel();
        panel2.setPreferredSize((Dimension)new JBDimension(500, 50, true));
        return panel2;
    }

    private static class LoginButtonComponent {
        @NotNull
        private final JBOptionButton myButton;
        @NotNull
        private final JPanel myPanel;
        @NotNull
        private final List<Action> myActions;

        LoginButtonComponent(@NotNull List<Action> actions) {
            this.myButton = new JBOptionButton((Action)ContainerUtil.getFirstItem(actions), LoginButtonComponent.getActionsAfterFirst(actions));
            this.myPanel = UI.PanelFactory.panel((JComponent)this.myButton).withTooltip(DvcsBundle.getString("clone.repository.url.autocomplete.login.tooltip")).createPanel();
            this.myPanel.setVisible(!actions.isEmpty());
            this.myPanel.setBorder((Border)JBUI.Borders.emptyRight((int)16));
            this.myActions = new ArrayList<Action>(actions);
        }

        void removeAction(@NotNull Action action) {
            if (this.myActions.remove(action)) {
                if (!this.myActions.isEmpty()) {
                    this.myButton.setAction((Action)ContainerUtil.getFirstItem(this.myActions));
                    this.myButton.setOptions(LoginButtonComponent.getActionsAfterFirst(this.myActions));
                } else {
                    this.myButton.setAction(null);
                    this.myButton.setOptions((Action[])null);
                    this.myPanel.setVisible(false);
                }
            }
        }

        private static Action @NotNull [] getActionsAfterFirst(@NotNull List<Action> actions) {
            if (actions.size() <= 1) {
                return new Action[0];
            }
            return actions.subList(1, actions.size()).toArray(new Action[actions.size() - 1]);
        }

        @NotNull
        public JPanel getPanel() {
            return this.myPanel;
        }
    }

    private static class MyTextFieldWithBrowseButton
    extends TextFieldWithBrowseButton {
        @NotNull
        private final Path myDefaultParentPath;
        private boolean myModifiedByUser = false;

        private MyTextFieldWithBrowseButton(@NotNull String defaultParentPath) {
            this.myDefaultParentPath = Paths.get(defaultParentPath, new String[0]).toAbsolutePath();
            this.setText(this.myDefaultParentPath.toString());
            this.getTextField().getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                    myModifiedByUser = true;
                }
            });
        }

        public void trySetChildPath(@NotNull String child) {
            if (!this.myModifiedByUser) {
                try {
                    this.setText(this.myDefaultParentPath.resolve(child).toString());
                }
                catch (InvalidPathException invalidPathException) {
                }
                finally {
                    this.myModifiedByUser = false;
                }
            }
        }
    }

    protected static class TestResult {
        @NotNull
        public static final TestResult SUCCESS = new TestResult(null);
        @Nullable
        private final String myErrorMessage;

        public TestResult(@Nullable String errorMessage) {
            this.myErrorMessage = errorMessage;
        }

        public boolean isSuccess() {
            return this.myErrorMessage == null;
        }

        @Nullable
        public String getError() {
            return this.myErrorMessage;
        }
    }
}

