/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PrePushHandler;
import com.intellij.dvcs.push.PushController;
import com.intellij.dvcs.push.PushInfo;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.PushActionBase;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.push.ui.VcsPushUi;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsPushDialog
extends DialogWrapper
implements VcsPushUi,
DataProvider {
    @NonNls
    private static final String DIMENSION_KEY = "Vcs.Push.Dialog.v2";
    @NonNls
    private static final String HELP_ID = "Vcs.Push.Dialog";
    private static final Logger LOG = Logger.getInstance(VcsPushDialog.class);
    private static final int CENTER_PANEL_HEIGHT = 450;
    private static final int CENTER_PANEL_WIDTH = 800;
    protected final Project myProject;
    private final PushLog myListPanel;
    protected final PushController myController;
    private final Map<PushSupport<?, ?, ?>, VcsPushOptionsPanel> myAdditionalPanels;
    private Action myMainAction;
    @NotNull
    private final List<ActionWrapper> myPushActions;

    public VcsPushDialog(@NotNull Project project, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo) {
        this(project, VcsRepositoryManager.getInstance(project).getRepositories(), selectedRepositories, currentRepo, null);
    }

    public VcsPushDialog(@NotNull Project project, Collection<? extends Repository> allRepos, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo, @Nullable PushSource pushSource) {
        super(project, true, Registry.is((String)"ide.perProjectModality") ? DialogWrapper.IdeModalityType.PROJECT : DialogWrapper.IdeModalityType.IDE);
        this.myProject = project;
        this.myController = new PushController(project, this, allRepos, selectedRepositories, currentRepo, pushSource);
        this.myAdditionalPanels = this.myController.createAdditionalPanels();
        this.myListPanel = this.myController.getPushPanelLog();
        this.myPushActions = this.collectPushActions();
        this.init();
        this.updateOkActions();
        this.setOKButtonText(DvcsBundle.getString("action.push"));
        this.setOKButtonMnemonic(80);
        String title2 = allRepos.size() == 1 ? DvcsBundle.message("push.dialog.push.commits.to.title", DvcsUtil.getShortRepositoryName((Repository)ContainerUtil.getFirstItem(allRepos))) : DvcsBundle.getString("push.dialog.push.commits.title");
        this.setTitle(title2);
    }

    @NotNull
    private List<ActionWrapper> collectPushActions() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Vcs.Push.Actions");
        List additionalActions = ContainerUtil.findAll((Object[])group.getChildren(null), PushActionBase.class);
        SimplePushAction simplePushAction = new SimplePushAction();
        PushActionBase.DefaultPushAction defaultPushAction = this.findDefaultPushAction(additionalActions);
        ArrayList<PushActionBase> pushActions = new ArrayList<PushActionBase>();
        pushActions.add(simplePushAction);
        pushActions.addAll(additionalActions);
        if (defaultPushAction != null) {
            pushActions.remove(defaultPushAction);
            defaultPushAction.customize(pushActions);
        }
        return ContainerUtil.map(pushActions, action -> new ActionWrapper(this.myProject, this, (PushActionBase)((Object)action)));
    }

    @Nullable
    private PushActionBase.DefaultPushAction findDefaultPushAction(@NotNull List<PushActionBase> additionalActions) {
        List defaultPushActions = ContainerUtil.findAll(additionalActions, action -> action instanceof PushActionBase.DefaultPushAction && action.isEnabled(this));
        if (defaultPushActions.isEmpty()) {
            return null;
        }
        if (defaultPushActions.size() == 1) {
            return (PushActionBase.DefaultPushAction)defaultPushActions.get(0);
        }
        LOG.warn("There can be only one default push action, found: " + defaultPushActions);
        return null;
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return null;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        return this.createSouthOptionsPanel();
    }

    protected JComponent createSouthPanel() {
        JComponent southPanel = super.createSouthPanel();
        southPanel.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        return southPanel;
    }

    protected JComponent createCenterPanel() {
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((int)0, (int)2).addToCenter((Component)this.myListPanel).addToBottom((Component)this.createOptionsPanel());
        this.myListPanel.setPreferredSize((Dimension)new JBDimension(800, 450));
        return panel2;
    }

    @NotNull
    protected JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel((LayoutManager)new MigLayout("ins 0 0, flowy")){

            @Override
            public Component add(Component comp) {
                BorderLayoutPanel wrapperPanel = new BorderLayoutPanel().addToCenter(comp);
                wrapperPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)15, (int)0, (int)0));
                return super.add((Component)wrapperPanel);
            }
        };
        for (VcsPushOptionsPanel panel2 : this.myAdditionalPanels.values()) {
            if (panel2.getPosition() != VcsPushOptionsPanel.OptionsPanelPosition.DEFAULT) continue;
            optionsPanel.add((Component)panel2);
        }
        return optionsPanel;
    }

    @NotNull
    private JPanel createSouthOptionsPanel() {
        JPanel optionsPanel = new JPanel((LayoutManager)new MigLayout(String.format("ins 0 %spx 0 0, flowx, gapx %spx", JBUI.scale((int)20), JBUI.scale((int)16))));
        for (VcsPushOptionsPanel panel2 : this.myAdditionalPanels.values()) {
            if (panel2.getPosition() != VcsPushOptionsPanel.OptionsPanelPosition.SOUTH) continue;
            optionsPanel.add((Component)panel2);
        }
        return optionsPanel;
    }

    protected String getDimensionServiceKey() {
        return DIMENSION_KEY;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.updateOkActions();
        return null;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected void doOKAction() {
        this.push(false);
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        this.myMainAction = new ComplexPushAction(this.myPushActions.get(0), this.myPushActions.subList(1, this.myPushActions.size()));
        this.myMainAction.putValue("DefaultAction", Boolean.TRUE);
        actions.add(this.myMainAction);
        actions.add(this.getCancelAction());
        actions.add(this.getHelpAction());
        return actions.toArray(new Action[0]);
    }

    @Override
    public boolean canPush() {
        return this.myController.isPushAllowed();
    }

    @Override
    @NotNull
    public Map<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> getSelectedPushSpecs() {
        return this.myController.getSelectedPushSpecs();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myListPanel.getPreferredFocusedComponent();
    }

    @NotNull
    protected Action getOKAction() {
        return this.myMainAction;
    }

    protected String getHelpId() {
        return HELP_ID;
    }

    @Override
    public void push(final boolean forcePush) {
        this.executeAfterRunningPrePushHandlers(new Task.Backgroundable(this.myProject, DvcsBundle.getString("push.process.pushing"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                VcsPushDialog.this.myController.push(forcePush);
            }
        });
    }

    @Override
    public void executeAfterRunningPrePushHandlers(@NotNull Task.Backgroundable activity) {
        PrePushHandler.Result result2 = this.runPrePushHandlersInModalTask();
        if (result2 == PrePushHandler.Result.OK) {
            activity.queue();
            this.close(0);
        } else if (result2 == PrePushHandler.Result.ABORT_AND_CLOSE) {
            this.doCancelAction();
        } else if (result2 == PrePushHandler.Result.ABORT) {
            // empty if block
        }
    }

    public PrePushHandler.Result runPrePushHandlersInModalTask() {
        FileDocumentManager.getInstance().saveAllDocuments();
        final AtomicReference<PrePushHandler.Result> result2 = new AtomicReference<PrePushHandler.Result>(PrePushHandler.Result.OK);
        new Task.Modal(this.myController.getProject(), DvcsBundle.getString("push.process.checking.commits"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                result2.set(VcsPushDialog.this.myController.executeHandlers(indicator));
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error instanceof PushController.HandlerException) {
                    String suggestionMessageProblem;
                    PushController.HandlerException handlerException = (PushController.HandlerException)error;
                    Throwable cause = handlerException.getCause();
                    String failedHandler = handlerException.getFailedHandlerName();
                    List<String> skippedHandlers = handlerException.getSkippedHandlers();
                    if (cause instanceof ProcessCanceledException) {
                        suggestionMessageProblem = DvcsBundle.message("push.dialog.push.cancelled.message", failedHandler);
                    } else {
                        super.onThrowable(cause);
                        suggestionMessageProblem = DvcsBundle.message("push.dialog.push.failed.message", failedHandler);
                    }
                    @Nls String suggestionMessageQuestion = skippedHandlers.isEmpty() ? DvcsBundle.message("push.dialog.push.anyway.confirmation", new Object[0]) : DvcsBundle.message("push.dialog.skip.all.remaining.steps.confirmation", new Object[0]);
                    this.suggestToSkipOrPush(suggestionMessageProblem + "\n" + suggestionMessageQuestion);
                } else {
                    super.onThrowable(error);
                }
            }

            public void onCancel() {
                super.onCancel();
                this.suggestToSkipOrPush(DvcsBundle.getString("push.dialog.skip.all.steps.confirmation"));
            }

            private void suggestToSkipOrPush(@Nls @NotNull String message) {
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)message, (String)DvcsBundle.getString("action.push"), (String)DvcsBundle.getString("action.push.anyway"), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)UIUtil.getWarningIcon()) == 0) {
                    result2.set(PrePushHandler.Result.OK);
                } else {
                    result2.set(PrePushHandler.Result.ABORT);
                }
            }
        }.queue();
        return result2.get();
    }

    public void updateOkActions() {
        this.myMainAction.setEnabled(this.canPush());
        for (ActionWrapper wrapper : this.myPushActions) {
            wrapper.update();
        }
    }

    public void enableOkActions(boolean value) {
        this.myMainAction.setEnabled(value);
    }

    @Override
    @Nullable
    public VcsPushOptionValue getAdditionalOptionValue(@NotNull PushSupport support) {
        VcsPushOptionsPanel panel2 = this.myAdditionalPanels.get(support);
        return panel2 == null ? null : panel2.getValue();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (VcsPushUi.VCS_PUSH_DIALOG.is(dataId)) {
            return this;
        }
        return null;
    }

    private static class ActionWrapper
    extends AbstractAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsPushUi myDialog;
        @NotNull
        private final PushActionBase myRealAction;

        ActionWrapper(@NotNull Project project, @NotNull VcsPushUi dialog, @NotNull PushActionBase realAction) {
            super(realAction.getTemplatePresentation().getTextWithMnemonic());
            this.myProject = project;
            this.myDialog = dialog;
            this.myRealAction = realAction;
            this.putValue("AnAction", (Object)realAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myRealAction.actionPerformed(this.myProject, this.myDialog);
        }

        public void update() {
            boolean enabled = this.myRealAction.isEnabled(this.myDialog);
            this.setEnabled(enabled);
            this.putValue("ShortDescription", this.myRealAction.getDescription(this.myDialog, enabled));
        }

        @NotNull
        public String getName() {
            return Objects.requireNonNull(this.myRealAction.getTemplatePresentation().getTextWithMnemonic());
        }
    }

    @ApiStatus.Internal
    public final class SimplePushAction
    extends PushActionBase {
        private SimplePushAction() {
            super(DvcsBundle.getString("action.complex.push"));
        }

        @Override
        protected boolean isEnabled(@NotNull VcsPushUi dialog) {
            return dialog.canPush();
        }

        @Override
        @Nls
        @Nullable
        protected String getDescription(@NotNull VcsPushUi dialog, boolean enabled) {
            return null;
        }

        @Override
        protected void actionPerformed(@NotNull Project project, @NotNull VcsPushUi dialog) {
            VcsPushDialog.this.push(false);
        }
    }

    private static class ComplexPushAction
    extends AbstractAction
    implements OptionAction {
        private final ActionWrapper myDefaultAction;
        private final List<? extends ActionWrapper> myOptions;

        private ComplexPushAction(@NotNull ActionWrapper defaultAction, @NotNull List<? extends ActionWrapper> additionalActions) {
            super(defaultAction.getName());
            this.myDefaultAction = defaultAction;
            this.myOptions = additionalActions;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myDefaultAction.actionPerformed(e);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            for (Action action : this.myOptions) {
                action.setEnabled(isEnabled);
            }
        }

        public Action @NotNull [] getOptions() {
            return this.myOptions.toArray(new ActionWrapper[0]);
        }
    }
}

