/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.model.ModelPatch;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsFacadeImpl
extends VcsFacade {
    @NotNull
    public static VcsFacadeImpl getVcsInstance() {
        return (VcsFacadeImpl)((Object)ServiceManager.getService(VcsFacade.class));
    }

    public boolean hasChanges(@NotNull PsiFile file) {
        Project project = file.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            Change change = ChangeListManager.getInstance((Project)project).getChange(virtualFile);
            return change != null;
        }
        return false;
    }

    public boolean hasChanges(@NotNull VirtualFile file, @NotNull Project project) {
        Collection changes = ChangeListManager.getInstance((Project)project).getChangesIn(file);
        for (Change change : changes) {
            if (change.getType() != Change.Type.NEW && change.getType() != Change.Type.MODIFICATION) continue;
            return true;
        }
        return false;
    }

    public Boolean isFileUnderVcs(@NotNull PsiFile psiFile) {
        return VcsUtil.isFileUnderVcs((Project)psiFile.getProject(), (FilePath)VcsUtil.getFilePath((VirtualFile)psiFile.getVirtualFile()));
    }

    @NotNull
    public Set<String> getVcsIgnoreFileNames(@NotNull Project project) {
        return VcsUtil.getVcsIgnoreFileNames((Project)project);
    }

    @NotNull
    public List<TextRange> getChangedTextRanges(@NotNull Project project, @NotNull PsiFile file) {
        ChangedRangesInfo helper = this.getChangedRangesInfo(file);
        return helper != null ? helper.allChangedRanges : new ArrayList();
    }

    @Nullable
    public ChangedRangesInfo getChangedRangesInfo(@NotNull PsiFile file) {
        CharSequence testContent;
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return null;
        }
        ChangedRangesInfo cachedChangedTextHelper = VcsFacadeImpl.getCachedChangedLines(project, document);
        if (cachedChangedTextHelper != null) {
            return cachedChangedTextHelper;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (testContent = (CharSequence)file.getUserData(TEST_REVISION_CONTENT)) != null) {
            return VcsFacadeImpl.calculateChangedRangesInfo(document, testContent);
        }
        Change change = ChangeListManager.getInstance((Project)project).getChange(file.getVirtualFile());
        if (change == null) {
            return null;
        }
        if (change.getType() == Change.Type.NEW) {
            TextRange fileRange = file.getTextRange();
            return new ChangedRangesInfo((List)ContainerUtil.newArrayList((Object[])new TextRange[]{fileRange}), null);
        }
        String contentFromVcs = VcsFacadeImpl.getRevisionedContentFrom(change);
        return contentFromVcs != null ? VcsFacadeImpl.calculateChangedRangesInfo(document, contentFromVcs) : null;
    }

    @NotNull
    public List<PsiFile> getChangedFilesFromDirs(@NotNull Project project, @NotNull List<? extends PsiDirectory> dirs) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        ArrayList changes = new ArrayList();
        for (PsiDirectory psiDirectory : dirs) {
            changes.addAll(changeListManager.getChangesIn(psiDirectory.getVirtualFile()));
        }
        return VcsFacadeImpl.getChangedFiles(project, changes);
    }

    @NotNull
    private static List<PsiFile> getChangedFiles(final @NotNull Project project, @NotNull Collection<? extends Change> changes) {
        Function<Change, PsiFile> changeToPsiFileMapper = new Function<Change, PsiFile>(){
            private final PsiManager myPsiManager;
            {
                this.myPsiManager = PsiManager.getInstance((Project)project);
            }

            public PsiFile fun(Change change) {
                VirtualFile vFile = change.getVirtualFile();
                return vFile != null ? this.myPsiManager.findFile(vFile) : null;
            }
        };
        return ContainerUtil.mapNotNull(changes, (Function)changeToPsiFileMapper);
    }

    @NotNull
    public <T extends PsiElement> List<T> getChangedElements(@NotNull Project project, Change @NotNull [] changes, @NotNull Function<? super VirtualFile, ? extends List<T>> elementsConvertor) {
        SmartList result2 = new SmartList();
        for (Change change : changes) {
            List elements;
            Document document;
            VirtualFile file;
            if (change.getType() == Change.Type.DELETED || !(change.getAfterRevision() instanceof CurrentContentRevision) || (file = ((CurrentContentRevision)change.getAfterRevision()).getVirtualFile()) == null || (document = FileDocumentManager.getInstance().getDocument(file)) == null) continue;
            List apply2 = (List)elementsConvertor.fun((Object)file);
            List list = elements = apply2 == null ? null : ContainerUtil.skipNulls((Collection)apply2);
            if (ContainerUtil.isEmpty((Collection)elements)) continue;
            BitSet changedLines = VcsFacadeImpl.getChangedLines(project, document, change);
            if (changedLines != null) {
                for (PsiElement element : elements) {
                    if (!VcsFacadeImpl.isElementChanged(element, document, changedLines)) continue;
                    result2.add(element);
                }
                continue;
            }
            result2.addAll(elements);
        }
        return result2;
    }

    @Nullable
    private static BitSet getChangedLines(@NotNull Project project, @NotNull Document document, @NotNull Change change) {
        if (change.getType() == Change.Type.NEW) {
            return null;
        }
        List<? extends Range> ranges = VcsFacadeImpl.getChangedRanges(project, document, change);
        if (ranges == null) {
            return null;
        }
        BitSet changedLines = new BitSet();
        for (Range range : ranges) {
            if (range.getType() == 3) {
                changedLines.set(Math.max(0, range.getLine1() - 1), range.getLine1() + 1);
                continue;
            }
            changedLines.set(range.getLine1(), range.getLine2());
        }
        return changedLines;
    }

    @Nullable
    private static List<? extends Range> getChangedRanges(@NotNull Project project, @NotNull Document document, @NotNull Change change) {
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document);
        if (tracker != null) {
            if (change instanceof ChangeListChange && tracker instanceof PartialLocalLineStatusTracker) {
                String changeListId = ((ChangeListChange)change).getChangeListId();
                List ranges = ((PartialLocalLineStatusTracker)tracker).getRanges();
                if (ranges != null) {
                    return ContainerUtil.filter((Collection)ranges, range -> range.getChangelistId().equals(changeListId));
                }
                return null;
            }
            return tracker.getRanges();
        }
        String contentFromVcs = VcsFacadeImpl.getRevisionedContentFrom(change);
        if (contentFromVcs != null) {
            return VcsFacadeImpl.getRanges(document, contentFromVcs);
        }
        return null;
    }

    private static boolean isElementChanged(@NotNull PsiElement element, @NotNull Document document, @NotNull BitSet changedLines) {
        TextRange textRange = element.getTextRange();
        int startLine = document.getLineNumber(textRange.getStartOffset());
        int endLine = textRange.isEmpty() ? startLine + 1 : document.getLineNumber(textRange.getEndOffset() - 1) + 1;
        int nextSetBit = changedLines.nextSetBit(startLine);
        return nextSetBit != -1 && nextSetBit < endLine;
    }

    @Nullable
    private static String getRevisionedContentFrom(@NotNull Change change) {
        ContentRevision revision = change.getBeforeRevision();
        if (revision == null) {
            return null;
        }
        try {
            return revision.getContent();
        }
        catch (VcsException e) {
            LOG.error("Can't get content for: " + change.getVirtualFile(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static ChangedRangesInfo getCachedChangedLines(@NotNull Project project, @NotNull Document document) {
        List ranges;
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document);
        if (tracker != null && (ranges = tracker.getRanges()) != null) {
            return VcsFacadeImpl.getChangedTextRanges(document, ranges);
        }
        return null;
    }

    @NotNull
    private static ChangedRangesInfo calculateChangedRangesInfo(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        return VcsFacadeImpl.getChangedTextRanges(document, VcsFacadeImpl.getRanges(document, contentFromVcs));
    }

    @NotNull
    private static List<Range> getRanges(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        return RangesBuilder.createRanges((CharSequence)document.getImmutableCharSequence(), (CharSequence)StringUtilRt.convertLineSeparators((CharSequence)contentFromVcs, (String)"\n"));
    }

    public int calculateChangedLinesNumber(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        List<Range> changedRanges = VcsFacadeImpl.getRanges(document, contentFromVcs);
        int linesChanges = 0;
        for (Range range : changedRanges) {
            int inserted = range.getLine2() - range.getLine1();
            int deleted = range.getVcsLine2() - range.getVcsLine1();
            linesChanges += Math.max(inserted, deleted);
        }
        return linesChanges;
    }

    @NotNull
    private static ChangedRangesInfo getChangedTextRanges(@NotNull Document document, @NotNull List<? extends Range> changedRanges) {
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        ArrayList<TextRange> insertedRanges = new ArrayList<TextRange>();
        for (Range range : changedRanges) {
            if (range.getType() == 3) continue;
            int changeStartLine = range.getLine1();
            int changeEndLine = range.getLine2();
            int lineStartOffset = document.getLineStartOffset(changeStartLine);
            int lineEndOffset = document.getLineEndOffset(changeEndLine - 1);
            TextRange changedTextRange = new TextRange(lineStartOffset, lineEndOffset);
            ranges.add(changedTextRange);
            if (range.getType() != 2) continue;
            insertedRanges.add(changedTextRange);
        }
        return new ChangedRangesInfo(ranges, insertedRanges);
    }

    public boolean isChangeNotTrackedForFile(@NotNull Project project, @NotNull PsiFile file) {
        boolean isUnderVcs = VcsUtil.isFileUnderVcs((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file.getVirtualFile()));
        if (!isUnderVcs) {
            return true;
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(project);
        List<VirtualFile> unversionedFiles = changeListManager.getUnversionedFiles();
        return unversionedFiles.contains(file.getVirtualFile());
    }

    public void runHeavyModificationTask(@NotNull Project project, @NotNull Document document, @NotNull Runnable o) {
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document);
        if (tracker != null) {
            tracker.doFrozen(o);
        } else {
            o.run();
        }
    }

    public void markFilesDirty(@NotNull Project project, @NotNull List<? extends VirtualFile> virtualFiles) {
        VcsFileUtil.markFilesDirty(project, virtualFiles);
    }

    public JComponent createPatchPreviewComponent(@NotNull Project project, @NotNull ModelPatch patch) {
        List changes = EntryStream.of((Map)patch.getBranchChanges()).mapKeyValue((file, content2) -> {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
            CurrentContentRevision current = new CurrentContentRevision(filePath);
            SimpleContentRevision changed = new SimpleContentRevision(content2.toString(), filePath, VcsBundle.message((String)"patched.version.name", (Object[])new Object[0]));
            return new Change((ContentRevision)current, (ContentRevision)changed);
        }).toList();
        return new SimpleChangesBrowser(project, changes);
    }
}

