/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.support.discovery;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.internal.impldep.org.junit.platform.commons.support.ReflectionSupport;
import org.gradle.internal.impldep.org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.gradle.internal.impldep.org.junit.platform.engine.discovery.DiscoverySelectors;
import org.gradle.internal.impldep.org.junit.platform.engine.discovery.ModuleSelector;
import org.gradle.internal.impldep.org.junit.platform.engine.discovery.PackageSelector;
import org.gradle.internal.impldep.org.junit.platform.engine.support.discovery.SelectorResolver;

class ClassContainerSelectorResolver
implements SelectorResolver {
    private final Predicate<Class<?>> classFilter;
    private final Predicate<String> classNameFilter;

    ClassContainerSelectorResolver(Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        this.classFilter = classFilter;
        this.classNameFilter = classNameFilter;
    }

    @Override
    public SelectorResolver.Resolution resolve(ClasspathRootSelector selector, SelectorResolver.Context context) {
        return this.classSelectors(ReflectionSupport.findAllClassesInClasspathRoot(selector.getClasspathRoot(), this.classFilter, this.classNameFilter));
    }

    @Override
    public SelectorResolver.Resolution resolve(ModuleSelector selector, SelectorResolver.Context context) {
        return this.classSelectors(ReflectionSupport.findAllClassesInModule(selector.getModuleName(), this.classFilter, this.classNameFilter));
    }

    @Override
    public SelectorResolver.Resolution resolve(PackageSelector selector, SelectorResolver.Context context) {
        return this.classSelectors(ReflectionSupport.findAllClassesInPackage(selector.getPackageName(), this.classFilter, this.classNameFilter));
    }

    private SelectorResolver.Resolution classSelectors(List<Class<?>> classes) {
        if (classes.isEmpty()) {
            return SelectorResolver.Resolution.unresolved();
        }
        return SelectorResolver.Resolution.selectors(classes.stream().map(DiscoverySelectors::selectClass).collect(Collectors.toSet()));
    }
}

