/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.MissingObjectException;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.BitmapIndex;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.NullProgressMonitor;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.BitmapCalculator;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.ReachabilityChecker;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;

class BitmappedReachabilityChecker
implements ReachabilityChecker {
    private final RevWalk walk;

    public BitmappedReachabilityChecker(RevWalk walk) throws IOException {
        this.walk = walk;
        if (walk.getObjectReader().getBitmapIndex() == null) {
            throw new AssertionError((Object)"Trying to use bitmapped reachability check on a repository without bitmaps");
        }
    }

    @Override
    public Optional<RevCommit> areAllReachable(Collection<RevCommit> targets, Collection<RevCommit> starters) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        BitmapCalculator calculator = new BitmapCalculator(this.walk);
        ArrayList<RevCommit> remainingTargets = new ArrayList<RevCommit>(targets);
        for (RevCommit starter : starters) {
            BitmapIndex.BitmapBuilder starterBitmap = calculator.getBitmap(starter, NullProgressMonitor.INSTANCE);
            remainingTargets.removeIf(starterBitmap::contains);
            if (!remainingTargets.isEmpty()) continue;
            return Optional.empty();
        }
        return Optional.of((RevCommit)remainingTargets.get(0));
    }
}

