/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.lib.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.internal.impldep.org.bouncycastle.gpg.SExprParser;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.BlobType;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.KeyBlob;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.KeyBox;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.KeyInformation;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.PublicKeyRingBlob;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.UserID;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.jcajce.JcaKeyBox;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.jcajce.JcaKeyBoxBuilder;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPSecretKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPUtil;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.JcePBEProtectionRemoverFactory;
import org.gradle.internal.impldep.org.bouncycastle.util.encoders.Hex;
import org.gradle.internal.impldep.org.eclipse.jgit.annotations.NonNull;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.CanceledException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.internal.BouncyCastleGpgKey;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.internal.BouncyCastleGpgKeyPassphrasePrompt;
import org.gradle.internal.impldep.org.eclipse.jgit.util.FS;
import org.gradle.internal.impldep.org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BouncyCastleGpgKeyLocator {
    private static final Logger log = LoggerFactory.getLogger(BouncyCastleGpgKeyLocator.class);
    private static final Path GPG_DIRECTORY = BouncyCastleGpgKeyLocator.findGpgDirectory();
    private static final Path USER_KEYBOX_PATH = GPG_DIRECTORY.resolve("pubring.kbx");
    private static final Path USER_SECRET_KEY_DIR = GPG_DIRECTORY.resolve("private-keys-v1.d");
    private static final Path USER_PGP_PUBRING_FILE = GPG_DIRECTORY.resolve("pubring.gpg");
    private static final Path USER_PGP_LEGACY_SECRING_FILE = GPG_DIRECTORY.resolve("secring.gpg");
    private final String signingKey;
    private BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt;

    private static Path findGpgDirectory() {
        File home;
        String appData;
        SystemReader system = SystemReader.getInstance();
        if (system.isWindows() && (appData = system.getenv("APPDATA")) != null && !appData.isEmpty()) {
            try {
                Path directory = Paths.get(appData, new String[0]).resolve("gnupg");
                if (Files.isDirectory(directory, new LinkOption[0])) {
                    return directory;
                }
            }
            catch (SecurityException | InvalidPathException runtimeException) {
                // empty catch block
            }
        }
        if ((home = FS.DETECTED.userHome()) == null) {
            home = new File(".").getAbsoluteFile();
        }
        return home.toPath().resolve(".gnupg");
    }

    public BouncyCastleGpgKeyLocator(String signingKey, @NonNull BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt) {
        this.signingKey = signingKey;
        this.passphrasePrompt = passphrasePrompt;
    }

    private PGPSecretKey attemptParseSecretKey(Path keyFile, PGPDigestCalculatorProvider calculatorProvider, PBEProtectionRemoverFactory passphraseProvider, PGPPublicKey publicKey) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream in = Files.newInputStream(keyFile, new OpenOption[0]);){
                return new SExprParser(calculatorProvider).parseSecretKey((InputStream)new BufferedInputStream(in), passphraseProvider, publicKey);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassCastException | PGPException e) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring unreadable file '{}': {}", new Object[]{keyFile, e.getMessage(), e});
            }
            return null;
        }
    }

    private boolean containsSigningKey(String userId) {
        return userId.toLowerCase(Locale.ROOT).contains(this.signingKey.toLowerCase(Locale.ROOT));
    }

    private PGPPublicKey findPublicKeyByKeyId(KeyBlob keyBlob) throws IOException {
        String keyId = this.signingKey.toLowerCase(Locale.ROOT);
        for (KeyInformation keyInfo : keyBlob.getKeyInformation()) {
            String fingerprint = Hex.toHexString(keyInfo.getFingerprint()).toLowerCase(Locale.ROOT);
            if (!fingerprint.endsWith(keyId)) continue;
            return this.getFirstPublicKey(keyBlob);
        }
        return null;
    }

    private PGPPublicKey findPublicKeyByUserId(KeyBlob keyBlob) throws IOException {
        for (UserID userID : keyBlob.getUserIds()) {
            if (!this.containsSigningKey(userID.getUserIDAsString())) continue;
            return this.getFirstPublicKey(keyBlob);
        }
        return null;
    }

    private PGPPublicKey findPublicKeyInKeyBox(Path keyboxFile) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, NoOpenPgpKeyException {
        KeyBox keyBox = this.readKeyBoxFile(keyboxFile);
        boolean hasOpenPgpKey = false;
        for (KeyBlob keyBlob : keyBox.getKeyBlobs()) {
            if (keyBlob.getType() != BlobType.OPEN_PGP_BLOB) continue;
            hasOpenPgpKey = true;
            PGPPublicKey key = this.findPublicKeyByKeyId(keyBlob);
            if (key != null) {
                return key;
            }
            key = this.findPublicKeyByUserId(keyBlob);
            if (key == null) continue;
            return key;
        }
        if (!hasOpenPgpKey) {
            throw new NoOpenPgpKeyException();
        }
        return null;
    }

    @NonNull
    public BouncyCastleGpgKey findSecretKey() throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        BouncyCastleGpgKey key;
        PGPPublicKey publicKey = null;
        if (this.hasKeyFiles(USER_SECRET_KEY_DIR)) {
            block12: {
                if (Files.exists(USER_KEYBOX_PATH, new LinkOption[0])) {
                    try {
                        publicKey = this.findPublicKeyInKeyBox(USER_KEYBOX_PATH);
                        if (publicKey != null) {
                            BouncyCastleGpgKey key2 = this.findSecretKeyForKeyBoxPublicKey(publicKey, USER_KEYBOX_PATH);
                            if (key2 != null) {
                                return key2;
                            }
                            throw new PGPException(MessageFormat.format(JGitText.get().gpgNoSecretKeyForPublicKey, Long.toHexString(publicKey.getKeyID())));
                        }
                        throw new PGPException(MessageFormat.format(JGitText.get().gpgNoPublicKeyFound, this.signingKey));
                    }
                    catch (NoOpenPgpKeyException e) {
                        if (!log.isDebugEnabled()) break block12;
                        log.debug("{} does not contain any OpenPGP keys", (Object)USER_KEYBOX_PATH);
                    }
                }
            }
            if (Files.exists(USER_PGP_PUBRING_FILE, new LinkOption[0]) && (publicKey = this.findPublicKeyInPubring(USER_PGP_PUBRING_FILE)) != null && (key = this.findSecretKeyForKeyBoxPublicKey(publicKey, USER_PGP_PUBRING_FILE)) != null) {
                return key;
            }
            if (publicKey == null) {
                throw new PGPException(MessageFormat.format(JGitText.get().gpgNoPublicKeyFound, this.signingKey));
            }
        }
        boolean hasSecring = false;
        if (Files.exists(USER_PGP_LEGACY_SECRING_FILE, new LinkOption[0])) {
            hasSecring = true;
            key = this.loadKeyFromSecring(USER_PGP_LEGACY_SECRING_FILE);
            if (key != null) {
                return key;
            }
        }
        if (publicKey != null) {
            throw new PGPException(MessageFormat.format(JGitText.get().gpgNoSecretKeyForPublicKey, Long.toHexString(publicKey.getKeyID())));
        }
        if (hasSecring) {
            throw new PGPException(MessageFormat.format(JGitText.get().gpgNoKeyInLegacySecring, this.signingKey));
        }
        throw new PGPException(JGitText.get().gpgNoKeyring);
    }

    private boolean hasKeyFiles(Path dir2) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DirectoryStream<Path> contents = Files.newDirectoryStream(dir2, "*.key");){
                return contents.iterator().hasNext();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    private BouncyCastleGpgKey loadKeyFromSecring(Path secring) throws IOException, PGPException {
        PGPSecretKey secretKey = this.findSecretKeyInLegacySecring(this.signingKey, secring);
        if (secretKey != null) {
            if (!secretKey.isSigningKey()) {
                throw new PGPException(MessageFormat.format(JGitText.get().gpgNotASigningKey, this.signingKey));
            }
            return new BouncyCastleGpgKey(secretKey, secring);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BouncyCastleGpgKey findSecretKeyForKeyBoxPublicKey(PGPPublicKey publicKey, Path userKeyboxPath) throws PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        PGPDigestCalculatorProvider calculatorProvider = new JcaPGPDigestCalculatorProviderBuilder().build();
        JcePBEProtectionRemoverFactory passphraseProvider = new JcePBEProtectionRemoverFactory(this.passphrasePrompt.getPassphrase(publicKey.getFingerprint(), userKeyboxPath));
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (Stream<Path> keyFiles = Files.walk(USER_SECRET_KEY_DIR, new FileVisitOption[0]);){
                Path keyFile;
                PGPSecretKey secretKey;
                Iterator iterator = keyFiles.filter(path -> Files.isRegularFile(path, new LinkOption[0])).collect(Collectors.toList()).iterator();
                do {
                    if (iterator.hasNext()) continue;
                    this.passphrasePrompt.clear();
                    return null;
                } while ((secretKey = this.attemptParseSecretKey(keyFile = (Path)iterator.next(), calculatorProvider, passphraseProvider, publicKey)) == null);
                if (secretKey.isSigningKey()) return new BouncyCastleGpgKey(secretKey, userKeyboxPath);
                throw new PGPException(MessageFormat.format(JGitText.get().gpgNotASigningKey, this.signingKey));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (RuntimeException e) {
            this.passphrasePrompt.clear();
            throw e;
        }
        catch (IOException e) {
            this.passphrasePrompt.clear();
            throw new PGPException(MessageFormat.format(JGitText.get().gpgFailedToParseSecretKey, USER_SECRET_KEY_DIR.toAbsolutePath()), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private PGPSecretKey findSecretKeyInLegacySecring(String signingkey, Path secringFile) throws IOException, PGPException {
        var3_3 = null;
        var4_5 = null;
        try {
            in = Files.newInputStream(secringFile, new OpenOption[0]);
            try {
                pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(new BufferedInputStream(in)), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                keyId = signingkey.toLowerCase(Locale.ROOT);
                keyrings = pgpSec.getKeyRings();
                while (true) {
                    keyRing = keyrings.next();
                    keys = keyRing.getSecretKeys();
                    while (keys.hasNext()) {
                        key = keys.next();
                        fingerprint = Hex.toHexString(key.getPublicKey().getFingerprint()).toLowerCase(Locale.ROOT);
                        if (fingerprint.endsWith(keyId)) {
                            return key;
                        }
                        userIDs = key.getUserIDs();
                        while (userIDs.hasNext()) {
                            userId = userIDs.next();
                            if (!this.containsSigningKey(userId)) continue;
                            return key;
                        }
                    }
                    break;
                }
            }
            finally {
                if (keyrings.hasNext()) ** continue;
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
            } else if (var3_3 != var4_6) {
                var3_3.addSuppressed(var4_6);
            }
            throw var3_3;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private PGPPublicKey findPublicKeyInPubring(Path pubringFile) throws IOException, PGPException {
        var2_2 = null;
        var3_4 = null;
        try {
            in = Files.newInputStream(pubringFile, new OpenOption[0]);
            try {
                pgpPub = new PGPPublicKeyRingCollection(new BufferedInputStream(in), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                keyId = this.signingKey.toLowerCase(Locale.ROOT);
                keyrings = pgpPub.getKeyRings();
                while (true) {
                    keyRing = keyrings.next();
                    keys = keyRing.getPublicKeys();
                    while (keys.hasNext()) {
                        key = keys.next();
                        fingerprint = Hex.toHexString(key.getFingerprint()).toLowerCase(Locale.ROOT);
                        if (fingerprint.endsWith(keyId)) {
                            return key;
                        }
                        userIDs = key.getUserIDs();
                        while (userIDs.hasNext()) {
                            userId = userIDs.next();
                            if (!this.containsSigningKey(userId)) continue;
                            return key;
                        }
                    }
                    break;
                }
            }
            finally {
                if (keyrings.hasNext()) ** continue;
            }
        }
        catch (Throwable var3_5) {
            if (var2_2 == null) {
                var2_2 = var3_5;
            } else if (var2_2 != var3_5) {
                var2_2.addSuppressed(var3_5);
            }
            throw var2_2;
        }
        return null;
    }

    private PGPPublicKey getFirstPublicKey(KeyBlob keyBlob) throws IOException {
        return ((PublicKeyRingBlob)keyBlob).getPGPPublicKeyRing().getPublicKey();
    }

    private KeyBox readKeyBoxFile(Path keyboxFile) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, NoOpenPgpKeyException {
        JcaKeyBox keyBox;
        if (keyboxFile.toFile().length() == 0L) {
            throw new NoOpenPgpKeyException();
        }
        Throwable throwable = null;
        Object var4_4 = null;
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(keyboxFile, new OpenOption[0]));){
            keyBox = new JcaKeyBoxBuilder().build(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return keyBox;
    }

    private static class NoOpenPgpKeyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private NoOpenPgpKeyException() {
        }
    }
}

