/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.core.resolve;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Configuration;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleId;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.IvyNode;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveData;

public class IvyNodeCallers {
    private Map callersByRootConf = new HashMap();
    private Map allCallers = new HashMap();
    private IvyNode node;

    public IvyNodeCallers(IvyNode node) {
        this.node = node;
    }

    public void addCaller(String rootModuleConf, IvyNode callerNode, String callerConf, String requestedConf, String[] dependencyConfs, DependencyDescriptor dd) {
        Caller caller;
        ModuleDescriptor md = callerNode.getDescriptor();
        ModuleRevisionId mrid = callerNode.getResolvedId();
        if (mrid.getModuleId().equals(this.node.getId().getModuleId())) {
            throw new IllegalArgumentException("a module is not authorized to depend on itself: " + this.node.getId());
        }
        HashMap<ModuleRevisionId, Caller> callers = (HashMap<ModuleRevisionId, Caller>)this.callersByRootConf.get(rootModuleConf);
        if (callers == null) {
            callers = new HashMap<ModuleRevisionId, Caller>();
            this.callersByRootConf.put(rootModuleConf, callers);
        }
        if ((caller = (Caller)callers.get(mrid)) == null) {
            caller = new Caller(md, mrid, dd, callerNode.canExclude(rootModuleConf));
            callers.put(mrid, caller);
        }
        caller.addConfiguration(requestedConf, dependencyConfs);
        IvyNode parent = callerNode.getRealNode();
        Iterator iter = parent.getAllCallersModuleIds().iterator();
        while (iter.hasNext()) {
            ModuleId mid = (ModuleId)iter.next();
            this.allCallers.put(mid, parent);
        }
        this.allCallers.put(mrid.getModuleId(), callerNode);
    }

    void removeCaller(String rootModuleConf, ModuleRevisionId callerMrid) {
        this.allCallers.remove(callerMrid.getModuleId());
        Map callers = (Map)this.callersByRootConf.get(rootModuleConf);
        if (callers != null) {
            callers.remove(callerMrid);
        }
    }

    public Caller[] getCallers(String rootModuleConf) {
        Map callers = (Map)this.callersByRootConf.get(rootModuleConf);
        if (callers == null) {
            return new Caller[0];
        }
        return callers.values().toArray(new Caller[callers.values().size()]);
    }

    public Caller[] getAllCallers() {
        HashSet all = new HashSet();
        Iterator iter = this.callersByRootConf.values().iterator();
        while (iter.hasNext()) {
            Map callers = (Map)iter.next();
            all.addAll(callers.values());
        }
        return all.toArray(new Caller[all.size()]);
    }

    public Caller[] getAllRealCallers() {
        HashSet<Caller> all = new HashSet<Caller>();
        Iterator iter = this.callersByRootConf.values().iterator();
        while (iter.hasNext()) {
            Map callers = (Map)iter.next();
            Iterator iterator = callers.values().iterator();
            while (iterator.hasNext()) {
                Caller c = (Caller)iterator.next();
                if (!c.isRealCaller()) continue;
                all.add(c);
            }
        }
        return all.toArray(new Caller[all.size()]);
    }

    public Collection getAllCallersModuleIds() {
        return this.allCallers.keySet();
    }

    void updateFrom(IvyNodeCallers callers, String rootModuleConf, boolean real) {
        Map nodecallers = (Map)callers.callersByRootConf.get(rootModuleConf);
        if (nodecallers != null) {
            HashMap<ModuleRevisionId, Caller> thiscallers = (HashMap<ModuleRevisionId, Caller>)this.callersByRootConf.get(rootModuleConf);
            if (thiscallers == null) {
                thiscallers = new HashMap<ModuleRevisionId, Caller>();
                this.callersByRootConf.put(rootModuleConf, thiscallers);
            }
            Iterator iter = nodecallers.values().iterator();
            while (iter.hasNext()) {
                Caller caller = (Caller)iter.next();
                if (thiscallers.containsKey(caller.getModuleRevisionId())) continue;
                if (!real) {
                    caller.setRealCaller(false);
                }
                thiscallers.put(caller.getModuleRevisionId(), caller);
            }
        }
    }

    public IvyNode getDirectCallerFor(ModuleId from) {
        return (IvyNode)this.allCallers.get(from);
    }

    boolean doesCallersExclude(String rootModuleConf, Artifact artifact) {
        return this.doesCallersExclude(rootModuleConf, artifact, new Stack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doesCallersExclude(String rootModuleConf, Artifact artifact, Stack callersStack) {
        callersStack.push(this.node.getId());
        try {
            Caller[] callers = this.getCallers(rootModuleConf);
            if (callers.length == 0) {
                boolean bl = false;
                return bl;
            }
            boolean allUnconclusive = true;
            for (int i = 0; i < callers.length; ++i) {
                if (!callers[i].canExclude()) {
                    boolean bl = false;
                    return bl;
                }
                ModuleDescriptor md = callers[i].getModuleDescriptor();
                Boolean doesExclude = this.node.doesExclude(md, rootModuleConf, callers[i].getCallerConfigurations(), callers[i].getDependencyDescriptor(), artifact, callersStack);
                if (doesExclude == null) continue;
                if (!doesExclude.booleanValue()) {
                    boolean bl = false;
                    return bl;
                }
                allUnconclusive = false;
            }
            boolean bl = !allUnconclusive;
            return bl;
        }
        finally {
            callersStack.pop();
        }
    }

    public static class Caller {
        private ModuleDescriptor md;
        private ModuleRevisionId mrid;
        private Map confs = new HashMap();
        private DependencyDescriptor dd;
        private boolean callerCanExclude;
        private boolean real = true;

        public Caller(ModuleDescriptor md, ModuleRevisionId mrid, DependencyDescriptor dd, boolean callerCanExclude) {
            this.md = md;
            this.mrid = mrid;
            this.dd = dd;
            this.callerCanExclude = callerCanExclude;
        }

        public void addConfiguration(String callerConf, String[] dependencyConfs) {
            String[] confExtends;
            this.updateConfs(callerConf, dependencyConfs);
            Configuration conf = this.md.getConfiguration(callerConf);
            if (conf != null && (confExtends = conf.getExtends()) != null) {
                for (int i = 0; i < confExtends.length; ++i) {
                    this.addConfiguration(confExtends[i], dependencyConfs);
                }
            }
        }

        private void updateConfs(String callerConf, String[] dependencyConfs) {
            String[] prevDepConfs = (String[])this.confs.get(callerConf);
            if (prevDepConfs != null) {
                HashSet<String> newDepConfs = new HashSet<String>(Arrays.asList(prevDepConfs));
                newDepConfs.addAll(Arrays.asList(dependencyConfs));
                this.confs.put(callerConf, newDepConfs.toArray(new String[newDepConfs.size()]));
            } else {
                this.confs.put(callerConf, dependencyConfs);
            }
        }

        public String[] getCallerConfigurations() {
            return this.confs.keySet().toArray(new String[this.confs.keySet().size()]);
        }

        public ModuleRevisionId getModuleRevisionId() {
            return this.mrid;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Caller)) {
                return false;
            }
            Caller other = (Caller)obj;
            return ((Object)other.confs).equals(this.confs) && this.mrid.equals(other.mrid);
        }

        public int hashCode() {
            int hash = 31;
            hash = hash * 13 + ((Object)this.confs).hashCode();
            hash = hash * 13 + this.mrid.hashCode();
            return hash;
        }

        public String toString() {
            return this.mrid.toString();
        }

        public ModuleRevisionId getAskedDependencyId(ResolveData resolveData) {
            return this.dd.getDependencyRevisionId();
        }

        public ModuleDescriptor getModuleDescriptor() {
            return this.md;
        }

        public boolean canExclude() {
            return this.callerCanExclude || this.md.canExclude() || this.dd.canExclude();
        }

        public DependencyDescriptor getDependencyDescriptor() {
            return this.dd;
        }

        public void setRealCaller(boolean b) {
            this.real = b;
        }

        public boolean isRealCaller() {
            return this.real;
        }
    }
}

