/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.util.Collection;
import java.util.Iterator;

public final class StringUtil {
    private static final String[] padding = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          "};

    public static String join(Collection strings, String sep) {
        return StringUtil.join(strings.iterator(), sep);
    }

    public static String join(Iterator strings, String sep) {
        if (!strings.hasNext()) {
            return "";
        }
        String start = strings.next().toString();
        if (!strings.hasNext()) {
            return start;
        }
        StringBuilder sb = new StringBuilder(64).append(start);
        while (strings.hasNext()) {
            sb.append(sep);
            sb.append(strings.next());
        }
        return sb.toString();
    }

    public static String padding(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (width < padding.length) {
            return padding[width];
        }
        char[] out = new char[width];
        for (int i = 0; i < width; ++i) {
            out[i] = 32;
        }
        return String.valueOf(out);
    }

    public static boolean isBlank(String string2) {
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        int l = string2.length();
        for (int i = 0; i < l; ++i) {
            if (StringUtil.isWhitespace(string2.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string2) {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        int l = string2.length();
        for (int i = 0; i < l; ++i) {
            if (Character.isDigit(string2.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13;
    }

    public static String normaliseWhitespace(String string2) {
        StringBuilder sb = new StringBuilder(string2.length());
        boolean lastWasWhite = false;
        boolean modified = false;
        int l = string2.length();
        for (int i = 0; i < l; ++i) {
            int c = string2.codePointAt(i);
            if (StringUtil.isWhitespace(c)) {
                if (lastWasWhite) {
                    modified = true;
                    continue;
                }
                if (c != 32) {
                    modified = true;
                }
                sb.append(' ');
                lastWasWhite = true;
                continue;
            }
            sb.appendCodePoint(c);
            lastWasWhite = false;
        }
        return modified ? sb.toString() : string2;
    }

    public static boolean in(String needle, String ... haystack) {
        for (String hay : haystack) {
            if (!hay.equals(needle)) continue;
            return true;
        }
        return false;
    }
}

