/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.validator.accessibility;

import com.android.tools.idea.validator.ValidatorResult;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

public class AtfBufferedImage
implements Image {
    private final BufferedImage mBufferedImage;
    private final ValidatorResult.Metric mMetric;
    private final int mLeft;
    private final int mTop;
    private final int mWidth;
    private final int mHeight;

    AtfBufferedImage(BufferedImage image, ValidatorResult.Metric metric) {
        assert (image.getType() == 2);
        this.mBufferedImage = image;
        this.mMetric = metric;
        this.mWidth = this.mBufferedImage.getWidth();
        this.mHeight = this.mBufferedImage.getHeight();
        this.mLeft = 0;
        this.mTop = 0;
    }

    private AtfBufferedImage(BufferedImage image, ValidatorResult.Metric metric, int left, int top, int width, int height) {
        this.mBufferedImage = image;
        this.mMetric = metric;
        this.mLeft = left;
        this.mTop = top;
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public Image crop(int left, int top, int width, int height) {
        return new AtfBufferedImage(this.mBufferedImage, this.mMetric, left, top, width, height);
    }

    @Override
    public int[] getPixels() {
        BufferedImage cropped = this.mBufferedImage.getSubimage(this.mLeft, this.mTop, this.mWidth, this.mHeight);
        WritableRaster raster = cropped.copyData(cropped.getRaster().createCompatibleWritableRaster());
        int[] toReturn = ((DataBufferInt)raster.getDataBuffer()).getData();
        this.mMetric.mImageMemoryBytes += (long)(toReturn.length * 4);
        return toReturn;
    }
}

