/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.validator.accessibility;

import android.view.View;
import com.android.tools.idea.validator.ValidatorData;
import com.android.tools.idea.validator.ValidatorResult;
import com.android.tools.idea.validator.accessibility.AtfBufferedImage;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckPreset;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchyAndroid;
import com.google.common.collect.BiMap;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class AccessibilityValidator {
    public static ValidatorResult validateAccessibility(View view, BufferedImage image, ValidatorData.Policy policy) {
        EnumSet<ValidatorData.Level> filter = policy.mLevels;
        ValidatorResult.Builder builder = new ValidatorResult.Builder();
        builder.mMetric.startTimer();
        if (!policy.mTypes.contains((Object)ValidatorData.Type.ACCESSIBILITY)) {
            return builder.build();
        }
        List<AccessibilityHierarchyCheckResult> results = AccessibilityValidator.getHierarchyCheckResults(builder.mMetric, view, builder.mSrcMap, image, policy.mChecks);
        for (AccessibilityHierarchyCheckResult result : results) {
            String category = AccessibilityValidator.getCheckClassCategory(result.getSourceCheckClass());
            ValidatorData.Level level = AccessibilityValidator.convertLevel(result.getType());
            if (!filter.contains((Object)level)) continue;
            try {
                AccessibilityHierarchyCheck subclass;
                ValidatorData.Issue.IssueBuilder issueBuilder = new ValidatorData.Issue.IssueBuilder().setCategory(category).setMsg(result.getMessage(Locale.ENGLISH).toString()).setLevel(level).setFix(AccessibilityValidator.generateFix(result)).setSourceClass(result.getSourceCheckClass().getSimpleName());
                if (result.getElement() != null) {
                    issueBuilder.setSrcId(result.getElement().getCondensedUniqueId());
                }
                if ((subclass = AccessibilityCheckPreset.getHierarchyCheckForClass(result.getSourceCheckClass().asSubclass(AccessibilityHierarchyCheck.class))) != null) {
                    issueBuilder.setHelpfulUrl(subclass.getHelpUrl());
                }
                builder.mIssues.add(issueBuilder.build());
            }
            catch (Exception e) {
                builder.mIssues.add(new ValidatorData.Issue.IssueBuilder().setCategory(category).setType(ValidatorData.Type.INTERNAL_ERROR).setMsg(e.getMessage()).setLevel(ValidatorData.Level.ERROR).setSourceClass("AccessibilityValidator").build());
            }
        }
        builder.mMetric.endTimer();
        return builder.build();
    }

    private static String getCheckClassCategory(Class<?> checkClass) {
        try {
            Class<AccessibilityHierarchyCheck> subClass = checkClass.asSubclass(AccessibilityHierarchyCheck.class);
            AccessibilityHierarchyCheck check = AccessibilityCheckPreset.getHierarchyCheckForClass(subClass);
            return check == null ? "Accessibility" : check.getCategory().name();
        }
        catch (ClassCastException e) {
            return "Accessibility";
        }
    }

    private static ValidatorData.Level convertLevel(AccessibilityCheckResult.AccessibilityCheckResultType type) {
        switch (type) {
            case ERROR: {
                return ValidatorData.Level.ERROR;
            }
            case WARNING: {
                return ValidatorData.Level.WARNING;
            }
            case INFO: {
                return ValidatorData.Level.INFO;
            }
        }
        return ValidatorData.Level.VERBOSE;
    }

    private static ValidatorData.Fix generateFix(AccessibilityHierarchyCheckResult result) {
        return new ValidatorData.Fix("");
    }

    private static List<AccessibilityHierarchyCheckResult> getHierarchyCheckResults(ValidatorResult.Metric metric, View view, BiMap<Long, View> originMap, BufferedImage image, HashSet<AccessibilityHierarchyCheck> policyChecks) {
        HashSet<AccessibilityHierarchyCheck> checks = policyChecks.isEmpty() ? AccessibilityCheckPreset.getAccessibilityHierarchyChecksForPreset(AccessibilityCheckPreset.LATEST) : policyChecks;
        AccessibilityHierarchyAndroid hierarchy = AccessibilityHierarchyAndroid.newBuilder(view).setViewOriginMap(originMap).build();
        ArrayList<AccessibilityHierarchyCheckResult> a11yResults = new ArrayList<AccessibilityHierarchyCheckResult>();
        Parameters parameters = null;
        if (image != null) {
            parameters = new Parameters();
            parameters.putScreenCapture(new AtfBufferedImage(image, metric));
        }
        for (AccessibilityHierarchyCheck check : checks) {
            a11yResults.addAll(check.runCheckOnHierarchy(hierarchy, null, parameters));
        }
        return a11yResults;
    }

    static {
        StringManager.setResourceBundleProvider(locale -> ResourceBundle.getBundle("strings"));
    }
}

