/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.validator;

import android.view.View;
import com.android.tools.idea.validator.ValidatorData;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.List;

public class ValidatorResult {
    private final ImmutableBiMap<Long, View> mSrcMap;
    private final ArrayList<ValidatorData.Issue> mIssues;
    private final Metric mMetric;

    private ValidatorResult(BiMap<Long, View> srcMap, ArrayList<ValidatorData.Issue> issues, Metric metric) {
        this.mSrcMap = ImmutableBiMap.builder().putAll(srcMap).build();
        this.mIssues = issues;
        this.mMetric = metric;
    }

    public ImmutableBiMap<Long, View> getSrcMap() {
        return this.mSrcMap;
    }

    public List<ValidatorData.Issue> getIssues() {
        return this.mIssues;
    }

    public Metric getMetric() {
        return this.mMetric;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("Result containing ").append(this.mIssues.size()).append(" issues:\n");
        for (ValidatorData.Issue issue : this.mIssues) {
            if (issue.mLevel != ValidatorData.Level.ERROR) continue;
            builder.append(" - [").append(issue.mLevel.name()).append("] ").append(issue.mMsg).append("\n");
        }
        return builder.toString();
    }

    public static class Metric {
        public String mErrorMessage = null;
        public long mElapsedMs = 0L;
        public long mImageMemoryBytes = 0L;
        private long mStart;

        private Metric() {
        }

        public void startTimer() {
            this.mStart = System.currentTimeMillis();
        }

        public void endTimer() {
            this.mElapsedMs = System.currentTimeMillis() - this.mStart;
        }

        public String toString() {
            return "Validation result metric: { elapsed=" + this.mElapsedMs + "ms, image memory=" + this.readableBytes() + " }";
        }

        private String readableBytes() {
            if (this.mImageMemoryBytes > 1000000000L) {
                return this.mImageMemoryBytes / 1000000000L + "gb";
            }
            if (this.mImageMemoryBytes > 1000000L) {
                return this.mImageMemoryBytes / 1000000L + "mb";
            }
            if (this.mImageMemoryBytes > 1000L) {
                return this.mImageMemoryBytes / 1000L + "kb";
            }
            return this.mImageMemoryBytes + "bytes";
        }
    }

    public static class Builder {
        public final BiMap<Long, View> mSrcMap = HashBiMap.create();
        public final ArrayList<ValidatorData.Issue> mIssues = new ArrayList();
        public final Metric mMetric = new Metric();

        public ValidatorResult build() {
            return new ValidatorResult(this.mSrcMap, this.mIssues, this.mMetric);
        }
    }
}

