/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ReflectionUtils {
    public static Method getMethod(Class<?> clazz, String name, Class<?> ... params) throws ReflectionException {
        try {
            return clazz.getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    public static Method getAccessibleMethod(Class<?> clazz, String name, Class<?> ... params) throws ReflectionException {
        Method method = ReflectionUtils.getMethod(clazz, name, params);
        method.setAccessible(true);
        return method;
    }

    public static Object invoke(Method method, Object object, Object ... args) throws ReflectionException {
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            ReflectiveOperationException ex = e;
            throw new ReflectionException(ex);
        }
    }

    public static boolean isInstanceOf(Object object, String className) {
        for (Class<?> superClass = object.getClass(); superClass != null; superClass = superClass.getSuperclass()) {
            String name = superClass.getName();
            if (!name.equals(className)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstanceOf(Object object, String[] classNames) {
        return ReflectionUtils.getParentClass(object, classNames) != null;
    }

    public static String getParentClass(Object object, String[] classNames) {
        for (Class<?> superClass = object.getClass(); superClass != null; superClass = superClass.getSuperclass()) {
            String name = superClass.getName();
            for (String className : classNames) {
                if (!name.equals(className)) continue;
                return className;
            }
        }
        return null;
    }

    public static Throwable getCause(Throwable throwable) {
        Throwable cause = throwable.getCause();
        return cause == null ? throwable : cause;
    }

    public static Class<?> getClassInstance(Object object, String className) {
        for (Class<?> superClass = object.getClass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!className.equals(superClass.getName())) continue;
            return superClass;
        }
        throw new RuntimeException("invalid object/classname combination.");
    }

    public static <T> T createProxy(Class<T> interfaze) {
        ClassLoader loader = interfaze.getClassLoader();
        return (T)Proxy.newProxyInstance(loader, new Class[]{interfaze}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method m, Object[] args) {
                Class<?> returnType = m.getReturnType();
                if (returnType == Boolean.TYPE) {
                    return false;
                }
                if (returnType == Integer.TYPE) {
                    return 0;
                }
                if (returnType == Long.TYPE) {
                    return 0L;
                }
                if (returnType == Short.TYPE) {
                    return 0;
                }
                if (returnType == Character.TYPE) {
                    return 0;
                }
                if (returnType == Byte.TYPE) {
                    return 0;
                }
                if (returnType == Float.TYPE) {
                    return Float.valueOf(0.0f);
                }
                if (returnType == Double.TYPE) {
                    return 0.0;
                }
                return null;
            }
        });
    }

    public static class ReflectionException
    extends Exception {
        public ReflectionException() {
        }

        public ReflectionException(String message) {
            super(message);
        }

        public ReflectionException(String message, Throwable cause) {
            super(message, cause);
        }

        public ReflectionException(Throwable cause) {
            super(cause);
        }
    }
}

