/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.ContentResolver;
import android.content.res.Resources;
import android.graphics.drawable.Icon;
import android.text.TextUtils;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import java.util.Locale;
import java.util.Objects;
import libcore.content.type.MimeMap;

public class MimeIconUtils {
    @GuardedBy(value={"sCache"})
    private static final ArrayMap<String, ContentResolver.MimeTypeInfo> sCache = new ArrayMap();

    private static ContentResolver.MimeTypeInfo buildTypeInfo(String mimeType, int iconId, int labelId, int extLabelId) {
        Resources res = Resources.getSystem();
        String ext = MimeMap.getDefault().guessExtensionFromMimeType(mimeType);
        String label = !TextUtils.isEmpty(ext) && extLabelId != -1 ? res.getString(extLabelId, ext.toUpperCase(Locale.US)) : res.getString(labelId);
        return new ContentResolver.MimeTypeInfo(Icon.createWithResource(res, iconId), label, label);
    }

    private static ContentResolver.MimeTypeInfo buildTypeInfo(String mimeType) {
        switch (mimeType) {
            case "inode/directory": 
            case "vnd.android.document/directory": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302410, 17040614, -1);
            }
            case "application/vnd.android.package-archive": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302401, 17040607, -1);
            }
            case "application/pgp-keys": 
            case "application/pgp-signature": 
            case "application/x-pkcs12": 
            case "application/x-pkcs7-certreqresp": 
            case "application/x-pkcs7-crl": 
            case "application/x-x509-ca-cert": 
            case "application/x-x509-user-cert": 
            case "application/x-pkcs7-certificates": 
            case "application/x-pkcs7-mime": 
            case "application/x-pkcs7-signature": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302403, 17040615, 17040616);
            }
            case "application/rdf+xml": 
            case "application/rss+xml": 
            case "application/x-object": 
            case "application/xhtml+xml": 
            case "text/css": 
            case "text/html": 
            case "text/xml": 
            case "text/x-c++hdr": 
            case "text/x-c++src": 
            case "text/x-chdr": 
            case "text/x-csrc": 
            case "text/x-dsrc": 
            case "text/x-csh": 
            case "text/x-haskell": 
            case "text/x-java": 
            case "text/x-literate-haskell": 
            case "text/x-pascal": 
            case "text/x-tcl": 
            case "text/x-tex": 
            case "application/x-latex": 
            case "application/x-texinfo": 
            case "application/atom+xml": 
            case "application/ecmascript": 
            case "application/json": 
            case "application/javascript": 
            case "application/xml": 
            case "text/javascript": 
            case "application/x-javascript": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302404, 17040612, 17040613);
            }
            case "application/mac-binhex40": 
            case "application/rar": 
            case "application/zip": 
            case "application/x-apple-diskimage": 
            case "application/x-debian-package": 
            case "application/x-gtar": 
            case "application/x-iso9660-image": 
            case "application/x-lha": 
            case "application/x-lzh": 
            case "application/x-lzx": 
            case "application/x-stuffit": 
            case "application/x-tar": 
            case "application/x-webarchive": 
            case "application/x-webarchive-xml": 
            case "application/gzip": 
            case "application/x-7z-compressed": 
            case "application/x-deb": 
            case "application/x-rar-compressed": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302405, 17040610, 17040611);
            }
            case "text/x-vcard": 
            case "text/vcard": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302406, 17040615, 17040616);
            }
            case "text/calendar": 
            case "text/x-vcalendar": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302408, 17040615, 17040616);
            }
            case "application/x-font": 
            case "application/font-woff": 
            case "application/x-font-woff": 
            case "application/x-font-ttf": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302411, 17040615, 17040616);
            }
            case "application/vnd.oasis.opendocument.graphics": 
            case "application/vnd.oasis.opendocument.graphics-template": 
            case "application/vnd.oasis.opendocument.image": 
            case "application/vnd.stardivision.draw": 
            case "application/vnd.sun.xml.draw": 
            case "application/vnd.sun.xml.draw.template": 
            case "application/vnd.google-apps.drawing": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302413, 17040617, 17040618);
            }
            case "application/pdf": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302414, 17040612, 17040613);
            }
            case "application/vnd.stardivision.impress": 
            case "application/vnd.sun.xml.impress": 
            case "application/vnd.sun.xml.impress.template": 
            case "application/x-kpresenter": 
            case "application/vnd.oasis.opendocument.presentation": 
            case "application/vnd.google-apps.presentation": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302416, 17040619, 17040620);
            }
            case "application/vnd.oasis.opendocument.spreadsheet": 
            case "application/vnd.oasis.opendocument.spreadsheet-template": 
            case "application/vnd.stardivision.calc": 
            case "application/vnd.sun.xml.calc": 
            case "application/vnd.sun.xml.calc.template": 
            case "application/x-kspread": 
            case "application/vnd.google-apps.spreadsheet": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302417, 17040621, 17040622);
            }
            case "application/vnd.oasis.opendocument.text": 
            case "application/vnd.oasis.opendocument.text-master": 
            case "application/vnd.oasis.opendocument.text-template": 
            case "application/vnd.oasis.opendocument.text-web": 
            case "application/vnd.stardivision.writer": 
            case "application/vnd.stardivision.writer-global": 
            case "application/vnd.sun.xml.writer": 
            case "application/vnd.sun.xml.writer.global": 
            case "application/vnd.sun.xml.writer.template": 
            case "application/x-abiword": 
            case "application/x-kword": 
            case "application/vnd.google-apps.document": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302407, 17040612, 17040613);
            }
            case "application/x-quicktimeplayer": 
            case "application/x-shockwave-flash": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302419, 17040623, 17040624);
            }
            case "application/msword": 
            case "application/vnd.openxmlformats-officedocument.wordprocessingml.document": 
            case "application/vnd.openxmlformats-officedocument.wordprocessingml.template": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302420, 17040612, 17040613);
            }
            case "application/vnd.ms-excel": 
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": 
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.template": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302409, 17040621, 17040622);
            }
            case "application/vnd.ms-powerpoint": 
            case "application/vnd.openxmlformats-officedocument.presentationml.presentation": 
            case "application/vnd.openxmlformats-officedocument.presentationml.template": 
            case "application/vnd.openxmlformats-officedocument.presentationml.slideshow": {
                return MimeIconUtils.buildTypeInfo(mimeType, 17302415, 17040619, 17040620);
            }
        }
        return MimeIconUtils.buildGenericTypeInfo(mimeType);
    }

    private static ContentResolver.MimeTypeInfo buildGenericTypeInfo(String mimeType) {
        if (mimeType.startsWith("audio/")) {
            return MimeIconUtils.buildTypeInfo(mimeType, 17302402, 17040608, 17040609);
        }
        if (mimeType.startsWith("video/")) {
            return MimeIconUtils.buildTypeInfo(mimeType, 17302419, 17040623, 17040624);
        }
        if (mimeType.startsWith("image/")) {
            return MimeIconUtils.buildTypeInfo(mimeType, 17302413, 17040617, 17040618);
        }
        if (mimeType.startsWith("text/")) {
            return MimeIconUtils.buildTypeInfo(mimeType, 17302418, 17040612, 17040613);
        }
        MimeMap mimeMap = MimeMap.getDefault();
        String bouncedMimeType = mimeMap.guessMimeTypeFromExtension(mimeMap.guessExtensionFromMimeType(mimeType));
        if (bouncedMimeType != null && !Objects.equals(mimeType, bouncedMimeType)) {
            return MimeIconUtils.buildTypeInfo(bouncedMimeType);
        }
        return MimeIconUtils.buildTypeInfo(mimeType, 17302412, 17040615, 17040616);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentResolver.MimeTypeInfo getTypeInfo(String mimeType) {
        mimeType = mimeType.toLowerCase(Locale.US);
        ArrayMap<String, ContentResolver.MimeTypeInfo> arrayMap = sCache;
        synchronized (arrayMap) {
            ContentResolver.MimeTypeInfo res = sCache.get(mimeType);
            if (res == null) {
                res = MimeIconUtils.buildTypeInfo(mimeType);
                sCache.put(mimeType, res);
            }
            return res;
        }
    }
}

