/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.metrics.LogMaker;
import android.os.Process;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.FrameworkStatsLog;
import dalvik.system.VMRuntime;

class StatsdHiddenApiUsageLogger
implements VMRuntime.HiddenApiUsageLogger {
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    private static final StatsdHiddenApiUsageLogger sInstance = new StatsdHiddenApiUsageLogger();
    private int mHiddenApiAccessLogSampleRate = 0;
    private int mHiddenApiAccessStatslogSampleRate = 0;

    StatsdHiddenApiUsageLogger() {
    }

    static void setHiddenApiAccessLogSampleRates(int sampleRate, int newSampleRate) {
        StatsdHiddenApiUsageLogger.sInstance.mHiddenApiAccessLogSampleRate = sampleRate;
        StatsdHiddenApiUsageLogger.sInstance.mHiddenApiAccessStatslogSampleRate = newSampleRate;
    }

    static StatsdHiddenApiUsageLogger getInstance() {
        return sInstance;
    }

    @Override
    public void hiddenApiUsed(int sampledValue, String packageName, String signature, int accessMethod, boolean accessDenied) {
        if (sampledValue < this.mHiddenApiAccessLogSampleRate) {
            this.logUsage(packageName, signature, accessMethod, accessDenied);
        }
        if (sampledValue < this.mHiddenApiAccessStatslogSampleRate) {
            this.newLogUsage(signature, accessMethod, accessDenied);
        }
    }

    private void logUsage(String packageName, String signature, int accessMethod, boolean accessDenied) {
        int accessMethodMetric = 0;
        switch (accessMethod) {
            case 0: {
                accessMethodMetric = 0;
                break;
            }
            case 1: {
                accessMethodMetric = 1;
                break;
            }
            case 2: {
                accessMethodMetric = 2;
                break;
            }
            case 3: {
                accessMethodMetric = 3;
            }
        }
        LogMaker logMaker = new LogMaker(1391).setPackageName(packageName).addTaggedData(1394, signature).addTaggedData(1392, accessMethodMetric);
        if (accessDenied) {
            logMaker.addTaggedData(1393, 1);
        }
        this.mMetricsLogger.write(logMaker);
    }

    private void newLogUsage(String signature, int accessMethod, boolean accessDenied) {
        int accessMethodProto = 0;
        switch (accessMethod) {
            case 0: {
                accessMethodProto = 0;
                break;
            }
            case 1: {
                accessMethodProto = 1;
                break;
            }
            case 2: {
                accessMethodProto = 2;
                break;
            }
            case 3: {
                accessMethodProto = 3;
            }
        }
        int uid = Process.myUid();
        FrameworkStatsLog.write(178, uid, signature, accessMethodProto, accessDenied);
    }
}

