/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.Ikev2VpnProfile;
import android.net.ProxyInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class VpnProfile
implements Cloneable,
Parcelable {
    private static final String TAG = "VpnProfile";
    @VisibleForTesting
    static final String VALUE_DELIMITER = "\u0000";
    @VisibleForTesting
    static final String LIST_DELIMITER = ",";
    public static final int TYPE_PPTP = 0;
    public static final int TYPE_L2TP_IPSEC_PSK = 1;
    public static final int TYPE_L2TP_IPSEC_RSA = 2;
    public static final int TYPE_IPSEC_XAUTH_PSK = 3;
    public static final int TYPE_IPSEC_XAUTH_RSA = 4;
    public static final int TYPE_IPSEC_HYBRID_RSA = 5;
    public static final int TYPE_IKEV2_IPSEC_USER_PASS = 6;
    public static final int TYPE_IKEV2_IPSEC_PSK = 7;
    public static final int TYPE_IKEV2_IPSEC_RSA = 8;
    public static final int TYPE_MAX = 8;
    public static final int PROXY_NONE = 0;
    public static final int PROXY_MANUAL = 1;
    private static final String ENCODED_NULL_PROXY_INFO = "\u0000\u0000\u0000\u0000";
    @UnsupportedAppUsage
    public final String key;
    @UnsupportedAppUsage
    public String name = "";
    @UnsupportedAppUsage
    public int type = 0;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public String server = "";
    @UnsupportedAppUsage
    public String username = "";
    public String password = "";
    public String dnsServers = "";
    public String searchDomains = "";
    public String routes = "";
    public boolean mppe = true;
    public String l2tpSecret = "";
    public String ipsecIdentifier = "";
    public String ipsecSecret = "";
    public String ipsecUserCert = "";
    public String ipsecCaCert = "";
    public String ipsecServerCert = "";
    public ProxyInfo proxy = null;
    private List<String> mAllowedAlgorithms = new ArrayList<String>();
    public boolean isBypassable = false;
    public boolean isMetered = false;
    public int maxMtu = 1360;
    public boolean areAuthParamsInline = false;
    public final boolean isRestrictedToTestNetworks;
    @UnsupportedAppUsage
    public transient boolean saveLogin = false;
    public static final Parcelable.Creator<VpnProfile> CREATOR = new Parcelable.Creator<VpnProfile>(){

        @Override
        public VpnProfile createFromParcel(Parcel in) {
            return new VpnProfile(in);
        }

        public VpnProfile[] newArray(int size) {
            return new VpnProfile[size];
        }
    };

    public VpnProfile(String key) {
        this(key, false);
    }

    public VpnProfile(String key, boolean isRestrictedToTestNetworks) {
        this.key = key;
        this.isRestrictedToTestNetworks = isRestrictedToTestNetworks;
    }

    @UnsupportedAppUsage
    public VpnProfile(Parcel in) {
        this.key = in.readString();
        this.name = in.readString();
        this.type = in.readInt();
        this.server = in.readString();
        this.username = in.readString();
        this.password = in.readString();
        this.dnsServers = in.readString();
        this.searchDomains = in.readString();
        this.routes = in.readString();
        this.mppe = in.readInt() != 0;
        this.l2tpSecret = in.readString();
        this.ipsecIdentifier = in.readString();
        this.ipsecSecret = in.readString();
        this.ipsecUserCert = in.readString();
        this.ipsecCaCert = in.readString();
        this.ipsecServerCert = in.readString();
        this.saveLogin = in.readInt() != 0;
        this.proxy = (ProxyInfo)in.readParcelable(null);
        this.mAllowedAlgorithms = new ArrayList<String>();
        in.readList(this.mAllowedAlgorithms, null);
        this.isBypassable = in.readBoolean();
        this.isMetered = in.readBoolean();
        this.maxMtu = in.readInt();
        this.areAuthParamsInline = in.readBoolean();
        this.isRestrictedToTestNetworks = in.readBoolean();
    }

    public List<String> getAllowedAlgorithms() {
        return Collections.unmodifiableList(this.mAllowedAlgorithms);
    }

    public void setAllowedAlgorithms(List<String> allowedAlgorithms) {
        VpnProfile.validateAllowedAlgorithms(allowedAlgorithms);
        this.mAllowedAlgorithms = allowedAlgorithms;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.key);
        out.writeString(this.name);
        out.writeInt(this.type);
        out.writeString(this.server);
        out.writeString(this.username);
        out.writeString(this.password);
        out.writeString(this.dnsServers);
        out.writeString(this.searchDomains);
        out.writeString(this.routes);
        out.writeInt(this.mppe ? 1 : 0);
        out.writeString(this.l2tpSecret);
        out.writeString(this.ipsecIdentifier);
        out.writeString(this.ipsecSecret);
        out.writeString(this.ipsecUserCert);
        out.writeString(this.ipsecCaCert);
        out.writeString(this.ipsecServerCert);
        out.writeInt(this.saveLogin ? 1 : 0);
        out.writeParcelable(this.proxy, flags);
        out.writeList(this.mAllowedAlgorithms);
        out.writeBoolean(this.isBypassable);
        out.writeBoolean(this.isMetered);
        out.writeInt(this.maxMtu);
        out.writeBoolean(this.areAuthParamsInline);
        out.writeBoolean(this.isRestrictedToTestNetworks);
    }

    @UnsupportedAppUsage
    public static VpnProfile decode(String key, byte[] value) {
        try {
            if (key == null) {
                return null;
            }
            String[] values = new String(value, StandardCharsets.UTF_8).split(VALUE_DELIMITER, -1);
            if ((values.length < 14 || values.length > 19) && values.length != 24 && values.length != 25) {
                return null;
            }
            boolean isRestrictedToTestNetworks = values.length >= 25 ? Boolean.parseBoolean(values[24]) : false;
            VpnProfile profile = new VpnProfile(key, isRestrictedToTestNetworks);
            profile.name = values[0];
            profile.type = Integer.parseInt(values[1]);
            if (profile.type < 0 || profile.type > 8) {
                return null;
            }
            profile.server = values[2];
            profile.username = values[3];
            profile.password = values[4];
            profile.dnsServers = values[5];
            profile.searchDomains = values[6];
            profile.routes = values[7];
            profile.mppe = Boolean.parseBoolean(values[8]);
            profile.l2tpSecret = values[9];
            profile.ipsecIdentifier = values[10];
            profile.ipsecSecret = values[11];
            profile.ipsecUserCert = values[12];
            profile.ipsecCaCert = values[13];
            String string2 = profile.ipsecServerCert = values.length > 14 ? values[14] : "";
            if (values.length > 15) {
                String pacFileUrl;
                String host = values.length > 15 ? values[15] : "";
                String port = values.length > 16 ? values[16] : "";
                String exclList = values.length > 17 ? values[17] : "";
                String string3 = pacFileUrl = values.length > 18 ? values[18] : "";
                if (!(host.isEmpty() && port.isEmpty() && exclList.isEmpty())) {
                    profile.proxy = new ProxyInfo(host, port.isEmpty() ? 0 : Integer.parseInt(port), exclList);
                } else if (!pacFileUrl.isEmpty()) {
                    profile.proxy = new ProxyInfo(pacFileUrl);
                }
            }
            if (values.length >= 24) {
                profile.mAllowedAlgorithms = Arrays.asList(values[19].split(LIST_DELIMITER));
                profile.isBypassable = Boolean.parseBoolean(values[20]);
                profile.isMetered = Boolean.parseBoolean(values[21]);
                profile.maxMtu = Integer.parseInt(values[22]);
                profile.areAuthParamsInline = Boolean.parseBoolean(values[23]);
            }
            profile.saveLogin = !profile.username.isEmpty() || !profile.password.isEmpty();
            return profile;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] encode() {
        StringBuilder builder = new StringBuilder(this.name);
        builder.append(VALUE_DELIMITER).append(this.type);
        builder.append(VALUE_DELIMITER).append(this.server);
        builder.append(VALUE_DELIMITER).append(this.saveLogin ? this.username : "");
        builder.append(VALUE_DELIMITER).append(this.saveLogin ? this.password : "");
        builder.append(VALUE_DELIMITER).append(this.dnsServers);
        builder.append(VALUE_DELIMITER).append(this.searchDomains);
        builder.append(VALUE_DELIMITER).append(this.routes);
        builder.append(VALUE_DELIMITER).append(this.mppe);
        builder.append(VALUE_DELIMITER).append(this.l2tpSecret);
        builder.append(VALUE_DELIMITER).append(this.ipsecIdentifier);
        builder.append(VALUE_DELIMITER).append(this.ipsecSecret);
        builder.append(VALUE_DELIMITER).append(this.ipsecUserCert);
        builder.append(VALUE_DELIMITER).append(this.ipsecCaCert);
        builder.append(VALUE_DELIMITER).append(this.ipsecServerCert);
        if (this.proxy != null) {
            builder.append(VALUE_DELIMITER).append(this.proxy.getHost() != null ? this.proxy.getHost() : "");
            builder.append(VALUE_DELIMITER).append(this.proxy.getPort());
            builder.append(VALUE_DELIMITER).append(this.proxy.getExclusionListAsString() != null ? this.proxy.getExclusionListAsString() : "");
            builder.append(VALUE_DELIMITER).append(this.proxy.getPacFileUrl().toString());
        } else {
            builder.append(ENCODED_NULL_PROXY_INFO);
        }
        builder.append(VALUE_DELIMITER).append(String.join((CharSequence)LIST_DELIMITER, this.mAllowedAlgorithms));
        builder.append(VALUE_DELIMITER).append(this.isBypassable);
        builder.append(VALUE_DELIMITER).append(this.isMetered);
        builder.append(VALUE_DELIMITER).append(this.maxMtu);
        builder.append(VALUE_DELIMITER).append(this.areAuthParamsInline);
        builder.append(VALUE_DELIMITER).append(this.isRestrictedToTestNetworks);
        return builder.toString().getBytes(StandardCharsets.UTF_8);
    }

    public static boolean isLegacyType(int type) {
        switch (type) {
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    private boolean isValidLockdownLegacyVpnProfile() {
        return VpnProfile.isLegacyType(this.type) && this.isServerAddressNumeric() && this.hasDns() && this.areDnsAddressesNumeric();
    }

    private boolean isValidLockdownPlatformVpnProfile() {
        return Ikev2VpnProfile.isValidVpnProfile(this);
    }

    public boolean isValidLockdownProfile() {
        return this.isTypeValidForLockdown() && (this.isValidLockdownLegacyVpnProfile() || this.isValidLockdownPlatformVpnProfile());
    }

    public boolean isTypeValidForLockdown() {
        return this.type != 0;
    }

    public boolean isServerAddressNumeric() {
        try {
            InetAddress.parseNumericAddress((String)this.server);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public boolean hasDns() {
        return !TextUtils.isEmpty(this.dnsServers);
    }

    public boolean areDnsAddressesNumeric() {
        try {
            for (String dnsServer : this.dnsServers.split(" +")) {
                InetAddress.parseNumericAddress((String)dnsServer);
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static void validateAllowedAlgorithms(List<String> allowedAlgorithms) {
        for (String alg : allowedAlgorithms) {
            if (!alg.contains(VALUE_DELIMITER) && !alg.contains(LIST_DELIMITER)) continue;
            throw new IllegalArgumentException("Algorithm contained illegal ('\u0000' or ',') character");
        }
    }

    public int hashCode() {
        return Objects.hash(this.key, this.type, this.server, this.username, this.password, this.dnsServers, this.searchDomains, this.routes, this.mppe, this.l2tpSecret, this.ipsecIdentifier, this.ipsecSecret, this.ipsecUserCert, this.ipsecCaCert, this.ipsecServerCert, this.proxy, this.mAllowedAlgorithms, this.isBypassable, this.isMetered, this.maxMtu, this.areAuthParamsInline, this.isRestrictedToTestNetworks);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VpnProfile)) {
            return false;
        }
        VpnProfile other = (VpnProfile)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.name, other.name) && this.type == other.type && Objects.equals(this.server, other.server) && Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && Objects.equals(this.dnsServers, other.dnsServers) && Objects.equals(this.searchDomains, other.searchDomains) && Objects.equals(this.routes, other.routes) && this.mppe == other.mppe && Objects.equals(this.l2tpSecret, other.l2tpSecret) && Objects.equals(this.ipsecIdentifier, other.ipsecIdentifier) && Objects.equals(this.ipsecSecret, other.ipsecSecret) && Objects.equals(this.ipsecUserCert, other.ipsecUserCert) && Objects.equals(this.ipsecCaCert, other.ipsecCaCert) && Objects.equals(this.ipsecServerCert, other.ipsecServerCert) && Objects.equals(this.proxy, other.proxy) && Objects.equals(this.mAllowedAlgorithms, other.mAllowedAlgorithms) && this.isBypassable == other.isBypassable && this.isMetered == other.isMetered && this.maxMtu == other.maxMtu && this.areAuthParamsInline == other.areAuthParamsInline && this.isRestrictedToTestNetworks == other.isRestrictedToTestNetworks;
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

