/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityTaskManager;
import android.os.RemoteException;
import android.util.Singleton;
import android.view.SurfaceControl;
import android.window.IWindowOrganizerController;
import android.window.WindowContainerToken;
import android.window.WindowContainerTransaction;
import android.window.WindowContainerTransactionCallback;

public class WindowOrganizer {
    private static final Singleton<IWindowOrganizerController> IWindowOrganizerControllerSingleton = new Singleton<IWindowOrganizerController>(){

        @Override
        protected IWindowOrganizerController create() {
            try {
                return ActivityTaskManager.getService().getWindowOrganizerController();
            }
            catch (RemoteException e) {
                return null;
            }
        }
    };

    public static void applyTransaction(WindowContainerTransaction t) {
        try {
            WindowOrganizer.getWindowOrganizerController().applyTransaction(t);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int applySyncTransaction(WindowContainerTransaction t, WindowContainerTransactionCallback callback) {
        try {
            return WindowOrganizer.getWindowOrganizerController().applySyncTransaction(t, callback.mInterface);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static SurfaceControl takeScreenshot(WindowContainerToken token) {
        try {
            SurfaceControl surfaceControl = new SurfaceControl();
            if (WindowOrganizer.getWindowOrganizerController().takeScreenshot(token, surfaceControl)) {
                return surfaceControl;
            }
            return null;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static IWindowOrganizerController getWindowOrganizerController() {
        return IWindowOrganizerControllerSingleton.get();
    }
}

