/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.graphics.Insets;
import android.graphics.Rect;
import android.view.DisplayCutout;
import android.view.ViewRootImpl;
import android.view.WindowInsets;
import android.view.WindowMetrics;

public class WindowMetricsHelper {
    private WindowMetricsHelper() {
    }

    public static Rect getBoundsExcludingNavigationBarAndCutout(WindowMetrics windowMetrics) {
        Insets insets;
        WindowInsets windowInsets = windowMetrics.getWindowInsets();
        if (ViewRootImpl.sNewInsetsMode == 2) {
            insets = windowInsets.getInsetsIgnoringVisibility(WindowInsets.Type.navigationBars() | WindowInsets.Type.displayCutout());
        } else {
            Insets stableInsets = windowInsets.getStableInsets();
            insets = Insets.of(stableInsets.left, 0, stableInsets.right, stableInsets.bottom);
            DisplayCutout cutout = windowInsets.getDisplayCutout();
            insets = cutout != null ? Insets.max(insets, Insets.of(cutout.getSafeInsets())) : insets;
        }
        Rect result = new Rect(windowMetrics.getBounds());
        result.inset(insets);
        return result;
    }
}

