/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.os.Parcel;
import android.os.Parcelable;

public class AutofillId
implements Parcelable {
    public static final int NO_SESSION = 0;
    private static final int FLAG_IS_VIRTUAL_INT = 1;
    private static final int FLAG_IS_VIRTUAL_LONG = 2;
    private static final int FLAG_HAS_SESSION = 4;
    private final int mViewId;
    private int mFlags;
    private final int mVirtualIntId;
    private final long mVirtualLongId;
    private int mSessionId;
    public static final Parcelable.Creator<AutofillId> CREATOR = new Parcelable.Creator<AutofillId>(){

        @Override
        public AutofillId createFromParcel(Parcel source) {
            int sessionId;
            int viewId = source.readInt();
            int flags = source.readInt();
            int n = sessionId = (flags & 4) != 0 ? source.readInt() : 0;
            if ((flags & 1) != 0) {
                return new AutofillId(flags, viewId, source.readInt(), sessionId);
            }
            if ((flags & 2) != 0) {
                return new AutofillId(flags, viewId, source.readLong(), sessionId);
            }
            return new AutofillId(flags, viewId, -1L, sessionId);
        }

        public AutofillId[] newArray(int size) {
            return new AutofillId[size];
        }
    };

    public AutofillId(int id2) {
        this(0, id2, -1L, 0);
    }

    public AutofillId(AutofillId hostId, int virtualChildId) {
        this(1, hostId.mViewId, virtualChildId, 0);
    }

    public AutofillId(int hostId, int virtualChildId) {
        this(1, hostId, virtualChildId, 0);
    }

    public AutofillId(AutofillId hostId, long virtualChildId, int sessionId) {
        this(6, hostId.mViewId, virtualChildId, sessionId);
    }

    private AutofillId(int flags, int parentId, long virtualChildId, int sessionId) {
        this.mFlags = flags;
        this.mViewId = parentId;
        this.mVirtualIntId = (flags & 1) != 0 ? (int)virtualChildId : -1;
        this.mVirtualLongId = (flags & 2) != 0 ? virtualChildId : -1L;
        this.mSessionId = sessionId;
    }

    public static AutofillId withoutSession(AutofillId id2) {
        int flags = id2.mFlags & 0xFFFFFFFB;
        long virtualChildId = (id2.mFlags & 2) != 0 ? id2.mVirtualLongId : (long)id2.mVirtualIntId;
        return new AutofillId(flags, id2.mViewId, virtualChildId, 0);
    }

    public int getViewId() {
        return this.mViewId;
    }

    public int getVirtualChildIntId() {
        return this.mVirtualIntId;
    }

    public long getVirtualChildLongId() {
        return this.mVirtualLongId;
    }

    public boolean isVirtualInt() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isVirtualLong() {
        return (this.mFlags & 2) != 0;
    }

    public boolean isNonVirtual() {
        return !this.isVirtualInt() && !this.isVirtualLong();
    }

    public boolean hasSession() {
        return (this.mFlags & 4) != 0;
    }

    public int getSessionId() {
        return this.mSessionId;
    }

    public void setSessionId(int sessionId) {
        this.mFlags |= 4;
        this.mSessionId = sessionId;
    }

    public void resetSessionId() {
        this.mFlags &= 0xFFFFFFFB;
        this.mSessionId = 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mViewId;
        result = 31 * result + this.mVirtualIntId;
        result = 31 * result + (int)(this.mVirtualLongId ^ this.mVirtualLongId >>> 32);
        result = 31 * result + this.mSessionId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutofillId other = (AutofillId)obj;
        if (this.mViewId != other.mViewId) {
            return false;
        }
        if (this.mVirtualIntId != other.mVirtualIntId) {
            return false;
        }
        if (this.mVirtualLongId != other.mVirtualLongId) {
            return false;
        }
        return this.mSessionId == other.mSessionId;
    }

    public boolean equalsIgnoreSession(AutofillId other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.mViewId != other.mViewId) {
            return false;
        }
        if (this.mVirtualIntId != other.mVirtualIntId) {
            return false;
        }
        return this.mVirtualLongId == other.mVirtualLongId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.mViewId);
        if (this.isVirtualInt()) {
            builder.append(':').append(this.mVirtualIntId);
        } else if (this.isVirtualLong()) {
            builder.append(':').append(this.mVirtualLongId);
        }
        if (this.hasSession()) {
            builder.append('@').append(this.mSessionId);
        }
        return builder.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mViewId);
        parcel.writeInt(this.mFlags);
        if (this.hasSession()) {
            parcel.writeInt(this.mSessionId);
        }
        if (this.isVirtualInt()) {
            parcel.writeInt(this.mVirtualIntId);
        } else if (this.isVirtualLong()) {
            parcel.writeLong(this.mVirtualLongId);
        }
    }
}

