/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.VerifiedKeyEvent;
import android.view.VerifiedMotionEvent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SuppressLint(value={"ParcelNotFinal"})
public abstract class VerifiedInputEvent
implements Parcelable {
    private static final String TAG = "VerifiedInputEvent";
    protected static final int VERIFIED_KEY = 1;
    protected static final int VERIFIED_MOTION = 2;
    private int mType;
    private int mDeviceId;
    private long mEventTimeNanos;
    private int mSource;
    private int mDisplayId;
    public static final Parcelable.Creator<VerifiedInputEvent> CREATOR = new Parcelable.Creator<VerifiedInputEvent>(){

        public VerifiedInputEvent[] newArray(int size) {
            return new VerifiedInputEvent[size];
        }

        @Override
        public VerifiedInputEvent createFromParcel(Parcel in) {
            int type = VerifiedInputEvent.peekInt(in);
            if (type == 1) {
                return VerifiedKeyEvent.CREATOR.createFromParcel(in);
            }
            if (type == 2) {
                return VerifiedMotionEvent.CREATOR.createFromParcel(in);
            }
            throw new IllegalArgumentException("Unexpected input event type in parcel.");
        }
    };

    protected VerifiedInputEvent(int type, int deviceId, long eventTimeNanos, int source, int displayId) {
        this.mType = type;
        this.mDeviceId = deviceId;
        this.mEventTimeNanos = eventTimeNanos;
        this.mSource = source;
        this.mDisplayId = displayId;
    }

    protected VerifiedInputEvent(Parcel in, int expectedType) {
        this.mType = in.readInt();
        if (this.mType != expectedType) {
            throw new IllegalArgumentException("Unexpected input event type token in parcel.");
        }
        this.mDeviceId = in.readInt();
        this.mEventTimeNanos = in.readLong();
        this.mSource = in.readInt();
        this.mDisplayId = in.readInt();
    }

    public int getDeviceId() {
        return this.mDeviceId;
    }

    @SuppressLint(value={"MethodNameUnits"})
    public long getEventTimeNanos() {
        return this.mEventTimeNanos;
    }

    public int getSource() {
        return this.mSource;
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeInt(this.mDeviceId);
        dest.writeLong(this.mEventTimeNanos);
        dest.writeInt(this.mSource);
        dest.writeInt(this.mDisplayId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static int peekInt(Parcel parcel) {
        int initialDataPosition = parcel.dataPosition();
        int data = parcel.readInt();
        parcel.setDataPosition(initialDataPosition);
        return data;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VerifiedInputEventType {
    }
}

