/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Matrix;
import android.os.IBinder;
import android.view.ViewRootImpl;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.IAccessibilityEmbeddedConnection;
import java.lang.ref.WeakReference;

class AccessibilityEmbeddedConnection
extends IAccessibilityEmbeddedConnection.Stub {
    private final WeakReference<ViewRootImpl> mViewRootImpl;
    private final Matrix mTmpScreenMatrix = new Matrix();

    AccessibilityEmbeddedConnection(ViewRootImpl viewRootImpl) {
        this.mViewRootImpl = new WeakReference<ViewRootImpl>(viewRootImpl);
    }

    @Override
    public IBinder associateEmbeddedHierarchy(IBinder host, int hostViewId) {
        ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
        if (viewRootImpl != null) {
            AccessibilityManager accessibilityManager = AccessibilityManager.getInstance(viewRootImpl.mContext);
            viewRootImpl.mAttachInfo.mLeashedParentToken = host;
            viewRootImpl.mAttachInfo.mLeashedParentAccessibilityViewId = hostViewId;
            if (accessibilityManager.isEnabled()) {
                accessibilityManager.associateEmbeddedHierarchy(host, viewRootImpl.mLeashToken);
            }
            return viewRootImpl.mLeashToken;
        }
        return null;
    }

    @Override
    public void disassociateEmbeddedHierarchy() {
        ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
        if (viewRootImpl != null) {
            AccessibilityManager accessibilityManager = AccessibilityManager.getInstance(viewRootImpl.mContext);
            viewRootImpl.mAttachInfo.mLeashedParentToken = null;
            viewRootImpl.mAttachInfo.mLeashedParentAccessibilityViewId = -1;
            viewRootImpl.mAttachInfo.mLocationInParentDisplay.set(0, 0);
            if (accessibilityManager.isEnabled()) {
                accessibilityManager.disassociateEmbeddedHierarchy(viewRootImpl.mLeashToken);
            }
        }
    }

    @Override
    public void setScreenMatrix(float[] matrixValues) {
        ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
        if (viewRootImpl != null) {
            this.mTmpScreenMatrix.setValues(matrixValues);
            if (viewRootImpl.mAttachInfo.mScreenMatrixInEmbeddedHierarchy == null) {
                viewRootImpl.mAttachInfo.mScreenMatrixInEmbeddedHierarchy = new Matrix();
            }
            viewRootImpl.mAttachInfo.mScreenMatrixInEmbeddedHierarchy.set(this.mTmpScreenMatrix);
        }
    }
}

