/*
 * Decompiled with CFR 0.152.
 */
package android.util.imagepool;

import android.util.imagepool.Bucket;
import android.util.imagepool.ImagePool;
import android.util.imagepool.ImagePoolStats;
import java.awt.image.BufferedImage;
import java.util.Map;

class ImagePoolHelper {
    ImagePoolHelper() {
    }

    public static Bucket.BucketCreationMetaData getBucketCreationMetaData(int w, int h, int type, ImagePool.ImagePoolPolicy poolPolicy, ImagePoolStats stats) {
        int widthBucket = -1;
        int heightBucket = -1;
        int index = 0;
        for (int bucketMinSize : poolPolicy.mBucketSizes) {
            if (widthBucket == -1 && w <= bucketMinSize) {
                widthBucket = bucketMinSize;
                if (heightBucket != -1) break;
            }
            if (heightBucket == -1 && h <= bucketMinSize) {
                heightBucket = bucketMinSize;
                if (widthBucket != -1) break;
            }
            ++index;
        }
        stats.recordBucketRequest(w, h);
        if (index >= poolPolicy.mNumberOfCopies.length) {
            return null;
        }
        return new Bucket.BucketCreationMetaData(widthBucket, heightBucket, type, poolPolicy.mNumberOfCopies[index], ImagePool.Image.Orientation.NONE, poolPolicy.mBucketMaxCacheSize);
    }

    public static BufferedImage getBufferedImage(Bucket bucket, Bucket.BucketCreationMetaData metaData, ImagePoolStats stats) {
        BufferedImage strongRef = ImagePoolHelper.populateBucket(bucket, metaData, stats);
        if (bucket.isEmpty()) {
            assert (strongRef == null);
            return null;
        }
        BufferedImage img = bucket.remove();
        while (img == null && !bucket.isEmpty()) {
            img = bucket.remove();
        }
        if (img == null && bucket.isEmpty()) {
            return ImagePoolHelper.getBufferedImage(bucket, metaData, stats);
        }
        return img;
    }

    private static BufferedImage populateBucket(Bucket bucket, Bucket.BucketCreationMetaData metaData, ImagePoolStats stats) {
        if (!bucket.isEmpty()) {
            return null;
        }
        BufferedImage strongRef = null;
        for (int i = 0; i < metaData.mNumberOfCopies && stats.fitsMaxCacheSize(metaData.mWidth, metaData.mHeight, metaData.mMaxCacheSize); ++i) {
            strongRef = new BufferedImage(metaData.mWidth, metaData.mHeight, metaData.mType);
            bucket.offer(strongRef);
            stats.recordBucketCreation(metaData.mWidth, metaData.mHeight);
        }
        return strongRef;
    }

    private static String toKey(int w, int h, int type) {
        return "" + w + 'x' + h + ':' + type;
    }

    public static Bucket getBucket(Map<String, Bucket> map, Bucket.BucketCreationMetaData metaData, ImagePool.ImagePoolPolicy mPolicy) {
        String key = ImagePoolHelper.toKey(metaData.mWidth, metaData.mHeight, metaData.mType);
        Bucket bucket = map.get(key);
        if (bucket == null) {
            bucket = new Bucket();
            map.put(key, bucket);
        }
        return bucket;
    }
}

