/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioMetadata;
import android.media.AudioMetadataReadMap;
import android.media.AudioPresentation;
import android.media.AudioRouting;
import android.media.AudioSystem;
import android.media.AudioTimestamp;
import android.media.NativeRoutingEventHandlerDelegate;
import android.media.PlaybackParams;
import android.media.PlayerBase;
import android.media.Utils;
import android.media.VolumeAutomation;
import android.media.VolumeShaper;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.NioUtils;
import java.util.LinkedList;
import java.util.concurrent.Executor;

public class AudioTrack
extends PlayerBase
implements AudioRouting,
VolumeAutomation {
    private static final float GAIN_MIN = 0.0f;
    private static final float GAIN_MAX = 1.0f;
    public static final int PLAYSTATE_STOPPED = 1;
    public static final int PLAYSTATE_PAUSED = 2;
    public static final int PLAYSTATE_PLAYING = 3;
    private static final int PLAYSTATE_STOPPING = 4;
    private static final int PLAYSTATE_PAUSED_STOPPING = 5;
    public static final int MODE_STATIC = 0;
    public static final int MODE_STREAM = 1;
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_NO_STATIC_DATA = 2;
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -2;
    public static final int ERROR_INVALID_OPERATION = -3;
    public static final int ERROR_DEAD_OBJECT = -6;
    public static final int ERROR_WOULD_BLOCK = -7;
    private static final int ERROR_NATIVESETUP_AUDIOSYSTEM = -16;
    private static final int ERROR_NATIVESETUP_INVALIDCHANNELMASK = -17;
    private static final int ERROR_NATIVESETUP_INVALIDFORMAT = -18;
    private static final int ERROR_NATIVESETUP_INVALIDSTREAMTYPE = -19;
    private static final int ERROR_NATIVESETUP_NATIVEINITFAILED = -20;
    private static final int NATIVE_EVENT_MARKER = 3;
    private static final int NATIVE_EVENT_NEW_POS = 4;
    private static final int NATIVE_EVENT_CAN_WRITE_MORE_DATA = 9;
    private static final int NATIVE_EVENT_NEW_IAUDIOTRACK = 6;
    private static final int NATIVE_EVENT_STREAM_END = 7;
    private static final int NATIVE_EVENT_CODEC_FORMAT_CHANGE = 100;
    private static final String TAG = "android.media.AudioTrack";
    public static final int ENCAPSULATION_MODE_NONE = 0;
    public static final int ENCAPSULATION_MODE_ELEMENTARY_STREAM = 1;
    @SystemApi
    public static final int ENCAPSULATION_MODE_HANDLE = 2;
    public static final int ENCAPSULATION_METADATA_TYPE_NONE = 0;
    public static final int ENCAPSULATION_METADATA_TYPE_FRAMEWORK_TUNER = 1;
    public static final int ENCAPSULATION_METADATA_TYPE_DVB_AD_DESCRIPTOR = 2;
    public static final int DUAL_MONO_MODE_OFF = 0;
    public static final int DUAL_MONO_MODE_LR = 1;
    public static final int DUAL_MONO_MODE_LL = 2;
    public static final int DUAL_MONO_MODE_RR = 3;
    public static final int WRITE_BLOCKING = 0;
    public static final int WRITE_NON_BLOCKING = 1;
    public static final int PERFORMANCE_MODE_NONE = 0;
    public static final int PERFORMANCE_MODE_LOW_LATENCY = 1;
    public static final int PERFORMANCE_MODE_POWER_SAVING = 2;
    private static final int AUDIO_OUTPUT_FLAG_FAST = 4;
    private static final int AUDIO_OUTPUT_FLAG_DEEP_BUFFER = 8;
    private static final float HEADER_V2_SIZE_BYTES = 20.0f;
    private int mState = 0;
    private int mPlayState = 1;
    private boolean mOffloadEosPending = false;
    private final Object mPlayStateLock = new Object();
    private int mNativeBufferSizeInBytes = 0;
    private int mNativeBufferSizeInFrames = 0;
    private NativePositionEventHandlerDelegate mEventHandlerDelegate;
    private final Looper mInitializationLooper;
    private int mSampleRate;
    private int mChannelCount = 1;
    private int mChannelMask = 4;
    @UnsupportedAppUsage
    private int mStreamType = 3;
    private int mDataLoadMode = 1;
    private int mChannelConfiguration = 4;
    private int mChannelIndexMask = 0;
    private int mAudioFormat;
    private AudioAttributes mConfiguredAudioAttributes;
    private int mSessionId = 0;
    private ByteBuffer mAvSyncHeader = null;
    private int mAvSyncBytesRemaining = 0;
    private int mOffset = 0;
    private boolean mOffloaded = false;
    private int mOffloadDelayFrames = 0;
    private int mOffloadPaddingFrames = 0;
    @UnsupportedAppUsage
    protected long mNativeTrackInJavaObj;
    @UnsupportedAppUsage
    private long mJniData;
    private static final float MAX_AUDIO_DESCRIPTION_MIX_LEVEL = 48.0f;
    private static final int SUPPORTED_OUT_CHANNELS = 7420;
    private AudioDeviceInfo mPreferredDevice = null;
    @GuardedBy(value={"mRoutingChangeListeners"})
    private ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> mRoutingChangeListeners = new ArrayMap();
    private final Utils.ListenerList<AudioMetadataReadMap> mCodecFormatChangedListeners = new Utils.ListenerList();
    private final Object mStreamEventCbLock = new Object();
    @GuardedBy(value={"mStreamEventCbLock"})
    private LinkedList<StreamEventCbInfo> mStreamEventCbInfoList = new LinkedList();
    private HandlerThread mStreamEventHandlerThread;
    private volatile StreamEventHandler mStreamEventHandler;

    public AudioTrack(int streamType, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes, int mode) throws IllegalArgumentException {
        this(streamType, sampleRateInHz, channelConfig, audioFormat, bufferSizeInBytes, mode, 0);
    }

    public AudioTrack(int streamType, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes, int mode, int sessionId) throws IllegalArgumentException {
        this(new AudioAttributes.Builder().setLegacyStreamType(streamType).build(), new AudioFormat.Builder().setChannelMask(channelConfig).setEncoding(audioFormat).setSampleRate(sampleRateInHz).build(), bufferSizeInBytes, mode, sessionId);
        AudioTrack.deprecateStreamTypeForPlayback(streamType, "AudioTrack", "AudioTrack()");
    }

    public AudioTrack(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int mode, int sessionId) throws IllegalArgumentException {
        this(attributes, format, bufferSizeInBytes, mode, sessionId, false, 0, null);
    }

    private AudioTrack(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int mode, int sessionId, boolean offload, int encapsulationMode, TunerConfiguration tunerConfiguration) throws IllegalArgumentException {
        super(attributes, 1);
        int rate;
        Looper looper;
        this.mConfiguredAudioAttributes = attributes;
        if (format == null) {
            throw new IllegalArgumentException("Illegal null AudioFormat");
        }
        if (AudioTrack.shouldEnablePowerSaving(this.mAttributes, format, bufferSizeInBytes, mode)) {
            this.mAttributes = new AudioAttributes.Builder(this.mAttributes).replaceFlags((this.mAttributes.getAllFlags() | 0x200) & 0xFFFFFEFF).build();
        }
        if ((looper = Looper.myLooper()) == null) {
            looper = Looper.getMainLooper();
        }
        if ((rate = format.getSampleRate()) == 0) {
            rate = 0;
        }
        int channelIndexMask = 0;
        if ((format.getPropertySetMask() & 8) != 0) {
            channelIndexMask = format.getChannelIndexMask();
        }
        int channelMask = 0;
        if ((format.getPropertySetMask() & 4) != 0) {
            channelMask = format.getChannelMask();
        } else if (channelIndexMask == 0) {
            channelMask = 12;
        }
        int encoding = 1;
        if ((format.getPropertySetMask() & 1) != 0) {
            encoding = format.getEncoding();
        }
        this.audioParamCheck(rate, channelMask, channelIndexMask, encoding, mode);
        this.mOffloaded = offload;
        this.mStreamType = -1;
        this.audioBuffSizeCheck(bufferSizeInBytes);
        this.mInitializationLooper = looper;
        if (sessionId < 0) {
            throw new IllegalArgumentException("Invalid audio session ID: " + sessionId);
        }
        int[] sampleRate = new int[]{this.mSampleRate};
        int[] session = new int[]{sessionId};
        int initResult = this.native_setup(new WeakReference<AudioTrack>(this), this.mAttributes, sampleRate, this.mChannelMask, this.mChannelIndexMask, this.mAudioFormat, this.mNativeBufferSizeInBytes, this.mDataLoadMode, session, 0L, offload, encapsulationMode, tunerConfiguration);
        if (initResult != 0) {
            AudioTrack.loge("Error code " + initResult + " when initializing AudioTrack.");
            return;
        }
        this.mSampleRate = sampleRate[0];
        this.mSessionId = session[0];
        if ((this.mAttributes.getFlags() & 0x10) != 0) {
            int frameSizeInBytes = AudioFormat.isEncodingLinearFrames(this.mAudioFormat) ? this.mChannelCount * AudioFormat.getBytesPerSample(this.mAudioFormat) : 1;
            this.mOffset = (int)Math.ceil(20.0f / (float)frameSizeInBytes) * frameSizeInBytes;
        }
        this.mState = this.mDataLoadMode == 0 ? 2 : 1;
        this.baseRegisterPlayer();
    }

    AudioTrack(long nativeTrackInJavaObj) {
        super(new AudioAttributes.Builder().build(), 1);
        this.mNativeTrackInJavaObj = 0L;
        this.mJniData = 0L;
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        this.mInitializationLooper = looper;
        if (nativeTrackInJavaObj != 0L) {
            this.baseRegisterPlayer();
            this.deferred_connect(nativeTrackInJavaObj);
        } else {
            this.mState = 0;
        }
    }

    @UnsupportedAppUsage
    void deferred_connect(long nativeTrackInJavaObj) {
        if (this.mState != 1) {
            int[] session = new int[]{0};
            int[] rates = new int[]{0};
            int initResult = this.native_setup(new WeakReference<AudioTrack>(this), null, rates, 0, 0, 0, 0, 0, session, nativeTrackInJavaObj, false, 0, null);
            if (initResult != 0) {
                AudioTrack.loge("Error code " + initResult + " when initializing AudioTrack.");
                return;
            }
            this.mSessionId = session[0];
            this.mState = 1;
        }
    }

    public void setOffloadDelayPadding(int delayInFrames, int paddingInFrames) {
        if (paddingInFrames < 0) {
            throw new IllegalArgumentException("Illegal negative padding");
        }
        if (delayInFrames < 0) {
            throw new IllegalArgumentException("Illegal negative delay");
        }
        if (!this.mOffloaded) {
            throw new IllegalStateException("Illegal use of delay/padding on non-offloaded track");
        }
        if (this.mState == 0) {
            throw new IllegalStateException("Uninitialized track");
        }
        this.mOffloadDelayFrames = delayInFrames;
        this.mOffloadPaddingFrames = paddingInFrames;
        this.native_set_delay_padding(delayInFrames, paddingInFrames);
    }

    public int getOffloadDelay() {
        if (!this.mOffloaded) {
            throw new IllegalStateException("Illegal query of delay on non-offloaded track");
        }
        if (this.mState == 0) {
            throw new IllegalStateException("Illegal query of delay on uninitialized track");
        }
        return this.mOffloadDelayFrames;
    }

    public int getOffloadPadding() {
        if (!this.mOffloaded) {
            throw new IllegalStateException("Illegal query of padding on non-offloaded track");
        }
        if (this.mState == 0) {
            throw new IllegalStateException("Illegal query of padding on uninitialized track");
        }
        return this.mOffloadPaddingFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffloadEndOfStream() {
        if (!this.mOffloaded) {
            throw new IllegalStateException("EOS not supported on non-offloaded track");
        }
        if (this.mState == 0) {
            throw new IllegalStateException("Uninitialized track");
        }
        if (this.mPlayState != 3) {
            throw new IllegalStateException("EOS not supported if not playing");
        }
        Object object = this.mStreamEventCbLock;
        synchronized (object) {
            if (this.mStreamEventCbInfoList.size() == 0) {
                throw new IllegalStateException("EOS not supported without StreamEventCallback");
            }
        }
        object = this.mPlayStateLock;
        synchronized (object) {
            this.native_stop();
            this.mOffloadEosPending = true;
            this.mPlayState = 4;
        }
    }

    public boolean isOffloadedPlayback() {
        return this.mOffloaded;
    }

    public static boolean isDirectPlaybackSupported(AudioFormat format, AudioAttributes attributes) {
        if (format == null) {
            throw new IllegalArgumentException("Illegal null AudioFormat argument");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes argument");
        }
        return AudioTrack.native_is_direct_output_supported(format.getEncoding(), format.getSampleRate(), format.getChannelMask(), format.getChannelIndexMask(), attributes.getContentType(), attributes.getUsage(), attributes.getFlags());
    }

    private static boolean isValidAudioDescriptionMixLevel(float level) {
        return !Float.isNaN(level) && !(level > 48.0f);
    }

    public boolean setAudioDescriptionMixLeveldB(float level) {
        if (!AudioTrack.isValidAudioDescriptionMixLevel(level)) {
            throw new IllegalArgumentException("level is out of range" + level);
        }
        return this.native_set_audio_description_mix_level_db(level) == 0;
    }

    public float getAudioDescriptionMixLeveldB() {
        float[] level = new float[]{Float.NEGATIVE_INFINITY};
        try {
            int status = this.native_get_audio_description_mix_level_db(level);
            if (status != 0 || Float.isNaN(level[0])) {
                return Float.NEGATIVE_INFINITY;
            }
        }
        catch (Exception e) {
            return Float.NEGATIVE_INFINITY;
        }
        return level[0];
    }

    private static boolean isValidDualMonoMode(int dualMonoMode) {
        switch (dualMonoMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean setDualMonoMode(int dualMonoMode) {
        if (!AudioTrack.isValidDualMonoMode(dualMonoMode)) {
            throw new IllegalArgumentException("Invalid Dual Mono mode " + dualMonoMode);
        }
        return this.native_set_dual_mono_mode(dualMonoMode) == 0;
    }

    public int getDualMonoMode() {
        int[] dualMonoMode = new int[]{0};
        try {
            int status = this.native_get_dual_mono_mode(dualMonoMode);
            if (status != 0 || !AudioTrack.isValidDualMonoMode(dualMonoMode[0])) {
                return 0;
            }
        }
        catch (Exception e) {
            return 0;
        }
        return dualMonoMode[0];
    }

    private static boolean shouldEnablePowerSaving(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int mode) {
        int flags = attributes.getAllFlags() & 0x318;
        if (attributes != null && (flags != 0 || attributes.getUsage() != 1 || attributes.getContentType() != 0 && attributes.getContentType() != 2 && attributes.getContentType() != 3)) {
            return false;
        }
        if (format == null || format.getSampleRate() == 0 || !AudioFormat.isEncodingLinearPcm(format.getEncoding()) || !AudioFormat.isValidEncoding(format.getEncoding()) || format.getChannelCount() < 1) {
            return false;
        }
        if (mode != 1) {
            return false;
        }
        if (bufferSizeInBytes != 0) {
            long BUFFER_TARGET_MODE_STREAM_MS = 100L;
            int MILLIS_PER_SECOND = 1000;
            long bufferTargetSize = 100L * (long)format.getChannelCount() * (long)AudioFormat.getBytesPerSample(format.getEncoding()) * (long)format.getSampleRate() / 1000L;
            if ((long)bufferSizeInBytes < bufferTargetSize) {
                return false;
            }
        }
        return true;
    }

    private void audioParamCheck(int sampleRateInHz, int channelConfig, int channelIndexMask, int audioFormat, int mode) {
        if ((sampleRateInHz < 4000 || sampleRateInHz > 192000) && sampleRateInHz != 0) {
            throw new IllegalArgumentException(sampleRateInHz + "Hz is not a supported sample rate.");
        }
        this.mSampleRate = sampleRateInHz;
        if (audioFormat == 13 && channelConfig != 12) {
            throw new IllegalArgumentException("ENCODING_IEC61937 must be configured as CHANNEL_OUT_STEREO");
        }
        this.mChannelConfiguration = channelConfig;
        switch (channelConfig) {
            case 1: 
            case 2: 
            case 4: {
                this.mChannelCount = 1;
                this.mChannelMask = 4;
                break;
            }
            case 3: 
            case 12: {
                this.mChannelCount = 2;
                this.mChannelMask = 12;
                break;
            }
            default: {
                if (channelConfig == 0 && channelIndexMask != 0) {
                    this.mChannelCount = 0;
                    break;
                }
                if (!AudioTrack.isMultichannelConfigSupported(channelConfig)) {
                    throw new IllegalArgumentException("Unsupported channel configuration.");
                }
                this.mChannelMask = channelConfig;
                this.mChannelCount = AudioFormat.channelCountFromOutChannelMask(channelConfig);
            }
        }
        this.mChannelIndexMask = channelIndexMask;
        if (this.mChannelIndexMask != 0) {
            int indexMask = (1 << AudioSystem.OUT_CHANNEL_COUNT_MAX) - 1;
            if ((channelIndexMask & ~indexMask) != 0) {
                throw new IllegalArgumentException("Unsupported channel index configuration " + channelIndexMask);
            }
            int channelIndexCount = Integer.bitCount(channelIndexMask);
            if (this.mChannelCount == 0) {
                this.mChannelCount = channelIndexCount;
            } else if (this.mChannelCount != channelIndexCount) {
                throw new IllegalArgumentException("Channel count must match");
            }
        }
        if (audioFormat == 1) {
            audioFormat = 2;
        }
        if (!AudioFormat.isPublicEncoding(audioFormat)) {
            throw new IllegalArgumentException("Unsupported audio encoding.");
        }
        this.mAudioFormat = audioFormat;
        if (mode != 1 && mode != 0 || mode != 1 && !AudioFormat.isEncodingLinearPcm(this.mAudioFormat)) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        this.mDataLoadMode = mode;
    }

    private static boolean isMultichannelConfigSupported(int channelConfig) {
        if ((channelConfig & 0x1CFC) != channelConfig) {
            AudioTrack.loge("Channel configuration features unsupported channels");
            return false;
        }
        int channelCount = AudioFormat.channelCountFromOutChannelMask(channelConfig);
        if (channelCount > AudioSystem.OUT_CHANNEL_COUNT_MAX) {
            AudioTrack.loge("Channel configuration contains too many channels " + channelCount + ">" + AudioSystem.OUT_CHANNEL_COUNT_MAX);
            return false;
        }
        int frontPair = 12;
        if ((channelConfig & 0xC) != 12) {
            AudioTrack.loge("Front channels must be present in multichannel configurations");
            return false;
        }
        int backPair = 192;
        if ((channelConfig & 0xC0) != 0 && (channelConfig & 0xC0) != 192) {
            AudioTrack.loge("Rear channels can't be used independently");
            return false;
        }
        int sidePair = 6144;
        if ((channelConfig & 0x1800) != 0 && (channelConfig & 0x1800) != 6144) {
            AudioTrack.loge("Side channels can't be used independently");
            return false;
        }
        return true;
    }

    private void audioBuffSizeCheck(int audioBufferSize) {
        int frameSizeInBytes = AudioFormat.isEncodingLinearFrames(this.mAudioFormat) ? this.mChannelCount * AudioFormat.getBytesPerSample(this.mAudioFormat) : 1;
        if (audioBufferSize % frameSizeInBytes != 0 || audioBufferSize < 1) {
            throw new IllegalArgumentException("Invalid audio buffer size.");
        }
        this.mNativeBufferSizeInBytes = audioBufferSize;
        this.mNativeBufferSizeInFrames = audioBufferSize / frameSizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.mStreamEventCbLock;
        synchronized (object) {
            this.endStreamEventHandling();
        }
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.baseRelease();
        this.native_release();
        object = this.mPlayStateLock;
        synchronized (object) {
            this.mState = 0;
            this.mPlayState = 1;
            this.mPlayStateLock.notify();
        }
    }

    protected void finalize() {
        this.baseRelease();
        this.native_finalize();
    }

    public static float getMinVolume() {
        return 0.0f;
    }

    public static float getMaxVolume() {
        return 1.0f;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getPlaybackRate() {
        return this.native_get_playback_rate();
    }

    public PlaybackParams getPlaybackParams() {
        return this.native_get_playback_params();
    }

    public AudioAttributes getAudioAttributes() {
        if (this.mState == 0 || this.mConfiguredAudioAttributes == null) {
            throw new IllegalStateException("track not initialized");
        }
        return this.mConfiguredAudioAttributes;
    }

    public int getAudioFormat() {
        return this.mAudioFormat;
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    public int getChannelConfiguration() {
        return this.mChannelConfiguration;
    }

    public AudioFormat getFormat() {
        AudioFormat.Builder builder = new AudioFormat.Builder().setSampleRate(this.mSampleRate).setEncoding(this.mAudioFormat);
        if (this.mChannelConfiguration != 0) {
            builder.setChannelMask(this.mChannelConfiguration);
        }
        if (this.mChannelIndexMask != 0) {
            builder.setChannelIndexMask(this.mChannelIndexMask);
        }
        return builder.build();
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public int getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayState() {
        Object object = this.mPlayStateLock;
        synchronized (object) {
            switch (this.mPlayState) {
                case 4: {
                    return 3;
                }
                case 5: {
                    return 2;
                }
            }
            return this.mPlayState;
        }
    }

    public int getBufferSizeInFrames() {
        return this.native_get_buffer_size_frames();
    }

    public int setBufferSizeInFrames(int bufferSizeInFrames) {
        if (this.mDataLoadMode == 0 || this.mState == 0) {
            return -3;
        }
        if (bufferSizeInFrames < 0) {
            return -2;
        }
        return this.native_set_buffer_size_frames(bufferSizeInFrames);
    }

    public int getBufferCapacityInFrames() {
        return this.native_get_buffer_capacity_frames();
    }

    @Deprecated
    protected int getNativeFrameCount() {
        return this.native_get_buffer_capacity_frames();
    }

    public int getNotificationMarkerPosition() {
        return this.native_get_marker_pos();
    }

    public int getPositionNotificationPeriod() {
        return this.native_get_pos_update_period();
    }

    public int getPlaybackHeadPosition() {
        return this.native_get_position();
    }

    @UnsupportedAppUsage(trackingBug=130237544L)
    public int getLatency() {
        return this.native_get_latency();
    }

    public int getUnderrunCount() {
        return this.native_get_underrun_count();
    }

    public int getPerformanceMode() {
        int flags = this.native_get_flags();
        if ((flags & 4) != 0) {
            return 1;
        }
        if ((flags & 8) != 0) {
            return 2;
        }
        return 0;
    }

    public static int getNativeOutputSampleRate(int streamType) {
        return AudioTrack.native_get_output_sample_rate(streamType);
    }

    public static int getMinBufferSize(int sampleRateInHz, int channelConfig, int audioFormat) {
        int channelCount = 0;
        switch (channelConfig) {
            case 2: 
            case 4: {
                channelCount = 1;
                break;
            }
            case 3: 
            case 12: {
                channelCount = 2;
                break;
            }
            default: {
                if (!AudioTrack.isMultichannelConfigSupported(channelConfig)) {
                    AudioTrack.loge("getMinBufferSize(): Invalid channel configuration.");
                    return -2;
                }
                channelCount = AudioFormat.channelCountFromOutChannelMask(channelConfig);
            }
        }
        if (!AudioFormat.isPublicEncoding(audioFormat)) {
            AudioTrack.loge("getMinBufferSize(): Invalid audio format.");
            return -2;
        }
        if (sampleRateInHz < 4000 || sampleRateInHz > 192000) {
            AudioTrack.loge("getMinBufferSize(): " + sampleRateInHz + " Hz is not a supported sample rate.");
            return -2;
        }
        int size = AudioTrack.native_get_min_buff_size(sampleRateInHz, channelCount, audioFormat);
        if (size <= 0) {
            AudioTrack.loge("getMinBufferSize(): error querying hardware");
            return -1;
        }
        return size;
    }

    public int getAudioSessionId() {
        return this.mSessionId;
    }

    public boolean getTimestamp(AudioTimestamp timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException();
        }
        long[] longArray = new long[2];
        int ret = this.native_get_timestamp(longArray);
        if (ret != 0) {
            return false;
        }
        timestamp.framePosition = longArray[0];
        timestamp.nanoTime = longArray[1];
        return true;
    }

    public int getTimestampWithStatus(AudioTimestamp timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException();
        }
        long[] longArray = new long[2];
        int ret = this.native_get_timestamp(longArray);
        timestamp.framePosition = longArray[0];
        timestamp.nanoTime = longArray[1];
        return ret;
    }

    public PersistableBundle getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private PersistableBundle native_getMetrics() {
        return (PersistableBundle)OverrideMethod.invokeA("android.media.AudioTrack#native_getMetrics()Landroid/os/PersistableBundle;", true, this);
    }

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener listener) {
        this.setPlaybackPositionUpdateListener(listener, null);
    }

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener listener, Handler handler) {
        this.mEventHandlerDelegate = listener != null ? new NativePositionEventHandlerDelegate(this, listener, handler) : null;
    }

    private static float clampGainOrLevel(float gainOrLevel) {
        if (Float.isNaN(gainOrLevel)) {
            throw new IllegalArgumentException();
        }
        if (gainOrLevel < 0.0f) {
            gainOrLevel = 0.0f;
        } else if (gainOrLevel > 1.0f) {
            gainOrLevel = 1.0f;
        }
        return gainOrLevel;
    }

    @Deprecated
    public int setStereoVolume(float leftGain, float rightGain) {
        if (this.mState == 0) {
            return -3;
        }
        this.baseSetVolume(leftGain, rightGain);
        return 0;
    }

    @Override
    void playerSetVolume(boolean muting, float leftVolume, float rightVolume) {
        leftVolume = AudioTrack.clampGainOrLevel(muting ? 0.0f : leftVolume);
        rightVolume = AudioTrack.clampGainOrLevel(muting ? 0.0f : rightVolume);
        this.native_setVolume(leftVolume, rightVolume);
    }

    public int setVolume(float gain) {
        return this.setStereoVolume(gain, gain);
    }

    @Override
    int playerApplyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
        return this.native_applyVolumeShaper(configuration, operation);
    }

    @Override
    VolumeShaper.State playerGetVolumeShaperState(int id2) {
        return this.native_getVolumeShaperState(id2);
    }

    @Override
    public VolumeShaper createVolumeShaper(VolumeShaper.Configuration configuration) {
        return new VolumeShaper(configuration, this);
    }

    public int setPlaybackRate(int sampleRateInHz) {
        if (this.mState != 1) {
            return -3;
        }
        if (sampleRateInHz <= 0) {
            return -2;
        }
        return this.native_set_playback_rate(sampleRateInHz);
    }

    public void setPlaybackParams(PlaybackParams params) {
        if (params == null) {
            throw new IllegalArgumentException("params is null");
        }
        this.native_set_playback_params(params);
    }

    public int setNotificationMarkerPosition(int markerInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_marker_pos(markerInFrames);
    }

    public int setPositionNotificationPeriod(int periodInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_pos_update_period(periodInFrames);
    }

    public int setPlaybackHeadPosition(int positionInFrames) {
        if (this.mDataLoadMode == 1 || this.mState == 0 || this.getPlayState() == 3) {
            return -3;
        }
        if (0 > positionInFrames || positionInFrames > this.mNativeBufferSizeInFrames) {
            return -2;
        }
        return this.native_set_position(positionInFrames);
    }

    public int setLoopPoints(int startInFrames, int endInFrames, int loopCount) {
        if (this.mDataLoadMode == 1 || this.mState == 0 || this.getPlayState() == 3) {
            return -3;
        }
        if (loopCount != 0 && (0 > startInFrames || startInFrames >= this.mNativeBufferSizeInFrames || startInFrames >= endInFrames || endInFrames > this.mNativeBufferSizeInFrames)) {
            return -2;
        }
        return this.native_set_loop(startInFrames, endInFrames, loopCount);
    }

    public int setPresentation(AudioPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException("audio presentation is null");
        }
        return this.native_setPresentation(presentation.getPresentationId(), presentation.getProgramId());
    }

    @Deprecated
    protected void setState(int state) {
        this.mState = state;
    }

    public void play() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("play() called on uninitialized AudioTrack.");
        }
        final int delay = this.getStartDelayMs();
        if (delay == 0) {
            this.startImpl();
        } else {
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    AudioTrack.this.baseSetStartDelayMs(0);
                    try {
                        AudioTrack.this.startImpl();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startImpl() {
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.baseStart();
            this.native_start();
            if (this.mPlayState == 5) {
                this.mPlayState = 4;
            } else {
                this.mPlayState = 3;
                this.mOffloadEosPending = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("stop() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_stop();
            this.baseStop();
            if (this.mOffloaded && this.mPlayState != 5) {
                this.mPlayState = 4;
            } else {
                this.mPlayState = 1;
                this.mOffloadEosPending = false;
                this.mAvSyncHeader = null;
                this.mAvSyncBytesRemaining = 0;
                this.mPlayStateLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("pause() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_pause();
            this.basePause();
            this.mPlayState = this.mPlayState == 4 ? 5 : 2;
        }
    }

    public void flush() {
        if (this.mState == 1) {
            this.native_flush();
            this.mAvSyncHeader = null;
            this.mAvSyncBytesRemaining = 0;
        }
    }

    public int write(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        return this.write(audioData, offsetInBytes, sizeInBytes, 0);
    }

    public int write(byte[] audioData, int offsetInBytes, int sizeInBytes, int writeMode) {
        if (this.mState == 0 || this.mAudioFormat == 4) {
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInBytes < 0 || sizeInBytes < 0 || offsetInBytes + sizeInBytes < 0 || offsetInBytes + sizeInBytes > audioData.length) {
            return -2;
        }
        if (!this.blockUntilOffloadDrain(writeMode)) {
            return 0;
        }
        int ret = this.native_write_byte(audioData, offsetInBytes, sizeInBytes, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    public int write(short[] audioData, int offsetInShorts, int sizeInShorts) {
        return this.write(audioData, offsetInShorts, sizeInShorts, 0);
    }

    public int write(short[] audioData, int offsetInShorts, int sizeInShorts, int writeMode) {
        if (this.mState == 0 || this.mAudioFormat == 4) {
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInShorts < 0 || sizeInShorts < 0 || offsetInShorts + sizeInShorts < 0 || offsetInShorts + sizeInShorts > audioData.length) {
            return -2;
        }
        if (!this.blockUntilOffloadDrain(writeMode)) {
            return 0;
        }
        int ret = this.native_write_short(audioData, offsetInShorts, sizeInShorts, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    public int write(float[] audioData, int offsetInFloats, int sizeInFloats, int writeMode) {
        if (this.mState == 0) {
            Log.e(TAG, "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (this.mAudioFormat != 4) {
            Log.e(TAG, "AudioTrack.write(float[] ...) requires format ENCODING_PCM_FLOAT");
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInFloats < 0 || sizeInFloats < 0 || offsetInFloats + sizeInFloats < 0 || offsetInFloats + sizeInFloats > audioData.length) {
            Log.e(TAG, "AudioTrack.write() called with invalid array, offset, or size");
            return -2;
        }
        if (!this.blockUntilOffloadDrain(writeMode)) {
            return 0;
        }
        int ret = this.native_write_float(audioData, offsetInFloats, sizeInFloats, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    public int write(ByteBuffer audioData, int sizeInBytes, int writeMode) {
        if (this.mState == 0) {
            Log.e(TAG, "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || sizeInBytes < 0 || sizeInBytes > audioData.remaining()) {
            Log.e(TAG, "AudioTrack.write() called with invalid size (" + sizeInBytes + ") value");
            return -2;
        }
        if (!this.blockUntilOffloadDrain(writeMode)) {
            return 0;
        }
        int ret = 0;
        ret = audioData.isDirect() ? this.native_write_native_bytes(audioData, audioData.position(), sizeInBytes, this.mAudioFormat, writeMode == 0) : this.native_write_byte(NioUtils.unsafeArray((ByteBuffer)audioData), NioUtils.unsafeArrayOffset((ByteBuffer)audioData) + audioData.position(), sizeInBytes, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        if (ret > 0) {
            audioData.position(audioData.position() + ret);
        }
        return ret;
    }

    public int write(ByteBuffer audioData, int sizeInBytes, int writeMode, long timestamp) {
        int sizeToWrite;
        if (this.mState == 0) {
            Log.e(TAG, "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (this.mDataLoadMode != 1) {
            Log.e(TAG, "AudioTrack.write() with timestamp called for non-streaming mode track");
            return -3;
        }
        if ((this.mAttributes.getFlags() & 0x10) == 0) {
            Log.d(TAG, "AudioTrack.write() called on a regular AudioTrack. Ignoring pts...");
            return this.write(audioData, sizeInBytes, writeMode);
        }
        if (audioData == null || sizeInBytes < 0 || sizeInBytes > audioData.remaining()) {
            Log.e(TAG, "AudioTrack.write() called with invalid size (" + sizeInBytes + ") value");
            return -2;
        }
        if (!this.blockUntilOffloadDrain(writeMode)) {
            return 0;
        }
        if (this.mAvSyncHeader == null) {
            this.mAvSyncHeader = ByteBuffer.allocate(this.mOffset);
            this.mAvSyncHeader.order(ByteOrder.BIG_ENDIAN);
            this.mAvSyncHeader.putInt(0x55550002);
        }
        if (this.mAvSyncBytesRemaining == 0) {
            this.mAvSyncHeader.putInt(4, sizeInBytes);
            this.mAvSyncHeader.putLong(8, timestamp);
            this.mAvSyncHeader.putInt(16, this.mOffset);
            this.mAvSyncHeader.position(0);
            this.mAvSyncBytesRemaining = sizeInBytes;
        }
        int ret = 0;
        if (this.mAvSyncHeader.remaining() != 0) {
            ret = this.write(this.mAvSyncHeader, this.mAvSyncHeader.remaining(), writeMode);
            if (ret < 0) {
                Log.e(TAG, "AudioTrack.write() could not write timestamp header!");
                this.mAvSyncHeader = null;
                this.mAvSyncBytesRemaining = 0;
                return ret;
            }
            if (this.mAvSyncHeader.remaining() > 0) {
                Log.v(TAG, "AudioTrack.write() partial timestamp header written.");
                return 0;
            }
        }
        if ((ret = this.write(audioData, sizeToWrite = Math.min(this.mAvSyncBytesRemaining, sizeInBytes), writeMode)) < 0) {
            Log.e(TAG, "AudioTrack.write() could not write audio data!");
            this.mAvSyncHeader = null;
            this.mAvSyncBytesRemaining = 0;
            return ret;
        }
        this.mAvSyncBytesRemaining -= ret;
        return ret;
    }

    public int reloadStaticData() {
        if (this.mDataLoadMode == 1 || this.mState != 1) {
            return -3;
        }
        return this.native_reload_static();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean blockUntilOffloadDrain(int writeMode) {
        Object object = this.mPlayStateLock;
        synchronized (object) {
            while (this.mPlayState == 4 || this.mPlayState == 5) {
                if (writeMode == 1) {
                    return false;
                }
                try {
                    this.mPlayStateLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
    }

    public int attachAuxEffect(int effectId) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_attachAuxEffect(effectId);
    }

    public int setAuxEffectSendLevel(float level) {
        if (this.mState == 0) {
            return -3;
        }
        return this.baseSetAuxEffectSendLevel(level);
    }

    @Override
    int playerSetAuxEffectSendLevel(boolean muting, float level) {
        level = AudioTrack.clampGainOrLevel(muting ? 0.0f : level);
        int err = this.native_setAuxEffectSendLevel(level);
        return err == 0 ? 0 : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPreferredDevice(AudioDeviceInfo deviceInfo) {
        if (deviceInfo != null && !deviceInfo.isSink()) {
            return false;
        }
        int preferredDeviceId = deviceInfo != null ? deviceInfo.getId() : 0;
        boolean status = this.native_setOutputDevice(preferredDeviceId);
        if (status) {
            AudioTrack audioTrack = this;
            synchronized (audioTrack) {
                this.mPreferredDevice = deviceInfo;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioDeviceInfo getPreferredDevice() {
        AudioTrack audioTrack = this;
        synchronized (audioTrack) {
            return this.mPreferredDevice;
        }
    }

    @Override
    public AudioDeviceInfo getRoutedDevice() {
        int deviceId = this.native_getRoutedDeviceId();
        if (deviceId == 0) {
            return null;
        }
        AudioDeviceInfo[] devices = AudioManager.getDevicesStatic(2);
        for (int i = 0; i < devices.length; ++i) {
            if (devices[i].getId() != deviceId) continue;
            return devices[i];
        }
        return null;
    }

    @GuardedBy(value={"mRoutingChangeListeners"})
    private void testEnableNativeRoutingCallbacksLocked() {
        if (this.mRoutingChangeListeners.size() == 0) {
            this.native_enableDeviceCallback();
        }
    }

    @GuardedBy(value={"mRoutingChangeListeners"})
    private void testDisableNativeRoutingCallbacksLocked() {
        if (this.mRoutingChangeListeners.size() == 0) {
            this.native_disableDeviceCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener, Handler handler) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (listener != null && !this.mRoutingChangeListeners.containsKey(listener)) {
                this.testEnableNativeRoutingCallbacksLocked();
                this.mRoutingChangeListeners.put(listener, new NativeRoutingEventHandlerDelegate(this, listener, handler != null ? handler : new Handler(this.mInitializationLooper)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (this.mRoutingChangeListeners.containsKey(listener)) {
                this.mRoutingChangeListeners.remove(listener);
            }
            this.testDisableNativeRoutingCallbacksLocked();
        }
    }

    @Deprecated
    public void addOnRoutingChangedListener(OnRoutingChangedListener listener, Handler handler) {
        this.addOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)listener, handler);
    }

    @Deprecated
    public void removeOnRoutingChangedListener(OnRoutingChangedListener listener) {
        this.removeOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastRoutingChange() {
        AudioManager.resetAudioPortGeneration();
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            for (NativeRoutingEventHandlerDelegate delegate : this.mRoutingChangeListeners.values()) {
                delegate.notifyClient();
            }
        }
    }

    public void addOnCodecFormatChangedListener(Executor executor, OnCodecFormatChangedListener listener) {
        this.mCodecFormatChangedListeners.add(listener, executor, (eventCode, readMap) -> listener.onCodecFormatChanged(this, (AudioMetadataReadMap)readMap));
    }

    public void removeOnCodecFormatChangedListener(OnCodecFormatChangedListener listener) {
        this.mCodecFormatChangedListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStreamEventCallback(Executor executor, StreamEventCallback eventCallback) {
        if (eventCallback == null) {
            throw new IllegalArgumentException("Illegal null StreamEventCallback");
        }
        if (!this.mOffloaded) {
            throw new IllegalStateException("Cannot register StreamEventCallback on non-offloaded AudioTrack");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Illegal null Executor for the StreamEventCallback");
        }
        Object object = this.mStreamEventCbLock;
        synchronized (object) {
            for (StreamEventCbInfo seci : this.mStreamEventCbInfoList) {
                if (seci.mStreamEventCb != eventCallback) continue;
                throw new IllegalArgumentException("StreamEventCallback already registered");
            }
            this.beginStreamEventHandling();
            this.mStreamEventCbInfoList.add(new StreamEventCbInfo(executor, eventCallback));
        }
    }

    public void unregisterStreamEventCallback(StreamEventCallback eventCallback) {
        if (eventCallback == null) {
            throw new IllegalArgumentException("Illegal null StreamEventCallback");
        }
        if (!this.mOffloaded) {
            throw new IllegalStateException("No StreamEventCallback on non-offloaded AudioTrack");
        }
        Object object = this.mStreamEventCbLock;
        synchronized (object) {
            Object seciToRemove = null;
            for (StreamEventCbInfo seci : this.mStreamEventCbInfoList) {
                if (seci.mStreamEventCb != eventCallback) continue;
                this.mStreamEventCbInfoList.remove(seci);
                if (this.mStreamEventCbInfoList.size() == 0) {
                    this.endStreamEventHandling();
                }
                return;
            }
            throw new IllegalArgumentException("StreamEventCallback was not registered");
        }
    }

    void handleStreamEventFromNative(int what, int arg) {
        if (this.mStreamEventHandler == null) {
            return;
        }
        switch (what) {
            case 9: {
                this.mStreamEventHandler.removeMessages(9);
                this.mStreamEventHandler.sendMessage(this.mStreamEventHandler.obtainMessage(9, arg, 0));
                break;
            }
            case 6: {
                this.mStreamEventHandler.sendMessage(this.mStreamEventHandler.obtainMessage(6));
                break;
            }
            case 7: {
                this.mStreamEventHandler.sendMessage(this.mStreamEventHandler.obtainMessage(7));
            }
        }
    }

    @GuardedBy(value={"mStreamEventCbLock"})
    private void beginStreamEventHandling() {
        if (this.mStreamEventHandlerThread == null) {
            this.mStreamEventHandlerThread = new HandlerThread("android.media.AudioTrack.StreamEvent");
            this.mStreamEventHandlerThread.start();
            Looper looper = this.mStreamEventHandlerThread.getLooper();
            if (looper != null) {
                this.mStreamEventHandler = new StreamEventHandler(looper);
            }
        }
    }

    @GuardedBy(value={"mStreamEventCbLock"})
    private void endStreamEventHandling() {
        if (this.mStreamEventHandlerThread != null) {
            this.mStreamEventHandlerThread.quit();
            this.mStreamEventHandlerThread = null;
        }
    }

    @Override
    void playerStart() {
        this.play();
    }

    @Override
    void playerPause() {
        this.pause();
    }

    @Override
    void playerStop() {
        this.stop();
    }

    @UnsupportedAppUsage
    private static void postEventFromNative(Object audiotrack_ref, int what, int arg1, int arg2, Object obj) {
        Handler handler;
        AudioTrack track = (AudioTrack)((WeakReference)audiotrack_ref).get();
        if (track == null) {
            return;
        }
        if (what == 1000) {
            track.broadcastRoutingChange();
            return;
        }
        if (what == 100) {
            ByteBuffer buffer = (ByteBuffer)obj;
            buffer.order(ByteOrder.nativeOrder());
            buffer.rewind();
            AudioMetadata.BaseMap audioMetaData = AudioMetadata.fromByteBuffer(buffer);
            if (audioMetaData == null) {
                Log.e(TAG, "Unable to get audio metadata from byte buffer");
                return;
            }
            track.mCodecFormatChangedListeners.notify(0, audioMetaData);
            return;
        }
        if (what == 9 || what == 6 || what == 7) {
            track.handleStreamEventFromNative(what, arg1);
            return;
        }
        NativePositionEventHandlerDelegate delegate = track.mEventHandlerDelegate;
        if (delegate != null && (handler = delegate.getHandler()) != null) {
            Message m = handler.obtainMessage(what, arg1, arg2, obj);
            handler.sendMessage(m);
        }
    }

    private static boolean native_is_direct_output_supported(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_is_direct_output_supported(IIIIIII)Z", true, null) != 0;
    }

    private int native_setup(Object object, Object object2, int[] nArray, int n, int n2, int n3, int n4, int n5, int[] nArray2, long l, boolean bl, int n6, Object object3) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_setup(Ljava/lang/Object;Ljava/lang/Object;[IIIIII[IJZILjava/lang/Object;)I", true, this);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_finalize()V", true, this);
    }

    @UnsupportedAppUsage
    public void native_release() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_release()V", true, this);
    }

    private void native_start() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_start()V", true, this);
    }

    private void native_stop() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_stop()V", true, this);
    }

    private void native_pause() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_pause()V", true, this);
    }

    private void native_flush() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_flush()V", true, this);
    }

    private int native_write_byte(byte[] byArray, int n, int n2, int n3, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_write_byte([BIIIZ)I", true, this);
    }

    private int native_write_short(short[] sArray, int n, int n2, int n3, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_write_short([SIIIZ)I", true, this);
    }

    private int native_write_float(float[] fArray, int n, int n2, int n3, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_write_float([FIIIZ)I", true, this);
    }

    private int native_write_native_bytes(ByteBuffer byteBuffer, int n, int n2, int n3, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_write_native_bytes(Ljava/nio/ByteBuffer;IIIZ)I", true, this);
    }

    private int native_reload_static() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_reload_static()I", true, this);
    }

    private int native_get_buffer_size_frames() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_buffer_size_frames()I", true, this);
    }

    private int native_set_buffer_size_frames(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_set_buffer_size_frames(I)I", true, this);
    }

    private int native_get_buffer_capacity_frames() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_buffer_capacity_frames()I", true, this);
    }

    private void native_setVolume(float f, float f2) {
        OverrideMethod.invokeV("android.media.AudioTrack#native_setVolume(FF)V", true, this);
    }

    private int native_set_playback_rate(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_set_playback_rate(I)I", true, this);
    }

    private int native_get_playback_rate() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_playback_rate()I", true, this);
    }

    private void native_set_playback_params(PlaybackParams playbackParams) {
        OverrideMethod.invokeV("android.media.AudioTrack#native_set_playback_params(Landroid/media/PlaybackParams;)V", true, this);
    }

    private PlaybackParams native_get_playback_params() {
        return (PlaybackParams)OverrideMethod.invokeA("android.media.AudioTrack#native_get_playback_params()Landroid/media/PlaybackParams;", true, this);
    }

    private int native_set_marker_pos(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_set_marker_pos(I)I", true, this);
    }

    private int native_get_marker_pos() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_marker_pos()I", true, this);
    }

    private int native_set_pos_update_period(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_set_pos_update_period(I)I", true, this);
    }

    private int native_get_pos_update_period() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_pos_update_period()I", true, this);
    }

    private int native_set_position(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_set_position(I)I", true, this);
    }

    private int native_get_position() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_position()I", true, this);
    }

    private int native_get_latency() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_latency()I", true, this);
    }

    private int native_get_underrun_count() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_underrun_count()I", true, this);
    }

    private int native_get_flags() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_flags()I", true, this);
    }

    private int native_get_timestamp(long[] lArray) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_timestamp([J)I", true, this);
    }

    private int native_set_loop(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_set_loop(III)I", true, this);
    }

    private static int native_get_output_sample_rate(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_output_sample_rate(I)I", true, null);
    }

    private static int native_get_min_buff_size(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_min_buff_size(III)I", true, null);
    }

    private int native_attachAuxEffect(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_attachAuxEffect(I)I", true, this);
    }

    private int native_setAuxEffectSendLevel(float f) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_setAuxEffectSendLevel(F)I", true, this);
    }

    private boolean native_setOutputDevice(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_setOutputDevice(I)Z", true, this) != 0;
    }

    private int native_getRoutedDeviceId() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_getRoutedDeviceId()I", true, this);
    }

    private void native_enableDeviceCallback() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_enableDeviceCallback()V", true, this);
    }

    private void native_disableDeviceCallback() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_disableDeviceCallback()V", true, this);
    }

    private int native_applyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_applyVolumeShaper(Landroid/media/VolumeShaper$Configuration;Landroid/media/VolumeShaper$Operation;)I", true, this);
    }

    private VolumeShaper.State native_getVolumeShaperState(int n) {
        return (VolumeShaper.State)OverrideMethod.invokeA("android.media.AudioTrack#native_getVolumeShaperState(I)Landroid/media/VolumeShaper$State;", true, this);
    }

    private int native_setPresentation(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_setPresentation(II)I", true, this);
    }

    private int native_getPortId() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_getPortId()I", true, this);
    }

    private void native_set_delay_padding(int n, int n2) {
        OverrideMethod.invokeV("android.media.AudioTrack#native_set_delay_padding(II)V", true, this);
    }

    private int native_set_audio_description_mix_level_db(float f) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_set_audio_description_mix_level_db(F)I", true, this);
    }

    private int native_get_audio_description_mix_level_db(float[] fArray) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_audio_description_mix_level_db([F)I", true, this);
    }

    private int native_set_dual_mono_mode(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_set_dual_mono_mode(I)I", true, this);
    }

    private int native_get_dual_mono_mode(int[] nArray) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_dual_mono_mode([I)I", true, this);
    }

    private static void logd(String msg) {
        Log.d(TAG, msg);
    }

    private static void loge(String msg) {
        Log.e(TAG, msg);
    }

    public static class MetricsConstants {
        private static final String MM_PREFIX = "android.media.audiotrack.";
        public static final String STREAMTYPE = "android.media.audiotrack.streamtype";
        public static final String CONTENTTYPE = "android.media.audiotrack.type";
        public static final String USAGE = "android.media.audiotrack.usage";
        @Deprecated
        public static final String SAMPLERATE = "android.media.audiorecord.samplerate";
        @Deprecated
        public static final String CHANNELMASK = "android.media.audiorecord.channelmask";
        public static final String SAMPLE_RATE = "android.media.audiotrack.sampleRate";
        public static final String CHANNEL_MASK = "android.media.audiotrack.channelMask";
        public static final String ENCODING = "android.media.audiotrack.encoding";
        public static final String PORT_ID = "android.media.audiotrack.portId";
        public static final String FRAME_COUNT = "android.media.audiotrack.frameCount";
        public static final String ATTRIBUTES = "android.media.audiotrack.attributes";

        private MetricsConstants() {
        }
    }

    private class NativePositionEventHandlerDelegate {
        private final Handler mHandler;

        NativePositionEventHandlerDelegate(final AudioTrack track, final OnPlaybackPositionUpdateListener listener, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : AudioTrack.this.mInitializationLooper;
            this.mHandler = looper != null ? new Handler(looper){

                @Override
                public void handleMessage(Message msg) {
                    if (track == null) {
                        return;
                    }
                    switch (msg.what) {
                        case 3: {
                            if (listener == null) break;
                            listener.onMarkerReached(track);
                            break;
                        }
                        case 4: {
                            if (listener == null) break;
                            listener.onPeriodicNotification(track);
                            break;
                        }
                        default: {
                            AudioTrack.loge("Unknown native event type: " + msg.what);
                        }
                    }
                }
            } : null;
        }

        Handler getHandler() {
            return this.mHandler;
        }
    }

    private class StreamEventHandler
    extends Handler {
        StreamEventHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            LinkedList cbInfoList;
            Object object = AudioTrack.this.mStreamEventCbLock;
            synchronized (object) {
                if (msg.what == 7) {
                    Object object2 = AudioTrack.this.mPlayStateLock;
                    synchronized (object2) {
                        if (AudioTrack.this.mPlayState == 4) {
                            if (AudioTrack.this.mOffloadEosPending) {
                                AudioTrack.this.native_start();
                                AudioTrack.this.mPlayState = 3;
                            } else {
                                AudioTrack.this.mAvSyncHeader = null;
                                AudioTrack.this.mAvSyncBytesRemaining = 0;
                                AudioTrack.this.mPlayState = 1;
                            }
                            AudioTrack.this.mOffloadEosPending = false;
                            AudioTrack.this.mPlayStateLock.notify();
                        }
                    }
                }
                if (AudioTrack.this.mStreamEventCbInfoList.size() == 0) {
                    return;
                }
                cbInfoList = new LinkedList(AudioTrack.this.mStreamEventCbInfoList);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                for (StreamEventCbInfo cbi : cbInfoList) {
                    switch (msg.what) {
                        case 9: {
                            cbi.mStreamEventExec.execute(() -> cbi.mStreamEventCb.onDataRequest(AudioTrack.this, msg.arg1));
                            break;
                        }
                        case 6: {
                            cbi.mStreamEventExec.execute(() -> cbi.mStreamEventCb.onTearDown(AudioTrack.this));
                            break;
                        }
                        case 7: {
                            cbi.mStreamEventExec.execute(() -> cbi.mStreamEventCb.onPresentationEnded(AudioTrack.this));
                        }
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private static class StreamEventCbInfo {
        final Executor mStreamEventExec;
        final StreamEventCallback mStreamEventCb;

        StreamEventCbInfo(Executor e, StreamEventCallback cb) {
            this.mStreamEventExec = e;
            this.mStreamEventCb = cb;
        }
    }

    public static abstract class StreamEventCallback {
        public void onTearDown(AudioTrack track) {
        }

        public void onPresentationEnded(AudioTrack track) {
        }

        public void onDataRequest(AudioTrack track, int sizeInFrames) {
        }
    }

    public static interface OnPlaybackPositionUpdateListener {
        public void onMarkerReached(AudioTrack var1);

        public void onPeriodicNotification(AudioTrack var1);
    }

    public static interface OnCodecFormatChangedListener {
        public void onCodecFormatChanged(AudioTrack var1, AudioMetadataReadMap var2);
    }

    @Deprecated
    public static interface OnRoutingChangedListener
    extends AudioRouting.OnRoutingChangedListener {
        public void onRoutingChanged(AudioTrack var1);

        @Override
        default public void onRoutingChanged(AudioRouting router) {
            if (router instanceof AudioTrack) {
                this.onRoutingChanged((AudioTrack)router);
            }
        }
    }

    public static class Builder {
        private AudioAttributes mAttributes;
        private AudioFormat mFormat;
        private int mBufferSizeInBytes;
        private int mEncapsulationMode = 0;
        private int mSessionId = 0;
        private int mMode = 1;
        private int mPerformanceMode = 0;
        private boolean mOffload = false;
        private TunerConfiguration mTunerConfiguration;

        public Builder setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
            if (attributes == null) {
                throw new IllegalArgumentException("Illegal null AudioAttributes argument");
            }
            this.mAttributes = attributes;
            return this;
        }

        public Builder setAudioFormat(AudioFormat format) throws IllegalArgumentException {
            if (format == null) {
                throw new IllegalArgumentException("Illegal null AudioFormat argument");
            }
            this.mFormat = format;
            return this;
        }

        public Builder setBufferSizeInBytes(int bufferSizeInBytes) throws IllegalArgumentException {
            if (bufferSizeInBytes <= 0) {
                throw new IllegalArgumentException("Invalid buffer size " + bufferSizeInBytes);
            }
            this.mBufferSizeInBytes = bufferSizeInBytes;
            return this;
        }

        public Builder setEncapsulationMode(int encapsulationMode) {
            switch (encapsulationMode) {
                case 0: 
                case 1: 
                case 2: {
                    this.mEncapsulationMode = encapsulationMode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid encapsulation mode " + encapsulationMode);
                }
            }
            return this;
        }

        public Builder setTransferMode(int mode) throws IllegalArgumentException {
            switch (mode) {
                case 0: 
                case 1: {
                    this.mMode = mode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transfer mode " + mode);
                }
            }
            return this;
        }

        public Builder setSessionId(int sessionId) throws IllegalArgumentException {
            if (sessionId != 0 && sessionId < 1) {
                throw new IllegalArgumentException("Invalid audio session ID " + sessionId);
            }
            this.mSessionId = sessionId;
            return this;
        }

        public Builder setPerformanceMode(int performanceMode) {
            switch (performanceMode) {
                case 0: 
                case 1: 
                case 2: {
                    this.mPerformanceMode = performanceMode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid performance mode " + performanceMode);
                }
            }
            return this;
        }

        public Builder setOffloadedPlayback(boolean offload) {
            this.mOffload = offload;
            return this;
        }

        @SystemApi
        public Builder setTunerConfiguration(TunerConfiguration tunerConfiguration) {
            if (tunerConfiguration == null) {
                throw new IllegalArgumentException("tunerConfiguration is null");
            }
            this.mTunerConfiguration = tunerConfiguration;
            return this;
        }

        public AudioTrack build() throws UnsupportedOperationException {
            if (this.mAttributes == null) {
                this.mAttributes = new AudioAttributes.Builder().setUsage(1).build();
            }
            switch (this.mPerformanceMode) {
                case 1: {
                    this.mAttributes = new AudioAttributes.Builder(this.mAttributes).replaceFlags((this.mAttributes.getAllFlags() | 0x100) & 0xFFFFFDFF).build();
                    break;
                }
                case 0: {
                    if (!AudioTrack.shouldEnablePowerSaving(this.mAttributes, this.mFormat, this.mBufferSizeInBytes, this.mMode)) break;
                }
                case 2: {
                    this.mAttributes = new AudioAttributes.Builder(this.mAttributes).replaceFlags((this.mAttributes.getAllFlags() | 0x200) & 0xFFFFFEFF).build();
                }
            }
            if (this.mFormat == null) {
                this.mFormat = new AudioFormat.Builder().setChannelMask(12).setEncoding(1).build();
            }
            if (this.mOffload) {
                if (this.mPerformanceMode == 1) {
                    throw new UnsupportedOperationException("Offload and low latency modes are incompatible");
                }
                if (!AudioSystem.isOffloadSupported(this.mFormat, this.mAttributes)) {
                    throw new UnsupportedOperationException("Cannot create AudioTrack, offload format / attributes not supported");
                }
            }
            try {
                AudioTrack track;
                if (this.mMode == 1 && this.mBufferSizeInBytes == 0) {
                    this.mBufferSizeInBytes = this.mFormat.getChannelCount() * AudioFormat.getBytesPerSample(this.mFormat.getEncoding());
                }
                if ((track = new AudioTrack(this.mAttributes, this.mFormat, this.mBufferSizeInBytes, this.mMode, this.mSessionId, this.mOffload, this.mEncapsulationMode, this.mTunerConfiguration)).getState() == 0) {
                    throw new UnsupportedOperationException("Cannot create AudioTrack");
                }
                return track;
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedOperationException(e.getMessage());
            }
        }
    }

    @SystemApi
    public static class TunerConfiguration {
        private final int mContentId;
        private final int mSyncId;

        public TunerConfiguration(int contentId, int syncId) {
            if (contentId < 1) {
                throw new IllegalArgumentException("contentId " + contentId + " must be positive");
            }
            if (syncId < 1) {
                throw new IllegalArgumentException("syncId " + syncId + " must be positive");
            }
            this.mContentId = contentId;
            this.mSyncId = syncId;
        }

        public int getContentId() {
            return this.mContentId;
        }

        public int getSyncId() {
            return this.mSyncId;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PerformanceMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WriteMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DualMonoMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EncapsulationMetadataType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EncapsulationMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TransferMode {
    }
}

