/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Binder;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.RemoteException;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.internal.util.function.pooled.PooledLambda;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

abstract class AbstractListenerManager<TRequest, TListener> {
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private volatile ArrayMap<Object, Registration<TRequest, TListener>> mListeners = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private TRequest mMergedRequest;

    AbstractListenerManager() {
    }

    public boolean addListener(TListener listener, Handler handler) throws RemoteException {
        return this.addInternal(null, listener, handler);
    }

    public boolean addListener(TListener listener, Executor executor) throws RemoteException {
        return this.addInternal(null, listener, executor);
    }

    public boolean addListener(TRequest request, TListener listener, Handler handler) throws RemoteException {
        return this.addInternal(request, listener, handler);
    }

    public boolean addListener(TRequest request, TListener listener, Executor executor) throws RemoteException {
        return this.addInternal(request, listener, executor);
    }

    protected boolean addInternal(TRequest request, Object listener, Handler handler) throws RemoteException {
        return this.addInternal(request, listener, new HandlerExecutor(handler));
    }

    protected boolean addInternal(TRequest request, Object listener, Executor executor) throws RemoteException {
        Preconditions.checkArgument(listener != null, "invalid null listener/callback");
        return this.addInternal(listener, new Registration(request, executor, this.convertKey(listener)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addInternal(Object key, Registration<TRequest, TListener> registration) throws RemoteException {
        Preconditions.checkNotNull(registration);
        Object object = this.mLock;
        synchronized (object) {
            boolean initialRequest = this.mListeners.isEmpty();
            ArrayMap<Object, Registration<TRequest, TListener>> newListeners = new ArrayMap<Object, Registration<TRequest, TListener>>(this.mListeners.size() + 1);
            newListeners.putAll(this.mListeners);
            Registration<TRequest, TListener> oldRegistration = newListeners.put(key, registration);
            this.mListeners = newListeners;
            if (oldRegistration != null) {
                ((Registration)oldRegistration).unregister();
            }
            TRequest merged = this.mergeRequests();
            if (initialRequest || !Objects.equals(merged, this.mMergedRequest)) {
                this.mMergedRequest = merged;
                if (!initialRequest) {
                    this.unregisterService();
                }
                this.registerService(this.mMergedRequest);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Object listener) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            boolean newRequest;
            ArrayMap<Object, Registration<TRequest, TListener>> newListeners = new ArrayMap<Object, Registration<TRequest, TListener>>(this.mListeners);
            Registration<TRequest, TListener> oldRegistration = newListeners.remove(listener);
            this.mListeners = newListeners;
            if (oldRegistration == null) {
                return;
            }
            ((Registration)oldRegistration).unregister();
            boolean lastRequest = this.mListeners.isEmpty();
            Object merged = lastRequest ? null : this.mergeRequests();
            boolean bl = newRequest = !lastRequest && !Objects.equals(merged, this.mMergedRequest);
            if (lastRequest || newRequest) {
                this.unregisterService();
                this.mMergedRequest = merged;
                if (newRequest) {
                    this.registerService(this.mMergedRequest);
                }
            }
        }
    }

    protected TListener convertKey(Object listener) {
        return (TListener)listener;
    }

    protected abstract boolean registerService(TRequest var1) throws RemoteException;

    protected abstract void unregisterService() throws RemoteException;

    protected TRequest merge(List<TRequest> requests) {
        for (TRequest request : requests) {
            Preconditions.checkArgument(request == null, "merge() has to be overridden for non-null requests.");
        }
        return null;
    }

    protected void execute(Consumer<TListener> operation) {
        for (Registration<TRequest, TListener> registration : this.mListeners.values()) {
            ((Registration)registration).execute(operation);
        }
    }

    @GuardedBy(value={"mLock"})
    private TRequest mergeRequests() {
        Preconditions.checkState(Thread.holdsLock(this.mLock));
        if (this.mListeners.isEmpty()) {
            return null;
        }
        if (this.mListeners.size() == 1) {
            return this.mListeners.valueAt(0).getRequest();
        }
        ArrayList<TRequest> requests = new ArrayList<TRequest>(this.mListeners.size());
        for (int index = 0; index < this.mListeners.size(); ++index) {
            requests.add(this.mListeners.valueAt(index).getRequest());
        }
        return (TRequest)this.merge(requests);
    }

    private static class Registration<TRequest, TListener> {
        private final Executor mExecutor;
        private TRequest mRequest;
        private volatile TListener mListener;

        private Registration(TRequest request, Executor executor, TListener listener) {
            Preconditions.checkArgument(listener != null, "invalid null listener/callback");
            Preconditions.checkArgument(executor != null, "invalid null executor");
            this.mExecutor = executor;
            this.mListener = listener;
            this.mRequest = request;
        }

        public TRequest getRequest() {
            return this.mRequest;
        }

        private void unregister() {
            this.mRequest = null;
            this.mListener = null;
        }

        private void execute(Consumer<TListener> operation) {
            this.mExecutor.execute(PooledLambda.obtainRunnable(Registration::accept, this, operation).recycleOnUse());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void accept(Consumer<TListener> operation) {
            TListener listener = this.mListener;
            if (listener == null) {
                return;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                operation.accept(listener);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }
}

